/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Variable;

public class ReferenceConstraint
implements BinaryConstraint {
    final Variable targetVariable;
    final EReference reference;

    public ReferenceConstraint(Variable target, EReference reference) {
        this.targetVariable = target;
        this.reference = reference;
    }

    @Override
    public boolean check(DomainSlot source, DomainSlot target) {
        Collection<Object> targetObjects;
        if (!source.locked) {
            return false;
        }
        if (this.reference.isMany()) {
            targetObjects = (List)source.value.eGet((EStructuralFeature)this.reference);
            if (targetObjects.isEmpty()) {
                return false;
            }
        } else {
            EObject obj = (EObject)source.value.eGet((EStructuralFeature)this.reference);
            if (obj == null) {
                return false;
            }
            targetObjects = Collections.singleton(obj);
        }
        if (target.locked) {
            return targetObjects.contains(target.value);
        }
        DomainChange change = new DomainChange(target, target.temporaryDomain);
        source.remoteChangeMap.put(this, change);
        target.temporaryDomain = new ArrayList<Object>(targetObjects);
        if (change.originalValues != null) {
            target.temporaryDomain.retainAll(change.originalValues);
        }
        return !target.temporaryDomain.isEmpty();
    }
}

