/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;

public class ParameterUtil {
    public static String getParametersKey(Rule rule) {
        String name = String.valueOf(rule.getName());
        name = name.replaceAll(" ", "_");
        name = name.replaceAll("\t", "_");
        if ((name = name.replaceAll("\n", "_")).length() > 0) {
            String first = name.substring(0, 1).toUpperCase();
            name = String.valueOf(first) + name.substring(1);
        }
        return "params" + name;
    }

    public static List<Node> getParameters(StateSpace stateSpace, Rule rule) throws StateSpaceException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        String value = (String)stateSpace.getProperties().get((Object)ParameterUtil.getParametersKey(rule));
        if (value != null && value.trim().length() > 0) {
            String[] names = value.split(",");
            int i = 0;
            while (i < names.length) {
                String name = names[i].trim();
                if (name.length() == 0) {
                    throw new StateSpaceException("Illegal rule parameters for rule \"" + rule.getName() + "\"");
                }
                Node node = ParameterUtil.findNodeByName(name, rule);
                if (node != null) {
                    nodes.add(node);
                }
                ++i;
            }
        } else {
            for (Parameter param : rule.getParameters()) {
                Node node = ParameterUtil.findNodeByName(param.getName(), rule);
                if (node == null) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public static List<EClass> getParameterTypes(StateSpace stateSpace, Rule rule) throws StateSpaceException {
        List<Node> params = ParameterUtil.getParameters(stateSpace, rule);
        ArrayList<EClass> types = new ArrayList<EClass>(params.size());
        for (Node param : params) {
            types.add(param.getType());
        }
        return types;
    }

    public static void setParameters(StateSpace stateSpace, Rule rule, List<Node> nodes) {
        String value = "";
        int i = 0;
        while (i < nodes.size()) {
            String name = nodes.get(i).getName();
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("All parameter nodes must have a unique, non-empty name");
            }
            value = String.valueOf(value) + name;
            if (i < nodes.size() - 1) {
                value = String.valueOf(value) + ",";
            }
            ++i;
        }
        stateSpace.getProperties().put((Object)ParameterUtil.getParametersKey(rule), (Object)value);
    }

    static Node findNodeByName(String name, Graph graph) {
        for (Node node : graph.getNodes()) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        return null;
    }

    static Node findNodeByName(String name, Rule rule) throws StateSpaceException {
        Node node = ParameterUtil.findNodeByName(name, rule.getLhs());
        if (node == null) {
            node = ParameterUtil.findNodeByName(name, rule.getRhs());
        }
        return node;
    }
}

