/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EcoreFactoryImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.henshin.HenshinModelPlugin;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.DescribedElement;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NamedElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.model.Xor;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

public class HenshinValidator
extends EObjectValidator {
    public static final HenshinValidator INSTANCE = new HenshinValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.henshin.model";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private static Constraint namedElement_ValidNameInvOCL;
    private static Constraint transformationSystem_uniqueUnitNamesInvOCL;
    private static Constraint rule_lhsAndRhsNotNullInvOCL;
    private static Constraint rule_mappingsFromLeft2RightInvOCL;
    private static Constraint parameter_nameRequiredInvOCL;
    private static Constraint graph_uniqueNodeNamesInvOCL;
    private static Constraint mapping_ruleMapping_TypeEqualityInvOCL;
    private static Constraint node_uniqueAttributeTypesInvOCL;
    private static Constraint edge_equalParentGraphsInvOCL;
    private static Constraint transformationUnit_uniqueParameterNamesInvOCL;
    private static final String OCL_ANNOTATION_SOURCE = "http://www.eclipse.org/emf/2010/Henshin/OCL";
    private static final OCL OCL_ENV;
    private static final Map<String, String> HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP;

    static {
        OCL_ENV = OCL.newInstance();
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP = new HashMap<String, String>();
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.put("info", Integer.toString(1));
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.put("warning", Integer.toString(2));
        HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.put("error", Integer.toString(4));
    }

    protected EPackage getEPackage() {
        return HenshinPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateDescribedElement((DescribedElement)value, diagnostics, context);
            }
            case 2: {
                return this.validateTransformationSystem((TransformationSystem)value, diagnostics, context);
            }
            case 3: {
                return this.validateRule((Rule)value, diagnostics, context);
            }
            case 4: {
                return this.validateAttributeCondition((AttributeCondition)value, diagnostics, context);
            }
            case 5: {
                return this.validateParameter((Parameter)value, diagnostics, context);
            }
            case 6: {
                return this.validateGraph((Graph)value, diagnostics, context);
            }
            case 7: {
                return this.validateGraphElement((GraphElement)value, diagnostics, context);
            }
            case 8: {
                return this.validateMapping((Mapping)value, diagnostics, context);
            }
            case 9: {
                return this.validateNode((Node)value, diagnostics, context);
            }
            case 10: {
                return this.validateAttribute((Attribute)value, diagnostics, context);
            }
            case 11: {
                return this.validateEdge((Edge)value, diagnostics, context);
            }
            case 12: {
                return this.validateTransformationUnit((TransformationUnit)value, diagnostics, context);
            }
            case 13: {
                return this.validateIndependentUnit((IndependentUnit)value, diagnostics, context);
            }
            case 14: {
                return this.validateSequentialUnit((SequentialUnit)value, diagnostics, context);
            }
            case 15: {
                return this.validateConditionalUnit((ConditionalUnit)value, diagnostics, context);
            }
            case 16: {
                return this.validatePriorityUnit((PriorityUnit)value, diagnostics, context);
            }
            case 17: {
                return this.validateIteratedUnit((IteratedUnit)value, diagnostics, context);
            }
            case 18: {
                return this.validateLoopUnit((LoopUnit)value, diagnostics, context);
            }
            case 19: {
                return this.validateNestedCondition((NestedCondition)value, diagnostics, context);
            }
            case 20: {
                return this.validateFormula((Formula)value, diagnostics, context);
            }
            case 21: {
                return this.validateUnaryFormula((UnaryFormula)value, diagnostics, context);
            }
            case 22: {
                return this.validateBinaryFormula((BinaryFormula)value, diagnostics, context);
            }
            case 23: {
                return this.validateAnd((And)value, diagnostics, context);
            }
            case 24: {
                return this.validateOr((Or)value, diagnostics, context);
            }
            case 25: {
                return this.validateXor((Xor)value, diagnostics, context);
            }
            case 26: {
                return this.validateNot((Not)value, diagnostics, context);
            }
            case 27: {
                return this.validateParameterMapping((ParameterMapping)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(namedElement, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(namedElement, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(namedElement, diagnostics, context);
        }
        return result;
    }

    public boolean validateNamedElement_ValidName(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (namedElement_ValidNameInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.NAMED_ELEMENT);
            EAnnotation ocl = HenshinPackage.Literals.NAMED_ELEMENT.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"ValidName");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                namedElement_ValidNameInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            namedElement_ValidNameInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"ValidName.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"ValidName.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(namedElement_ValidNameInvOCL)).check((Object)namedElement)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = namedElement_ValidNameInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ValidName", HenshinValidator.getObjectLabel((EObject)namedElement, context)}, new Object[]{namedElement}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateDescribedElement(DescribedElement describedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(describedElement, diagnostics, context);
    }

    public boolean validateTransformationSystem(TransformationSystem transformationSystem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(transformationSystem, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationSystem_uniqueUnitNames(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationSystem_noCyclicUnits(transformationSystem, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationSystem_parameterNamesNotTypeName(transformationSystem, diagnostics, context);
        }
        return result;
    }

    public boolean validateTransformationSystem_uniqueUnitNames(TransformationSystem transformationSystem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (transformationSystem_uniqueUnitNamesInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.TRANSFORMATION_SYSTEM);
            EAnnotation ocl = HenshinPackage.Literals.TRANSFORMATION_SYSTEM.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"uniqueUnitNames");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                transformationSystem_uniqueUnitNamesInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            transformationSystem_uniqueUnitNamesInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"uniqueUnitNames.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"uniqueUnitNames.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(transformationSystem_uniqueUnitNamesInvOCL)).check((Object)transformationSystem)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = transformationSystem_uniqueUnitNamesInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"uniqueUnitNames", HenshinValidator.getObjectLabel((EObject)transformationSystem, context)}, new Object[]{transformationSystem}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateTransformationSystem_noCyclicUnits(TransformationSystem transformationSystem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Stack<TransformationUnit> path = new Stack<TransformationUnit>();
        ArrayList<TransformationUnit> cyclic = new ArrayList<TransformationUnit>();
        boolean result = true;
        for (TransformationUnit unit : transformationSystem.getTransformationUnits()) {
            path.clear();
            TransformationUnit cyc = this.isCyclic(path, unit);
            if (cyc == null || cyclic.contains(cyc)) continue;
            cyclic.add(cyc);
            diagnostics.add((Diagnostic)this.createDiagnostic(2, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"transformationSystem_noCyclicUnits", HenshinValidator.getObjectLabel((EObject)transformationSystem, context), HenshinValidator.getObjectLabel((EObject)cyc, context)}, new Object[]{transformationSystem}, context, "_EcoreConstraint_Msg_TransformationSystem_noCyclicUnits"));
            result = false;
        }
        return result;
    }

    public boolean validateTransformationSystem_parameterNamesNotTypeName(TransformationSystem transformationSystem, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (TransformationUnit tUnit : transformationSystem.getTransformationUnits()) {
            for (Parameter param : tUnit.getParameters()) {
                if (!this.containsImportedEClassifier(transformationSystem, param.getName())) continue;
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"transformationSystem_parameterNamesNotTypeName", HenshinValidator.getObjectLabel((EObject)transformationSystem, context)}, new Object[]{transformationSystem}, context, "_EcoreConstraint_Msg_TransformationSystem_parameterNamesNotTypeName"));
                return false;
            }
        }
        return true;
    }

    protected boolean containsImportedEClassifier(TransformationSystem tSys, String name) {
        for (EPackage pack : tSys.getImports()) {
            if (pack.getEClassifier(name) == null) continue;
            return true;
        }
        return false;
    }

    protected TransformationUnit isCyclic(Stack<TransformationUnit> path, TransformationUnit unit) {
        if (path.contains(unit)) {
            return unit;
        }
        path.push(unit);
        for (TransformationUnit subUnit : unit.getSubUnits(false)) {
            TransformationUnit tu;
            if (subUnit == null || (tu = this.isCyclic(path, subUnit)) == null) continue;
            return tu;
        }
        path.pop();
        return null;
    }

    public boolean validateRule(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(rule, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_lhsAndRhsNotNull(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_mappingsFromLeft2Right(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_createdNodesNotAbstract(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_createdEdgesNotDerived(rule, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRule_deletedEdgesNotDerived(rule, diagnostics, context);
        }
        return result;
    }

    public boolean validateRule_lhsAndRhsNotNull(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (rule_lhsAndRhsNotNullInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.RULE);
            EAnnotation ocl = HenshinPackage.Literals.RULE.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"lhsAndRhsNotNull");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                rule_lhsAndRhsNotNullInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            rule_lhsAndRhsNotNullInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"lhsAndRhsNotNull.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"lhsAndRhsNotNull.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(rule_lhsAndRhsNotNullInvOCL)).check((Object)rule)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = rule_lhsAndRhsNotNullInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"lhsAndRhsNotNull", HenshinValidator.getObjectLabel((EObject)rule, context)}, new Object[]{rule}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateRule_mappingsFromLeft2Right(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (rule_mappingsFromLeft2RightInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.RULE);
            EAnnotation ocl = HenshinPackage.Literals.RULE.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"mappingsFromLeft2Right");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                rule_mappingsFromLeft2RightInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            rule_mappingsFromLeft2RightInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"mappingsFromLeft2Right.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"mappingsFromLeft2Right.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(rule_mappingsFromLeft2RightInvOCL)).check((Object)rule)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = rule_mappingsFromLeft2RightInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"mappingsFromLeft2Right", HenshinValidator.getObjectLabel((EObject)rule, context)}, new Object[]{rule}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateRule_createdNodesNotAbstract(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        block0: for (Node node : rule.getRhs().getNodes()) {
            if (node.getType() == null || !node.getType().isAbstract()) continue;
            for (Mapping mapping : rule.getMappings()) {
                if (mapping.getImage() == node) continue block0;
            }
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"rule_createdNodesNotAbstract", HenshinValidator.getObjectLabel((EObject)node, context)}, new Object[]{node}, context, "_EcoreConstraint_Msg_Rule_createdNodesNotAbstract"));
            return false;
        }
        return true;
    }

    public boolean validateRule_createdEdgesNotDerived(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        block0: for (Edge edge : rule.getRhs().getEdges()) {
            if (edge.getType() == null || !edge.getType().isDerived()) continue;
            Node sourceOrigin = null;
            Node targetOrigin = null;
            boolean originsFound = false;
            for (Mapping mapping : rule.getMappings()) {
                if (mapping.getImage() != null && mapping.getImage() == edge.getSource() && (sourceOrigin = mapping.getOrigin()) == null || mapping.getImage() != null && mapping.getImage() == edge.getTarget() && (targetOrigin = mapping.getOrigin()) == null) continue block0;
                if (sourceOrigin == null || targetOrigin == null) continue;
                originsFound = true;
                break;
            }
            if (!originsFound) continue;
            for (Edge oEdge : sourceOrigin.getOutgoing()) {
                if (oEdge.getTarget() == targetOrigin && oEdge.getType() == edge.getType()) continue block0;
            }
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"rule_createdNodesNotAbstract", HenshinValidator.getObjectLabel((EObject)edge, context)}, new Object[]{edge}, context, "_EcoreConstraint_Msg_Rule_createdEdgesNotDerived"));
            return false;
        }
        return true;
    }

    public boolean validateRule_deletedEdgesNotDerived(Rule rule, DiagnosticChain diagnostics, Map<Object, Object> context) {
        block0: for (Edge edge : rule.getLhs().getEdges()) {
            if (edge.getType() == null || !edge.getType().isDerived()) continue;
            Node sourceImage = null;
            Node targetImage = null;
            boolean imagesFound = false;
            for (Mapping mapping : rule.getMappings()) {
                if (mapping.getOrigin() != null && mapping.getOrigin() == edge.getSource() && (sourceImage = mapping.getImage()) == null || mapping.getOrigin() != null && mapping.getOrigin() == edge.getTarget() && (targetImage = mapping.getImage()) == null) continue block0;
                if (sourceImage == null || targetImage == null) continue;
                imagesFound = true;
                break;
            }
            if (!imagesFound) continue;
            for (Edge iEdge : sourceImage.getOutgoing()) {
                if (iEdge.getTarget() == targetImage && iEdge.getType() == edge.getType()) continue block0;
            }
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"rule_createdNodesNotAbstract", HenshinValidator.getObjectLabel((EObject)edge, context)}, new Object[]{edge}, context, "_EcoreConstraint_Msg_Rule_deletedEdgesNotDerived"));
            return false;
        }
        return true;
    }

    public boolean validateAttributeCondition(AttributeCondition attributeCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(attributeCondition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(attributeCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(attributeCondition, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameter(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(parameter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(parameter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateParameter_nameRequired(parameter, diagnostics, context);
        }
        return result;
    }

    public boolean validateParameter_nameRequired(Parameter parameter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (parameter_nameRequiredInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.PARAMETER);
            EAnnotation ocl = HenshinPackage.Literals.PARAMETER.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"nameRequired");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                parameter_nameRequiredInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            parameter_nameRequiredInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"nameRequired.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"nameRequired.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(parameter_nameRequiredInvOCL)).check((Object)parameter)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = parameter_nameRequiredInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"nameRequired", HenshinValidator.getObjectLabel((EObject)parameter, context)}, new Object[]{parameter}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateGraph(Graph graph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(graph, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(graph, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateGraph_uniqueNodeNames(graph, diagnostics, context);
        }
        return result;
    }

    public boolean validateGraph_uniqueNodeNames(Graph graph, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (graph_uniqueNodeNamesInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.GRAPH);
            EAnnotation ocl = HenshinPackage.Literals.GRAPH.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"uniqueNodeNames");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                graph_uniqueNodeNamesInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            graph_uniqueNodeNamesInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"uniqueNodeNames.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"uniqueNodeNames.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(graph_uniqueNodeNamesInvOCL)).check((Object)graph)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = graph_uniqueNodeNamesInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"uniqueNodeNames", HenshinValidator.getObjectLabel((EObject)graph, context)}, new Object[]{graph}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateGraphElement(GraphElement graphElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(graphElement, diagnostics, context);
    }

    public boolean validateMapping(Mapping mapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(mapping, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(mapping, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMapping_ruleMapping_TypeEquality(mapping, diagnostics, context);
        }
        return result;
    }

    public boolean validateMapping_ruleMapping_TypeEquality(Mapping mapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (mapping_ruleMapping_TypeEqualityInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.MAPPING);
            EAnnotation ocl = HenshinPackage.Literals.MAPPING.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"ruleMapping_TypeEquality");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                mapping_ruleMapping_TypeEqualityInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            mapping_ruleMapping_TypeEqualityInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"ruleMapping_TypeEquality.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"ruleMapping_TypeEquality.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(mapping_ruleMapping_TypeEqualityInvOCL)).check((Object)mapping)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = mapping_ruleMapping_TypeEqualityInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"ruleMapping_TypeEquality", HenshinValidator.getObjectLabel((EObject)mapping, context)}, new Object[]{mapping}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateNode(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(node, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(node, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNode_uniqueAttributeTypes(node, diagnostics, context);
        }
        return result;
    }

    public boolean validateNode_uniqueAttributeTypes(Node node, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (node_uniqueAttributeTypesInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.NODE);
            EAnnotation ocl = HenshinPackage.Literals.NODE.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"uniqueAttributeTypes");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                node_uniqueAttributeTypesInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            node_uniqueAttributeTypesInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"uniqueAttributeTypes.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"uniqueAttributeTypes.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(node_uniqueAttributeTypesInvOCL)).check((Object)node)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = node_uniqueAttributeTypesInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"uniqueAttributeTypes", HenshinValidator.getObjectLabel((EObject)node, context)}, new Object[]{node}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateAttribute(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(attribute, diagnostics, context);
    }

    public boolean validateEdge(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(edge, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(edge, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEdge_equalParentGraphs(edge, diagnostics, context);
        }
        return result;
    }

    public boolean validateEdge_equalParentGraphs(Edge edge, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (edge_equalParentGraphsInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.EDGE);
            EAnnotation ocl = HenshinPackage.Literals.EDGE.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"equalParentGraphs");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                edge_equalParentGraphsInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            edge_equalParentGraphsInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"equalParentGraphs.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"equalParentGraphs.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(edge_equalParentGraphsInvOCL)).check((Object)edge)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = edge_equalParentGraphsInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"equalParentGraphs", HenshinValidator.getObjectLabel((EObject)edge, context)}, new Object[]{edge}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateTransformationUnit(TransformationUnit transformationUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(transformationUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(transformationUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(transformationUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateTransformationUnit_uniqueParameterNames(TransformationUnit transformationUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        OCL.Query query;
        if (transformationUnit_uniqueParameterNamesInvOCL == null) {
            String sev;
            OCL.Helper helper = OCL_ENV.createOCLHelper();
            helper.setContext((Object)HenshinPackage.Literals.TRANSFORMATION_UNIT);
            EAnnotation ocl = HenshinPackage.Literals.TRANSFORMATION_UNIT.getEAnnotation(OCL_ANNOTATION_SOURCE);
            String expr = (String)ocl.getDetails().get((Object)"uniqueParameterNames");
            EAnnotation henshinOclAnnotation = EcoreFactoryImpl.eINSTANCE.createEAnnotation();
            henshinOclAnnotation.setSource(OCL_ANNOTATION_SOURCE);
            try {
                transformationUnit_uniqueParameterNamesInvOCL = (Constraint)helper.createInvariant(expr);
            }
            catch (ParserException e) {
                throw new UnsupportedOperationException(e.getLocalizedMessage());
            }
            transformationUnit_uniqueParameterNamesInvOCL.getEAnnotations().add((Object)henshinOclAnnotation);
            String msg = (String)ocl.getDetails().get((Object)"uniqueParameterNames.Msg");
            if (msg != null && msg.length() > 0) {
                henshinOclAnnotation.getDetails().put((Object)"Msg", (Object)msg);
            }
            if ((sev = (String)ocl.getDetails().get((Object)"uniqueParameterNames.Severity")) != null && sev.length() > 0 && HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.containsKey(sev = sev.toLowerCase())) {
                henshinOclAnnotation.getDetails().put((Object)"Severity", (Object)HENSHIN_SEVERITY_2_DIAGNOSTIC_MAP.get(sev));
            }
        }
        if (!(query = OCL_ENV.createQuery(transformationUnit_uniqueParameterNamesInvOCL)).check((Object)transformationUnit)) {
            if (diagnostics != null) {
                EAnnotation henshinAnnotation = transformationUnit_uniqueParameterNamesInvOCL.getEAnnotation(OCL_ANNOTATION_SOURCE);
                int severity = henshinAnnotation.getDetails().containsKey((Object)"Severity") ? Integer.parseInt((String)henshinAnnotation.getDetails().get((Object)"Severity")) : 4;
                String addMsg = henshinAnnotation.getDetails().containsKey((Object)"Msg") ? (String)henshinAnnotation.getDetails().get((Object)"Msg") : null;
                diagnostics.add((Diagnostic)this.createDiagnostic(severity, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"uniqueParameterNames", HenshinValidator.getObjectLabel((EObject)transformationUnit, context)}, new Object[]{transformationUnit}, context, addMsg));
            }
            return false;
        }
        return true;
    }

    public boolean validateTransformationUnit_parameterMappingsPointToDirectSubUnit(TransformationUnit transformationUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (ParameterMapping pm : transformationUnit.getParameterMappings()) {
            if (transformationUnit.getParameters().contains((Object)pm.getSource()) && pm.getTarget() != null && !transformationUnit.getSubUnits(false).contains((Object)pm.getTarget().getUnit())) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"transformationUnit_parameterMappingsPointToDirectSubUnit", HenshinValidator.getObjectLabel((EObject)transformationUnit, context)}, new Object[]{transformationUnit}, context, "_EcoreConstraint_Msg_TransformationUnit_parameterMappingsPointToDirectSubUnit"));
                return false;
            }
            if (!transformationUnit.getParameters().contains((Object)pm.getTarget()) || pm.getSource() == null || transformationUnit.getSubUnits(false).contains((Object)pm.getSource().getUnit())) continue;
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"transformationUnit_parameterMappingsPointToDirectSubUnit", HenshinValidator.getObjectLabel((EObject)transformationUnit, context)}, new Object[]{transformationUnit}, context, "_EcoreConstraint_Msg_TransformationUnit_parameterMappingsPointToDirectSubUnit"));
            return false;
        }
        return true;
    }

    public boolean validateIndependentUnit(IndependentUnit independentUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(independentUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(independentUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(independentUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateSequentialUnit(SequentialUnit sequentialUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(sequentialUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(sequentialUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(sequentialUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateConditionalUnit(ConditionalUnit conditionalUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(conditionalUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(conditionalUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(conditionalUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validatePriorityUnit(PriorityUnit priorityUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(priorityUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(priorityUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(priorityUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateIteratedUnit(IteratedUnit iteratedUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(iteratedUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(iteratedUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(iteratedUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateLoopUnit(LoopUnit loopUnit, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(loopUnit, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNamedElement_ValidName(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_uniqueParameterNames(loopUnit, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTransformationUnit_parameterMappingsPointToDirectSubUnit(loopUnit, diagnostics, context);
        }
        return result;
    }

    public boolean validateNestedCondition(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_NoCircularContainment(nestedCondition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryMultiplicityConforms(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedCondition_mappingOriginContainedInParentCondition(nestedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedCondition_mappingImageContainedInCurrent(nestedCondition, diagnostics, context);
        }
        return result;
    }

    public boolean validateNestedCondition_mappingOriginContainedInParentCondition(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Graph graph = this.findContainingGraph(nestedCondition);
        if (graph != null && graph.eContainer() instanceof NestedCondition) {
            for (Mapping mapping : nestedCondition.getMappings()) {
                if (mapping.getOrigin() == null || mapping.getOrigin().getGraph() == graph) continue;
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"nestedCondition_mappingOriginContainedInParentCondition", HenshinValidator.getObjectLabel((EObject)nestedCondition, context)}, new Object[]{nestedCondition}, context, "_EcoreConstraint_Msg_NestedCondition_mappingOriginContainedInParentCondition"));
                return false;
            }
        }
        return true;
    }

    protected Graph findContainingGraph(NestedCondition nestedCondition) {
        EObject container = nestedCondition.eContainer();
        while (container != null) {
            if (container instanceof Graph) {
                return (Graph)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public boolean validateNestedCondition_mappingImageContainedInCurrent(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        for (Mapping mapping : nestedCondition.getMappings()) {
            if (nestedCondition.getConclusion().getNodes().contains((Object)mapping.getImage())) continue;
            diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_GenericConstraint_diagnostic", new Object[]{"nestedCondition_mappingImageContainedInCurrent", HenshinValidator.getObjectLabel((EObject)nestedCondition, context)}, new Object[]{nestedCondition, mapping}, context, "_EcoreConstraint_Msg_NestedCondition_mappingImageContainedInCurrent"));
            return false;
        }
        return true;
    }

    public boolean validateFormula(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(formula, diagnostics, context);
    }

    public boolean validateUnaryFormula(UnaryFormula unaryFormula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(unaryFormula, diagnostics, context);
    }

    public boolean validateBinaryFormula(BinaryFormula binaryFormula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(binaryFormula, diagnostics, context);
    }

    public boolean validateAnd(And and, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(and, diagnostics, context);
    }

    public boolean validateOr(Or or, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(or, diagnostics, context);
    }

    public boolean validateNot(Not not, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(not, diagnostics, context);
    }

    public boolean validateXor(Xor xor, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(xor, diagnostics, context);
    }

    public boolean validateParameterMapping(ParameterMapping parameterMapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(parameterMapping, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return HenshinModelPlugin.INSTANCE;
    }

    protected BasicDiagnostic createDiagnostic(int severity, String source, int code, String messageKey, Object[] messageSubstitutions, Object[] data, Map<Object, Object> context, String additionalMessage) {
        String henshinMessage = "";
        if (additionalMessage != null && additionalMessage.length() > 0) {
            henshinMessage = " -- " + (additionalMessage.startsWith("_") ? this.getString(additionalMessage, messageSubstitutions) : additionalMessage);
        }
        String message = this.getString(messageKey, messageSubstitutions);
        return new BasicDiagnostic(severity, source, code, String.valueOf(message) + henshinMessage, data);
    }
}

