/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.commands.HenshinModelUtils;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class CreateMappedNodeCommand
extends AbstractCommand {
    protected Rule rule;
    protected Node origNode;
    protected Node imgNode;
    protected Mapping mapping;

    public CreateMappedNodeCommand(Rule rule) {
        this.rule = rule;
    }

    protected boolean prepare() {
        return this.rule != null;
    }

    public void execute() {
        HenshinFactory factory = HenshinFactory.eINSTANCE;
        this.origNode = factory.createNode();
        this.origNode.setName(HenshinModelUtils.generateNewNodeName((Graph)this.rule.getLhs()));
        this.imgNode = factory.createNode();
        this.imgNode.setName(HenshinModelUtils.generateNewNodeName((Graph)this.rule.getRhs()));
        this.mapping = factory.createMapping();
        this.mapping.setOrigin(this.origNode);
        this.mapping.setImage(this.imgNode);
        this.redo();
    }

    public Collection<?> getAffectedObjects() {
        ArrayList<Object> affectedObjects = new ArrayList<Object>();
        affectedObjects.add(this.origNode);
        affectedObjects.add(this.imgNode);
        affectedObjects.add(this.mapping);
        return affectedObjects;
    }

    public Collection<?> getResult() {
        return this.getAffectedObjects();
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.rule.getLhs().getNodes().remove((Object)this.origNode);
        this.rule.getRhs().getNodes().remove((Object)this.imgNode);
        this.rule.getMappings().remove((Object)this.mapping);
    }

    public void redo() {
        this.rule.getLhs().getNodes().add((Object)this.origNode);
        this.rule.getRhs().getNodes().add((Object)this.imgNode);
        this.rule.getMappings().add((Object)this.mapping);
    }
}

