/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.mutualexclusion;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class STSBenchmark {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/mutualexclusion";
    static final int GRAPH_SIZE_MIN = 1000;
    static final int GRAPH_SIZE_MAX = 10000;
    static final int STEP = 1000;
    static final int ITERATIONS = 3;

    public static void run(String path) {
        System.out.println("**************** Short Transformation Sequence ***************");
        System.out.println("Memory allocated:" + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "M");
        System.out.println("GRAPH_SIZE_MIN:1000");
        System.out.println("GRAPH_SIZE_MAX:10000");
        System.out.println("STEP:1000");
        System.out.println("ITERATIONS:3 , first iteration is not included into evaluation");
        System.out.println("**************************************************************");
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        TransformationSystem trasys = resourceSet.getTransformationSystem("mutualexclusion.henshin");
        EObject container = resourceSet.getObject("initialgraph.xmi");
        Rule newRule = trasys.findRuleByName("newRule");
        TransformationUnit stsUnit = trasys.findUnitByName("sts");
        TransformationUnit loopStsUnit = trasys.findUnitByName("loopSts");
        int graphSize = 1000;
        while (graphSize <= 10000) {
            long sum = 0L;
            int j = 0;
            while (j < 3) {
                EObject container2 = EcoreUtil.copy((EObject)container);
                EGraph graph = InterpreterFactory.INSTANCE.createEGraph();
                graph.addTree(container2);
                Engine engine = InterpreterFactory.INSTANCE.createEngine();
                RuleApplication ruleAppl = InterpreterFactory.INSTANCE.createRuleApplication(engine);
                ruleAppl.setEGraph(graph);
                UnitApplication unitAppl = InterpreterFactory.INSTANCE.createUnitApplication(engine);
                unitAppl.setEGraph(graph);
                long startTime = System.currentTimeMillis();
                ruleAppl.setRule(newRule);
                int i = 0;
                while (i < graphSize - 2) {
                    ruleAppl.execute(null);
                    ++i;
                }
                unitAppl.setUnit(stsUnit);
                unitAppl.execute(null);
                unitAppl.setUnit(loopStsUnit);
                i = 0;
                while (i < graphSize) {
                    unitAppl.execute(null);
                    ++i;
                }
                long finishTime = System.currentTimeMillis();
                if (j != 0) {
                    sum = sum + finishTime - startTime;
                }
                ++j;
            }
            System.out.println(" Graph size: " + graphSize + "  average time:" + sum / 2L);
            graphSize += 1000;
        }
    }

    public static void main(String[] args) {
        STSBenchmark.run(PATH);
    }
}

