/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.StateSpaceValidator;
import org.eclipse.emf.henshin.statespace.ValidationResult;
import org.eclipse.emf.henshin.statespace.explorer.jobs.AbstractStateSpaceJob;

public class ValidateStateSpaceJob
extends AbstractStateSpaceJob {
    private StateSpaceValidator validator;
    private String property;
    private ValidationResult result;

    public ValidateStateSpaceJob(StateSpaceManager manager) {
        super("Validating state space...", manager);
        this.setUser(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.validator.setStateSpaceIndex((StateSpaceIndex)this.getStateSpaceManager());
            this.validator.setProperty(this.property);
            this.result = this.validator.validate(this.getStateSpaceManager().getStateSpace(), monitor);
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? e.getMessage() : "Error validating property";
            return new Status(4, "org.eclipse.emf.henshin.statespace", 0, message, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public ValidationResult getValidationResult() {
        return this.result;
    }

    public void setValidator(StateSpaceValidator validator) {
        this.validator = validator;
        this.setName("Running " + validator.getName() + "...");
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

