/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.henshin.diagram.edit.helpers.HenshinBaseEditHelper;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class RuleEditHelper
extends HenshinBaseEditHelper {
    private static final String DEFAULT_ACTION_EANNOTATION_KEY = "defaultAction";
    private static final String DEFAULT_ACTION_VALUE_KEY = "value";

    public static Action getDefaultAction(Rule rule) {
        String value;
        EAnnotation annotation;
        View ruleView = RuleEditHelper.findRuleView(rule.getRootRule());
        if (ruleView != null && (annotation = ruleView.getEAnnotation(DEFAULT_ACTION_EANNOTATION_KEY)) != null && (value = (String)annotation.getDetails().get((Object)DEFAULT_ACTION_VALUE_KEY)) != null) {
            try {
                return Action.parse((String)value);
            }
            catch (Throwable throwable) {}
        }
        return new Action(Action.Type.PRESERVE);
    }

    public static void setDefaultAction(Rule rule, Action action) {
        View ruleView = RuleEditHelper.findRuleView(rule.getRootRule());
        if (ruleView != null) {
            EAnnotation annotation = ruleView.getEAnnotation(DEFAULT_ACTION_EANNOTATION_KEY);
            if (annotation == null) {
                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                annotation.setSource(DEFAULT_ACTION_EANNOTATION_KEY);
                annotation.setEModelElement((EModelElement)ruleView);
            }
            if (action == null) {
                action = new Action(Action.Type.PRESERVE);
            }
            annotation.getDetails().put((Object)DEFAULT_ACTION_VALUE_KEY, (Object)action.toString());
        }
    }

    public static boolean isRuleView(View view) {
        return view != null && view.getElement() instanceof Rule && view.getType().equals(String.valueOf(2001));
    }

    public static View findRuleView(Rule rule) {
        for (Resource resource : rule.eResource().getResourceSet().getResources()) {
            if (!(resource instanceof GMFResource)) continue;
            for (EObject object : resource.getContents()) {
                if (!(object instanceof Diagram) || ((Diagram)object).getElement() != rule.getModule()) continue;
                Diagram diagram = (Diagram)object;
                int i = 0;
                while (i < diagram.getChildren().size()) {
                    View view = (View)diagram.getChildren().get(i);
                    if (RuleEditHelper.isRuleView(view) && view.getElement() == rule) {
                        return view;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public static class RuleListener
    extends EContentAdapter {
        private Rule rule;

        public RuleListener(EObject ruleElement) {
            while (ruleElement != null && !(ruleElement instanceof Rule)) {
                ruleElement = ruleElement.eContainer();
            }
            if (ruleElement == null) {
                throw new IllegalArgumentException();
            }
            this.rule = (Rule)ruleElement;
        }

        public void dispose() {
            this.rule.eAdapters().remove((Object)this.rule);
        }
    }
}

