/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.util;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Action;
import org.osgi.framework.Bundle;

public class HenshinColorMode {
    public static final Map<String, HenshinColorMode> REGISTRY = new LinkedHashMap<String, HenshinColorMode>(){
        private static final long serialVersionUID = 1L;

        @Override
        public HenshinColorMode get(Object v) {
            return (HenshinColorMode)super.get(String.valueOf(v).toLowerCase());
        }

        @Override
        public HenshinColorMode put(String v, HenshinColorMode mode) {
            return super.put(String.valueOf(v).toLowerCase(), mode);
        }
    };
    private static HenshinColorMode DEFAULT;
    public static final String BG_RULE = "BG_RULE";
    public static final String BG_UNIT = "BG_UNIT";
    public static final String BG_INVOCATION = "BG_INVOCATION";
    public static final String BG_ACTION_PRESERVE = "BG_ACTION_PRESERVE";
    public static final String BG_ACTION_CREATE = "BG_ACTION_CREATE";
    public static final String BG_ACTION_DELETE = "BG_ACTION_DELETE";
    public static final String BG_ACTION_FORBID = "BG_ACTION_FORBID";
    public static final String BG_ACTION_REQUIRE = "BG_ACTION_REQUIRE";
    public static final String FG_ACTION_PRESERVE = "FG_ACTION_PRESERVE";
    public static final String FG_ACTION_CREATE = "FG_ACTION_CREATE";
    public static final String FG_ACTION_DELETE = "FG_ACTION_DELETE";
    public static final String FG_ACTION_FORBID = "FG_ACTION_FORBID";
    public static final String FG_ACTION_REQUIRE = "FG_ACTION_REQUIRE";
    private Properties properties;
    private Map<String, Color> colors;

    static {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.henshin.edit");
        URL colorModesURL = bundle.getEntry("colorModes");
        try {
            File dir = new File(FileLocator.resolve((URL)colorModesURL).toURI());
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getAbsolutePath().endsWith(".properties")) {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(file));
                    HenshinColorMode mode = new HenshinColorMode(properties);
                    REGISTRY.put(mode.getName(), mode);
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static HenshinColorMode getDefaultColorMode() {
        if (DEFAULT == null && (DEFAULT = REGISTRY.get("default")) == null && !REGISTRY.isEmpty()) {
            DEFAULT = REGISTRY.get(0);
        }
        return DEFAULT;
    }

    public HenshinColorMode(Properties properties) {
        this.properties = properties;
        this.colors = new HashMap<String, Color>();
    }

    public Color getColor(String type) {
        Color color = this.colors.get(type);
        if (color != null) {
            return color;
        }
        String value = this.properties.getProperty(type);
        if (value == null) {
            return null;
        }
        String[] vals = value.split(",");
        if (vals.length != 3) {
            return null;
        }
        try {
            int red = Integer.parseInt(vals[0]);
            int green = Integer.parseInt(vals[1]);
            int blue = Integer.parseInt(vals[2]);
            color = new Color(red, green, blue);
            this.colors.put(type, color);
            return color;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Color getActionColor(Action action, boolean foreground) {
        if (action == null) {
            return null;
        }
        return this.getColor(HenshinColorMode.getActionColorKey(action, foreground));
    }

    public static String getActionColorKey(Action action, boolean foreground) {
        if (action == null) {
            return null;
        }
        return String.valueOf(foreground ? "FG_" : "BG_") + "ACTION_" + action.getType().toString().toUpperCase();
    }

    public String getName() {
        return this.properties.getProperty("colorModeName");
    }

    public static class Color {
        public final int red;
        public final int green;
        public final int blue;

        public Color(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public int hashCode() {
            return this.red + this.green + this.blue;
        }

        public boolean equals(Object o) {
            if (o instanceof Color) {
                Color c = (Color)o;
                return c.red == this.red && c.green == this.green && c.blue == this.blue;
            }
            return false;
        }

        public URI toURI() {
            return URI.createURI((String)("color://rgb/" + this.red + "/" + this.green + "/" + this.blue));
        }
    }
}

