/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.cons.AtomConstraint;
import agg.cons.Evaluable;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.NestedApplCond;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Formula
implements Evaluable,
XMLObject,
Serializable {
    public static final int NOP = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int NOT = 3;
    public static final int AND = 4;
    public static final int OR = 5;
    public static final int EXISTS = 6;
    public static final int FORALL = 7;
    public static final int UNDEF = -1;
    private Evaluable sub1;
    private Evaluable sub2;
    private int op;
    public String str = "";
    private int running_tick;
    private String name = "";
    private boolean evaluable = true;
    private boolean enabled = true;
    private String comment = "";
    private Vector<Integer> layer = new Vector(5);
    private Vector<Integer> priority = new Vector(5);

    private void init(int _op, Evaluable e1, Evaluable e2) {
        this.op = _op;
        this.sub1 = e1;
        this.sub2 = e2;
    }

    public Formula(boolean v) {
        this.init(v ? 1 : 2, null, null);
        this.running_tick = 0;
        this.name = "Formula";
        this.evaluable = true;
        this.enabled = true;
        this.str = String.valueOf(v);
    }

    public Formula(List<Evaluable> vars, String s) {
        this.setFormula(vars, s);
        this.running_tick = 0;
        this.name = "Formula";
        this.evaluable = true;
        this.enabled = true;
        this.str = s;
    }

    public Formula(List<Evaluable> vars, int op) {
        this.running_tick = 0;
        if (op != 4 && op != 5) {
            this.init(-1, null, null);
            return;
        }
        if (vars.isEmpty()) {
            this.init(1, null, null);
            this.str = String.valueOf(true);
        } else {
            String s = "1";
            int i = 1;
            while (i < vars.size()) {
                s = String.valueOf(s) + (op == 4 ? " && " : " || ");
                s = String.valueOf(s) + Integer.toString(i + 1);
                ++i;
            }
            this.setFormula(vars, s);
            this.str = s;
        }
        this.name = "Formula";
        this.evaluable = true;
        this.enabled = true;
    }

    public void setName(String str) {
        this.name = str;
    }

    public String getName() {
        return this.name;
    }

    public void setTextualComment(String text) {
        this.comment = text;
    }

    public String getTextualComment() {
        return this.comment;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean setFormula(List<Evaluable> vars, String s) {
        Formula that = this.get_multiple(vars, new StringCharacterIterator(s));
        if (that != null) {
            this.init(that.op, that.sub1, that.sub2);
            return true;
        }
        this.init(-1, null, null);
        return false;
    }

    public String getAsString(List<Evaluable> v) {
        HashMap<Evaluable, String> m = new HashMap<Evaluable, String>();
        int i = 0;
        while (i < v.size()) {
            m.put(v.get(i), Integer.toString(i + 1, 10));
            ++i;
        }
        return this.getAsString(v, m);
    }

    public String getAsString(List<Evaluable> v, List<String> names) {
        if (names.size() != v.size()) {
            return this.getAsString(v);
        }
        HashMap<Evaluable, String> map = new HashMap<Evaluable, String>();
        int i = 0;
        while (i < v.size()) {
            map.put(v.get(i), names.get(i));
            ++i;
        }
        return this.getAsReadableString(v, map);
    }

    public String getAsReadableString(List<Evaluable> v) {
        String s1 = "";
        String s2 = "";
        switch (this.op) {
            case -1: {
                return "";
            }
            case 3: 
            case 7: {
                return "FORALL( " + s1 + " )";
            }
            case 6: {
                return "EXISTS( " + s1 + " )";
            }
            case 2: {
                return "false";
            }
            case 1: {
                return "true";
            }
            case 4: 
            case 5: {
                return "(" + s1 + (this.op == 4 ? " & " : " | ") + s2 + ")";
            }
        }
        return "true";
    }

    private String getAsReadableString(List<Evaluable> v, HashMap<Evaluable, String> map) {
        String s1 = "";
        String s2 = "";
        switch (this.op) {
            case -1: {
                return "";
            }
            case 3: {
                return "(!" + ((Formula)this.sub1).getAsReadableString(v, map) + ")";
            }
            case 7: {
                s1 = ((Formula)this.sub1).getAsReadableString(v, map);
                return "FORALL( " + s1 + " )";
            }
            case 6: {
                s1 = ((Formula)this.sub1).getAsReadableString(v, map);
                return "EXISTS( " + s1 + " )";
            }
            case 2: {
                return "false";
            }
            case 1: {
                return "true";
            }
            case 4: 
            case 5: {
                s1 = ((Formula)this.sub1).getAsReadableString(v, map);
                s2 = ((Formula)this.sub2).getAsReadableString(v, map);
                return "(" + s1 + (this.op == 4 ? " & " : " | ") + s2 + ")";
            }
            case 0: {
                String n;
                if (this.sub1 instanceof Formula) {
                    return "(" + ((Formula)this.sub1).getAsString(v, map) + ")";
                }
                if (!map.containsKey(this.sub1)) {
                    int i = v.size();
                    v.add(this.sub1);
                    n = Integer.toString(i + 1, 10);
                    map.put(this.sub1, n);
                } else {
                    n = map.get(this.sub1);
                }
                return n;
            }
        }
        return "true";
    }

    public boolean compareTo(Formula f) {
        String form1;
        if (!this.getName().equals(f.getName())) {
            return false;
        }
        Vector<Evaluable> vec = new Vector<Evaluable>();
        String form = this.getAsString(vec);
        return form.equals(form1 = f.getAsString(vec));
    }

    private boolean isValid(Evaluable e) {
        if (e == null) {
            return false;
        }
        if (!(e instanceof Formula)) {
            return true;
        }
        return ((Formula)e).isValid();
    }

    public boolean isValid() {
        this.evaluable = true;
        switch (this.op) {
            case -1: {
                return false;
            }
            case 1: 
            case 2: {
                return true;
            }
            case 0: 
            case 3: 
            case 6: 
            case 7: {
                return this.isValid(this.sub1);
            }
            case 4: 
            case 5: {
                return this.isValid(this.sub1) && this.isValid(this.sub2);
            }
        }
        return false;
    }

    private void setEvaluable(Evaluable e) {
        if (e instanceof AtomConstraint) {
            this.evaluable = this.evaluable && ((AtomConstraint)e).isEvaluable();
        } else if (e instanceof Formula) {
            this.evaluable = this.evaluable && ((Formula)e).isEvaluable();
        } else if (e instanceof NestedApplCond) {
            this.evaluable = this.evaluable && ((NestedApplCond)e).isEvaluable();
        }
    }

    public boolean isEvaluable() {
        return this.evaluable;
    }

    @Override
    public boolean eval(Object o) {
        return this.eval(o, -1);
    }

    @Override
    public boolean eval(Object o, int t) {
        int tick = t;
        if (tick == -1) {
            if (this.running_tick < 0) {
                this.running_tick = 0;
            }
            tick = this.running_tick++;
        }
        switch (this.op) {
            case 0: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 3: {
                if (this.sub1 != null) {
                    boolean result = !this.sub1.eval(o, tick, true);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 4: {
                if (this.sub1 != null && this.sub2 != null) {
                    boolean result = this.sub1.eval(o, tick) && this.sub2.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    this.setEvaluable(this.sub2);
                    return result;
                }
                return false;
            }
            case 5: {
                boolean result;
                if (this.sub1 != null) {
                    result = this.sub1.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    if (result) {
                        return result;
                    }
                }
                if (this.sub2 != null) {
                    result = this.sub2.eval(o, tick);
                    this.setEvaluable(this.sub2);
                    if (result) {
                        return result;
                    }
                }
                return false;
            }
            case 7: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.evalForall(o, tick);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 6: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean eval(Object o, boolean negation) {
        return this.eval(o, -1, negation);
    }

    @Override
    public boolean eval(Object o, int t, boolean negation) {
        int tick = t;
        if (tick == -1) {
            if (this.running_tick < 0) {
                this.running_tick = 0;
            }
            tick = this.running_tick++;
        }
        switch (this.op) {
            case 0: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.eval(o, tick, negation);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 3: {
                if (this.sub1 != null) {
                    boolean result = !this.sub1.eval(o, tick, true);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 4: {
                if (this.sub1 != null && this.sub2 != null) {
                    boolean result = this.sub1.eval(o, tick, false) && this.sub2.eval(o, tick, false);
                    this.setEvaluable(this.sub1);
                    this.setEvaluable(this.sub2);
                    return result;
                }
                return false;
            }
            case 5: {
                boolean result;
                if (this.sub1 != null) {
                    result = this.sub1.eval(o, tick, false);
                    this.setEvaluable(this.sub1);
                    if (result) {
                        return result;
                    }
                }
                if (this.sub2 != null) {
                    result = this.sub2.eval(o, tick, false);
                    this.setEvaluable(this.sub2);
                    if (result) {
                        return result;
                    }
                }
                return false;
            }
            case 7: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.evalForall(o, tick);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 6: {
                if (this.sub1 != null) {
                    boolean result = this.sub1.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    return result;
                }
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void patchOutEvaluable(Evaluable e, boolean subst) {
        switch (this.op) {
            case 4: 
            case 5: {
                if (this.sub1 == e) {
                    this.sub1 = new Formula(subst);
                } else if (this.sub1 != null && this.sub1 instanceof Formula) {
                    ((Formula)this.sub1).patchOutEvaluable(e, subst);
                }
                if (this.sub2 != e) ** GOTO lbl11
                this.sub2 = new Formula(subst);
                ** GOTO lbl13
lbl11:
                // 1 sources

                if (this.sub2 != null && this.sub2 instanceof Formula) {
                    ((Formula)this.sub2).patchOutEvaluable(e, subst);
                }
            }
lbl13:
            // 5 sources

            case 3: {
                if (this.sub1 != e) ** GOTO lbl17
                this.sub1 = new Formula(subst == false);
                ** GOTO lbl19
lbl17:
                // 1 sources

                if (this.sub1 != null && this.sub1 instanceof Formula) {
                    ((Formula)this.sub1).patchOutEvaluable(e, subst == false);
                }
            }
lbl19:
            // 5 sources

            case 0: 
            case 6: 
            case 7: {
                if (this.sub1 == e) {
                    this.sub1 = new Formula(subst);
                    break;
                }
                if (this.sub1 == null || !(this.sub1 instanceof Formula)) break;
                ((Formula)this.sub1).patchOutEvaluable(e, subst);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void patchInEvaluableAsDisjunction(Evaluable e, List<Evaluable> subst) {
        s = "";
        if (subst.size() > 0) {
            s = "1";
        }
        i = 1;
        while (i < subst.size()) {
            s = String.valueOf(s) + "|" + String.valueOf(i + 1);
            ++i;
        }
        f = new Formula(subst, s);
        switch (this.op) {
            case 4: 
            case 5: {
                if (this.sub1 == e) {
                    this.sub1 = f;
                } else if (this.sub1 != null && this.sub1 instanceof Formula) {
                    ((Formula)this.sub1).patchInEvaluableAsDisjunction(e, subst);
                }
                if (this.sub2 != e) ** GOTO lbl20
                this.sub2 = f;
                ** GOTO lbl22
lbl20:
                // 1 sources

                if (this.sub2 != null && this.sub2 instanceof Formula) {
                    ((Formula)this.sub2).patchInEvaluableAsDisjunction(e, subst);
                }
            }
lbl22:
            // 5 sources

            case 3: {
                if (this.sub1 != e) ** GOTO lbl26
                this.sub1 = f;
                ** GOTO lbl28
lbl26:
                // 1 sources

                if (this.sub1 != null && this.sub1 instanceof Formula) {
                    ((Formula)this.sub1).patchInEvaluableAsDisjunction(e, subst);
                }
            }
lbl28:
            // 5 sources

            case 0: 
            case 6: 
            case 7: {
                if (this.sub1 == e) {
                    this.sub1 = f;
                    break;
                }
                if (this.sub1 == null || !(this.sub1 instanceof Formula)) break;
                ((Formula)this.sub1).patchInEvaluableAsDisjunction(e, subst);
            }
        }
    }

    public Formula(int _op, Evaluable e1, Evaluable e2) {
        this.init(_op, e1, e2);
    }

    private String getAsString(List<Evaluable> v, HashMap<Evaluable, String> map) {
        String s1 = "";
        String s2 = "";
        switch (this.op) {
            case -1: {
                return "";
            }
            case 3: {
                return "(!" + ((Formula)this.sub1).getAsString(v, map) + ")";
            }
            case 7: {
                s1 = ((Formula)this.sub1).getAsString(v, map);
                return "A( " + s1 + " )";
            }
            case 6: {
                s1 = ((Formula)this.sub1).getAsString(v, map);
                return "E( " + s1 + " )";
            }
            case 2: {
                return "F";
            }
            case 1: {
                return "T";
            }
            case 4: {
                s1 = ((Formula)this.sub1).getAsString(v, map);
                s2 = ((Formula)this.sub2).getAsString(v, map);
                return "( " + s1 + " & " + s2 + " )";
            }
            case 5: {
                s1 = ((Formula)this.sub1).getAsString(v, map);
                s2 = ((Formula)this.sub2).getAsString(v, map);
                return "( " + s1 + " | " + s2 + " )";
            }
            case 0: {
                String n;
                if (this.sub1 instanceof Formula) {
                    return "(" + ((Formula)this.sub1).getAsString(v, map) + ")";
                }
                if (!map.containsKey(this.sub1)) {
                    int i = v.size();
                    v.add(this.sub1);
                    n = Integer.toString(i + 1, 10);
                    map.put(this.sub1, n);
                } else {
                    n = map.get(this.sub1);
                }
                return n;
            }
        }
        return "true";
    }

    private void skipWS(StringCharacterIterator i) {
        char c = i.current();
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
            c = i.next();
        }
    }

    private Formula get_multiple(List<Evaluable> vars, StringCharacterIterator i) {
        Formula ret = this.get_one(vars, i);
        while (ret != null) {
            Formula f;
            char c = i.current();
            if (c == '\uffff') break;
            if (c == '&' || c == '|') {
                while (i.current() == c) {
                    i.next();
                }
                Formula f2 = this.get_one(vars, i);
                if (f2 == null) {
                    ret = null;
                    continue;
                }
                ret = new Formula(c == '&' ? 4 : 5, ret, f2);
                continue;
            }
            if (c == 'A') {
                i.next();
                c = i.next();
                f = this.get_one(vars, i);
                if (f == null) {
                    return null;
                }
                return new Formula(7, f, null);
            }
            if (c == 'E') {
                i.next();
                c = i.next();
                f = this.get_one(vars, i);
                if (f == null) {
                    return null;
                }
                return new Formula(6, f, null);
            }
            if (c == 'T') {
                return this.get_one(vars, i);
            }
            if (c == 'F') {
                return this.get_one(vars, i);
            }
            if (c == ')') {
                c = i.next();
                this.skipWS(i);
                break;
            }
            this.skipWS(i);
        }
        return ret;
    }

    private Formula get_one(List<Evaluable> vars, StringCharacterIterator i) {
        this.skipWS(i);
        char c = i.current();
        if (c == '(') {
            c = i.next();
            if (c == '\uffff') {
                return null;
            }
            Formula f = this.get_multiple(vars, i);
            if (i.current() == ')') {
                c = i.next();
            }
            return f;
        }
        if (c == '!') {
            c = i.next();
            Formula f = this.get_one(vars, i);
            if (f == null) {
                return null;
            }
            return new Formula(3, f, null);
        }
        if (c == 'A') {
            i.next();
            c = i.next();
            Formula f1 = this.get_one(vars, i);
            if (f1 == null) {
                return null;
            }
            return new Formula(7, f1, null);
        }
        if (c == 'E') {
            i.next();
            c = i.next();
            Formula f1 = this.get_one(vars, i);
            if (f1 == null) {
                return null;
            }
            return new Formula(6, f1, null);
        }
        if (c == 'T') {
            c = i.next();
            return new Formula(true);
        }
        if (c == 'F') {
            c = i.next();
            return new Formula(false);
        }
        if (c >= '0' && c <= '9') {
            int v = 0;
            while (c >= '0' && c <= '9') {
                v = v * 10 + (c - 48);
                c = i.next();
            }
            this.skipWS(i);
            if (--v < 0 || v >= vars.size()) {
                return null;
            }
            return new Formula(0, vars.get(v), null);
        }
        if (c == 'f' || c == 't') {
            while (i.current() >= 'a' && i.current() <= 'z') {
                i.next();
            }
            this.skipWS(i);
            return new Formula(c == 't');
        }
        return null;
    }

    public static List<Integer> getFromStringAboveList(String s, List<String> list) {
        Vector<Integer> result = new Vector<Integer>(2);
        Vector<String> edit = new Vector<String>(5, 2);
        StringCharacterIterator i = new StringCharacterIterator(s);
        char c = i.current();
        while (c != '\uffff') {
            String cs;
            if (c == '&' || c == '|' || c == '!' || c == '$' || c == 'A' || c == 'E' || c == ' ' || c == ',' || c == '(' || c == ')') {
                edit.add(String.valueOf(c));
                i.next();
            } else if (c >= '0' && c <= '9') {
                cs = "";
                int v = 0;
                while (c >= '0' && c <= '9') {
                    cs = cs.concat(String.valueOf(c));
                    v = v * 10 + (c - 48);
                    c = i.next();
                }
                if (--v < 0 || v >= list.size()) {
                    return result;
                }
                edit.add(String.valueOf(cs));
            } else if (c == 'f' || c == 't') {
                cs = "";
                while (i.current() >= 'a' && i.current() <= 'z') {
                    cs = cs.concat(String.valueOf(c));
                    i.next();
                }
                edit.add(String.valueOf(cs));
            }
            c = i.current();
        }
        int j = 0;
        while (j < edit.size()) {
            try {
                result.add(Integer.valueOf((String)edit.get(j)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++j;
        }
        return result;
    }

    public int getOperation() {
        return this.op;
    }

    public Evaluable getFirst() {
        return this.sub1;
    }

    public Evaluable getSecond() {
        return this.sub2;
    }

    public boolean isNOT(Evaluable var, Vector<Evaluable> vars) {
        boolean b = false;
        switch (this.op) {
            case -1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: 
            case 6: 
            case 7: {
                b = ((Formula)this.sub1).isNOT(var, vars);
                return b;
            }
            case 4: 
            case 5: {
                b = ((Formula)this.sub1).isNOT(var, vars);
                if (!b) {
                    b = ((Formula)this.sub2).isNOT(var, vars);
                }
                return b;
            }
            case 0: {
                if (this.sub1 instanceof Formula) {
                    b = ((Formula)this.sub1).isNOT(var, vars);
                } else if (vars.contains(this.sub1) && this.sub1 == var) {
                    b = true;
                }
                return b;
            }
        }
        return b;
    }

    public Vector<Integer> getLayer() {
        return this.layer;
    }

    public String getLayerAsString() {
        String str = "";
        int k = 0;
        while (k < this.layer.size()) {
            int l = this.layer.get(k);
            str = String.valueOf(str) + String.valueOf(l);
            if (k < this.layer.size() - 1) {
                str = String.valueOf(str) + ",";
            }
            ++k;
        }
        return str;
    }

    public void addLayer(int l) {
        boolean added = false;
        int i = 0;
        while (i < this.layer.size()) {
            if (l <= this.layer.get(i)) {
                this.layer.add(i, new Integer(l));
                added = true;
                break;
            }
            ++i;
        }
        if (!added) {
            this.layer.add(new Integer(l));
        }
    }

    public void setLayer(Vector<Integer> l) {
        this.layer = l;
    }

    public Vector<Integer> getPriority() {
        return this.priority;
    }

    public String getPriorityAsString() {
        String str = "";
        int k = 0;
        while (k < this.priority.size()) {
            int l = this.priority.get(k);
            str = String.valueOf(str) + String.valueOf(l);
            if (k < this.priority.size() - 1) {
                str = String.valueOf(str) + ",";
            }
            ++k;
        }
        return str;
    }

    public void addPriority(int p) {
        boolean added = false;
        int i = 0;
        while (i < this.priority.size()) {
            if (p <= this.priority.get(i)) {
                this.priority.add(i, new Integer(p));
                added = true;
                break;
            }
            ++i;
        }
        if (!added) {
            this.priority.add(new Integer(p));
        }
    }

    public void setPriority(Vector<Integer> p) {
        this.priority = p;
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Formula", this)) {
            int i;
            String[] array;
            String size;
            String attr_enabled;
            this.name = h.readAttr("name");
            String str = h.readAttr("comment");
            if (!str.equals("")) {
                this.comment = str;
            }
            this.enabled = (attr_enabled = h.readAttr("enabled")) == null || !attr_enabled.equals("false");
            if (this.layer == null) {
                this.layer = new Vector(5);
            } else {
                this.layer.clear();
            }
            if (h.readSubTag("Layer")) {
                String l = h.readAttr("Layer");
                size = h.readAttr("Size");
                if (!"".equals(l)) {
                    if ((l = l.replaceAll(" ", "")).indexOf("[") >= 0) {
                        l = l.substring(1);
                    }
                    if (l.indexOf("]") >= 0) {
                        l = l.substring(0, l.length() - 1);
                    }
                    array = l.split(",");
                    i = 0;
                    while (i < array.length) {
                        try {
                            this.layer.add(new Integer(array[i]));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                h.close();
            }
            if (this.priority == null) {
                this.priority = new Vector(5);
            } else {
                this.priority.clear();
            }
            if (h.readSubTag("Priority")) {
                String p = h.readAttr("Priority");
                size = h.readAttr("Size");
                if (!"".equals(p)) {
                    if ((p = p.replaceAll(" ", "")).indexOf("[") >= 0) {
                        p = p.substring(1);
                    }
                    if (p.indexOf("]") >= 0) {
                        p = p.substring(0, p.length() - 1);
                    }
                    array = p.split(",");
                    i = 0;
                    while (i < array.length) {
                        try {
                            this.priority.add(new Integer(array[i]));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                h.close();
            }
            h.close();
        }
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Formula", this);
        h.addAttr("name", this.getName());
        h.addAttr("comment", this.comment);
        h.addAttr("enabled", String.valueOf(this.enabled));
        h.openSubTag("Layer");
        if (this.layer.size() == 0) {
            h.addAttr("Layer", "");
        } else if (this.layer.size() == 1) {
            String l = this.layer.get(0).toString();
            h.addAttr("Layer", l);
        } else {
            h.addAttr("Layer", this.layer.toString());
        }
        h.addAttr("Size", String.valueOf(this.layer.size()));
        h.close();
        h.openSubTag("Priority");
        if (this.priority.size() == 0) {
            h.addAttr("Priority", "");
        } else if (this.priority.size() == 1) {
            String p = this.priority.get(0).toString();
            h.addAttr("Priority", p);
        } else {
            h.addAttr("Priority", this.priority.toString());
        }
        h.addAttr("Size", String.valueOf(this.priority.size()));
        h.close();
        h.close();
    }

    @Override
    public boolean evalForall(Object o, int t) {
        int tick = t;
        if (tick == -1) {
            if (this.running_tick < 0) {
                this.running_tick = 0;
            }
            tick = this.running_tick++;
        }
        switch (this.op) {
            case 0: {
                if (this.sub1 != null) {
                    if (this.sub1 instanceof NestedApplCond) {
                        ((NestedApplCond)this.sub1).forall = true;
                    }
                    boolean result = this.sub1.eval(o, tick);
                    this.setEvaluable(this.sub1);
                    if (this.sub1 instanceof NestedApplCond) {
                        ((NestedApplCond)this.sub1).forall = false;
                    }
                    return result;
                }
                return false;
            }
        }
        return false;
    }

    public void trimToSize() {
        this.layer.trimToSize();
        this.priority.trimToSize();
    }
}

