/*
 * Decompiled with CFR 0.152.
 */
package agg.gui;

import agg.gui.AGGAnalyzer;
import agg.gui.AGGConstraints;
import agg.gui.AGGPreferences;
import agg.gui.DebugFrame;
import agg.gui.StatusBar;
import agg.gui.cpa.CriticalPairAnalysis;
import agg.gui.editor.GraGraEditor;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.help.GraGraHelp;
import agg.gui.parser.AGGParser;
import agg.gui.ruleappl.ApplicabilityRuleSequence;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.gui.termination.TerminationAnalysis;
import agg.gui.treeview.GraGraTreeView;
import agg.xt_basis.Version;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class AGGAppl
extends JFrame
implements EditEventListener {
    static final long serialVersionUID = 42L;
    public static final int FRAME_WIDTH = 900;
    public static final int FRAME_HEIGHT = 550;
    public static final int INITIAL_WIDTH = 350;
    public static final int INITIAL_HEIGHT = 400;
    protected static final AGGAppl appl = new AGGAppl();
    private String aggTitle = "AGG";
    public static final int total = 10;
    public static int currentProgressValue;
    public static final JProgressBar progressBar;
    static final JDialog logoFrame;
    static final JLabel gragraLogo;
    private static final JPanel contentPanel;
    private static final JPanel toolBarPanel;
    private static final JMenuBar menuBar;
    private static final StatusBar statusBar;
    private static final JPanel mainPanel;
    private static final JMenu helpMenu;
    protected static final GraGraTreeView treeView;
    protected static final GraGraEditor editor;
    private static final boolean DEBUGFRAME = false;
    private static final AGGAnalyzer aggAnalyzer;
    private static final TerminationAnalysis terminationAnalysis;
    protected static final CriticalPairAnalysis criticalPairAnalysis;
    private static final ApplicabilityRuleSequence aggApplRuleSequence;
    private static final AGGConstraints aggConstraints;
    private static final AGGParser aggParser;
    private static final AGGPreferences aggPreferences;
    private static final GraphicsExportJPEG exportJPEG;
    private static final ImageIcon image;
    private static final JLabel loadlabel;
    private static final JSplitPane splitPane;
    private static final JPanel progressPanel;
    protected static String fname;
    protected static boolean typesHidden;

    static {
        progressBar = new JProgressBar();
        logoFrame = new JDialog();
        gragraLogo = new JLabel();
        contentPanel = new JPanel(new BorderLayout(), true);
        toolBarPanel = new JPanel(new GridLayout(2, 1));
        menuBar = new JMenuBar();
        statusBar = new StatusBar();
        mainPanel = new JPanel(new BorderLayout(), true);
        helpMenu = new GraGraHelp();
        treeView = new GraGraTreeView(appl);
        editor = new GraGraEditor(appl);
        aggAnalyzer = new AGGAnalyzer(appl, treeView);
        terminationAnalysis = new TerminationAnalysis(appl, treeView);
        criticalPairAnalysis = new CriticalPairAnalysis(appl, treeView);
        aggApplRuleSequence = new ApplicabilityRuleSequence(appl, treeView, criticalPairAnalysis.getCriticalPairOption());
        aggConstraints = new AGGConstraints(appl, treeView);
        aggParser = new AGGParser(appl, treeView);
        aggPreferences = new AGGPreferences(appl);
        exportJPEG = new GraphicsExportJPEG(appl);
        image = new ImageIcon(ClassLoader.getSystemResource("agg/lib/icons/AGG_LOGO.gif"));
        loadlabel = new JLabel("Loading  graph  grammar,  please wait . . .");
        splitPane = new JSplitPane(1, treeView, editor);
        progressPanel = new JPanel(){

            @Override
            public Insets getInsets() {
                return new Insets(30, 10, 10, 10);
            }
        };
    }

    public static final AGGAppl getInstance() {
        return appl;
    }

    public static void main(String[] args) {
        long time0 = System.currentTimeMillis();
        fname = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].endsWith(".ggx")) {
                fname = args[i];
            } else if (args[i].equals("-t")) {
                typesHidden = true;
            }
            ++i;
        }
        appl.initApplication();
        appl.showApplication(args);
        AGGAppl.criticalPairAnalysis.allowNodeTypeInheritance = true;
        treeView.enableNestedApplCond(true);
        editor.enableNestedApplCond(true);
        aggPreferences.selectTypesOnTop(!typesHidden);
        System.out.println("AGG used " + (System.currentTimeMillis() - time0) + " ms" + " to start.");
    }

    private void createApplContent() {
        progressBar.setValue(++currentProgressValue);
        statusBar.setFrame(this);
        contentPanel.add((Component)statusBar, "South");
        progressBar.setValue(++currentProgressValue);
        editor.addEditEventListener(this);
        editor.addEditEventListener(statusBar);
        editor.getTypeEditor().addTypeEventListener(statusBar);
        editor.setExportJPEG(exportJPEG);
        progressBar.setValue(++currentProgressValue);
        treeView.setExportJPEG(exportJPEG);
        treeView.addSaveEventListener(statusBar);
        treeView.addLoadEventListener(statusBar);
        treeView.addTreeViewEventListener(statusBar);
        treeView.addTreeViewEventListener(editor);
        treeView.addTreeModelListener(editor);
        editor.addEditEventListener(treeView);
        editor.getGraGraTransform().addTransformEventListener(treeView);
        aggPreferences.addActionListenerOfDefaults(treeView.getActionAdapter());
        progressBar.setValue(++currentProgressValue);
        toolBarPanel.add(treeView.getToolBar());
        toolBarPanel.add(editor.getToolBar());
        aggParser.addStatusMessageListener(statusBar);
        aggParser.addParserEventListener(statusBar);
        editor.addEditEventListener(aggParser);
        aggPreferences.addActionListenerOfDefaults(editor.getActionListener());
        progressBar.setValue(++currentProgressValue);
        editor.addEditEventListener(aggAnalyzer);
        aggAnalyzer.addCriticalPairAnalysis(criticalPairAnalysis);
        treeView.addTreeViewEventListener(criticalPairAnalysis);
        criticalPairAnalysis.addCPAnalysisEventListener(statusBar);
        criticalPairAnalysis.addStatusMessageListener(statusBar);
        criticalPairAnalysis.setLayerOption(aggParser.getLayerOption());
        criticalPairAnalysis.setParserOption(aggParser.getParserOption());
        criticalPairAnalysis.setGUIOption(aggParser.getParserGUIOption());
        criticalPairAnalysis.setExportJPEG(exportJPEG);
        aggParser.setCriticalPairOption(criticalPairAnalysis.getCriticalPairOption());
        progressBar.setValue(++currentProgressValue);
        aggAnalyzer.addApplicabilityRuleSequence(aggApplRuleSequence);
        treeView.addTreeViewEventListener(aggApplRuleSequence);
        aggAnalyzer.addConstraints(aggConstraints);
        aggAnalyzer.addTerminationAnalysis(terminationAnalysis);
        treeView.addTreeViewEventListener(terminationAnalysis);
        aggAnalyzer.addCPAOptions();
        progressBar.setValue(++currentProgressValue);
        aggPreferences.getOptionGUI().addGUI(editor.getGeneralTransformOptionGUI());
        aggPreferences.getOptionGUI().addGUI(editor.getTransformOptionGUI());
        aggPreferences.getOptionGUI().addGUI(editor.getGraphLayouterOptionGUI());
        aggPreferences.getOptionGUI().addGUI(aggParser.getParserOptionGUI());
        aggPreferences.getOptionGUI().addGUI(aggAnalyzer.getCriticalPairAnalysis().getCriticalPairOptionGUI());
        aggPreferences.addActionListenerOfDefaults(editor.getActionListener());
        editor.addEditEventListener(aggPreferences);
        editor.getTransformOptionGUI().addActionListener(aggAnalyzer.getCriticalPairAnalysis().getCriticalPairOptionGUI());
        editor.getTransformOptionGUI().addActionListener(treeView.getActionAdapter());
        aggAnalyzer.getCriticalPairAnalysis().getCriticalPairOptionGUI().addActionListener(editor.getTransformOptionGUI());
        editor.getGeneralTransformOptionGUI().addOptionListener(aggParser);
        editor.getGeneralTransformOptionGUI().addOptionListener(aggAnalyzer.getCriticalPairAnalysis());
        progressBar.setValue(++currentProgressValue);
        mainPanel.setPreferredSize(new Dimension(900, 550));
        mainPanel.add((Component)toolBarPanel, "North");
        splitPane.setDividerSize(15);
        splitPane.setPreferredSize(new Dimension(900, 550));
        splitPane.setContinuousLayout(true);
        splitPane.setOneTouchExpandable(true);
        mainPanel.add((Component)splitPane, "Center");
        mainPanel.revalidate();
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.revalidate();
        progressBar.setValue(++currentProgressValue);
        this.addMenus(treeView.getMenus());
        this.addMenus(editor.getMenus());
        this.addMenus(aggParser.getMenus());
        this.addMenus(aggAnalyzer.getMenus());
        this.addMenus(aggPreferences.getMenus());
        this.addHelpMenu();
    }

    public void initApplication() {
        String ver = Version.getID();
        System.out.println(">>> This AGG version 2.1 (and all future versions) \n    is made available under the terms of the Eclipse Public License v1.0 \n    which accompanies this distribution, and is available at \n    http://www.eclipse.org/legal/epl-v10.html.");
        System.out.println(">>> ");
        System.out.println(">>> Java Version " + System.getProperty("java.version"));
        System.out.println(">>> AGG Version " + ver + " runs under JVM 1.6 and higher.");
        appl.setTitle("AGG  " + ver);
        this.aggTitle = appl.getTitle();
        appl.getContentPane().setLayout(new BorderLayout());
        JOptionPane.setRootFrame(appl);
        WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Object[] options = new Object[]{"SAVE", "EXIT"};
                treeView.exitAppl(options);
            }
        };
        appl.addWindowListener(wl);
        ComponentAdapter cl = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                editor.resetTypePanelWidth();
            }
        };
        appl.addComponentListener(cl);
        URL url = ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/AGG_ICON64.gif");
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            if (icon.getImage() != null) {
                appl.setIconImage(icon.getImage());
            }
        } else {
            System.out.println("AGG_ICON64.gif not found!");
        }
    }

    private void showApplicationLogo() {
        logoFrame.setModal(false);
        logoFrame.getContentPane().setLayout(new BorderLayout());
        logoFrame.setSize(350, 400);
        if (image == null) {
            System.out.println("AGG_LOGO.gif not found!");
        } else {
            gragraLogo.setIcon(image);
            gragraLogo.setPreferredSize(new Dimension(image.getIconWidth(), image.getIconHeight()));
            logoFrame.getContentPane().add((Component)gragraLogo, "Center");
        }
        WindowAdapter wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                logoFrame.setVisible(false);
            }
        };
        logoFrame.addWindowListener(wl);
        progressPanel.setLayout(new BoxLayout(progressPanel, 1));
        progressPanel.setBackground(Color.white);
        Dimension d = new Dimension(300, 20);
        JLabel progressLabel = new JLabel("Loading, please wait...");
        progressLabel.setAlignmentX(0.5f);
        progressLabel.setMaximumSize(d);
        progressLabel.setPreferredSize(d);
        progressPanel.add(progressLabel);
        progressPanel.add(Box.createRigidArea(new Dimension(300, 5)));
        progressLabel.setLabelFor(progressBar);
        progressBar.setAlignmentX(0.5f);
        progressBar.setMinimum(0);
        progressBar.setMaximum(10);
        progressBar.setValue(0);
        progressBar.setPreferredSize(new Dimension(300, 20));
        progressPanel.add(progressBar);
        progressPanel.revalidate();
        logoFrame.getContentPane().add((Component)progressPanel, "South");
        Point locationPoint = this.getLocationPoint(350, 400);
        logoFrame.setLocation(locationPoint);
        logoFrame.setCursor(Cursor.getPredefinedCursor(3));
        logoFrame.pack();
        logoFrame.setVisible(true);
    }

    public void showApplication(String[] args) {
        appl.showApplicationLogo();
        appl.createApplContent();
        appl.setJMenuBar(menuBar);
        appl.getContentPane().add((Component)contentPanel, "Center");
        appl.setLocation(new Point(100, 100));
        appl.setCursor(Cursor.getPredefinedCursor(0));
        appl.pack();
        logoFrame.setVisible(false);
        appl.setVisible(true);
        this.createFileLoadLogo();
        if (fname != null && fname.length() > 0) {
            logoFrame.setVisible(true);
            Thread tmpThread = new Thread(){

                @Override
                public void run() {
                    treeView.loadGraGra(fname);
                    logoFrame.setVisible(false);
                }
            };
            tmpThread.start();
        }
    }

    private Point getLocationPoint(int wdth, int hght) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize.width <= 1400) {
            return new Point(screenSize.width / 2 - wdth / 2, screenSize.height / 2 - hght / 2 - 100);
        }
        return new Point(screenSize.width / 4 - wdth / 2, screenSize.height / 2 - hght / 2 - 200);
    }

    private void createFileLoadLogo() {
        logoFrame.getContentPane().remove(progressPanel);
        logoFrame.getContentPane().add((Component)loadlabel, "South");
        logoFrame.setCursor(Cursor.getPredefinedCursor(3));
        logoFrame.pack();
    }

    public static void showFileLoadLogo() {
        if (!logoFrame.isVisible()) {
            logoFrame.setCursor(Cursor.getPredefinedCursor(3));
            logoFrame.setVisible(true);
            logoFrame.toFront();
        } else {
            logoFrame.toFront();
        }
    }

    public static void hideFileLoadLogo() {
        if (logoFrame.isVisible()) {
            logoFrame.setVisible(false);
        }
    }

    public static AGGAppl sharedInstance() {
        return appl;
    }

    public void addMenus(Enumeration<JMenu> menus) {
        while (menus.hasMoreElements()) {
            menuBar.add(menus.nextElement());
        }
    }

    public void addMenu(JMenu menu) {
        menuBar.add(menu);
    }

    public void removeMenus(Enumeration<JMenu> menus) {
        while (menus.hasMoreElements()) {
            JMenu m = menus.nextElement();
            this.removeMenu(m);
        }
    }

    public void removeMenu(JMenu menu) {
        int i = menuBar.getMenuCount() - 1;
        while (i >= 0) {
            JMenu m = menuBar.getMenu(i);
            if (m == menu) {
                menuBar.remove(i);
            }
            --i;
        }
    }

    public void setMenuEnabled(int indx, boolean enabled) {
        menuBar.getMenu(indx).setEnabled(enabled);
    }

    public void extendHelp(JMenuItem item) {
        if (helpMenu != null) {
            helpMenu.add(item);
        }
    }

    public void removeHelp(JMenuItem item) {
        if (helpMenu != null) {
            helpMenu.remove(item);
        }
    }

    public void setMainContent(Component comp) {
        mainPanel.removeAll();
        mainPanel.add(comp, "Center");
        this.validate();
        this.repaint();
    }

    public static void resetMainContent() {
        mainPanel.removeAll();
        mainPanel.add((Component)toolBarPanel, "North");
        mainPanel.add((Component)splitPane, "Center");
        statusBar.setMode(editor.getEditMode(), new EditEvent(new Object(), editor.getEditMode()).getMessage());
    }

    public void removeMainContent() {
        mainPanel.removeAll();
    }

    public void addToFrameTitle(String dirname, String filename) {
        String str = "";
        if (dirname != null && !dirname.equals("")) {
            str = dirname.endsWith(File.separator) ? str.concat(dirname) : str.concat(dirname).concat(File.separator);
        }
        if (filename != null && !filename.equals("")) {
            str = str.concat(filename);
        }
        if (str.equals("")) {
            appl.setTitle(this.aggTitle);
        } else {
            appl.setTitle(this.aggTitle.concat("     ( ".concat(str).concat(" )")));
        }
    }

    private void addHelpMenu() {
        ((GraGraHelp)helpMenu).setParentFrame(this);
        menuBar.add(helpMenu);
    }

    private void addDebugMenu() {
        JMenu debug = menuBar.add(new JMenu("DEBUG", true));
        debug.setMnemonic('D');
        JMenuItem mi = debug.add(new JMenuItem("DebugPrefs"));
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugFrame df = new DebugFrame();
                df.setVisible(true);
            }
        });
    }

    public void addToolBar(JToolBar aToolBar) {
        toolBarPanel.add(aToolBar);
    }

    public GraGraTreeView getGraGraTreeView() {
        return treeView;
    }

    public GraGraEditor getGraGraEditor() {
        return editor;
    }

    public AGGPreferences getPreferences() {
        return aggPreferences;
    }

    public CriticalPairAnalysis getCPA() {
        return criticalPairAnalysis;
    }

    public ApplicabilityRuleSequence getARS() {
        return aggApplRuleSequence;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public void exportJPEG() {
        exportJPEG.save(editor);
    }

    public void exportAppl2JPEG() {
        exportJPEG.save(mainPanel);
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -10 && e.getMessage().equals("Help")) {
            helpMenu.doClick();
        }
    }

    public void setPreferenceNoArcParallel(boolean b) {
        aggPreferences.selectNoArcParallel(b);
    }
}

