/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.editor.impl.EdGraGra;
import agg.gui.cpa.CriticalPairPanel;
import agg.gui.cpa.GraphDesktop;
import agg.gui.cpa.IntNumberDialog;
import agg.gui.options.ParserGUIOption;
import agg.gui.parser.event.CPAEventData;
import agg.gui.parser.event.GUIOptionEvent;
import agg.gui.parser.event.GUIOptionListener;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.CriticalPairData;
import agg.parser.CriticalPairEvent;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.PairContainer;
import agg.util.Pair;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class CriticalPairAnalysisGUI
implements ParserGUIListener,
ActionListener,
GUIOptionListener {
    public static final String CRITICALPAIRS = "Critical Pairs";
    public static final String CINFLICTSPAIRS = "Minimal Conflicts";
    public static final String DEPENDENCYPAIRS = "Minimal Dependencies";
    public static final String PARSER = "Parser";
    public static final String LOAD = "Load Pairs";
    public static final String SAVE = "Save Pairs";
    public static final String EXCLUDE = "Exclude";
    public static final String BEFORE = "Before";
    JSplitPane mainPane;
    JSplitPane treePane;
    JSplitPane graphPane;
    GraGra grammar;
    GraphDesktop gDesktop;
    Rule links;
    Rule rechts;
    CriticalPairPanel pairPanel;
    CriticalPairPanel pairPanel2;
    boolean isPanel2 = false;
    Thread threadCP;
    boolean threadCPisAlive;
    Vector<StatusMessageListener> listener;
    EdGraGra layout;
    PairContainer beo;
    PairContainer beo2;
    ParserGUIOption option;
    IntNumberDialog fromToDialog;
    boolean showGACsWarn = true;

    public CriticalPairAnalysisGUI(JFrame applFrame, ParserGUIOption option) {
        this(applFrame, null, null, option);
    }

    public CriticalPairAnalysisGUI(JFrame applFrame, GraGra gragra, EdGraGra layout, ParserGUIOption option) {
        this.setGrammar(gragra);
        this.gDesktop = new GraphDesktop(applFrame, layout, option);
        this.gDesktop.addParserGUIListener(this);
        this.setLayout(layout);
        this.option = option;
        if (option != null) {
            option.addOptionListener(this);
        }
        this.listener = new Vector();
        if (option != null) {
            this.gDesktop.setOverlappingGraphWindowSize(option.getCriticalPairWindowSize());
        } else {
            this.gDesktop.setOverlappingGraphWindowSize(new Dimension(250, 200));
        }
        this.graphPane = new JSplitPane(0);
        this.graphPane.setOneTouchExpandable(false);
        this.graphPane.setTopComponent(null);
        this.graphPane.setBottomComponent(this.gDesktop.getComponent());
        this.graphPane.setDividerLocation(0);
        this.mainPane = new JSplitPane();
        this.mainPane.setOneTouchExpandable(false);
        this.mainPane.setLeftComponent(null);
        this.mainPane.setRightComponent(this.graphPane);
        this.mainPane.setDividerLocation(0);
        this.mainPane.revalidate();
        this.fromToDialog = new IntNumberDialog(null);
    }

    public void addMouseListener(MouseListener ml) {
        this.treePane.addMouseListener(ml);
        this.gDesktop.getComponent().addMouseListener(ml);
        if (this.pairPanel != null) {
            this.pairPanel.getMainContainer().addMouseListener(ml);
        }
        if (this.pairPanel2 != null) {
            this.pairPanel.getMainContainer().addMouseListener(ml);
        }
    }

    private void setGrammar(GraGra gragra) {
        this.grammar = gragra;
    }

    public void setCriticalPairs(PairContainer pairs) {
        if (pairs == null || pairs.getGrammar().getListOfRules().isEmpty()) {
            return;
        }
        if (pairs.getKindOfConflict() == 1 || pairs.getKindOfConflict() == 2) {
            this.setCriticalPairs2(pairs);
            return;
        }
        this.beo = pairs;
        if (this.pairPanel == null) {
            String cpTableName = CINFLICTSPAIRS;
            this.pairPanel = this.beo instanceof LayeredExcludePairContainer ? new CriticalPairPanel(this.beo.getRules(), this.beo.getRules2(), (LayeredExcludePairContainer)this.beo) : new CriticalPairPanel(this.beo.getRules(), this.beo.getRules2(), (ExcludePairContainer)this.beo);
            this.gDesktop.addCriticalPairTable(this.pairPanel, cpTableName);
            this.mainPane.revalidate();
            this.mainPane.repaint();
            this.pairPanel.addParserGUIListener(this);
            ((ExcludePairContainer)this.beo).addPairEventListener(this.pairPanel);
        } else {
            if (this.beo instanceof LayeredExcludePairContainer) {
                this.pairPanel.setPairContainer((LayeredExcludePairContainer)this.beo);
            } else {
                this.pairPanel.setPairContainer((ExcludePairContainer)this.beo);
            }
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
            this.mainPane.revalidate();
            this.mainPane.repaint();
            ((ExcludePairContainer)this.beo).addPairEventListener(this.pairPanel);
        }
        this.fireStatusMessageEvent(new StatusMessageEvent(this, ""));
    }

    private void setCriticalPairs2(PairContainer pairs) {
        if (pairs == null || pairs.getGrammar().getListOfRules().isEmpty()) {
            return;
        }
        this.beo2 = pairs;
        if (this.pairPanel2 == null) {
            String cpTableName = DEPENDENCYPAIRS;
            if (this.beo2 instanceof LayeredDependencyPairContainer) {
                this.pairPanel2 = new CriticalPairPanel(this.beo2.getRules(), this.beo2.getRules2(), (LayeredDependencyPairContainer)this.beo2);
            } else if (this.beo2 instanceof DependencyPairContainer) {
                this.pairPanel2 = new CriticalPairPanel(this.beo2.getRules(), this.beo2.getRules2(), (DependencyPairContainer)this.beo2);
            }
            this.gDesktop.addCriticalPairTable(this.pairPanel2, cpTableName);
            this.mainPane.revalidate();
            this.mainPane.repaint();
            this.pairPanel2.addParserGUIListener(this);
            ((ExcludePairContainer)this.beo2).addPairEventListener(this.pairPanel2);
        } else {
            if (this.beo2 instanceof LayeredDependencyPairContainer) {
                this.pairPanel2.setPairContainer((LayeredDependencyPairContainer)this.beo2);
            } else if (this.beo instanceof DependencyPairContainer) {
                this.pairPanel2.setPairContainer((DependencyPairContainer)this.beo2);
            }
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
            this.mainPane.revalidate();
            this.mainPane.repaint();
            ((ExcludePairContainer)this.beo2).addPairEventListener(this.pairPanel2);
        }
        this.fireStatusMessageEvent(new StatusMessageEvent(this, ""));
    }

    public PairContainer getCriticalPairs() {
        return this.beo;
    }

    public PairContainer getCriticalPairs2() {
        return this.beo2;
    }

    public PairContainer getCriticalPairs(int kindOfConflict) {
        if (kindOfConflict == 0) {
            return this.beo;
        }
        if (kindOfConflict == 1) {
            return this.beo2;
        }
        if (kindOfConflict == 2) {
            return this.beo2;
        }
        return null;
    }

    private void setLayout(EdGraGra edgragra) {
        this.layout = edgragra;
        this.gDesktop.setLayout(this.layout);
    }

    public boolean isEmpty() {
        return !(this.beo != null && !this.beo.isEmpty() || this.beo2 != null && !this.beo2.isEmpty());
    }

    public Container getContainer() {
        return this.mainPane;
    }

    public CriticalPairPanel getCriticalPairPanel() {
        return this.pairPanel;
    }

    public CriticalPairPanel getCriticalPairPanel2() {
        return this.pairPanel2;
    }

    public CriticalPairPanel getCriticalPairPanel(int kind) {
        if (kind == 0) {
            return this.pairPanel;
        }
        if (kind == 1) {
            return this.pairPanel2;
        }
        if (kind == 2) {
            return this.pairPanel2;
        }
        return null;
    }

    public void reinitGraphDesktop() {
        if (this.beo != null) {
            ((ExcludePairContainer)this.beo).removePairEventListener(this.pairPanel);
        }
        if (this.beo2 != null) {
            ((ExcludePairContainer)this.beo2).removePairEventListener(this.pairPanel2);
        }
        this.gDesktop.reinitComponents();
        this.pairPanel = null;
        this.beo = null;
        this.pairPanel2 = null;
        this.beo2 = null;
        this.gDesktop.getDesktop().repaint();
        this.showGACsWarn = true;
    }

    public GraphDesktop getGraphDesktop() {
        return this.gDesktop;
    }

    public JFrame getApplFrame() {
        return this.gDesktop.parentFrame;
    }

    public void update() {
        this.gDesktop.refresh();
        this.mainPane.revalidate();
        this.mainPane.repaint();
    }

    public String setGraGra(EdGraGra edgragra) {
        if (edgragra == null) {
            this.reinitGraphDesktop();
            this.grammar = null;
            this.layout = null;
            this.links = null;
            this.rechts = null;
        } else {
            if (this.grammar == null || edgragra.getBasisGraGra() != this.grammar) {
                this.reinitGraphDesktop();
                this.setGrammar(edgragra.getBasisGraGra());
                if (this.pairPanel != null) {
                    ((ExcludePairContainer)this.beo).removePairEventListener(this.pairPanel);
                    this.gDesktop.removePairPanelFrame(this.pairPanel);
                    this.pairPanel = null;
                    this.beo = null;
                }
                if (this.pairPanel2 != null) {
                    ((ExcludePairContainer)this.beo2).removePairEventListener(this.pairPanel2);
                    this.gDesktop.removePairPanelFrame(this.pairPanel2);
                    this.pairPanel2 = null;
                    this.beo2 = null;
                }
            }
            this.setLayout(edgragra);
            this.links = null;
            this.rechts = null;
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
        }
        return "";
    }

    public EdGraGra getGraGra() {
        return this.layout;
    }

    public void setGUIOption(ParserGUIOption opt) {
        this.option = opt;
        this.gDesktop.setGUIOption(opt);
        this.option.addOptionListener(this);
    }

    public JMenu createMenu() {
        JMenu m = new JMenu("Parse");
        m.add(new JCheckBoxMenuItem(CRITICALPAIRS, false));
        m.add(new JMenuItem(PARSER));
        m.addSeparator();
        JMenuItem load = new JMenuItem(LOAD);
        JMenuItem save = new JMenuItem(SAVE);
        load.setEnabled(false);
        save.setEnabled(false);
        m.add(load);
        m.add(save);
        m.addSeparator();
        JMenu beforeExcludeList = new JMenu("Mode");
        m.add(beforeExcludeList);
        JCheckBoxMenuItem exclude = new JCheckBoxMenuItem(EXCLUDE, true);
        exclude.addActionListener(this);
        JCheckBoxMenuItem before = new JCheckBoxMenuItem(BEFORE, false);
        before.addActionListener(this);
        beforeExcludeList.add(exclude);
        beforeExcludeList.add(before);
        return m;
    }

    void getRulesByEvent(ParserGUIEvent pguie) {
        if (pguie.getSource() == this.pairPanel) {
            this.gDesktop.setIconOfCPAGraph(true);
            this.gDesktop.setIconOfRules(true);
            if (pguie.getData() instanceof Pair) {
                if (((Pair)pguie.getData()).first instanceof Rule && ((Pair)pguie.getData()).second instanceof Rule) {
                    this.isPanel2 = false;
                    this.links = (Rule)((Pair)pguie.getData()).first;
                    this.rechts = (Rule)((Pair)pguie.getData()).second;
                }
            } else if (pguie.getData() instanceof CriticalPairData) {
                this.isPanel2 = false;
                this.links = ((CriticalPairData)pguie.getData()).getRule1();
                this.rechts = ((CriticalPairData)pguie.getData()).getRule2();
            }
        } else if (pguie.getSource() == this.pairPanel2) {
            this.gDesktop.setIconOfCPAGraph(true);
            this.gDesktop.setIconOfRules(true);
            if (pguie.getData() instanceof Pair) {
                if (((Pair)pguie.getData()).first instanceof Rule && ((Pair)pguie.getData()).second instanceof Rule) {
                    this.isPanel2 = true;
                    this.links = (Rule)((Pair)pguie.getData()).first;
                    this.rechts = (Rule)((Pair)pguie.getData()).second;
                }
            } else if (pguie.getData() instanceof CriticalPairData) {
                this.isPanel2 = true;
                this.links = ((CriticalPairData)pguie.getData()).getRule1();
                this.rechts = ((CriticalPairData)pguie.getData()).getRule2();
            }
        }
        if (this.links != null && this.rechts != null) {
            this.gDesktop.addRule1(this.links, 300, 150);
            this.gDesktop.addRule2(this.rechts, 300, 150);
        }
    }

    Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> getOverlappingsByEvent(ParserGUIEvent pguie) {
        Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlappings = null;
        Hashtable<Graph, Vector<Hashtable<GraphObject, GraphObject>>> overlappingsForGraph = null;
        try {
            if (!this.isPanel2) {
                if (pguie.getData() instanceof Pair) {
                    if (this.beo.useHostGraphEnabled()) {
                        overlappingsForGraph = ((ExcludePairContainer)this.beo).getCriticalForGraph(this.links, this.rechts);
                        if (overlappingsForGraph != null && !overlappingsForGraph.isEmpty()) {
                            overlappings = ((ExcludePairContainer)this.beo).getCriticalPair(this.links, this.rechts, 0, true);
                        }
                        this.gDesktop.refresh();
                    } else {
                        overlappings = pguie.getMsg() == 10 ? ((ExcludePairContainer)this.beo).continueComputeCriticalPair(this.links, this.rechts, 0, true) : ((ExcludePairContainer)this.beo).getCriticalPair(this.links, this.rechts, 0, true);
                    }
                } else if (pguie.getData() instanceof CriticalPairData) {
                    overlappings = (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)((CriticalPairData)pguie.getData()).getCriticalsOfKind(-1);
                }
            } else if (pguie.getData() instanceof Pair) {
                overlappings = ((ExcludePairContainer)this.beo2).getCriticalPair(this.links, this.rechts, 0, true);
            } else if (pguie.getData() instanceof CriticalPairData) {
                overlappings = (Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>)((CriticalPairData)pguie.getData()).getCriticalsOfKind(-1);
            }
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
        return overlappings;
    }

    @Override
    public void occured(ParserGUIEvent pguie) {
        if (pguie.getData() instanceof CPAEventData || this.getCriticalPairs() != null && ((ExcludePairContainer)this.getCriticalPairs()).isAlive() || this.getCriticalPairs2() != null && ((ExcludePairContainer)this.getCriticalPairs2()).isAlive() || pguie.getData() instanceof CriticalPairEvent && ((CriticalPairEvent)pguie.getData()).getKey() == 6) {
            return;
        }
        if (pguie.getData() == null) {
            this.gDesktop.removeAllGraphFrames();
            this.gDesktop.removeRuleFrames();
            this.mainPane.revalidate();
            this.mainPane.repaint();
            return;
        }
        if (pguie.getSource() == this.gDesktop) {
            return;
        }
        if (this.threadCP == null || !this.threadCPisAlive) {
            this.mainPane.revalidate();
            this.mainPane.repaint();
            this.getRulesByEvent(pguie);
            this.mainPane.revalidate();
            this.mainPane.repaint();
            if (this.links != null && this.rechts != null) {
                StatusMessageEvent sme = new StatusMessageEvent(this, "", "Overlapping graphs of rules  [  " + this.links.getName() + "  ,  " + this.rechts.getName() + "  ]");
                this.fireStatusMessageEvent(sme);
                this.gDesktop.removeAllGraphFrames();
                this.mainPane.revalidate();
                this.mainPane.repaint();
                if (!this.isPanel2) {
                    ((ExcludePairContainer)this.beo).setStop(false);
                } else {
                    ((ExcludePairContainer)this.beo2).setStop(false);
                }
                this.threadCP = this.runCPairThread(pguie);
                this.threadCP.setPriority(4);
                this.threadCP.start();
            }
        }
    }

    Thread runCPairThread(final ParserGUIEvent pguie) {
        Thread th = new Thread(){

            @Override
            public void run() {
                CriticalPairAnalysisGUI.this.threadCPisAlive = true;
                CriticalPairAnalysisGUI.this.fireStatusMessageEvent(new StatusMessageEvent(this, "", "Thread  -  Computing overlapping graphs of rules  [  " + CriticalPairAnalysisGUI.this.links.getName() + "  ,  " + CriticalPairAnalysisGUI.this.rechts.getName() + "  ]  -  is running ..."));
                Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>> overlappings = CriticalPairAnalysisGUI.this.getOverlappingsByEvent(pguie);
                if (overlappings != null && overlappings.size() > 0) {
                    int x0 = 0;
                    int xn = overlappings.size() - 1;
                    if (overlappings.size() >= 50) {
                        CriticalPairAnalysisGUI.this.fromToDialog.showGUI(xn);
                        if (CriticalPairAnalysisGUI.this.fromToDialog.isCanceled()) {
                            x0 = 0;
                            xn = -1;
                        } else {
                            Point fromTo = CriticalPairAnalysisGUI.this.fromToDialog.getFromTo();
                            x0 = fromTo.x;
                            if (x0 > 0) {
                                --x0;
                            }
                            xn = fromTo.y;
                            --xn;
                        }
                    }
                    if (!CriticalPairAnalysisGUI.this.isPanel2) {
                        if (CriticalPairAnalysisGUI.this.beo instanceof DependencyPairContainer || CriticalPairAnalysisGUI.this.beo instanceof ExcludePairContainer) {
                            int x = x0;
                            while (x <= xn) {
                                Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = overlappings.elementAt(x);
                                Pair p1 = (Pair)p.first;
                                Graph graph = ((OrdinaryMorphism)p1.first).getTarget();
                                CriticalPairAnalysisGUI.this.gDesktop.addOverlapping(graph, p);
                                CriticalPairAnalysisGUI.this.gDesktop.addGraph(graph);
                                ++x;
                            }
                        }
                    } else if (CriticalPairAnalysisGUI.this.beo2 instanceof DependencyPairContainer) {
                        int x = x0;
                        while (x <= xn) {
                            Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p = overlappings.elementAt(x);
                            Pair p1 = (Pair)p.first;
                            Graph graph = ((OrdinaryMorphism)p1.first).getTarget();
                            CriticalPairAnalysisGUI.this.gDesktop.addOverlapping(graph, p);
                            CriticalPairAnalysisGUI.this.gDesktop.addGraph(graph);
                            ++x;
                        }
                    }
                    CriticalPairAnalysisGUI.this.showWarningWhenGACsUsed(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts);
                } else if (!CriticalPairAnalysisGUI.this.isPanel2) {
                    boolean hostGraphCheck = CriticalPairAnalysisGUI.this.beo.useHostGraphEnabled();
                    ExcludePairContainer.Entry entry = ((ExcludePairContainer)CriticalPairAnalysisGUI.this.beo).getEntry(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts, true);
                    if (entry.getState() == 3) {
                        if (hostGraphCheck) {
                            CriticalPairAnalysisGUI.this.gDesktop.notCriticFrame(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts, "on the current host graph");
                        } else {
                            CriticalPairAnalysisGUI.this.gDesktop.notCriticFrame(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts);
                        }
                        CriticalPairAnalysisGUI.this.showWarningWhenGACsUsed(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts);
                    }
                } else {
                    ExcludePairContainer.Entry entry = ((ExcludePairContainer)CriticalPairAnalysisGUI.this.beo2).getEntry(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts, true);
                    int state = entry.getState();
                    if (state == 3 || state == 31 || state == 32) {
                        if (entry.getStatus() == 7) {
                            JOptionPane.showMessageDialog(null, "This rule pair could not be computed \nbecause reverting of the rule <" + CriticalPairAnalysisGUI.this.links.getName() + ">" + " failed.");
                        } else {
                            CriticalPairAnalysisGUI.this.gDesktop.notCriticFrame(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts);
                            CriticalPairAnalysisGUI.this.showWarningWhenGACsUsed(CriticalPairAnalysisGUI.this.links, CriticalPairAnalysisGUI.this.rechts);
                        }
                    }
                }
                CriticalPairAnalysisGUI.this.fireStatusMessageEvent(new StatusMessageEvent(this, "", "Thread  -  Computing overlapping graphs of rules  [  " + CriticalPairAnalysisGUI.this.links.getName() + "  ,  " + CriticalPairAnalysisGUI.this.rechts.getName() + "  ]  -  finished"));
                CriticalPairAnalysisGUI.this.threadCPisAlive = false;
            }
        };
        return th;
    }

    void showWarningWhenGACsUsed(Rule r1, Rule r2) {
        String what = "";
        if (r1.hasEnabledACs(false)) {
            what = "The first rule: < ".concat(r1.getName()).concat(" > ");
        } else if (r2.hasEnabledACs(false)) {
            what = "The second rule: < ".concat(r2.getName()).concat(" > ");
        }
        if (!what.isEmpty() && this.showGACsWarn) {
            Object[] options = new Object[]{"OK", "Do not warn again"};
            int answer = JOptionPane.showOptionDialog(null, "The result of this critical pair may be incomplete! \n" + what + "\nmakes use of General Application Conditions.\n" + "Unfortunately, critical pair analysis does not take GACs in account" + "\n(not jet implemented).\n", "CPA", -1, 2, null, options, options[1]);
            this.showGACsWarn = answer == 0;
        }
    }

    public boolean isGenerating() {
        if (this.beo != null && ((ExcludePairContainer)this.beo).isAlive()) {
            return true;
        }
        return this.beo2 != null && ((ExcludePairContainer)this.beo2).isAlive();
    }

    public boolean pairsComputed() {
        if (this.beo != null && ((ExcludePairContainer)this.beo).isComputed()) {
            return true;
        }
        return this.beo2 != null && ((ExcludePairContainer)this.beo2).isComputed();
    }

    public boolean isOnePairThreadAlive() {
        return this.threadCP != null && this.threadCPisAlive;
    }

    public PairContainer getActivePairContainer() {
        CriticalPairPanel p = this.gDesktop.getActivePairPanel();
        if (p != null) {
            return p.getPairContainer();
        }
        return null;
    }

    public void stopOnePairThread() {
        if (this.threadCP != null && this.threadCPisAlive) {
            if (this.beo != null) {
                ((ExcludePairContainer)this.beo).setStop(true);
            }
            if (this.beo2 != null) {
                ((ExcludePairContainer)this.beo2).setStop(true);
            }
            this.threadCPisAlive = false;
        }
    }

    public void addStatusMessageListener(StatusMessageListener sml) {
        this.listener.addElement(sml);
    }

    void fireStatusMessageEvent(StatusMessageEvent sme) {
        int i = 0;
        while (i < this.listener.size()) {
            this.listener.elementAt(i).newMessage(sme);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void optionHasChanged(GUIOptionEvent e) {
        if (e.getChangedOption().equals("CriticalPairWindowSize")) {
            this.gDesktop.setOverlappingGraphWindowSize(this.option.getCriticalPairWindowSize());
        } else if (!e.getChangedOption().equals("ParserDisplay")) {
            e.getChangedOption().equals("NumberOfCriticalPair");
        }
    }
}

