/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.gui.cpa.ConflictsDependenciesContainerSaveLoad;
import agg.gui.cpa.ConflictsDependenciesGraph;
import agg.gui.cpa.CriticalPairAnalysisGUI;
import agg.gui.options.CriticalPairOptionGUI;
import agg.gui.options.ParserGUIOption;
import agg.gui.options.ParserOptionGUI;
import agg.gui.parser.LayerGUI;
import agg.gui.parser.PairIOGUI;
import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.parser.CriticalPairOption;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.LayerOption;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.OptionEventListener;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.parser.ParserOption;
import agg.parser.PriorityDependencyPairContainer;
import agg.parser.PriorityExcludePairContainer;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.RuleLayer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class CriticalPairAnalysisSeparated
implements ParserEventListener,
OptionListener,
OptionEventListener {
    protected final String title = "Critical Pair Analysis ";
    protected ParserGUIOption option;
    protected ParserOptionGUI pOptionGUI;
    protected ParserOption pOption;
    protected LayerOption lOption;
    protected CriticalPairOptionGUI cpOptionGUI;
    protected CriticalPairOption cpOption;
    protected CriticalPairAnalysisGUI pairsGUI;
    protected PairIOGUI pairsIOGUI;
    protected PairContainer excludePC;
    protected PairContainer dependPC;
    protected ConflictsDependenciesGraph conflictDependGraph;
    protected EdGraph cpaGraph;
    protected EdGraGra pairsGraGra;
    protected GraGra emptyGraGra;
    protected RuleLayer rlayer;
    protected JMenu menu;
    protected JMenu showCP;
    protected JMenuItem startCP;
    protected JMenuItem stopCP;
    protected JMenuItem reduceCP;
    protected JMenuItem consistCP;
    protected JMenuItem emptyCP;
    protected JMenuItem saveCP;
    protected JMenuItem showConflictCP;
    protected JMenuItem showDependencyCP;
    protected JMenuItem cpaCombiGraphCP;
    protected JFrame parent;
    protected JFrame frame;
    protected JLabel label;
    protected int x;
    protected int y;
    protected boolean ready;
    protected boolean needToLoad;
    protected boolean loaded;
    protected GraphicsExportJPEG exportJPEG;

    public CriticalPairAnalysisSeparated(JFrame parent, PairIOGUI pairsIOGUI, CriticalPairOptionGUI cpOptionGUI, CriticalPairOption cpOption, LayerOption lOption, ParserOption pOption, ParserGUIOption option) {
        this.parent = parent;
        this.pairsIOGUI = pairsIOGUI;
        this.cpOptionGUI = cpOptionGUI;
        this.needToLoad = true;
        this.createCriticalPairAnalysis(cpOption, lOption, pOption, option);
    }

    public CriticalPairAnalysisSeparated(JFrame parent, ExcludePairContainer conflictContainer, ExcludePairContainer dependContainer, CriticalPairOption cpOption, LayerOption lOption, ParserOption pOption, ParserGUIOption option) {
        this.parent = parent;
        this.excludePC = conflictContainer;
        this.dependPC = dependContainer;
        this.needToLoad = false;
        this.createCriticalPairAnalysis(cpOption, lOption, pOption, option);
    }

    public void extendTitle(String name) {
        String str = " ( ".concat(name).concat(" )");
        this.frame.setTitle("Critical Pair Analysis ".concat(str));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createCriticalPairAnalysis(CriticalPairOption cpoption, LayerOption loption, ParserOption poption, ParserGUIOption pguioption) {
        this.cpOption = cpoption;
        this.lOption = loption;
        this.pOption = poption;
        this.option = pguioption;
        this.cpOption.addOptionListener(this);
        this.frame = new JFrame("Critical Pair Analysis");
        JMenuBar menuBar = new JMenuBar();
        this.label = new JLabel("          ");
        this.frame.getContentPane().add((Component)this.label, "South");
        this.createAnalysisMenu("Critical Pair Analysis / Show");
        menuBar.add(this.menu);
        this.frame.setJMenuBar(menuBar);
        this.createCriticalPairAnalysisGUI();
        if (!this.needToLoad || this.loadCriticalPairs()) {
            if (!this.loaded) {
                if (this.excludePC != null && this.dependPC != null) {
                    if (!this.excludePC.getGrammar().compareTo(this.dependPC.getGrammar())) {
                        JOptionPane.showMessageDialog(null, "Show CPA Graph failed!\nConflicts and Dependencies use different grammars!", "CPA Graph", 0);
                        return;
                    }
                    this.pairsGraGra = new EdGraGra(this.excludePC.getGrammar());
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.pairsGUI.setCriticalPairs(this.excludePC);
                    this.pairsGUI.setCriticalPairs(this.dependPC);
                } else {
                    if (this.excludePC != null) {
                        this.pairsGraGra = new EdGraGra(this.excludePC.getGrammar());
                        this.pairsGUI.setGraGra(this.pairsGraGra);
                        this.pairsGUI.setCriticalPairs(this.excludePC);
                    }
                    if (this.dependPC != null) {
                        this.pairsGraGra = new EdGraGra(this.dependPC.getGrammar());
                        this.pairsGUI.setGraGra(this.pairsGraGra);
                        this.pairsGUI.setCriticalPairs(this.dependPC);
                    }
                }
            }
            this.stopCP.setEnabled(false);
            this.stopCPaddActionListener();
            this.showCP.setEnabled(true);
            this.showCPaddActionListener();
            this.saveCP.setEnabled(true);
            this.saveCPaddActionListener();
            this.ready = true;
        } else {
            this.ready = false;
        }
        this.frame.getContentPane().setSize(600, 500);
        this.frame.pack();
        this.frame.getRootPane().revalidate();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public EdGraGra getGraGra() {
        return this.pairsGraGra;
    }

    public ExcludePairContainer getPairContainer() {
        return (ExcludePairContainer)this.excludePC;
    }

    public ExcludePairContainer getPairContainer(int kindOfConflict) {
        if (kindOfConflict == 0) {
            return (ExcludePairContainer)this.excludePC;
        }
        if (kindOfConflict == 1 || kindOfConflict == 2) {
            return (ExcludePairContainer)this.dependPC;
        }
        return null;
    }

    public CriticalPairAnalysisGUI getCriticalPairAnalusisGUI() {
        return this.pairsGUI;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        if (this.pairsGUI != null) {
            this.pairsGUI.getGraphDesktop().setExportJPEG(this.exportJPEG);
        }
    }

    public void showFrame() {
        this.frame.setLocation(this.x, this.y);
        this.frame.setVisible(true);
    }

    public void toFront() {
        this.frame.toFront();
    }

    public void disposeFrame() {
        this.frame.dispose();
    }

    private void createAnalysisMenu(String menutitle) {
        this.menu = new JMenu(menutitle);
        this.stopCP = new JMenuItem("Stop");
        this.stopCP.setEnabled(false);
        this.menu.add(this.stopCP);
        this.saveCP = new JMenuItem("Save");
        this.saveCP.setEnabled(false);
        this.menu.add(this.saveCP);
        this.showCP = new JMenu("Show");
        this.showCP.setEnabled(false);
        this.showConflictCP = this.showCP.add(new JMenuItem("Conflicts"));
        this.showDependencyCP = this.showCP.add(new JMenuItem("Dependencies"));
        this.cpaCombiGraphCP = this.showCP.add(new JMenuItem("CPA Graph"));
        this.menu.add(this.showCP);
    }

    private void createCriticalPairAnalysisGUI() {
        this.pairsGUI = new CriticalPairAnalysisGUI(this.parent, this.option);
        ((JSplitPane)this.pairsGUI.getContainer()).setPreferredSize(new Dimension(550, 450));
        this.frame.getContentPane().add((Component)this.pairsGUI.getContainer(), "Center");
        if (this.needToLoad) {
            this.emptyGraGra = BaseFactory.theFactory().createGraGra();
            this.cpOption.enableLayered(true);
            if (this.pairsIOGUI == null) {
                this.excludePC = ParserFactory.createEmptyCriticalPairs(this.emptyGraGra, this.cpOption.getCriticalPairAlgorithm(), this.cpOption.layeredEnabled());
            }
        }
    }

    private boolean loadCriticalPairs() {
        Object o;
        if (this.pairsIOGUI == null) {
            this.pairsIOGUI = new PairIOGUI(this.parent);
        }
        if ((o = this.pairsIOGUI.load(true)) == null) {
            this.cpOption.enableLayered(false);
            return false;
        }
        if (this.pairsIOGUI.isCombined()) {
            ConflictsDependenciesContainerSaveLoad cdc = (ConflictsDependenciesContainerSaveLoad)o;
            if (this.cpaGraph != null && this.conflictDependGraph != null) {
                if (this.excludePC != null) {
                    this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(this.conflictDependGraph);
                }
                if (this.dependPC != null) {
                    this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(this.conflictDependGraph);
                }
                this.pairsGUI.getGraphDesktop().removeActionListenerFromCPAGraphMenu(this.conflictDependGraph);
            }
            this.cpOption.setOptionsFromList(cdc.getLoadedCPAOptions());
            this.pairsGUI.reinitGraphDesktop();
            this.excludePC = null;
            this.dependPC = null;
            this.pairsGUI.getGraphDesktop().getDesktop().repaint();
            if (cdc.isLayered()) {
                if (cdc.getLayeredExcludePairContainer() != null) {
                    this.excludePC = cdc.getLayeredExcludePairContainer();
                }
                if (cdc.getLayeredDependencyPairContainer() != null) {
                    this.dependPC = cdc.getLayeredDependencyPairContainer();
                }
                this.cpOption.enableLayered(true);
                this.cpOption.enablePriority(false);
            } else if (cdc.isPriority()) {
                if (cdc.getPriorityExcludePairContainer() != null) {
                    this.excludePC = cdc.getPriorityExcludePairContainer();
                }
                if (cdc.getPriorityDependencyPairContainer() != null) {
                    this.dependPC = cdc.getPriorityDependencyPairContainer();
                }
                this.cpOption.enablePriority(true);
                this.cpOption.enableLayered(false);
            } else {
                if (cdc.getExcludePairContainer() != null) {
                    this.excludePC = cdc.getExcludePairContainer();
                }
                if (cdc.getDependencyPairContainer() != null) {
                    this.dependPC = cdc.getDependencyPairContainer();
                }
                this.cpOption.enablePriority(false);
                this.cpOption.enableLayered(false);
            }
            if (cdc.getContainerCount() == 2) {
                this.pairsGraGra = cdc.getPairsGraGra();
                this.pairsGUI.setGraGra(this.pairsGraGra);
                this.resetCP_GUI(this.pairsGraGra, this.excludePC, true);
                this.resetCP_GUI(this.pairsGraGra, this.dependPC, true);
            } else if (cdc.getContainerCount() == 1) {
                if (this.excludePC != null) {
                    this.pairsGraGra = cdc.getPairsGraGra();
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.excludePC, true);
                } else if (this.dependPC != null) {
                    this.pairsGraGra = cdc.getPairsGraGra();
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.dependPC, true);
                }
            }
            this.cpaGraph = cdc.getCPAGraph();
            if (this.cpaGraph != null) {
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.excludePC, (ExcludePairContainer)this.dependPC, this.cpaGraph, true);
                if (this.excludePC != null) {
                    this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                if (this.dependPC != null) {
                    this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300);
                try {
                    this.pairsGUI.getGraphDesktop().getInternalCPAGraphFrame().setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.pairsGUI.getGraphDesktop().refresh();
            }
            this.cpOptionGUI.update();
            this.extendTitle(String.valueOf(this.pairsIOGUI.getFileName()) + " : " + this.pairsGraGra.getName());
            this.loaded = true;
        }
        return true;
    }

    private void resetCP_GUI(EdGraGra gragra, PairContainer pc, boolean newpc) {
        if (gragra == null || gragra.getRules().isEmpty()) {
            return;
        }
        if (pc != null) {
            if (newpc) {
                if (this.pairsGUI.getGraGra() != gragra) {
                    this.pairsGUI.setGraGra(gragra);
                }
                this.addPairEventListenerToPairContainer(pc);
                this.pairsGUI.setCriticalPairs(pc);
            } else {
                this.pairsGUI.update();
            }
            this.setCPoptions((ExcludePairContainer)pc);
        }
    }

    private void setCPoptions(ExcludePairContainer pc) {
        pc.enableComplete(this.cpOption.completeEnabled());
        pc.enableReduce(this.cpOption.reduceEnabled());
        pc.enableConsistent(this.cpOption.consistentEnabled());
        pc.enableIgnoreIdenticalRules(this.cpOption.ignoreIdenticalRulesEnabled());
        pc.enableReduceSameMatch(this.cpOption.reduceSameMatchEnabled());
        pc.enableStrongAttrCheck(this.cpOption.strongAttrCheckEnabled());
        pc.enableEqualVariableNameOfAttrMapping(this.cpOption.equalVariableNameOfAttrMappingEnabled());
        pc.enableNamedObjectOnly(this.cpOption.namedObjectEnabled());
        pc.enableMaxBoundOfCriticKind(this.cpOption.getMaxBoundOfCriticKind());
        if (!(pc instanceof DependencyPairContainer)) {
            pc.enableDirectlyStrictConfluent(this.cpOption.directlyStrictConflEnabled());
            pc.enableDirectlyStrictConfluentUpToIso(this.cpOption.directlyStrictConflUpToIsoEnabled());
        }
    }

    private void addPairEventListenerToPairContainer(PairContainer pc) {
        if (pc instanceof LayeredDependencyPairContainer) {
            ((LayeredDependencyPairContainer)pc).addPairEventListener(this);
        } else if (pc instanceof LayeredExcludePairContainer) {
            ((LayeredExcludePairContainer)pc).addPairEventListener(this);
        } else if (pc instanceof PriorityDependencyPairContainer) {
            ((PriorityDependencyPairContainer)pc).addPairEventListener(this);
        } else if (pc instanceof PriorityExcludePairContainer) {
            ((PriorityExcludePairContainer)pc).addPairEventListener(this);
        } else if (pc instanceof DependencyPairContainer) {
            ((DependencyPairContainer)pc).addPairEventListener(this);
        } else if (pc instanceof ExcludePairContainer) {
            ((ExcludePairContainer)pc).addPairEventListener(this);
        }
    }

    @Override
    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("finished") != -1) {
            this.updateCPAgraph();
            this.stopCP.setEnabled(false);
            this.saveCP.setEnabled(true);
        } else if (e.getMessage().indexOf("rule pair") != -1) {
            if (e.getMessage().indexOf("done") == -1) {
                this.stopCP.setEnabled(true);
                this.saveCP.setEnabled(false);
                this.showCP.setEnabled(false);
            } else {
                this.stopCP.setEnabled(false);
                this.saveCP.setEnabled(true);
                this.showCP.setEnabled(true);
            }
        } else if (e.getMessage().indexOf("done") != -1) {
            this.stopCP.setEnabled(false);
            this.saveCP.setEnabled(true);
            this.showCP.setEnabled(true);
        }
    }

    private void updateCPAgraph() {
        if (this.cpaGraph != null && this.conflictDependGraph != null) {
            this.conflictDependGraph.updateGraphAlongPairContainer();
            this.conflictDependGraph.updateGraphAlongPairContainer();
            this.cpaGraph.makeGraphObjectsOfNewBasisObjects(false);
            this.cpaGraph.setTransformChangeEnabled(true);
            this.cpaGraph.updateGraph();
            this.cpaGraph.setTransformChangeEnabled(false);
            this.pairsGUI.getGraphDesktop().refresh();
        }
    }

    @Override
    public void optionEventOccurred(OptionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.getText().equals("NACs")) {
                this.cpOption.enableNacs(cb.isSelected());
            } else if (cb.getText().equals("PACs")) {
                this.cpOption.enablePacs(cb.isSelected());
            }
        }
    }

    @Override
    public void optionEventOccurred(EventObject e) {
        if (e.getSource() instanceof CriticalPairOption) {
            if (this.excludePC != null) {
                this.setCPoptions((ExcludePairContainer)this.excludePC);
                if (this.excludePC instanceof LayeredExcludePairContainer) {
                    ((LayeredExcludePairContainer)this.excludePC).setLayer(this.cpOption.getLayer());
                }
            }
            if (this.dependPC != null) {
                ((DependencyPairContainer)this.dependPC).enableSwitchDependency(this.cpOption.switchDependencyEnabled());
                this.setCPoptions((ExcludePairContainer)this.dependPC);
                if (this.dependPC instanceof LayeredDependencyPairContainer) {
                    ((LayeredDependencyPairContainer)this.dependPC).setLayer(this.cpOption.getLayer());
                }
            }
        }
    }

    public CriticalPairAnalysisGUI getCriticalPairAnalysisGUI() {
        return this.pairsGUI;
    }

    public boolean isReady() {
        return this.ready;
    }

    private void stopCPaddActionListener() {
        this.stopCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC).stop();
                CriticalPairAnalysisSeparated.this.stopCP.setEnabled(false);
                CriticalPairAnalysisSeparated.this.saveCP.setEnabled(true);
                CriticalPairAnalysisSeparated.this.showCP.setEnabled(true);
                CriticalPairAnalysisSeparated.this.label.setText("Generating critical pairs is stopped. Please wait.");
            }
        });
    }

    private void saveCPaddActionListener() {
        this.saveCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.pairsGUI.isGenerating() || CriticalPairAnalysisSeparated.this.pairsGUI.isOnePairThreadAlive()) {
                    return;
                }
                if (CriticalPairAnalysisSeparated.this.pairsIOGUI == null) {
                    CriticalPairAnalysisSeparated.this.pairsIOGUI = new PairIOGUI(CriticalPairAnalysisSeparated.this.parent);
                }
                ConflictsDependenciesContainerSaveLoad cdPC = new ConflictsDependenciesContainerSaveLoad(CriticalPairAnalysisSeparated.this.excludePC, CriticalPairAnalysisSeparated.this.dependPC, CriticalPairAnalysisSeparated.this.cpaGraph, CriticalPairAnalysisSeparated.this.pairsGraGra);
                CriticalPairAnalysisSeparated.this.pairsIOGUI.setCriticalPairContainer(cdPC);
                CriticalPairAnalysisSeparated.this.pairsIOGUI.save();
            }
        });
    }

    protected PairContainer makeEmptyCriticalPairs(int kindOfAlgorithm) {
        if (kindOfAlgorithm == 0) {
            if (this.excludePC != null) {
                this.excludePC.clear();
                this.excludePC.refreshOptions(this.cpOption);
                return this.excludePC;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setConflictPairContainer(pc);
            }
            return pc;
        }
        if (kindOfAlgorithm == 1 || kindOfAlgorithm == 2) {
            if (this.dependPC != null) {
                this.dependPC.clear();
                this.dependPC.refreshOptions(this.cpOption);
                return this.dependPC;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setDependencyPairContainer(pc);
            }
            return pc;
        }
        return null;
    }

    private void showCPaddActionListener() {
        this.showConflictCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysisSeparated.this.showPairContainer(0);
            }
        });
        this.showDependencyCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysisSeparated.this.showPairContainer(1);
            }
        });
        this.showCPAGraphCPaddActionListener();
    }

    void showPairContainer(int kindOfConflict) {
        if (kindOfConflict == 0) {
            if (this.excludePC == null) {
                this.excludePC = this.makeEmptyCriticalPairs(0);
                this.resetCP_GUI(this.pairsGraGra, this.excludePC, true);
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getConflictPairPanel(), "");
            }
        } else if (kindOfConflict == 1) {
            if (this.dependPC == null) {
                this.dependPC = this.makeEmptyCriticalPairs(1);
                this.resetCP_GUI(this.pairsGraGra, this.dependPC, true);
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getDependPairPanel(), "");
            }
        }
    }

    private void showCPAGraphCPaddActionListener() {
        this.cpaCombiGraphCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysisSeparated.this.cpaGraph != null) {
                    if (CriticalPairAnalysisSeparated.this.conflictDependGraph != null) {
                        if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeActionListenerFromCPAGraphMenu(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    }
                    CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC, (ExcludePairContainer)CriticalPairAnalysisSeparated.this.dependPC, CriticalPairAnalysisSeparated.this.cpaGraph, false);
                    if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    }
                    if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    }
                    CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                    CriticalPairAnalysisSeparated.this.conflictDependGraph.setGraphDesktop(CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop());
                    CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeAllGraphFrames();
                    CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeRuleFrames();
                    CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeCPAGraphFrame();
                    CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDesktop().repaint();
                    try {
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addGraph(CriticalPairAnalysisSeparated.this.cpaGraph, 400, 300).setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    if (CriticalPairAnalysisSeparated.this.conflictDependGraph != null) {
                        if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                    }
                    CriticalPairAnalysisSeparated.this.conflictDependGraph = null;
                    if (CriticalPairAnalysisSeparated.this.excludePC != null && CriticalPairAnalysisSeparated.this.dependPC != null) {
                        CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC, (ExcludePairContainer)CriticalPairAnalysisSeparated.this.dependPC);
                        CriticalPairAnalysisSeparated.this.cpaGraph = CriticalPairAnalysisSeparated.this.conflictDependGraph.getGraph();
                    } else if (CriticalPairAnalysisSeparated.this.excludePC != null && CriticalPairAnalysisSeparated.this.excludePC.getKindOfConflict() == 0) {
                        CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)CriticalPairAnalysisSeparated.this.excludePC, null);
                        CriticalPairAnalysisSeparated.this.cpaGraph = CriticalPairAnalysisSeparated.this.conflictDependGraph.getGraph();
                    } else if (CriticalPairAnalysisSeparated.this.dependPC != null && CriticalPairAnalysisSeparated.this.dependPC.getKindOfConflict() == 1) {
                        CriticalPairAnalysisSeparated.this.conflictDependGraph = new ConflictsDependenciesGraph(null, (ExcludePairContainer)CriticalPairAnalysisSeparated.this.dependPC);
                        CriticalPairAnalysisSeparated.this.cpaGraph = CriticalPairAnalysisSeparated.this.conflictDependGraph.getGraph();
                    }
                    if (CriticalPairAnalysisSeparated.this.cpaGraph != null) {
                        if (CriticalPairAnalysisSeparated.this.excludePC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        if (CriticalPairAnalysisSeparated.this.dependPC != null) {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        }
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(CriticalPairAnalysisSeparated.this.conflictDependGraph);
                        CriticalPairAnalysisSeparated.this.conflictDependGraph.setGraphDesktop(CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop());
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeAllGraphFrames();
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().removeRuleFrames();
                        CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().getDesktop().repaint();
                        try {
                            CriticalPairAnalysisSeparated.this.pairsGUI.getGraphDesktop().addGraph(CriticalPairAnalysisSeparated.this.cpaGraph, 400, 300).setIcon(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        CriticalPairAnalysisSeparated.this.saveCP.setEnabled(true);
                        CriticalPairAnalysisSeparated.this.showCP.setEnabled(true);
                    } else {
                        JOptionPane.showMessageDialog(CriticalPairAnalysisSeparated.this.frame, "Show CPA graph failed!.", "Warning", 2);
                    }
                }
            }
        });
    }

    protected boolean resetLayerFunction() {
        if (this.cpOption.layeredEnabled()) {
            this.rlayer = new RuleLayer(this.pairsGraGra.getBasisGraGra().getEnabledRules());
            LayerGUI lgui = new LayerGUI(this.parent, this.rlayer);
            lgui.showGUI();
            if (lgui.isCancelled()) {
                this.cpOption.enableLayered(false);
                this.cpOptionGUI.update();
                this.rlayer = null;
            }
            return true;
        }
        return false;
    }
}

