/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.attribute.gui.AttrTopEditor;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.gui.AGGAppl;
import agg.gui.editor.GraGraEditor;
import agg.gui.editor.GraphCanvas;
import agg.gui.editor.GraphEditor;
import agg.gui.editor.GraphPanel;
import agg.gui.editor.RuleEditorMouseAdapter;
import agg.gui.editor.RuleEditorMouseMotionAdapter;
import agg.gui.popupmenu.EditPopupMenu;
import agg.gui.popupmenu.EditSelPopupMenu;
import agg.gui.popupmenu.ModePopupMenu;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.gui.treeview.nodedata.NACTreeNodeData;
import agg.gui.treeview.nodedata.NestedACTreeNodeData;
import agg.gui.treeview.nodedata.PACTreeNodeData;
import agg.xt_basis.Arc;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import agg.xt_basis.agt.RuleScheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public class RuleEditor
extends JPanel {
    private final RuleEditorMouseAdapter mouseAdapter;
    private final RuleEditorMouseMotionAdapter mouseMotionAdapter;
    protected final JFrame applFrame;
    private final GraGraEditor gragraEditor;
    private GraphEditor graphEditor;
    private AttrTopEditor attrEditor;
    private final JLabel title;
    private String titleKind = " ";
    private final JLabel titleAC;
    private String titleKindAC = " ";
    private String ruleName;
    private String gragraName;
    private String conclusionName;
    private String atomicName;
    private final JSplitPane splitPane;
    private final JSplitPane ruleSplitPane;
    private int ruleDividerLocation;
    private int acDividerLocation;
    private final Hashtable<Object, Integer> dividerLocationSet;
    private final GraphPanel leftPanel;
    private final GraphPanel rightPanel;
    private final GraphPanel leftCondPanel;
    private GraphPanel activePanel;
    private String msg = "";
    private EdGraGra eGra;
    private EdRule eRule;
    private EdNAC eNAC;
    private EdPAC ePAC;
    private EdNestedApplCond eGAC;
    private EdGraph sourceOfCopy;
    private ModePopupMenu modePopupMenu;
    private EditPopupMenu editPopupMenu;
    private EditSelPopupMenu editSelPopupMenu;
    private boolean isEditPopupMenu = false;
    private boolean isEditSelPopupMenu = false;
    private boolean doNotShowPopupMenu;
    private EdGraphObject leftObj;
    private EdGraphObject rightObj;
    private EdGraphObject leftCondObj;
    private EdGraphObject graphObj;
    private boolean synchrMoveOfMapObjs = false;
    private boolean draggingL = false;
    private boolean draggingR = false;
    private boolean draggingC = false;
    private boolean mapping = false;
    private boolean mouseListenerFromGraphEditorAdded = false;
    GraphicsExportJPEG exportJPEG;
    private final JButton exportJPEGButton;
    final JPanel mainPanel = this;

    public RuleEditor(GraGraEditor anEditor) {
        super(new BorderLayout());
        this.mouseAdapter = new RuleEditorMouseAdapter(this);
        this.mouseMotionAdapter = new RuleEditorMouseMotionAdapter(this);
        this.leftPanel = new GraphPanel(this);
        JPanel lPanel = new JPanel(new BorderLayout());
        lPanel.setPreferredSize(new Dimension(250, 150));
        lPanel.add((Component)this.leftPanel, "Center");
        this.rightPanel = new GraphPanel(this);
        JPanel rPanel = new JPanel(new BorderLayout());
        rPanel.setPreferredSize(new Dimension(250, 150));
        rPanel.add((Component)this.rightPanel, "Center");
        this.ruleSplitPane = new JSplitPane(1, lPanel, rPanel);
        this.ruleSplitPane.setBackground(Color.WHITE);
        this.ruleSplitPane.setDividerSize(10);
        this.ruleSplitPane.setContinuousLayout(true);
        this.ruleSplitPane.setOneTouchExpandable(true);
        this.ruleDividerLocation = 250;
        this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        JPanel panelRule = new JPanel(new BorderLayout());
        panelRule.setPreferredSize(new Dimension(500, 150));
        this.title = new JLabel("  ");
        this.exportJPEGButton = this.createExportJPEGButton();
        JPanel rtitlePanel = new JPanel(new BorderLayout());
        rtitlePanel.add((Component)this.title, "West");
        if (this.exportJPEGButton != null) {
            rtitlePanel.add((Component)this.exportJPEGButton, "East");
        }
        panelRule.add((Component)rtitlePanel, "North");
        panelRule.add((Component)this.ruleSplitPane, "Center");
        this.leftCondPanel = new GraphPanel(this);
        this.titleAC = new JLabel("  ");
        this.leftCondPanel.add((Component)this.titleAC, "North");
        this.splitPane = new JSplitPane(1, null, panelRule);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(0);
        this.acDividerLocation = 150;
        this.dividerLocationSet = new Hashtable(0);
        this.add((Component)this.splitPane, "Center");
        this.gragraEditor = anEditor;
        if (this.gragraEditor != null) {
            this.applFrame = anEditor.getParentFrame();
            if (this.gragraEditor.getGraphEditor() != null) {
                this.graphEditor = this.gragraEditor.getGraphEditor();
            }
        } else {
            this.applFrame = null;
        }
        this.leftPanel.getCanvas().addMouseListener(this.mouseAdapter);
        this.rightPanel.getCanvas().addMouseListener(this.mouseAdapter);
        this.leftCondPanel.getCanvas().addMouseListener(this.mouseAdapter);
        this.leftPanel.getCanvas().addMouseMotionListener(this.mouseMotionAdapter);
        this.rightPanel.getCanvas().addMouseMotionListener(this.mouseMotionAdapter);
        this.leftCondPanel.getCanvas().addMouseMotionListener(this.mouseMotionAdapter);
    }

    public JFrame getApplFrame() {
        return this.applFrame;
    }

    public RuleEditorMouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public RuleEditorMouseMotionAdapter getMouseMotionAdapter() {
        return this.mouseMotionAdapter;
    }

    public void setCursorOfApplFrame(Cursor cursor) {
        if (this.applFrame != null) {
            this.applFrame.setCursor(cursor);
        }
    }

    private JButton createExportJPEGButton() {
        URL url = ClassLoader.getSystemClassLoader().getResource("agg/lib/icons/print.gif");
        if (url != null) {
            ImageIcon image = new ImageIcon(url);
            JButton b = new JButton(image);
            b.setToolTipText("Export Rule JPEG");
            b.setMargin(new Insets(-5, 0, -5, 0));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RuleEditor.this.exportJPEG != null && !RuleEditor.this.exportJPEG.save(RuleEditor.this.mainPanel)) {
                        JOptionPane.showMessageDialog(RuleEditor.this.applFrame, "Cannot export to JPEG.\nThere are problems with the Class \n    com.sun.image.codec.jpeg.JPEGImageEncoder \nand the currently used JAVA 1.6 version.", "Expost failed", 0);
                    }
                }
            });
            b.setEnabled(false);
            return b;
        }
        return null;
    }

    public void setMoveCursorWhenLoop(EdGraphObject ego) {
        if (this.applFrame == null || ego == null || !ego.isArc() || ((EdArc)ego).isLine()) {
            return;
        }
        EdArc ea = (EdArc)ego;
        if (ea.getAnchorID() == 0) {
            this.applFrame.setCursor(new Cursor(13));
        } else if (ea.getAnchorID() == 1) {
            this.applFrame.setCursor(new Cursor(6));
        } else if (ea.getAnchorID() == 2) {
            this.applFrame.setCursor(new Cursor(7));
        } else if (ea.getAnchorID() == 3) {
            this.applFrame.setCursor(new Cursor(5));
        } else if (ea.getAnchorID() == 4) {
            this.applFrame.setCursor(new Cursor(4));
        }
    }

    public boolean setRuleMapping(EdGraphObject leftgo, EdGraphObject rightgo) {
        if (leftgo == null || rightgo == null) {
            return false;
        }
        if (this.eRule.getBasisRule() instanceof MultiRule && (((MultiRule)this.eRule.getBasisRule()).isTargetOfEmbeddingLeft(leftgo.getBasisObject()) || ((MultiRule)this.eRule.getBasisRule()).isTargetOfEmbeddingRight(rightgo.getBasisObject())) && !this.eRule.getBasisRule().getInverseImage(rightgo.getBasisObject()).hasMoreElements()) {
            JOptionPane.showMessageDialog(this.applFrame, "Mapping failed!\nNew objects of kernel rule cannot be mapped from a multi rule.", "Mapping Error", 0);
            return false;
        }
        this.eRule.addCreatedMappingToUndo(leftgo, rightgo);
        this.eRule.interactRule(leftgo, rightgo);
        this.eRule.propagateAddRuleMappingToMultiRule(leftgo, rightgo);
        this.leftPanel.updateGraphics();
        this.rightPanel.updateGraphics();
        if (this.eRule.isBadMapping()) {
            this.eRule.undoManagerLastEditDie();
            this.msg = this.eRule.getMsg();
            if (leftgo.isArc()) {
                JOptionPane.showMessageDialog(this.applFrame, this.msg, "Mapping Error", 0);
            }
            return false;
        }
        this.eRule.undoManagerEndEdit();
        if (this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
        }
        return true;
    }

    public boolean removeRuleMapping(EdGraphObject go, boolean ruleLHS) {
        if (go == null) {
            return false;
        }
        if (ruleLHS && go.getContext() == this.eRule.getLeft()) {
            if (this.eRule.getBasisRule() instanceof MultiRule && !go.getMorphismMark().isEmpty() && ((MultiRule)this.eRule.getBasisRule()).isTargetOfEmbeddingLeft(go.getBasisObject())) {
                JOptionPane.showMessageDialog(this.applFrame, "Cannot remove this mapping. It should be removed from the kernel rule.", "Remove Rule Object Mapping", 0);
                return false;
            }
            EdGraphObject rgo = null;
            if (this.eRule instanceof EdAtomic) {
                rgo = this.eRule.getRight().findGraphObject(((EdAtomic)this.eRule).getBasisAtomic().getImage(go.getBasisObject()));
            } else {
                this.eRule.propagateRemoveRuleMappingToMultiRule(go);
                rgo = this.eRule.getRight().findGraphObject(this.eRule.getBasisRule().getImage(go.getBasisObject()));
            }
            if (rgo != null) {
                this.eRule.addDeletedMappingToUndo(go, rgo);
                this.eRule.removeRuleMapping(go);
                this.eRule.undoManagerEndEdit();
                if (this.gragraEditor != null) {
                    this.gragraEditor.updateUndoButton();
                    this.gragraEditor.getGraGra().setChanged(true);
                }
                return true;
            }
            return false;
        }
        if (go.getContext() == this.eRule.getRight()) {
            if (this.eRule.getBasisRule() instanceof MultiRule && !go.getMorphismMark().isEmpty() && ((MultiRule)this.eRule.getBasisRule()).isTargetOfEmbeddingRight(go.getBasisObject())) {
                JOptionPane.showMessageDialog(this.applFrame, "Cannot remove this mapping. It should be removed from the kernel rule.", "Remove Graph Object Mapping", 0);
                return false;
            }
            Vector<EdGraphObject> vec = this.eRule.getOriginal(go);
            boolean result = false;
            int i = 0;
            while (i < vec.size()) {
                EdGraphObject lgo = vec.get(i);
                result = this.removeRuleMapping(lgo, true) || result;
                ++i;
            }
            if (result && this.gragraEditor != null) {
                this.gragraEditor.getGraGra().setChanged(true);
            }
            return result;
        }
        return false;
    }

    public void setMappingRule(EdGraphObject lobj, EdGraphObject robj) {
        if (lobj != null && robj != null) {
            if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping()) {
                this.setObjMapping(true);
            }
            if (this.setRuleMapping(lobj, robj)) {
                this.getLeftPanel().updateGraphics();
                this.getRightPanel().updateGraphics();
            }
        }
        if (lobj != null) {
            this.getLeftPanel().updateGraphics();
        }
        this.setObjMapping(false);
        if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping() && !this.isObjMapping()) {
            this.resetEditModeAfterMapping();
        }
    }

    public void setMappingRule(List<EdGraphObject> lobjs, EdGraphObject robj) {
        if (lobjs != null && robj != null) {
            if (this.isEditSelPopupMenuShown() && this.getEditSelPopupMenu().isMapping()) {
                this.setObjMapping(true);
            }
            boolean done = !lobjs.isEmpty();
            for (EdGraphObject lobj : lobjs) {
                if (!this.setRuleMapping(lobj, robj)) continue;
                done = true;
            }
            if (done) {
                this.getLeftPanel().updateGraphics();
                this.getRightPanel().updateGraphics();
            }
            this.setObjMapping(false);
        }
        if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping() && !this.isObjMapping()) {
            this.resetEditModeAfterMapping();
        }
    }

    public void setMappingApplCond(EdGraphObject lobj, EdGraphObject cobj) {
        if (lobj != null && cobj != null) {
            if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping()) {
                this.setObjMapping(true);
            }
            if (this.getNAC() != null && this.setNACMapping(lobj, cobj)) {
                this.getLeftPanel().updateGraphics();
                this.getLeftCondPanel().updateGraphics();
            } else if (this.getPAC() != null && this.setPACMapping(lobj, cobj)) {
                this.getLeftPanel().updateGraphics();
                this.getLeftCondPanel().updateGraphics();
            } else if (this.getNestedAC() != null && this.setNestedACMapping(lobj, cobj)) {
                this.getLeftPanel().updateGraphics();
                this.getLeftCondPanel().updateGraphics();
            }
        }
        if (lobj != null) {
            this.getLeftPanel().updateGraphics();
        }
        this.setObjMapping(false);
        if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping() && !this.isObjMapping()) {
            this.resetEditModeAfterMapping();
        }
    }

    public void setMappingApplCond(List<EdGraphObject> lobjs, EdGraphObject cobj) {
        if (lobjs != null && cobj != null) {
            if (this.isEditSelPopupMenuShown() && this.getEditSelPopupMenu().isMapping()) {
                this.setObjMapping(true);
            }
            boolean done = !lobjs.isEmpty();
            for (EdGraphObject lobj : lobjs) {
                if (this.getNAC() != null && this.setNACMapping(lobj, cobj)) {
                    done = true;
                    continue;
                }
                if (this.getPAC() != null && this.setPACMapping(lobj, cobj)) {
                    done = true;
                    continue;
                }
                if (this.getNestedAC() == null || !this.setNestedACMapping(lobj, cobj)) continue;
                done = true;
            }
            if (done) {
                this.getLeftPanel().updateGraphics();
                this.getLeftCondPanel().updateGraphics();
            }
        }
        this.setObjMapping(false);
        if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping() && !this.isObjMapping()) {
            this.resetEditModeAfterMapping();
        }
    }

    public void setMappingGraph(EdGraphObject lobj, EdGraphObject gobj) {
        if (lobj != null && gobj != null) {
            if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping()) {
                this.setObjMapping(true);
            }
            if (this.setMatchMapping(lobj, gobj)) {
                this.getLeftPanel().updateGraphics();
                this.getGraphEditor().getGraphPanel().updateGraphics();
            }
        }
        if (lobj != null) {
            this.getLeftPanel().updateGraphics();
        }
        this.setObjMapping(false);
        if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping() && !this.isObjMapping()) {
            this.resetEditModeAfterMapping();
        }
    }

    public void setMappingGraph(List<EdGraphObject> lobjs, EdGraphObject gobj) {
        if (lobjs != null && gobj != null) {
            if (this.isEditSelPopupMenuShown() && this.getEditSelPopupMenu().isMapping()) {
                this.setObjMapping(true);
            }
            boolean done = !lobjs.isEmpty();
            for (EdGraphObject lobj : lobjs) {
                if (!this.setMatchMapping(lobj, gobj)) continue;
                done = true;
            }
            if (done) {
                this.getLeftPanel().updateGraphics();
                this.getGraphEditor().getGraphPanel().updateGraphics();
            }
        }
        this.setObjMapping(false);
        if (this.isEditPopupMenuShown() && this.getEditPopupMenu().isMapping() && !this.isObjMapping()) {
            this.resetEditModeAfterMapping();
        }
    }

    public void removeMappingLeft(EdGraphObject obj) {
        if (obj == null) {
            return;
        }
        boolean unmapdone = false;
        Vector<EdGraphObject> l = new Vector<EdGraphObject>(1);
        EdGraphObject lgo = null;
        if (obj.isSelected()) {
            l.addAll(this.getRule().getLeft().getSelectedObjs());
        } else {
            l.add(obj);
        }
        int i = 0;
        while (i < l.size()) {
            lgo = (EdGraphObject)l.elementAt(i);
            if (this.removeRuleMapping(lgo, true) || this.getNAC() != null && this.removeNacMapping(lgo, true) || this.getPAC() != null && this.removePacMapping(lgo, true) || this.getNestedAC() != null && this.removeNestedACMapping(obj, true)) {
                unmapdone = true;
            }
            if (this.getRule().getMatch() != null && this.removeMatchMapping(lgo, true)) {
                unmapdone = true;
            }
            ++i;
        }
        if (unmapdone) {
            this.leftPanel.updateGraphics();
            this.rightPanel.updateGraphics();
            if (this.getNAC() != null) {
                this.leftCondPanel.updateGraphics();
            } else if (this.getPAC() != null) {
                this.leftCondPanel.updateGraphics();
            } else if (this.getNestedAC() != null) {
                this.leftCondPanel.updateGraphics();
            }
            if (this.getRule().getMatch() != null && this.getGraphEditor() != null) {
                this.getGraphEditor().getGraphPanel().updateGraphics();
            }
        }
    }

    public void removeMappingRight(EdGraphObject obj) {
        if (obj == null) {
            return;
        }
        Vector<EdGraphObject> vec = null;
        boolean unmapdone = false;
        EdGraphObject imageObj = null;
        Vector<EdGraphObject> l = new Vector<EdGraphObject>(1);
        if (obj.isSelected()) {
            l.addAll(this.getRule().getRight().getSelectedObjs());
        } else {
            l.add(obj);
        }
        int i = 0;
        while (i < l.size()) {
            imageObj = (EdGraphObject)l.elementAt(i);
            vec = this.getRule().getOriginal(imageObj);
            int j = 0;
            while (j < vec.size()) {
                EdGraphObject go = vec.get(j);
                if (this.removeRuleMapping(go, true)) {
                    unmapdone = true;
                }
                ++j;
            }
            ++i;
        }
        if (unmapdone) {
            this.leftPanel.updateGraphics();
            this.rightPanel.updateGraphics();
        }
    }

    public void removeMappingApplCond(EdGraphObject obj) {
        if (obj == null) {
            return;
        }
        boolean unmapdone = false;
        Vector<EdGraphObject> vec = null;
        EdGraphObject imageObj = null;
        EdGraphObject go = null;
        Vector<EdGraphObject> l = new Vector<EdGraphObject>(1);
        if (this.getNAC() != null) {
            if (obj.isSelected()) {
                l.addAll(this.getNAC().getSelectedObjs());
            } else {
                l.add(obj);
            }
            int i = 0;
            while (i < l.size()) {
                imageObj = (EdGraphObject)l.elementAt(i);
                vec = this.getNAC().getOriginal(imageObj);
                int j = 0;
                while (j < vec.size()) {
                    go = vec.get(j);
                    if (this.removeNacMapping(go, true)) {
                        unmapdone = true;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (this.getPAC() != null) {
            if (obj.isSelected()) {
                l.addAll(this.getPAC().getSelectedObjs());
            } else {
                l.add(obj);
            }
            int i = 0;
            while (i < l.size()) {
                imageObj = (EdGraphObject)l.elementAt(i);
                vec = this.getPAC().getOriginal(imageObj);
                int j = 0;
                while (j < vec.size()) {
                    go = vec.get(j);
                    if (this.removePacMapping(go, true)) {
                        unmapdone = true;
                    }
                    ++j;
                }
                ++i;
            }
        } else if (this.getNestedAC() != null) {
            if (obj.isSelected()) {
                l.addAll(this.getNestedAC().getSelectedObjs());
            } else {
                l.add(obj);
            }
            int i = 0;
            while (i < l.size()) {
                imageObj = (EdGraphObject)l.elementAt(i);
                vec = this.getNestedAC().getOriginal(imageObj);
                int j = 0;
                while (j < vec.size()) {
                    go = vec.get(j);
                    if (this.removeNestedACMapping(go, true)) {
                        unmapdone = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (unmapdone) {
            this.leftPanel.updateGraphics();
            this.leftCondPanel.updateGraphics();
        }
    }

    public void removeMappingGraph(EdGraphObject obj) {
        if (this.getGraphEditor() != null && obj != null) {
            boolean unmapdone = false;
            Enumeration<GraphObject> inverse = null;
            EdGraphObject lgo = null;
            if (obj.isSelected()) {
                EdGraphObject imageObj = null;
                int i = 0;
                while (i < this.getGraphEditor().getGraph().getSelectedObjs().size()) {
                    imageObj = this.getGraphEditor().getGraph().getSelectedObjs().get(i);
                    inverse = this.getRule().getMatch().getInverseImage(imageObj.getBasisObject());
                    while (inverse.hasMoreElements()) {
                        lgo = this.getRule().getLeft().findGraphObject(inverse.nextElement());
                        if (!this.removeMatchMapping(lgo, true)) continue;
                        unmapdone = true;
                    }
                    ++i;
                }
            } else if (this.getRule().getMatch() != null) {
                inverse = this.getRule().getMatch().getInverseImage(obj.getBasisObject());
                while (inverse.hasMoreElements()) {
                    lgo = this.getRule().getLeft().findGraphObject(inverse.nextElement());
                    if (!this.removeMatchMapping(lgo, true)) continue;
                    unmapdone = true;
                }
            }
            if (unmapdone) {
                this.leftPanel.updateGraphics();
                this.getGraphEditor().getGraphPanel().updateGraphics();
            }
        }
    }

    public boolean setNACMapping(EdGraphObject leftgo, EdGraphObject nacgo) {
        if (leftgo == null || nacgo == null) {
            return false;
        }
        this.eRule.addCreatedNACMappingToUndo(leftgo, nacgo);
        this.eRule.interactNAC(leftgo, nacgo, this.eNAC.getMorphism());
        if (!this.eRule.getBasisRule().compareConstantAttributeValue(leftgo.getBasisObject(), nacgo.getBasisObject())) {
            JOptionPane.showMessageDialog(this.applFrame, "NAC attribute value failed!\nThe value of an attribute member of a NAC \nhas to be equal to the correspondent \nattribute value of the LHS of a rule.\nNAC attribute value will be unset.", "Attribute value changed", 0);
        }
        this.leftPanel.updateGraphics();
        this.leftCondPanel.updateGraphics();
        if (this.eRule.isBadMapping()) {
            this.eRule.undoManagerLastEditDie();
            this.msg = this.eRule.getMsg();
            if (leftgo.isArc()) {
                JOptionPane.showMessageDialog(this.applFrame, this.msg, "Mapping Error", 0);
            }
            return false;
        }
        this.eRule.undoManagerEndEdit();
        if (this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
            this.gragraEditor.getGraGra().setChanged(true);
        }
        return true;
    }

    public boolean removeNacMapping(EdGraphObject go, boolean left) {
        if (go == null || this.eNAC == null) {
            return false;
        }
        if (left) {
            EdGraphObject ngo = this.eNAC.findGraphObject(this.eNAC.getMorphism().getImage(go.getBasisObject()));
            if (ngo != null) {
                this.eRule.addDeletedNACMappingToUndo(go, ngo);
                this.eRule.removeNACMapping(go, this.eNAC.getMorphism());
                this.eRule.undoManagerEndEdit();
                if (this.gragraEditor != null) {
                    this.gragraEditor.updateUndoButton();
                    this.gragraEditor.getGraGra().setChanged(true);
                }
                return true;
            }
            return false;
        }
        boolean res = false;
        Vector<EdGraphObject> vec = this.eNAC.getOriginal(go);
        int i = 0;
        while (i < vec.size()) {
            EdGraphObject lgo = vec.get(i);
            res = this.removeNacMapping(lgo, true) || res;
            ++i;
        }
        return res;
    }

    public boolean removeNacMapping(EdGraphObject left) {
        if (left == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < this.eRule.getNACs().size()) {
            EdNAC nac = this.eRule.getNACs().get(i);
            EdGraphObject ngo = nac.findGraphObject(nac.getMorphism().getImage(left.getBasisObject()));
            if (ngo != null) {
                this.eRule.addDeletedNACMappingToUndo(left, ngo);
                this.eRule.removeNACMapping(left, nac.getMorphism());
                this.eRule.undoManagerEndEdit();
                result = true;
            }
            ++i;
        }
        if (result && this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
            this.gragraEditor.getGraGra().setChanged(true);
        }
        return result;
    }

    public boolean setPACMapping(EdGraphObject leftgo, EdGraphObject pacgo) {
        if (leftgo == null || pacgo == null) {
            return false;
        }
        this.eRule.addCreatedACMappingToUndo(leftgo, pacgo);
        this.eRule.interactPAC(leftgo, pacgo, this.ePAC.getMorphism());
        if (!this.eRule.getBasisRule().compareConstantAttributeValue(leftgo.getBasisObject(), pacgo.getBasisObject())) {
            JOptionPane.showMessageDialog(this.applFrame, "PAC attribute value failed!\nThe value of each attribute of a PAC \nhas to be equal to the correspondent \nattribute value of the LHS of a rule.\nThe PAC attribute value will be unset.", "Attribute value changed", 0);
        }
        this.leftPanel.updateGraphics();
        this.leftCondPanel.updateGraphics();
        if (this.eRule.isBadMapping()) {
            this.eRule.undoManagerLastEditDie();
            this.msg = this.eRule.getMsg();
            if (leftgo.isArc()) {
                JOptionPane.showMessageDialog(this.applFrame, this.msg, "Mapping Error", 0);
            }
            return false;
        }
        this.eRule.undoManagerEndEdit();
        if (this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
            this.gragraEditor.getGraGra().setChanged(true);
        }
        return true;
    }

    public boolean removePacMapping(EdGraphObject go, boolean left) {
        if (go == null || this.ePAC == null) {
            return false;
        }
        if (left) {
            EdGraphObject pgo = this.ePAC.findGraphObject(this.ePAC.getMorphism().getImage(go.getBasisObject()));
            if (pgo != null) {
                this.eRule.addDeletedPACMappingToUndo(go, pgo);
                this.eRule.removePACMapping(go, this.ePAC.getMorphism());
                this.eRule.undoManagerEndEdit();
                if (this.gragraEditor != null) {
                    this.gragraEditor.updateUndoButton();
                    this.gragraEditor.getGraGra().setChanged(true);
                }
                return true;
            }
            return false;
        }
        boolean res = false;
        Vector<EdGraphObject> vec = this.ePAC.getOriginal(go);
        int i = 0;
        while (i < vec.size()) {
            EdGraphObject lgo = vec.get(i);
            res = this.removePacMapping(lgo, true) || res;
            ++i;
        }
        return res;
    }

    public boolean removePacMapping(EdGraphObject goLHS) {
        if (goLHS == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < this.eRule.getPACs().size()) {
            EdPAC pac = this.eRule.getPACs().get(i);
            EdGraphObject pgo = pac.findGraphObject(pac.getMorphism().getImage(goLHS.getBasisObject()));
            if (pgo != null) {
                this.eRule.addDeletedPACMappingToUndo(goLHS, pgo);
                this.eRule.removePACMapping(goLHS, pac.getMorphism());
                this.eRule.undoManagerEndEdit();
                result = true;
            }
            ++i;
        }
        if (result && this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
            this.gragraEditor.getGraGra().setChanged(true);
        }
        return result;
    }

    public boolean setNestedACMapping(EdGraphObject leftgo, EdGraphObject acgo) {
        if (leftgo == null || acgo == null) {
            return false;
        }
        this.eRule.addCreatedACMappingToUndo(leftgo, acgo);
        this.eRule.interactNestedAC(leftgo, acgo, this.eGAC.getNestedMorphism());
        this.eRule.updateNestedAC(this.eGAC);
        this.leftPanel.updateGraphics();
        this.leftCondPanel.updateGraphics();
        if (this.eRule.isBadMapping()) {
            this.eRule.undoManagerLastEditDie();
            this.msg = this.eRule.getMsg();
            if (leftgo.isArc()) {
                JOptionPane.showMessageDialog(this.applFrame, this.msg, "Mapping Error", 0);
            }
            return false;
        }
        this.eRule.undoManagerEndEdit();
        if (this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
            this.gragraEditor.getGraGra().setChanged(true);
        }
        return true;
    }

    public boolean removeNestedACMapping(EdGraphObject go, boolean left) {
        if (go == null || this.eGAC == null) {
            return false;
        }
        if (left) {
            EdGraphObject pgo = this.eGAC.findGraphObject(this.eGAC.getMorphism().getImage(go.getBasisObject()));
            if (pgo != null) {
                if (this.eGAC.getParent() == null) {
                    this.eRule.addDeletedACMappingToUndo(go, pgo);
                    this.eRule.removeNestedACMapping(go, this.eGAC.getNestedMorphism());
                    this.eRule.undoManagerEndEdit();
                } else {
                    this.eGAC.getParent().addDeletedMappingToUndo(go, pgo);
                    this.eGAC.getParent().removeNestedACMapping(go, this.eGAC);
                    this.eGAC.undoManagerEndEdit();
                }
                if (this.gragraEditor != null) {
                    this.gragraEditor.updateUndoButton();
                    this.gragraEditor.getGraGra().setChanged(true);
                }
                return true;
            }
            return false;
        }
        boolean res = false;
        Vector<EdGraphObject> vec = this.eGAC.getOriginal(go);
        int i = 0;
        while (i < vec.size()) {
            EdGraphObject lgo = vec.get(i);
            res = res || this.removeNestedACMapping(lgo, true) || res;
            ++i;
        }
        if (res) {
            this.eGAC.updateNestedACs();
        }
        return res;
    }

    public boolean removeNestedACMapping(EdGraphObject left) {
        if (left == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < this.eRule.getNestedACs().size()) {
            EdNestedApplCond ac = (EdNestedApplCond)this.eRule.getNestedACs().get(i);
            EdGraphObject go = ac.findGraphObject(ac.getMorphism().getImage(left.getBasisObject()));
            if (go != null) {
                this.eRule.addDeletedACMappingToUndo(left, go);
                this.eRule.removeNestedACMapping(left, ac.getNestedMorphism());
                this.eRule.undoManagerEndEdit();
                result = true;
            }
            ++i;
        }
        if (result && this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
            this.gragraEditor.getGraGra().setChanged(true);
        }
        return result;
    }

    public boolean removeNestedACMapping(EdGraphObject left, EdNestedApplCond cond, List<EdNestedApplCond> list) {
        if (left == null) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < list.size()) {
            EdNestedApplCond ac = list.get(i);
            EdGraphObject go = ac.findGraphObject(ac.getMorphism().getImage(left.getBasisObject()));
            if (go != null) {
                ac.addDeletedMappingToUndo(left, go);
                cond.removeNestedACMapping(left, ac);
                ac.undoManagerEndEdit();
                result = true;
            }
            ++i;
        }
        if (result && this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
            this.gragraEditor.getGraGra().setChanged(true);
        }
        return result;
    }

    public boolean setMatchMapping(EdGraphObject leftgo, EdGraphObject graphgo) {
        if (leftgo == null || graphgo == null) {
            return false;
        }
        if (this.eRule.getBasisRule().getMatch() == null) {
            this.eRule.getGraGra().getBasisGraGra().createMatch(this.eRule.getBasisRule());
        }
        this.eRule.getBasisRule().getMatch().setCompletionStrategy(this.eRule.getGraGra().getBasisGraGra().getMorphismCompletionStrategy());
        this.eRule.addCreatedMatchMappingToUndo(leftgo, graphgo);
        this.eRule.interactMatch(leftgo, graphgo);
        if (this.eRule.isBadMapping()) {
            this.eRule.undoManagerLastEditDie();
            this.msg = this.eRule.getMsg();
            JOptionPane.showMessageDialog(this.applFrame, this.msg, "Mapping Error", 0);
            return false;
        }
        this.eRule.undoManagerEndEdit();
        if (this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
        }
        if (this.graphEditor != null) {
            this.graphEditor.getGraph().update();
        }
        return true;
    }

    public boolean removeMatchMapping(EdGraphObject go, boolean left) {
        if (go == null || this.eRule.getMatch() == null) {
            return false;
        }
        if (left && this.graphEditor != null) {
            EdGraphObject ggo = this.graphEditor.getGraph().findGraphObject(this.eRule.getMatch().getImage(go.getBasisObject()));
            if (ggo != null) {
                this.eRule.addDeletedMatchMappingToUndo(go, ggo);
                this.eRule.removeMatchMapping(go);
                this.eRule.undoManagerEndEdit();
                if (this.gragraEditor != null) {
                    this.gragraEditor.updateUndoButton();
                }
                this.graphEditor.getGraph().update();
                return true;
            }
            return false;
        }
        boolean res = false;
        Enumeration<GraphObject> inverse = this.eRule.getMatch().getInverseImage(go.getBasisObject());
        while (inverse.hasMoreElements()) {
            GraphObject o = inverse.nextElement();
            EdGraphObject lgo = this.eRule.getLeft().findGraphObject(o);
            boolean bl = res = this.removeMatchMapping(lgo, true) || res;
        }
        return res;
    }

    public void enableSynchronMoveOfMappedObjects(boolean b) {
        this.synchrMoveOfMapObjs = b;
    }

    public boolean isSynchronMoveOfMappedObjectsEnabled() {
        return this.synchrMoveOfMapObjs;
    }

    public boolean isLeftDragging() {
        return this.draggingL;
    }

    public void setLeftDragging(boolean b) {
        this.draggingL = b;
    }

    public boolean isRightDragging() {
        return this.draggingR;
    }

    public void setRightDragging(boolean b) {
        this.draggingR = b;
    }

    public boolean isLeftCondDragging() {
        return this.draggingC;
    }

    public void setLeftCondDragging(boolean b) {
        this.draggingC = b;
    }

    public Vector<EdGraphObject> getImages(EdGraph imageGraph, OrdinaryMorphism morph, Vector<EdGraphObject> objs) {
        Vector<EdGraphObject> res = new Vector<EdGraphObject>(5);
        int i = 0;
        while (i < objs.size()) {
            EdGraphObject obj;
            EdGraphObject go = objs.get(i);
            GraphObject img = morph.getImage(go.getBasisObject());
            if (img != null && (obj = imageGraph.findGraphObject(img)) != null) {
                if (img instanceof Node) {
                    EdArc ea;
                    res.add(obj);
                    for (Arc a : ((Node)img).getIncomingArcsSet()) {
                        if (!morph.getInverseImage(a).hasMoreElements() || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getSource()) || res.contains(ea)) continue;
                        res.add(ea);
                    }
                    for (Arc a : ((Node)img).getOutgoingArcsSet()) {
                        if (!morph.getInverseImage(a).hasMoreElements() || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getTarget()) || res.contains(ea)) continue;
                        res.add(ea);
                    }
                } else if (!res.contains(obj)) {
                    res.add(obj);
                }
            }
            ++i;
        }
        return res;
    }

    public Vector<EdGraphObject> getInverseImages(EdGraph imageGraph, OrdinaryMorphism morph, Vector<EdGraphObject> objs) {
        Vector<EdGraphObject> res = new Vector<EdGraphObject>(5);
        int i = 0;
        while (i < objs.size()) {
            EdGraphObject go = objs.get(i);
            Enumeration<GraphObject> en = morph.getInverseImage(go.getBasisObject());
            while (en.hasMoreElements()) {
                EdGraphObject obj;
                GraphObject img = en.nextElement();
                if (img == null || (obj = imageGraph.findGraphObject(img)) == null) continue;
                if (img instanceof Node) {
                    EdArc ea;
                    res.add(obj);
                    for (Arc a : ((Node)img).getIncomingArcsSet()) {
                        if (morph.getImage(a) == null || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getSource()) || res.contains(ea)) continue;
                        res.add(ea);
                    }
                    for (Arc a : ((Node)img).getOutgoingArcsSet()) {
                        if (morph.getImage(a) == null || (ea = imageGraph.findArc(a)) == null || !res.contains(ea.getTarget()) || res.contains(ea)) continue;
                        res.add(ea);
                    }
                    continue;
                }
                if (res.contains(obj)) continue;
                res.add(obj);
            }
            ++i;
        }
        return res;
    }

    public void keyPressed(KeyEvent e) {
        if (this.leftPanel.getEditMode() == 9) {
            return;
        }
        Object source = e.getSource();
        int keyCode = e.getKeyCode();
        if (source == this.leftPanel.getCanvas()) {
            switch (keyCode) {
                case 127: {
                    System.out.println("KeyEvent.VK_DELETE");
                    this.removeProc();
                    break;
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.leftPanel.getEditMode() == 9) {
            return;
        }
        Object source = e.getSource();
        int keyCode = e.getKeyCode();
        if (source == this.leftPanel.getCanvas()) {
            switch (keyCode) {
                case 127: {
                    if (this.leftPanel.getEditMode() == 32) {
                        this.leftPanel.setEditMode(31);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 82) {
                        this.leftPanel.setEditMode(81);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 802) {
                        this.leftPanel.setEditMode(801);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 8020) {
                        this.leftPanel.setEditMode(8010);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 43) {
                        this.leftPanel.setEditMode(42);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() == 1161) {
                        this.leftPanel.setEditMode(115);
                        this.leftPanel.setEditCursor(new Cursor(12));
                        if (this.applFrame == null) break;
                        this.applFrame.setCursor(new Cursor(12));
                        break;
                    }
                    if (this.leftPanel.getEditMode() != 1181) break;
                    this.leftPanel.setEditMode(117);
                    this.leftPanel.setEditCursor(new Cursor(12));
                    if (this.applFrame == null) break;
                    this.applFrame.setCursor(new Cursor(12));
                    break;
                }
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 200);
    }

    public String getTitle() {
        return this.title.getText();
    }

    public void setTitle(String str) {
        this.title.setText("  " + str);
    }

    public void setRuleTitle(String str1, String str2) {
        if (!str1.equals("") && !str2.equals("")) {
            this.ruleName = str1;
            this.gragraName = str2;
            this.title.setText(String.valueOf(this.titleKind) + this.ruleName + "  of  " + this.gragraName);
        } else if (!str1.equals("") && str2.equals("")) {
            this.ruleName = str1;
            this.title.setText(String.valueOf(this.titleKind) + this.ruleName);
        } else if (str1.equals("") && !str2.equals("")) {
            this.gragraName = str2;
            this.title.setText(String.valueOf(this.titleKind) + this.gragraName);
        } else {
            this.title.setText(this.titleKind);
        }
    }

    public void setAtomicTitle(String str1, String str2) {
        if (!str1.equals("") && !str2.equals("")) {
            this.conclusionName = str1;
            this.atomicName = str2;
            this.title.setText(String.valueOf(this.titleKind) + this.atomicName + "  ->  " + this.conclusionName);
        } else if (!str1.equals("") && str2.equals("")) {
            this.conclusionName = str1;
            this.title.setText(String.valueOf(this.titleKind) + this.conclusionName);
        } else if (str1.equals("") && !str2.equals("")) {
            this.atomicName = str2;
            this.title.setText(String.valueOf(this.titleKind) + this.atomicName);
        } else {
            this.title.setText(this.titleKind);
        }
    }

    public void setNACTitle(String str) {
        this.titleAC.setText(String.valueOf(this.titleKindAC) + str);
    }

    public void setPACTitle(String str) {
        this.titleAC.setText(String.valueOf(this.titleKindAC) + str);
    }

    public void setLeftApplCondTitle(String str) {
        this.titleAC.setText(String.valueOf(this.titleKindAC) + str);
    }

    public GraGraEditor getGraGraEditor() {
        return this.gragraEditor;
    }

    public GraphEditor getGraphEditor() {
        return this.graphEditor;
    }

    public GraphPanel getLeftPanel() {
        return this.leftPanel;
    }

    public GraphPanel getRightPanel() {
        return this.rightPanel;
    }

    public boolean isEditPopupMenuShown() {
        return this.isEditPopupMenu;
    }

    public EditPopupMenu getEditPopupMenu() {
        return this.editPopupMenu;
    }

    public boolean isEditSelPopupMenuShown() {
        return this.isEditSelPopupMenu;
    }

    public EditSelPopupMenu getEditSelPopupMenu() {
        return this.editSelPopupMenu;
    }

    public void allowToShowPopupMenu(boolean b) {
        this.doNotShowPopupMenu = !b;
    }

    public boolean isPopupMenuAllowed() {
        return !this.doNotShowPopupMenu;
    }

    public GraphPanel getLeftCondPanel() {
        return this.leftCondPanel;
    }

    public GraphPanel getNACPanel() {
        return this.leftCondPanel;
    }

    public GraphPanel getPACPanel() {
        return this.leftCondPanel;
    }

    public GraphPanel getActivePanel() {
        return this.activePanel;
    }

    public GraphPanel getPanelOf(EdGraph g) {
        if (this.leftPanel.getGraph() == g) {
            return this.leftPanel;
        }
        if (this.rightPanel.getGraph() == g) {
            return this.rightPanel;
        }
        if (this.leftCondPanel.getGraph() == g) {
            return this.leftCondPanel;
        }
        return null;
    }

    public GraphPanel getPanelOfLocationOnScreen(Point p) {
        if (p == null) {
            return null;
        }
        Point p2 = new Point(20, 20);
        p2.x = p.x - this.leftPanel.getLocationOnScreen().x;
        p2.y = p.y - this.leftPanel.getLocationOnScreen().y;
        if (this.leftPanel.contains(p2)) {
            return this.leftPanel;
        }
        p2.x = p.x - this.rightPanel.getLocationOnScreen().x;
        p2.y = p.y - this.rightPanel.getLocationOnScreen().y;
        if (this.rightPanel.contains(p2)) {
            return this.rightPanel;
        }
        p2.x = p.x - this.leftCondPanel.getLocationOnScreen().x;
        p2.y = p.y - this.leftCondPanel.getLocationOnScreen().y;
        if (this.leftCondPanel.contains(p2)) {
            return this.leftCondPanel;
        }
        return null;
    }

    public int getEditMode() {
        return this.leftPanel.getEditMode();
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public EdRule getRule() {
        return this.eRule;
    }

    public EdAtomic getAtomic() {
        if (this.eRule != null && this.eRule instanceof EdAtomic) {
            return (EdAtomic)this.eRule;
        }
        return null;
    }

    public EdNAC getNAC() {
        return this.eNAC;
    }

    public EdPAC getPAC() {
        return this.ePAC;
    }

    public EdNestedApplCond getNestedAC() {
        return this.eGAC;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String s) {
        this.msg = s;
    }

    public boolean hasRule() {
        return this.eRule != null;
    }

    public EdGraphObject setLeftGraphObject(EdGraphObject go) {
        this.leftObj = go;
        return this.leftObj;
    }

    public EdGraphObject setRightGraphObject(EdGraphObject go) {
        this.rightObj = go;
        return this.rightObj;
    }

    public EdGraphObject setLeftCondGraphObject(EdGraphObject go) {
        this.leftCondObj = go;
        return this.leftCondObj;
    }

    public EdGraphObject setHostGraphObject(EdGraphObject go) {
        this.graphObj = go;
        return this.graphObj;
    }

    public boolean isObjMapping() {
        return this.mapping;
    }

    public void setObjMapping(boolean b) {
        this.mapping = b;
    }

    public void setGraphEditor(GraphEditor gEditor) {
        this.graphEditor = gEditor;
    }

    public void setRule(EdRule er) {
        if (this.eRule != null) {
            if (this.dividerLocationSet.get(this.eRule) == null) {
                this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
                this.dividerLocationSet.put(this.eRule, this.ruleDividerLocation);
            } else {
                this.ruleDividerLocation = this.dividerLocationSet.get(this.eRule);
            }
        }
        this.eRule = er;
        this.titleKind = " ";
        if (this.eRule == null) {
            this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
            this.setTitle("    ");
            this.setBorder(this.leftPanel.canvas, "  LHS  ");
            this.setBorder(this.rightPanel.canvas, "  RHS  ");
            this.leftPanel.setGraph(null);
            this.rightPanel.setGraph(null);
            this.setNAC(null);
            this.setPAC(null);
            this.setNestedAC(null);
            this.eGra = null;
            if (this.exportJPEGButton != null) {
                this.exportJPEGButton.setEnabled(false);
            }
            return;
        }
        this.eGra = this.eRule.getGraGra();
        if (this.eRule.getBasisRule() instanceof RuleScheme) {
            this.eRule = ((EdRuleScheme)this.eRule).getKernelRule();
        }
        this.makeRuleTitle();
        this.setBorder(this.leftPanel.canvas, "  LHS  ");
        this.setBorder(this.rightPanel.canvas, "  RHS  ");
        this.eRule.updateRule();
        this.leftPanel.setGraph(this.eRule.getLeft(), true);
        this.rightPanel.setGraph(this.eRule.getRight(), true);
        this.showRightPanel();
        if (this.attrEditor != null) {
            this.attrEditor.setContext(this.eRule.getBasisRule().getAttrContext());
        }
        if (this.dividerLocationSet.get(this.eRule) != null) {
            this.ruleSplitPane.setDividerLocation(this.dividerLocationSet.get(this.eRule));
        } else {
            this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        }
        if (this.exportJPEGButton != null && this.exportJPEG != null) {
            this.exportJPEGButton.setEnabled(true);
        }
    }

    private void setBorder(JPanel p, String txt) {
        p.setBorder(new TitledBorder(null, txt, 0, 0, null, new Color(204, 204, 204)));
    }

    public void adjustLeftRightBorderTitle() {
        this.setBorder(this.leftPanel.canvas, "  LHS  ");
        this.setBorder(this.rightPanel.canvas, "  RHS  ");
    }

    public void resetRule() {
        if (this.eRule != null) {
            this.showRightPanel();
            this.setNAC(null);
            this.setPAC(null);
            this.setNestedAC(null);
            if (this.eRule.getBasisRule() instanceof RuleScheme) {
                this.eRule = ((EdRuleScheme)this.eRule).getKernelRule();
            }
            this.makeRuleTitle();
            this.setBorder(this.leftPanel.canvas, "  LHS  ");
            this.setBorder(this.rightPanel.canvas, "  RHS  ");
            this.eRule.updateRule();
            this.leftPanel.setGraph(this.eRule.getLeft(), true);
            this.rightPanel.setGraph(this.eRule.getRight(), true);
            if (this.attrEditor != null) {
                this.attrEditor.setContext(this.eRule.getBasisRule().getAttrContext());
            }
            if (this.dividerLocationSet.get(this.eRule) != null) {
                this.ruleDividerLocation = this.dividerLocationSet.get(this.eRule);
                this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
            } else {
                this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
                this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
                this.dividerLocationSet.put(this.eRule, new Integer(this.ruleDividerLocation));
            }
            if (this.exportJPEGButton != null && this.exportJPEG != null) {
                this.exportJPEGButton.setEnabled(true);
            }
        }
    }

    private void makeRuleTitle() {
        String titleStr = "";
        titleStr = this.eRule.getBasisRule() instanceof RuleScheme ? ((RuleScheme)this.eRule.getBasisRule()).getName() : (this.eRule.getBasisRule() instanceof KernelRule ? String.valueOf(this.eRule.getBasisRule().getName()) + "  of  " + ((KernelRule)this.eRule.getBasisRule()).getRuleScheme().getName() : (this.eRule.getBasisRule() instanceof MultiRule ? String.valueOf(this.eRule.getBasisRule().getName()) + "  of  " + ((MultiRule)this.eRule.getBasisRule()).getRuleScheme().getName() : (this.eRule.getBasisRule() instanceof AmalgamatedRule && ((AmalgamatedRule)this.eRule.getBasisRule()).getRuleScheme() != null ? String.valueOf(this.eRule.getBasisRule().getName()) + "  of  " + ((AmalgamatedRule)this.eRule.getBasisRule()).getRuleScheme().getName() : this.eRule.getBasisRule().getName())));
        if (this.eGra != null) {
            this.setRuleTitle(titleStr, this.eGra.getName());
        } else {
            this.setRuleTitle(titleStr, "");
        }
    }

    public void setDividerLocation(int indx, int i) {
        if (indx == 0) {
            this.splitPane.setDividerLocation(i);
        } else if (indx == 1) {
            this.ruleSplitPane.setDividerLocation(i);
        }
    }

    public void setAtomic(EdAtomic a) {
        if (this.eRule != null) {
            this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
            this.dividerLocationSet.put(this.eRule, this.ruleDividerLocation);
        }
        this.eRule = a;
        this.titleKind = "  ";
        if (this.eRule == null) {
            this.ruleDividerLocation = this.ruleSplitPane.getDividerLocation();
            this.setTitle("    ");
            this.setBorder(this.leftPanel.canvas, "  LHS  ");
            this.setBorder(this.rightPanel.canvas, "  RHS  ");
            this.leftPanel.setGraph(null);
            this.rightPanel.setGraph(null);
            this.setNAC(null);
            this.setPAC(null);
            this.setNestedAC(null);
            this.eGra = null;
            if (this.exportJPEGButton != null) {
                this.exportJPEGButton.setEnabled(false);
            }
            return;
        }
        this.setNAC(null);
        this.setPAC(null);
        this.setNestedAC(null);
        this.eGra = this.eRule.getGraGra();
        String s = a.getBasisAtomic().getAtomicName();
        this.setAtomicTitle(this.eRule.getMorphism().getName(), s);
        this.setBorder(this.leftPanel.canvas, "  P  ");
        this.setBorder(this.rightPanel.canvas, "  C  ");
        this.leftPanel.setGraph(this.eRule.getLeft());
        this.rightPanel.setGraph(this.eRule.getRight());
        if (this.attrEditor != null) {
            this.attrEditor.setContext(a.getBasisAtomic().getAttrContext());
        }
        if (this.dividerLocationSet.get(this.eRule) != null) {
            this.ruleSplitPane.setDividerLocation(this.dividerLocationSet.get(this.eRule));
        } else {
            this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        }
        if (this.exportJPEGButton != null && this.exportJPEG != null) {
            this.exportJPEGButton.setEnabled(true);
        }
    }

    public void setNAC(EdNAC enac) {
        this.showRightPanel();
        if (this.eNAC != null) {
            this.acDividerLocation = this.splitPane.getDividerLocation();
            this.dividerLocationSet.put(this.eNAC, this.acDividerLocation);
        } else if (this.ePAC != null) {
            this.dividerLocationSet.put(this.ePAC, this.splitPane.getDividerLocation());
        } else if (this.eGAC != null) {
            this.dividerLocationSet.put(this.eGAC, this.splitPane.getDividerLocation());
        }
        this.eNAC = enac;
        this.titleKindAC = "  ";
        if (this.eNAC == null) {
            this.leftCondPanel.setGraph(null);
            this.setNACTitle("");
            this.hideLeftApplCond();
            return;
        }
        this.ePAC = null;
        this.eGAC = null;
        this.makeRuleTitle();
        this.setBorder(this.leftPanel.canvas, "  LHS  ");
        this.setBorder(this.rightPanel.canvas, "  RHS  ");
        this.setBorder(this.leftCondPanel.canvas, "  NAC  ");
        this.setNACTitle(this.eNAC.getBasisGraph().getName());
        this.eRule.updateRule();
        this.eRule.updateNAC(this.eNAC);
        this.leftCondPanel.setGraph(this.eNAC, true);
        this.setDividerLocationOfLeftApplCond(this.eNAC);
        if (this.dividerLocationSet.get(this.eRule) != null) {
            this.ruleDividerLocation = this.dividerLocationSet.get(this.eRule);
            this.ruleSplitPane.setDividerLocation(this.dividerLocationSet.get(this.eRule));
        } else {
            this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        }
    }

    public void setPAC(EdPAC epac) {
        this.showRightPanel();
        if (this.ePAC != null) {
            this.acDividerLocation = this.splitPane.getDividerLocation();
            this.dividerLocationSet.put(this.ePAC, this.acDividerLocation);
        } else if (this.eNAC != null) {
            this.dividerLocationSet.put(this.eNAC, this.splitPane.getDividerLocation());
        } else if (this.eGAC != null) {
            this.dividerLocationSet.put(this.eGAC, this.splitPane.getDividerLocation());
        }
        this.ePAC = epac;
        this.titleKindAC = "  ";
        if (this.ePAC == null) {
            this.leftCondPanel.setGraph(null);
            this.leftCondPanel.updateGraphics();
            this.setPACTitle("");
            this.hideLeftApplCond();
            return;
        }
        this.eNAC = null;
        this.eGAC = null;
        this.makeRuleTitle();
        this.setBorder(this.leftPanel.canvas, "  LHS  ");
        this.setBorder(this.rightPanel.canvas, "  RHS  ");
        this.setBorder(this.leftCondPanel.canvas, "  PAC  ");
        this.setPACTitle(this.ePAC.getBasisGraph().getName());
        this.eRule.updateRule();
        this.eRule.updatePAC(this.ePAC);
        this.leftCondPanel.setGraph(this.ePAC, true);
        this.setDividerLocationOfLeftApplCond(this.ePAC);
        if (this.dividerLocationSet.get(this.eRule) != null) {
            this.ruleDividerLocation = this.dividerLocationSet.get(this.eRule);
            this.ruleSplitPane.setDividerLocation(this.dividerLocationSet.get(this.eRule));
        } else {
            this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        }
    }

    private void setDividerLocationOfLeftApplCond(EdGraph ac) {
        if (this.splitPane.getLeftComponent() == null) {
            this.splitPane.setDividerSize(10);
            this.splitPane.setLeftComponent(this.leftCondPanel);
        }
        if (this.dividerLocationSet.get(ac) != null) {
            this.acDividerLocation = this.dividerLocationSet.get(ac);
            if (this.acDividerLocation < 10) {
                this.acDividerLocation = 300;
            }
            this.splitPane.setDividerLocation(this.acDividerLocation);
        } else {
            this.acDividerLocation = 300;
            this.splitPane.setDividerLocation(this.acDividerLocation);
            this.dividerLocationSet.put(ac, this.acDividerLocation);
        }
    }

    public void setNestedAC(EdNestedApplCond ac) {
        if (this.eGAC != null) {
            this.acDividerLocation = this.splitPane.getDividerLocation();
            this.dividerLocationSet.put(this.eGAC, this.acDividerLocation);
        } else if (this.eNAC != null) {
            this.dividerLocationSet.put(this.eNAC, this.splitPane.getDividerLocation());
        } else if (this.ePAC != null) {
            this.dividerLocationSet.put(this.ePAC, this.splitPane.getDividerLocation());
        }
        this.eGAC = ac;
        this.titleKindAC = "  ";
        if (this.eGAC == null) {
            this.leftCondPanel.setGraph(null);
            this.leftCondPanel.updateGraphics();
            this.setLeftApplCondTitle("");
            this.hideLeftApplCond();
            return;
        }
        this.eNAC = null;
        this.ePAC = null;
        this.setBorder(this.leftCondPanel.canvas, "  GAC  ");
        this.updateNestedAC(this.eGAC);
        if (this.eGAC.getParent() == null) {
            this.setBorder(this.leftPanel.canvas, "  LHS  ");
            this.title.setText(" <-  LHS  of  " + this.eRule.getName());
            this.eRule.updateRule();
            this.leftPanel.setGraph(this.eRule.getLeft());
        } else {
            EdNestedApplCond parAC = this.eGAC.getParent();
            this.setBorder(this.leftPanel.canvas, "  GAC  ");
            this.title.setText(" <-  " + parAC.getName());
            this.eRule.updateNestedAC(parAC);
            this.leftPanel.setGraph(parAC);
        }
        this.setLeftApplCondTitle(this.eGAC.getBasisGraph().getName());
        this.eRule.updateNestedAC(this.eGAC);
        this.leftCondPanel.setGraph(this.eGAC, true);
        this.setDividerLocationOfLeftApplCond(this.eGAC);
        if (this.eGAC.getParent() != null) {
            this.hideRightPanel();
        } else if (!this.isRightPanelVisible()) {
            this.showRightPanel();
        }
    }

    public void hideLeftApplCond() {
        this.splitPane.setLeftComponent(null);
    }

    private void hideLeftPanel() {
        this.ruleSplitPane.setLeftComponent(null);
    }

    protected void hideRightPanel() {
        this.ruleSplitPane.setRightComponent(null);
    }

    private void showLeftPanel() {
        if (this.ruleSplitPane.getLeftComponent() == null) {
            if (this.dividerLocationSet.get(this.eRule) != null) {
                this.ruleDividerLocation = this.dividerLocationSet.get(this.eRule);
            }
            this.ruleSplitPane.setLeftComponent(this.leftPanel);
            this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        }
    }

    protected void showRightPanel() {
        if (this.ruleSplitPane.getRightComponent() == null && this.eRule != null) {
            this.ruleDividerLocation = this.dividerLocationSet.get(this.eRule) != null ? this.dividerLocationSet.get(this.eRule) : 250;
            this.ruleSplitPane.setRightComponent(this.rightPanel);
            this.ruleSplitPane.setDividerLocation(this.ruleDividerLocation);
        }
    }

    protected boolean isLeftPanelVisible() {
        return this.ruleSplitPane.getLeftComponent() != null;
    }

    protected boolean isRightPanelVisible() {
        return this.ruleSplitPane.getRightComponent() != null;
    }

    public void setRuleDividerLocation(int l) {
        this.ruleSplitPane.setDividerLocation(l);
    }

    public boolean hasOneSelection() {
        if (this.eRule == null) {
            return false;
        }
        if (!(!this.leftPanel.getGraph().hasSelection() || this.rightPanel.getGraph().hasSelection() || this.leftCondPanel.getGraph() != null && this.leftCondPanel.getGraph().hasSelection())) {
            return true;
        }
        if (!(!this.rightPanel.getGraph().hasSelection() || this.leftPanel.getGraph().hasSelection() || this.leftCondPanel.getGraph() != null && this.leftCondPanel.getGraph().hasSelection())) {
            return true;
        }
        return this.leftCondPanel.getGraph() != null && this.leftCondPanel.getGraph().hasSelection() && !this.leftPanel.getGraph().hasSelection() && !this.rightPanel.getGraph().hasSelection();
    }

    public boolean hasSelection() {
        return this.leftPanel.hasSelection() || this.rightPanel.hasSelection() || this.leftCondPanel.hasSelection();
    }

    public boolean hasSelection(GraphPanel gPanel) {
        return gPanel.hasSelection();
    }

    public void updateNestedAC(EdNestedApplCond ac) {
        if (ac != null) {
            if (ac.getParent() == null) {
                this.eRule.updateRule();
                this.eRule.updateNestedAC(ac);
            } else {
                this.eRule.updateNestedAC(ac.getParent());
                this.eRule.updateNestedAC(ac);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphics() {
        RuleEditor ruleEditor = this;
        synchronized (ruleEditor) {
            this.leftPanel.updateGraphics();
            this.rightPanel.updateGraphics();
            this.leftCondPanel.updateGraphics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphics(boolean graphDimensionCheck) {
        RuleEditor ruleEditor = this;
        synchronized (ruleEditor) {
            this.leftPanel.updateGraphics(graphDimensionCheck);
            this.rightPanel.updateGraphics(graphDimensionCheck);
            this.leftCondPanel.updateGraphics(graphDimensionCheck);
        }
    }

    public void clear() {
        this.setRule(null);
        this.updateGraphics();
    }

    public void clearNAC() {
        this.setNAC(null);
        this.leftCondPanel.updateGraphics();
        this.updateGraphics();
    }

    public void clearPAC() {
        this.setPAC(null);
        this.leftCondPanel.updateGraphics();
        this.updateGraphics();
    }

    public void clearNestedAC() {
        this.setNestedAC(null);
        this.leftCondPanel.updateGraphics();
        this.updateGraphics();
    }

    public void setAttrEditor(AttrTopEditor attrEditor) {
        this.attrEditor = attrEditor;
    }

    public void setModePopupMenu(ModePopupMenu pm) {
        this.modePopupMenu = pm;
    }

    public void setEditPopupMenu(EditPopupMenu pm) {
        this.editPopupMenu = pm;
    }

    public void setEditSelPopupMenu(EditSelPopupMenu pm) {
        this.editSelPopupMenu = pm;
    }

    public void setEditMode(int mode) {
        this.handleMouseListenerFromGraphEditor(mode);
        if (mode != 42) {
            this.resetEditModeAfterInteractMatch();
        }
        switch (mode) {
            case 11: {
                this.drawModeProc();
                break;
            }
            case 12: {
                this.selectModeProc();
                break;
            }
            case 13: {
                this.moveModeProc();
                break;
            }
            case 114: {
                this.attributesModeProc();
                break;
            }
            case 42: {
                this.matchDefModeProc();
                break;
            }
            case 15: {
                this.copyModeProc();
                break;
            }
            case 152: {
                this.pasteModeProc();
                break;
            }
            case 115: {
                this.mapModeProc();
                break;
            }
            case 116: {
                this.unmapModeProc();
                break;
            }
            case 117: {
                this.mapselModeProc();
                break;
            }
            case 118: {
                this.unmapselModeProc();
                break;
            }
            case 9: {
                this.viewModeProc();
                break;
            }
        }
    }

    public int getMode() {
        return this.leftPanel.getEditMode();
    }

    public int getPreviousMode() {
        return this.leftPanel.getLastEditMode();
    }

    public void setEditCursor(Cursor cur) {
        this.leftPanel.setEditCursor(cur);
        this.rightPanel.setEditCursor(cur);
        this.leftCondPanel.setEditCursor(cur);
    }

    public void resetAfterInteractMatch() {
        this.setEditMode(this.leftPanel.getLastEditMode());
    }

    public void setAttributeVisible(boolean vis) {
        this.leftPanel.getCanvas().setAttributeVisible(vis);
        this.rightPanel.getCanvas().setAttributeVisible(vis);
        this.leftCondPanel.getCanvas().setAttributeVisible(vis);
        this.updateGraphics();
    }

    public void unsetDragging() {
        this.draggingL = false;
        this.draggingR = false;
        this.draggingC = false;
    }

    private void resetEditModeAfterInteractMatch() {
        if (this.eRule == null || this.leftPanel.getEditMode() != 42) {
            return;
        }
        if (this.graphEditor != null) {
            if (this.leftPanel.getLastEditMode() == 9) {
                this.graphEditor.setEditMode(this.leftPanel.getLastEditMode());
            } else {
                this.graphEditor.setEditMode(this.leftPanel.getLastEditMode());
            }
        }
    }

    private void drawModeProc() {
        this.setPanelEditMode(11);
        this.leftPanel.setLastEditMode(13);
        this.setEditCursor(new Cursor(0));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(0));
        }
        this.msg = "Click on the background to get a node / on a source node and a target node to get an edge.";
    }

    private void selectModeProc() {
        this.setPanelEditMode(12);
        this.leftPanel.setLastEditMode(13);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on an object to select it.";
    }

    private void moveModeProc() {
        this.setPanelEditMode(13);
        this.leftPanel.setLastEditMode(13);
        this.setEditCursor(new Cursor(13));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(13));
        }
        this.msg = "Press and drag the button when the cursor points to an object.";
    }

    private void attributesModeProc() {
        this.setPanelEditMode(114);
        this.setEditCursor(new Cursor(0));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(0));
        }
        this.msg = "Click on an object to activate the attribute editor.";
    }

    private void ruleDefModeProc() {
        this.setPanelEditMode(31);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void nacDefModeProc() {
        this.setPanelEditMode(81);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void pacDefModeProc() {
        this.setPanelEditMode(801);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void acDefModeProc() {
        this.setPanelEditMode(8010);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void matchDefModeProc() {
        if (this.eRule == null || this.graphEditor == null) {
            return;
        }
        this.setLastEditModeBeforMatch(this.leftPanel);
        this.setPanelEditMode(42);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.graphEditor.setEditMode(42);
        this.graphEditor.setEditCursor(new Cursor(12));
        this.leftObj = null;
        this.graphObj = null;
        this.msg = "Click on a source object and a target object to get a mapping pair.";
    }

    private void mapModeProc() {
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(115);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping.";
    }

    private void unmapModeProc() {
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(116);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on the source of the mapping to destroy it.";
    }

    private void mapselModeProc() {
        if (this.leftPanel.getEditMode() == 117) {
            return;
        }
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(117);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on a source object and a target object to get a mapping.";
    }

    private void unmapselModeProc() {
        if (this.leftPanel.getEditMode() == 118) {
            return;
        }
        this.setLastEditModeBeforMapping(this.leftPanel);
        this.setPanelEditMode(118);
        this.setEditCursor(new Cursor(12));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(12));
        }
        this.msg = "Click on the source object of the mapping to destroy it.";
    }

    private void copyModeProc() {
        if (this.eRule == null) {
            return;
        }
        this.saveLastEditMode();
        this.setPanelEditMode(15);
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
        this.msg = "To place a copy click on the background of the panel.";
    }

    private void pasteModeProc() {
        if (this.eRule == null) {
            return;
        }
        this.setPanelEditMode(152);
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
        this.msg = "To place a copy click on the background of the panel.";
    }

    private void saveLastEditMode() {
        this.leftPanel.setLastEditMode(this.leftPanel.getEditMode());
        this.leftPanel.setLastEditCursor(this.leftPanel.getEditCursor());
        this.rightPanel.setLastEditMode(this.rightPanel.getEditMode());
        this.rightPanel.setLastEditCursor(this.rightPanel.getEditCursor());
        if (this.leftCondPanel.getGraph() != null) {
            this.leftCondPanel.setLastEditMode(this.leftCondPanel.getEditMode());
            this.leftCondPanel.setLastEditCursor(this.leftCondPanel.getEditCursor());
        }
    }

    private void viewModeProc() {
        this.leftPanel.setEditMode(9);
        this.rightPanel.setEditMode(9);
        this.leftCondPanel.setEditMode(9);
    }

    public boolean deleteProc() {
        if (this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return false;
        }
        if (this.eRule == null) {
            return false;
        }
        boolean result = false;
        if (this.hasSelection(this.leftPanel)) {
            if (this.getAtomic() != null) {
                this.unmapSelectedGraphObjects(this.leftPanel, "P", true);
            } else if (this.getRule() != null) {
                this.unmapSelectedGraphObjects(this.leftPanel, "LHS", true);
            }
            this.leftPanel.deleteSelected();
            result = true;
        }
        if (this.hasSelection(this.rightPanel)) {
            if (this.getAtomic() != null) {
                this.unmapSelectedGraphObjects(this.rightPanel, "C", true);
            } else if (this.getRule() != null) {
                this.unmapSelectedGraphObjects(this.rightPanel, "RHS", true);
            }
            this.rightPanel.deleteSelected();
            result = true;
        }
        if (this.hasSelection(this.leftCondPanel)) {
            if (this.getNAC() != null) {
                this.unmapSelectedGraphObjects(this.leftCondPanel, "NAC", true);
            } else if (this.getPAC() != null) {
                this.unmapSelectedGraphObjects(this.leftCondPanel, "PAC", true);
            } else if (this.getNestedAC() != null) {
                this.unmapSelectedGraphObjects(this.leftCondPanel, "AC", true);
            }
            this.leftCondPanel.deleteSelected();
            result = true;
        }
        if (result) {
            this.eRule.update();
            this.leftPanel.updateGraphicsAfterDelete();
            this.rightPanel.updateGraphicsAfterDelete();
            this.leftCondPanel.updateGraphicsAfterDelete();
            if (this.graphEditor != null) {
                this.graphEditor.getGraphPanel().updateGraphicsAfterDelete();
            }
        }
        return result;
    }

    protected void unmapSelectedGraphObjects(GraphPanel gp, String kind, boolean wantDeleteGraphObject) {
        Vector<EdGraphObject> selObjs = gp.getGraph().getSelectedObjs();
        if (kind.equals("LHS")) {
            int i = 0;
            while (i < selObjs.size()) {
                boolean isRuleObj;
                EdGraphObject origObj = selObjs.elementAt(i);
                boolean bl = isRuleObj = this.getRule().getLeft() == origObj.getContext();
                if (!wantDeleteGraphObject) {
                    if (this.getNAC() != null) {
                        this.removeNacMapping(origObj, true);
                    } else if (this.getPAC() != null) {
                        this.removePacMapping(origObj, true);
                    } else if (this.getNestedAC() != null) {
                        this.removeNestedACMapping(origObj, true);
                    }
                    if (this.getRule().getMatch() != null && isRuleObj) {
                        this.removeMatchMapping(origObj, true);
                    }
                    this.removeRuleMapping(origObj, true);
                } else if (isRuleObj) {
                    this.removeNacMapping(origObj);
                    this.removePacMapping(origObj);
                    this.removeNestedACMapping(origObj);
                    this.removeMatchMapping(origObj, true);
                    this.removeRuleMapping(origObj, true);
                }
                ++i;
            }
        } else if (kind.equals("RHS")) {
            int i = 0;
            while (i < selObjs.size()) {
                EdGraphObject imageObj = selObjs.elementAt(i);
                this.removeRuleMapping(imageObj, false);
                ++i;
            }
        } else if (kind.equals("NAC")) {
            int i = 0;
            while (i < selObjs.size()) {
                EdGraphObject imageObj = selObjs.elementAt(i);
                this.removeNacMapping(imageObj, false);
                ++i;
            }
        } else if (kind.equals("PAC")) {
            int i = 0;
            while (i < selObjs.size()) {
                EdGraphObject imageObj = selObjs.elementAt(i);
                this.removePacMapping(imageObj, false);
                ++i;
            }
        } else if (kind.equals("AC")) {
            int i = 0;
            while (i < selObjs.size()) {
                EdGraphObject imageObj = selObjs.elementAt(i);
                this.removeNestedACMapping(imageObj, false);
                ++i;
            }
        } else if (kind.equals("P")) {
            int i = 0;
            while (i < selObjs.size()) {
                this.removeRuleMapping(selObjs.elementAt(i), true);
                ++i;
            }
        } else if (kind.equals("C")) {
            int i = 0;
            while (i < selObjs.size()) {
                this.removeRuleMapping(selObjs.elementAt(i), false);
                ++i;
            }
        }
        if (this.gragraEditor != null) {
            this.gragraEditor.updateUndoButton();
        }
    }

    public void copyProc() {
        if (this.eRule == null) {
            return;
        }
        if (!this.hasSelection()) {
            this.msg = "Cannot copy. There isn't any object selected";
            return;
        }
        this.saveLastEditMode();
        this.msg = "";
        this.setEditMode(15);
    }

    public void selectAllProc() {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.selectAll();
        this.rightPanel.selectAll();
        if (this.leftCondPanel.getGraph() != null) {
            this.leftCondPanel.selectAll();
        }
    }

    public void selectNodeTypeProc() {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.selectNodesOfSelectedNodeType();
        this.rightPanel.selectNodesOfSelectedNodeType();
        if (this.leftCondPanel.getGraph() != null) {
            this.leftCondPanel.selectNodesOfSelectedNodeType();
        }
    }

    public void selectArcTypeProc() {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.selectArcsOfSelectedArcType();
        this.rightPanel.selectArcsOfSelectedArcType();
        if (this.leftCondPanel.getGraph() != null) {
            this.leftCondPanel.selectArcsOfSelectedArcType();
        }
    }

    public void deselectAllProc() {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.deselectAll();
        this.rightPanel.deselectAll();
        if (this.leftCondPanel.getGraph() != null) {
            this.leftCondPanel.deselectAll();
        }
    }

    public void setStraightenArcs(boolean b) {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.getGraph().setStraightenArcs(b);
        this.rightPanel.getGraph().setStraightenArcs(b);
        if (this.leftCondPanel.getGraph() != null) {
            this.leftCondPanel.getGraph().setStraightenArcs(b);
        }
    }

    public void straightenArcsProc() {
        if (this.eRule == null) {
            return;
        }
        this.leftPanel.straightenSelectedArcs();
        this.rightPanel.straightenSelectedArcs();
        if (this.leftCondPanel.getGraph() != null) {
            this.leftCondPanel.straightenSelectedArcs();
        }
    }

    public void doIdenticRule() {
        this.msg = "";
        if (this.eRule == null || this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (this.eRule.getBasisRule() instanceof MultiRule && !((MultiRule)this.eRule.getBasisRule()).getRuleScheme().getKernelRule().getSource().isEmpty()) {
            this.msg = "It is not possible to make identical multi rule\n because of non-empty kernel rule.";
            JOptionPane.showMessageDialog(this.applFrame, this.msg, "Failed", 0);
            return;
        }
        this.removeMapppingBeforeIdenticRule(this.eRule.getLeft().getNodes(), this.eRule.getLeft().getArcs());
        this.removeObjectsOfGraph(false, this.eRule.getRight(), this.eRule.getRight().getNodes(), this.eRule.getRight().getArcs());
        this.eRule.identicRule();
        this.msg = this.eRule.getMsg();
        if (this.msg.equals("")) {
            if (this.gragraEditor != null) {
                this.gragraEditor.updateUndoButton();
            }
            this.leftPanel.updateGraphics();
            this.rightPanel.updateGraphics(true);
        }
    }

    private void removeMapppingBeforeIdenticRule(List<EdNode> nodesList, List<EdArc> arcsList) {
        for (EdGraphObject edGraphObject : arcsList) {
            this.removeRuleMapping(edGraphObject, true);
        }
        for (EdGraphObject edGraphObject : nodesList) {
            this.removeRuleMapping(edGraphObject, true);
        }
    }

    private void removeObjectsOfGraph(boolean left, EdGraph g, List<EdNode> nodesList, List<EdArc> arcsList) {
        GraphCanvas canvas = left ? this.leftPanel.getCanvas() : this.rightPanel.getCanvas();
        Iterator<EdArc> arcs = arcsList.iterator();
        while (arcs.hasNext()) {
            EdGraphObject obj = arcs.next();
            canvas.deleteObj(obj);
            arcs = arcsList.iterator();
        }
        Iterator<EdNode> nodes = nodesList.iterator();
        while (nodes.hasNext()) {
            EdGraphObject obj = nodes.next();
            canvas.deleteObj(obj);
            nodes = nodesList.iterator();
        }
    }

    public void doIdenticNAC() {
        if (this.eRule == null || this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().getSelectedPath().getLastPathComponent();
        if (this.eNAC != null && this.eNAC.getRule() == this.eRule && treeNode.getUserObject() instanceof NACTreeNodeData && ((NACTreeNodeData)treeNode.getUserObject()).getNAC() == this.eNAC) {
            if (!this.eNAC.getBasisGraph().isEmpty()) {
                Vector<EdGraphObject> elems = this.eRule.getLeft().getArcs();
                int i = 0;
                while (i < elems.size()) {
                    this.removeNacMapping(elems.get(i), true);
                    ++i;
                }
                elems = this.eRule.getLeft().getNodes();
                i = 0;
                while (i < elems.size()) {
                    this.removeNacMapping(elems.get(i), true);
                    ++i;
                }
                Vector<EdGraphObject> vec = new Vector<EdGraphObject>();
                vec.addAll(this.eNAC.getNodes());
                vec.addAll(this.eNAC.getArcs());
                this.eNAC.addDeletedToUndo(vec);
            }
        } else if (this.eNAC == null || this.eNAC.getRule() != this.eRule || treeNode.getUserObject() != this.eNAC) {
            EdNAC enac = ((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().addNAC(false);
            ((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().selectPath(((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().getTreePathOfGrammarElement(enac));
        }
        this.eRule.identicNAC(this.eNAC);
        this.msg = this.eRule.getMsg();
        if (this.msg.equals("")) {
            if (this.gragraEditor != null) {
                this.gragraEditor.updateUndoButton();
            }
            this.leftPanel.updateGraphics();
            this.leftCondPanel.updateGraphics(true);
        }
    }

    public void doIdenticPAC() {
        if (this.eRule == null || this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().getSelectedPath().getLastPathComponent();
        if (this.ePAC != null && this.ePAC.getRule() == this.eRule && treeNode.getUserObject() instanceof PACTreeNodeData && ((PACTreeNodeData)treeNode.getUserObject()).getPAC() == this.ePAC) {
            if (!this.ePAC.getBasisGraph().isEmpty()) {
                Vector<EdGraphObject> elems = this.eRule.getLeft().getArcs();
                int i = 0;
                while (i < elems.size()) {
                    this.removePacMapping(elems.get(i), true);
                    ++i;
                }
                elems = this.eRule.getLeft().getNodes();
                i = 0;
                while (i < elems.size()) {
                    this.removePacMapping(elems.get(i), true);
                    ++i;
                }
                Vector<EdGraphObject> vec = new Vector<EdGraphObject>();
                vec.addAll(this.ePAC.getNodes());
                vec.addAll(this.ePAC.getArcs());
                this.ePAC.addDeletedToUndo(vec);
            }
        } else if (this.ePAC == null || this.ePAC.getRule() != this.eRule || treeNode.getUserObject() != this.ePAC) {
            EdPAC epac = ((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().addPAC();
            ((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().selectPath(((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().getTreePathOfGrammarElement(epac));
        }
        this.eRule.identicPAC(this.ePAC);
        this.msg = this.eRule.getMsg();
        if (this.msg.equals("")) {
            if (this.gragraEditor != null) {
                this.gragraEditor.updateUndoButton();
            }
            this.leftPanel.updateGraphics();
            this.leftCondPanel.updateGraphics(true);
        }
    }

    public void doIdenticGAC() {
        if (this.eRule == null || this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().getSelectedPath().getLastPathComponent();
        if (this.eGAC != null && treeNode.getUserObject() instanceof NestedACTreeNodeData && ((NestedACTreeNodeData)treeNode.getUserObject()).getNestedAC() == this.eGAC) {
            if (!this.eGAC.getBasisGraph().isEmpty()) {
                EdGraph srcGraph = this.eGAC.getSource() == null ? this.eRule.getLeft() : this.eGAC.getSource();
                Vector<EdGraphObject> elems = srcGraph.getArcs();
                int i = 0;
                while (i < elems.size()) {
                    this.removeNestedACMapping(elems.get(i), true);
                    ++i;
                }
                elems = srcGraph.getNodes();
                i = 0;
                while (i < elems.size()) {
                    this.removeNestedACMapping(elems.get(i), true);
                    ++i;
                }
                Vector<EdGraphObject> vec = new Vector<EdGraphObject>();
                vec.addAll(this.eGAC.getNodes());
                vec.addAll(this.eGAC.getArcs());
                this.eGAC.addDeletedToUndo(vec);
            }
        } else if (this.eGAC == null || this.eGAC.getRule() != this.eRule || treeNode.getUserObject() != this.eGAC) {
            EdNestedApplCond egac = ((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().addNestedAC(false);
            ((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().selectPath(((AGGAppl)this.getGraGraEditor().getParentFrame()).getGraGraTreeView().getTreePathOfGrammarElement(egac));
        }
        this.eRule.identicNestedAC(this.eGAC);
        this.msg = this.eRule.getMsg();
        if (this.msg.equals("")) {
            if (this.gragraEditor != null) {
                this.gragraEditor.updateUndoButton();
            }
            this.leftPanel.updateGraphics();
            this.leftCondPanel.updateGraphics(true);
        }
    }

    public void doGACDuetoRHS() {
        if (this.eRule == null || this.eGAC == null || this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (!this.eGAC.getBasisGraph().isEmpty()) {
            EdGraph srcGraph = this.eGAC.getSource() == null ? this.eRule.getLeft() : this.eGAC.getSource();
            Vector<EdGraphObject> elems = srcGraph.getArcs();
            int i = 0;
            while (i < elems.size()) {
                this.removeNestedACMapping(elems.get(i), true);
                ++i;
            }
            elems = srcGraph.getNodes();
            i = 0;
            while (i < elems.size()) {
                this.removeNestedACMapping(elems.get(i), true);
                ++i;
            }
            Vector<EdGraphObject> vec = new Vector<EdGraphObject>();
            vec.addAll(this.eGAC.getNodes());
            vec.addAll(this.eGAC.getArcs());
            this.eGAC.addDeletedToUndo(vec);
        }
        this.eRule.makeGACDuetoRHS(this.eGAC);
        this.msg = this.eRule.getMsg();
        if (this.msg.equals("")) {
            if (this.gragraEditor != null) {
                this.gragraEditor.updateUndoButton();
            }
            this.leftPanel.updateGraphics();
            this.leftCondPanel.updateGraphics(true);
        }
    }

    public void doNACDuetoRHS() {
        if (this.eRule == null || this.eNAC == null || this.leftPanel.getEditMode() == 9 || this.rightPanel.getEditMode() == 9) {
            return;
        }
        if (!this.eNAC.getBasisGraph().isEmpty()) {
            Vector<EdGraphObject> elems = this.eRule.getLeft().getArcs();
            int i = 0;
            while (i < elems.size()) {
                this.removeNacMapping(elems.get(i), true);
                ++i;
            }
            elems = this.eRule.getLeft().getNodes();
            i = 0;
            while (i < elems.size()) {
                this.removeNacMapping(elems.get(i), true);
                ++i;
            }
            Vector<EdGraphObject> vec = new Vector<EdGraphObject>();
            vec.addAll(this.eNAC.getNodes());
            vec.addAll(this.eNAC.getArcs());
            this.eNAC.addDeletedToUndo(vec);
        }
        this.eRule.makeNACDuetoRHS(this.eNAC);
        this.msg = this.eRule.getMsg();
        if (this.msg.equals("")) {
            if (this.gragraEditor != null) {
                this.gragraEditor.updateUndoButton();
            }
            this.leftPanel.updateGraphics();
            this.leftCondPanel.updateGraphics(true);
        }
    }

    public void setGraphToCopy(EdGraph g) {
        if (this.eRule != null) {
            this.eRule.getLeft().setGraphToCopy(g);
            this.eRule.getRight().setGraphToCopy(g);
            if (this.leftCondPanel.getGraph() != null) {
                this.leftCondPanel.getGraph().setGraphToCopy(g);
            }
        }
    }

    public EdGraph getSelectedAsGraph() {
        if (this.eRule == null) {
            return null;
        }
        EdGraph g = this.eRule.getLeft().getSelectedAsGraph();
        if (g != null) {
            this.sourceOfCopy = this.eRule.getLeft();
            return g;
        }
        g = this.eRule.getRight().getSelectedAsGraph();
        if (g != null) {
            this.sourceOfCopy = this.eRule.getRight();
            return g;
        }
        if (this.leftCondPanel.getGraph() != null) {
            g = this.leftCondPanel.getGraph().getSelectedAsGraph();
            if (g != null) {
                this.sourceOfCopy = this.leftCondPanel.getGraph();
                return g;
            }
            return null;
        }
        return null;
    }

    public EdGraph getSourceOfCopy() {
        return this.sourceOfCopy;
    }

    public void setSourceOfCopy(EdGraph g) {
        this.sourceOfCopy = g;
    }

    private void setLastEditModeBeforMatch(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 801 || gp.getEditMode() == 8010 || gp.getEditMode() == 9) {
            gp.setLastEditMode(gp.getEditMode());
        }
    }

    private void handleMouseListenerFromGraphEditor(int mode) {
        switch (mode) {
            case 11: 
            case 12: 
            case 13: 
            case 113: 
            case 114: {
                if (!this.mouseListenerFromGraphEditorAdded || this.graphEditor == null) break;
                this.graphEditor.getGraphPanel().getCanvas().removeMouseListener(this.mouseAdapter);
                this.mouseListenerFromGraphEditorAdded = false;
                break;
            }
            case 42: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                if (this.mouseListenerFromGraphEditorAdded || this.graphEditor == null) break;
                this.graphEditor.getGraphPanel().getCanvas().addMouseListener(this.mouseAdapter);
                this.mouseListenerFromGraphEditorAdded = true;
                break;
            }
        }
    }

    private void removeProc() {
        if (this.leftPanel.getEditMode() == 115) {
            this.removeMappingProc();
        } else if (this.leftPanel.getEditMode() == 117) {
            this.removeMappingSelProc();
        }
    }

    private void removeRuleMappingProc() {
        this.leftPanel.setEditMode(32);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeNACMappingProc() {
        this.leftPanel.setEditMode(82);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removePACMappingProc() {
        this.leftPanel.setEditMode(802);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeNestedACMappingProc() {
        this.leftPanel.setEditMode(8020);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeMatchMappingProc() {
        this.leftPanel.setEditMode(43);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeMappingProc() {
        this.leftPanel.setEditMode(1161);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    private void removeMappingSelProc() {
        this.leftPanel.setEditMode(1181);
        this.leftPanel.setEditCursor(new Cursor(1));
        if (this.applFrame != null) {
            this.applFrame.setCursor(new Cursor(1));
        }
    }

    public void resetEditModeAfterMapping() {
        this.mapping = false;
        this.isEditPopupMenu = false;
        this.isEditSelPopupMenu = false;
        this.setEditMode(this.leftPanel.getLastEditMode());
        if (this.graphEditor != null) {
            this.graphEditor.setEditMode(this.leftPanel.getLastEditMode());
        }
        if (this.gragraEditor != null) {
            this.gragraEditor.setMsg(this.getMsg());
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
    }

    private void setLastEditModeBeforMapping(GraphPanel gp) {
        if (gp.getEditMode() == 11 || gp.getEditMode() == 113 || gp.getEditMode() == 12 || gp.getEditMode() == 13 || gp.getEditMode() == 114 || gp.getEditMode() == 31 || gp.getEditMode() == 81 || gp.getEditMode() == 801 || gp.getEditMode() == 8010 || gp.getEditMode() == 42 || gp.getEditMode() == 115 || gp.getEditMode() == 116) {
            gp.setLastEditMode(gp.getEditMode());
        }
    }

    public GraphPanel setActivePanel(Object src) {
        this.activePanel = src instanceof GraphCanvas ? ((GraphCanvas)src).getViewport() : null;
        return this.activePanel;
    }

    public void showPopupMenu(MouseEvent e) {
        if (this.activePanel != null && e.getX() > 0 && e.getY() > 0) {
            if (this.editPopupMenu != null) {
                this.editPopupMenu.setEditor(this);
                this.editPopupMenu.setParentFrame(this.applFrame);
            }
            if (this.editSelPopupMenu != null) {
                this.editSelPopupMenu.setEditor(this);
                this.editSelPopupMenu.setParentFrame(this.applFrame);
            }
            this.isEditPopupMenu = false;
            this.isEditSelPopupMenu = false;
            if (this.activePanel == this.leftPanel) {
                if (this.modePopupMenu != null && this.modePopupMenu.invoked(this, this.activePanel, e.getX(), e.getY())) {
                    this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
                } else if (this.editPopupMenu != null && this.editPopupMenu.invoked(this.activePanel, e.getX(), e.getY())) {
                    this.isEditPopupMenu = true;
                    this.editPopupMenu.setMapEnabled(true);
                    this.editPopupMenu.setUnmapEnabled(true);
                    this.editPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                } else if (this.editSelPopupMenu != null && this.editSelPopupMenu.invoked(this.activePanel, e.getX(), e.getY())) {
                    this.isEditSelPopupMenu = true;
                    this.editSelPopupMenu.setMapEnabled(true);
                    this.editSelPopupMenu.setUnmapEnabled(true);
                    this.editSelPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            } else if (this.modePopupMenu != null && this.modePopupMenu.invoked(this, this.activePanel, e.getX(), e.getY())) {
                this.modePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (this.editPopupMenu != null && this.editPopupMenu.invoked(this.activePanel, e.getX(), e.getY())) {
                this.isEditPopupMenu = true;
                this.editPopupMenu.setMapEnabled(false);
                this.editPopupMenu.setUnmapEnabled(true);
                this.editPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            } else if (this.editSelPopupMenu != null && this.editSelPopupMenu.invoked(this.activePanel, e.getX(), e.getY())) {
                this.isEditSelPopupMenu = true;
                this.editSelPopupMenu.setMapEnabled(false);
                this.editSelPopupMenu.setUnmapEnabled(true);
                this.editSelPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void deselectAllWeakselected() {
        if (this.leftPanel.eGraph != null) {
            this.leftPanel.eGraph.deselectAllWeakselected();
        }
        if (this.rightPanel.eGraph != null) {
            this.rightPanel.eGraph.deselectAllWeakselected();
        }
        if (this.leftCondPanel.eGraph != null) {
            this.leftCondPanel.eGraph.deselectAllWeakselected();
        }
    }

    private void setPanelEditMode(int mode) {
        this.leftPanel.setEditMode(mode);
        this.rightPanel.setEditMode(mode);
        this.leftCondPanel.setEditMode(mode);
    }
}

