/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdConstraint;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ConstraintPopupMenu
extends JPopupMenu {
    private GraGraTreeView treeView;
    private JMenuItem disable;
    private JMenuItem checkGraph;

    public ConstraintPopupMenu(GraGraTreeView tree) {
        super("Constraint");
        this.treeView = tree;
        JMenuItem mi = this.add(new JMenuItem("Select Rule Layer"));
        mi.setActionCommand("setConstraintLayer");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        mi = this.add(new JMenuItem("Select Rule Priority"));
        mi.setActionCommand("setConstraintPriority");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.checkGraph = this.add(new JMenuItem("Check Graph"));
        this.checkGraph.setActionCommand("checkOneConstraint");
        this.checkGraph.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        mi = this.add(new JMenuItem("Edit"));
        mi.setActionCommand("editConstraint");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = this.add(new JMenuItem("Delete               Delete"));
        mi.setActionCommand("deleteConstraint");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.addSeparator();
        this.disable = new JCheckBoxMenuItem("disabled");
        this.disable.setActionCommand("disableConstraint");
        this.disable.addActionListener(this.treeView.getActionAdapter());
        this.add(this.disable);
        this.addSeparator();
        mi = this.add(new JMenuItem("Textual Comments"));
        mi.setActionCommand("commentConstraint");
        mi.addActionListener(this.treeView.getActionAdapter());
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        DefaultMutableTreeNode aNode;
        GraGraTreeNodeData sd;
        TreePath path;
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && (path = this.treeView.getTree().getPathForLocation(x, y)).getPath().length == 3 && (sd = (GraGraTreeNodeData)(aNode = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) != null && sd.isConstraint()) {
            EdConstraint constr = sd.getConstraint();
            if (!constr.getBasisConstraint().isEnabled()) {
                this.disable.setSelected(true);
                this.checkGraph.setEnabled(false);
            } else {
                this.disable.setSelected(false);
                this.checkGraph.setEnabled(true);
            }
            return true;
        }
        return false;
    }
}

