/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.trafo;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdRule;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.gui.trafo.GraGraTransform;
import agg.gui.treeview.dialog.GraGraLayerDialog;
import agg.xt_basis.GraTra;
import agg.xt_basis.GraTraEvent;
import agg.xt_basis.GraTraEventListener;
import agg.xt_basis.GraTraOptions;
import agg.xt_basis.LayeredGraTraImpl;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class TransformLayered
extends Thread
implements GraTraEventListener,
EditEventListener {
    public static int MAX_LAYERED_RUNS = 5;
    private JFrame parent;
    private GraGraTransform gragraTransform;
    private LayeredGraTraImpl gratra;
    private boolean consistencyWhenCheckAfterGraphTrafo = true;
    private int msgGraTra;
    private GraTraEvent event;
    private EdGraGra gragra;
    private Rule currentRule;
    private Match currentMatch;
    private boolean inputParameterOK = false;
    private int steps;
    private boolean cancelled = false;
    private boolean stopped = false;
    private RuleLayer rl;
    private boolean showGraphAfterStep;
    private boolean gragraAnimated;
    private boolean consistencyCheckNotNeeded = false;

    public TransformLayered(GraGraTransform transform) {
        this.gragraTransform = transform;
        this.gratra = new LayeredGraTraImpl();
        this.gratra.enableWriteLogFile(true);
        this.gratra.addGraTraListener(this);
    }

    public void dispose() {
        this.gratra.removeGraTraListener(this);
        this.gratra.dispose();
        this.rl.dispose();
        this.currentMatch = null;
        this.currentRule = null;
        this.gragra = null;
        this.event = null;
    }

    public GraTra getGraTra() {
        return this.gratra;
    }

    public void setGraGra(EdGraGra gra) {
        this.gragra = gra;
        this.gratra.setGraGra(this.gragra.getBasisGraGra());
        this.gratra.setHostGraph(this.gragra.getBasisGraGra().getGraph());
    }

    public void setCompletionStrategy(MorphCompletionStrategy strat) {
        this.gratra.setCompletionStrategy(strat);
    }

    public void setParentFrame(JFrame f) {
        this.parent = f;
    }

    public void setShowGraphAfterStep(boolean show) {
        this.showGraphAfterStep = show;
    }

    @Override
    public void run() {
        this.gragraAnimated = false;
        this.steps = 0;
        this.cancelled = false;
        this.stopped = false;
        if (this.gratra.getHostGraph() != this.gragra.getBasisGraGra().getGraph()) {
            this.gratra.setHostGraph(this.gragra.getBasisGraGra().getGraph());
        }
        this.gratra.setLayerToStop(this.gragraTransform.getLayerToStop());
        this.consistencyCheckNotNeeded = !this.gragra.hasEnabledConstraints();
        this.consistencyWhenCheckAfterGraphTrafo = this.gragraTransform.consistencyCheckAfterGraphTrafoEnabled();
        this.gragraAnimated = this.gragra.isAnimated();
        this.layeredTransform();
    }

    public void stopping() {
        if (this.gragraTransform.breakAllLayerEnabled()) {
            this.stopped = true;
        }
        this.gratra.stop();
    }

    public void nextLayer() {
        this.gratra.nextLayer();
    }

    private void layeredTransform() {
        this.gratra.setGraTraOptions(this.gragraTransform.getGraTraOptions());
        GraTraOptions gratraOptions = this.gratra.getGraTraOptions();
        gratraOptions.addOption("layered");
        this.gragra.getBasisGraGra().setGraTraOptions(this.gragraTransform.getGraTraOptionsList());
        this.rl = new RuleLayer(this.gragra.getBasisGraGra().getEnabledRules());
        if (this.gragraTransform.showLayerEnabled()) {
            GraGraLayerDialog lg = new GraGraLayerDialog(this.parent, this.rl);
            lg.showGUI();
            if (!lg.isCancelled()) {
                this.gragra.getBasisGraGra().setRuleLayer(this.rl);
            }
        }
        this.gratra.transform();
    }

    @Override
    public void graTraEventOccurred(GraTraEvent e) {
        String ruleName = "";
        this.event = e;
        this.msgGraTra = e.getMessage();
        if (this.msgGraTra == 8) {
            ruleName = e.getMatch().getRule().getName();
            if (this.gragraTransform.selectMatchObjectsEnabled()) {
                this.gragra.getGraph().updateAlongMorph(e.getMatch());
            }
            this.gragra.getGraph().unsetNodeNumberChanged();
            this.gragraTransform.fireTransform(new TransformEvent(this, 17, this.event.getMatch(), "  match of  <" + ruleName + ">  is valid"));
        } else if (this.msgGraTra == 2) {
            ++this.steps;
            this.currentMatch = this.event.getMatch();
            this.currentRule = this.currentMatch.getRule();
            ruleName = this.currentRule.getName();
            if (this.showGraphAfterStep) {
                this.gragra.getGraph().setXYofNewNode(this.gragra.getRule(this.currentRule), this.currentMatch, this.currentMatch.getCoMorphism());
                if (this.gragra.isRuleAnimated(this.currentRule)) {
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 25, this.currentMatch));
                } else if (!this.gragraAnimated) {
                    this.gragraTransform.getEditor().doStepLayoutProc();
                    if (this.gragraTransform.selectNewAfterStepEnabled()) {
                        this.gragra.getGraph().updateAlongMorph(this.event.getCoMatch(), this.currentRule);
                    }
                }
                this.disposeMatch();
            }
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 2, "  <" + ruleName + ">  is applied"));
        } else if (this.msgGraTra == 16) {
            if (this.gratra.getCurrentLayer() >= 0) {
                if (!this.showGraphAfterStep) {
                    this.gragraTransform.getEditor().doStandardLayoutProc();
                }
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 22, " Layer  " + e.getMessageText() + "  done.  "));
            } else if (this.gragraTransform.layeredLoopEnabled()) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 22, " Loop over layer. First layer will start. "));
            }
        } else if (this.msgGraTra == 5) {
            this.gratra.stop();
            this.gragra.getGraph().clearMarks();
            if (!this.showGraphAfterStep) {
                this.gragraTransform.getEditor().doStandardLayoutProc();
            }
            if (!this.cancelled && this.steps == 0) {
                this.gragraTransform.fireTransform(new TransformEvent((Object)this, 4, e.getMessageText()));
            }
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 10, "  finished.  "));
            System.out.println("*** Layered transformation - finished.  ");
            if (this.gragraTransform.layeredLoopEnabled() && this.gragraTransform.resetGraphEnabled() && (!this.consistencyWhenCheckAfterGraphTrafo || this.consistencyCheckNotNeeded)) {
                this.gragraTransform.fireTransform(new TransformEvent(this, 26));
            }
        } else if (this.msgGraTra == 1) {
            this.inputParameterOK = false;
            String rulename = "";
            if (this.event.getMatch() != null) {
                rulename = this.event.getMatch().getRule().getName();
            } else if (this.event.getRule() != null) {
                rulename = this.event.getRule().getName();
            }
            int answer = this.parameterWarning(rulename);
            if (answer == 0) {
                if (this.event.getMatch() != null) {
                    this.currentMatch = this.event.getMatch();
                    this.currentRule = this.currentMatch.getRule();
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.currentMatch));
                } else if (this.event.getRule() != null) {
                    this.currentRule = this.event.getRule();
                    this.gragraTransform.fireTransform(new TransformEvent((Object)this, 1, this.currentRule));
                }
                while (!this.inputParameterOK) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            } else if (answer == 1) {
                this.gratra.stopRule();
            } else if (answer == 2) {
                this.gratra.stop();
                this.cancelled = true;
                this.gragraTransform.fireTransform(new TransformEvent(this, 8));
            }
        } else if (this.msgGraTra == 6) {
            ruleName = this.event.getMessageText();
            String s = "Please check variables of the rule:  " + ruleName;
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, s));
        } else if (this.msgGraTra == 15 || this.msgGraTra == 9 || this.msgGraTra == 14 || this.msgGraTra == 10) {
            String s = e.getMessageText();
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 18, s));
        } else if (this.msgGraTra != 7 && this.msgGraTra != 3 && this.msgGraTra == 11 && this.gragraTransform.consistencyCheckAfterGraphTrafoEnabled()) {
            this.consistencyWhenCheckAfterGraphTrafo = false;
            this.gragraTransform.fireTransform(new TransformEvent((Object)this, 19, this.event.getMessageText()));
        }
    }

    @Override
    public void editEventOccurred(EditEvent e) {
        if (e.getMsg() == -3) {
            this.inputParameterOK = true;
        }
    }

    public boolean isSuccessful() {
        return this.steps != 0;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void disposeMatch() {
        EdRule r = this.gragra.getRule(this.currentRule);
        if (r != null) {
            r.updateRule();
        }
    }

    private int parameterWarning(String ruleName) {
        Object[] options = new Object[]{"Set", "Continue", "Cancel"};
        int answer = JOptionPane.showOptionDialog(null, "Input parameter of the rule  \" " + ruleName + " \"  not set!\nDo you want to set parameter?", "Warning", -1, 2, null, options, options[0]);
        return answer;
    }
}

