/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.AttrException;
import agg.attribute.AttrInstance;
import agg.attribute.AttrManager;
import agg.attribute.AttrMapping;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.ExtObservable;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.CompletionStrategySelector;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MatchHelper;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.UndirectedArc;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class OrdinaryMorphism
extends ExtObservable
implements Morphism {
    protected String itsName = "OrdinaryMorphism";
    protected String comment = "";
    protected MorphCompletionStrategy itsCompleter;
    protected boolean itsTouchedFlag = true;
    protected boolean itsInteractiveFlag = true;
    protected Dictionary<AttrInstance, AttrMapping> itsAttrMappings;
    protected AttrContext itsAttrContext;
    protected AttrManager itsAttrManager;
    protected Graph itsOrig;
    protected Graph itsImag;
    protected static final AttrContext cKeepContext = null;
    protected final Vector<GraphObject> itsDomObjects = new Vector();
    protected final Vector<GraphObject> itsCodomObjects = new Vector();
    protected OrdinaryMorphism itsCoMorph;
    protected boolean enabled = true;
    boolean mappingChanged;
    protected boolean changed;
    protected boolean typeObjectsMapChanged;
    protected boolean partialMorphCompletion;
    protected boolean shifted;
    protected String errorMsg;
    protected boolean removeAttrMapping = true;

    protected OrdinaryMorphism() {
        this(new Graph(), new Graph(), cKeepContext);
    }

    protected OrdinaryMorphism(AttrContext ac) {
        this(new Graph(), new Graph(), ac);
    }

    public OrdinaryMorphism(Graph orig, Graph img) {
        this(orig, img, cKeepContext);
    }

    public OrdinaryMorphism(Graph orig, Graph img, AttrContext ac) {
        this.itsOrig = orig;
        this.itsOrig.addUsingMorph(this);
        this.itsImag = img;
        this.itsImag.addUsingMorph(this);
        this.itsAttrContext = ac;
        this.itsAttrMappings = new Hashtable<AttrInstance, AttrMapping>(20);
        this.itsAttrManager = AttrTupleManager.getDefaultManager();
        this.setCompletionStrategy(CompletionStrategySelector.getDefault());
        this.itsTouchedFlag = true;
        this.itsInteractiveFlag = true;
        this.errorMsg = "";
    }

    @Override
    public void dispose() {
        if (this.itsCompleter != null) {
            this.itsCompleter.dispose();
        }
        this.removeAllMappings();
        this.itsOrig.removeUsingMorph(this);
        this.itsImag.removeUsingMorph(this);
        if (this.itsCoMorph != null) {
            this.itsCoMorph.dispose();
            this.itsCoMorph = null;
        }
        this.clearErrorMsg();
        super.dispose();
    }

    public void dispose(boolean disposableSource, boolean disposableTarget) {
        if (this.itsCompleter != null) {
            this.itsCompleter.dispose();
        }
        this.removeAllMappings();
        this.itsOrig.removeUsingMorph(this);
        this.itsImag.removeUsingMorph(this);
        if (this.itsCoMorph != null) {
            this.itsCoMorph.dispose();
            this.itsCoMorph = null;
        }
        this.clearErrorMsg();
        super.dispose();
        if (disposableSource) {
            this.itsOrig.dispose();
            this.itsOrig = null;
        }
        if (disposableTarget) {
            this.itsImag.dispose();
            this.itsImag = null;
        }
    }

    public boolean isInjectiveSet() {
        return this.getCompletionStrategy().getProperties().get(0);
    }

    public boolean isDanglingSet() {
        return this.getCompletionStrategy().getProperties().get(1);
    }

    public boolean isIdentificationSet() {
        return this.getCompletionStrategy().getProperties().get(2);
    }

    public boolean isGluingConditionSet() {
        return this.getCompletionStrategy().getProperties().get(1) && this.getCompletionStrategy().getProperties().get(2);
    }

    public boolean isNotificationRequired() {
        return this.countObservers() > 0;
    }

    public void setTarget(Graph g) {
        this.itsImag = g;
    }

    public void setSource(Graph g) {
        this.itsOrig = g;
    }

    public boolean isTypeObjectsMapChanged() {
        return this.typeObjectsMapChanged;
    }

    public void setTypeObjectsMapChanged(boolean b) {
        this.typeObjectsMapChanged = b;
    }

    public boolean hasPartialMorphismCompletion() {
        return this.partialMorphCompletion;
    }

    public void setPartialMorphismCompletion(boolean b) {
        this.partialMorphCompletion = b;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isShifted() {
        return this.shifted;
    }

    public void setErrorMsg(String msg) {
        this.errorMsg = msg;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void clearErrorMsg() {
        this.errorMsg = "";
        ((ContextView)this.getAttrContext()).getManager().clearErrorMsg();
        ((ContextView)this.getAttrContext()).clearErrorMsg();
    }

    public final boolean isCommutative(Morphism m) {
        if (this.itsOrig.getTypeSet().isArcDirected()) {
            return this.isCommutative1(m);
        }
        return this.isCommutative2(m);
    }

    private final boolean isCommutative1(Morphism m) {
        if (m == this) {
            return true;
        }
        if (m.getOriginal() == this.itsOrig) {
            for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
                GraphObject graphObject2 = this.getImage(graphObject);
                GraphObject anImage2 = m.getImage(graphObject);
                if (!(graphObject2 == null ? anImage2 != null : graphObject2 != anImage2)) continue;
                return false;
            }
            for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
                GraphObject anImage1 = this.getImage(graphObject);
                GraphObject anImage2 = m.getImage(graphObject);
                if (!(anImage1 == null ? anImage2 != null : anImage1 != anImage2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean isCommutativeORIG(Morphism m) {
        if (m == this) {
            return true;
        }
        if (m.getOriginal() == this.itsOrig) {
            for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
                GraphObject graphObject2 = this.getImage(graphObject);
                GraphObject anImage2 = m.getImage(graphObject);
                if (graphObject2 == null) {
                    if (anImage2 == null) continue;
                    return false;
                }
                if (graphObject2 == anImage2) continue;
                return false;
            }
            for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
                GraphObject anImage1 = this.getImage(graphObject);
                GraphObject anImage2 = m.getImage(graphObject);
                if (anImage1 == null) {
                    if (anImage2 == null) continue;
                    return false;
                }
                if (anImage1 == anImage2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean isCommutative2(Morphism m) {
        if (m == this) {
            return true;
        }
        if (m.getOriginal() == this.itsOrig) {
            for (Arc anOrig : this.itsOrig.getArcsSet()) {
                GraphObject graphObject = this.getImage(anOrig);
                GraphObject anImage2 = m.getImage(anOrig);
                if (!(graphObject == null ? anImage2 != null : graphObject != anImage2)) continue;
                return false;
            }
            for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
                GraphObject anImage1 = this.getImage(graphObject);
                GraphObject anImage2 = m.getImage(graphObject);
                if (anImage1 == null) {
                    if (anImage2 == null) continue;
                    return false;
                }
                if (anImage2 == null) {
                    return false;
                }
                if (anImage1.getNumberOfInOutArcs() != 0 || anImage2.getNumberOfInOutArcs() != 0 || anImage1 == anImage2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean isCommutative(Morphism m1, Morphism m2) {
        if (this.itsOrig.getTypeSet().isArcDirected()) {
            return this.isCommutative1(m1, m2);
        }
        return this.isCommutative2(m1, m2);
    }

    private final boolean isCommutativeORIG(Morphism m1, Morphism m2) {
        if (m1 == this) {
            return ((OrdinaryMorphism)m1).isCommutativeORIG(m2);
        }
        if (m1.getOriginal() == this.itsOrig && this.itsImag == m2.getOriginal() && m1.getImage() == m2.getImage()) {
            for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
                GraphObject graphObject2 = this.getImage(graphObject);
                GraphObject anImage1 = m1.getImage(graphObject);
                if (graphObject2 == null) {
                    if (anImage1 == null) continue;
                    return false;
                }
                if (m2.getImage(graphObject2) == anImage1) continue;
                return false;
            }
            for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
                GraphObject anImage = this.getImage(graphObject);
                GraphObject anImage1 = m1.getImage(graphObject);
                if (anImage == null) {
                    if (anImage1 == null) continue;
                    return false;
                }
                if (m2.getImage(anImage) == anImage1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCommutative1(Morphism m1, Morphism m2) {
        if (m1 == this) {
            return ((OrdinaryMorphism)m1).isCommutative1(m2);
        }
        if (m1.getOriginal() == this.itsOrig && this.itsImag == m2.getOriginal() && m1.getImage() == m2.getImage()) {
            for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
                GraphObject graphObject2 = this.getImage(graphObject);
                GraphObject anImage1 = m1.getImage(graphObject);
                if (graphObject2 == null) {
                    if (anImage1 == null) continue;
                    return false;
                }
                if (m2.getImage(graphObject2) == anImage1) continue;
                return false;
            }
            for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
                GraphObject anImage = this.getImage(graphObject);
                GraphObject anImage1 = m1.getImage(graphObject);
                if (anImage == null) {
                    if (anImage1 == null) continue;
                    return false;
                }
                if (m2.getImage(anImage) == anImage1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCommutative2(Morphism m1, Morphism m2) {
        if (m1 == this) {
            return ((OrdinaryMorphism)m1).isCommutative2(m2);
        }
        if (m1.getOriginal() == this.itsOrig && this.itsImag == m2.getOriginal() && m1.getImage() == m2.getImage()) {
            for (Arc anOrig : this.itsOrig.getArcsSet()) {
                GraphObject graphObject = this.getImage(anOrig);
                GraphObject anImage1 = m1.getImage(anOrig);
                GraphObject anImage2 = m2.getImage(graphObject);
                if (!(graphObject == null ? anImage1 != null : anImage2 != anImage1)) continue;
                return false;
            }
            for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
                GraphObject anImage = this.getImage(graphObject);
                GraphObject anImage1 = m1.getImage(graphObject);
                GraphObject anImage2 = m2.getImage(anImage);
                if (anImage == null) {
                    if (anImage1 == null) continue;
                    return false;
                }
                if (anImage1 == null) {
                    return false;
                }
                if (anImage.getNumberOfInOutArcs() != 0 || anImage1.getNumberOfInOutArcs() != 0 || anImage1 == anImage2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Match makeMatch(Rule rule) {
        Match m = BaseFactory.theFactory().createMatch(rule, this.itsImag);
        Enumeration<GraphObject> elements = this.getDomain();
        while (elements.hasMoreElements()) {
            GraphObject grob = elements.nextElement();
            try {
                m.addMapping(grob, this.getImage(grob));
            }
            catch (BadMappingException e) {
                this.errorMsg = e.getMessage();
                m.dispose();
                return null;
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrdinaryMorphism morphcopy() {
        OrdinaryMorphism ordinaryMorphism = this;
        synchronized (ordinaryMorphism) {
            GraphObject x;
            Graph targetCopy;
            Graph sourceCopy;
            Hashtable<GraphObject, GraphObject> orig2copyTarget;
            Hashtable<GraphObject, GraphObject> orig2copySource;
            boolean failed;
            block23: {
                block22: {
                    block21: {
                        failed = false;
                        orig2copySource = new Hashtable<GraphObject, GraphObject>();
                        orig2copyTarget = new Hashtable<GraphObject, GraphObject>();
                        sourceCopy = this.itsOrig.copy(orig2copySource);
                        targetCopy = this.itsImag.copy(orig2copyTarget);
                        if (sourceCopy != null || targetCopy != null) break block21;
                        return null;
                    }
                    if (sourceCopy != null) break block22;
                    targetCopy = null;
                    return null;
                }
                if (targetCopy != null) break block23;
                sourceCopy = null;
                return null;
            }
            OrdinaryMorphism theCopy = BaseFactory.theFactory().createMorphism(sourceCopy, targetCopy);
            Enumeration<GraphObject> domainOrig = this.getDomain();
            while (!failed && domainOrig.hasMoreElements()) {
                Node y;
                x = domainOrig.nextElement();
                if (!x.isNode() || (y = (Node)this.getImage(x)) == null) continue;
                Node xCopy = (Node)orig2copySource.get(x);
                Node yCopy = (Node)orig2copyTarget.get(y);
                try {
                    theCopy.addMapping(xCopy, yCopy);
                }
                catch (BadMappingException badMappingException) {
                    // empty catch block
                }
            }
            domainOrig = this.getDomain();
            while (!failed && domainOrig.hasMoreElements()) {
                x = domainOrig.nextElement();
                if (!x.isArc()) continue;
                Node vtx1 = (Node)((Arc)x).getSource();
                Node vtx2 = (Node)((Arc)x).getTarget();
                Node vtx1Copy = (Node)orig2copySource.get(vtx1);
                Node vtx2Copy = (Node)orig2copySource.get(vtx2);
                Arc y = (Arc)this.getImage(x);
                Node vtx3Copy = null;
                Node vtx4Copy = null;
                if (y != null) {
                    Node vtx3 = (Node)y.getSource();
                    Node vtx4 = (Node)y.getTarget();
                    vtx3Copy = (Node)orig2copyTarget.get(vtx3);
                    vtx4Copy = (Node)orig2copyTarget.get(vtx4);
                }
                Arc q = null;
                if (sourceCopy != null) {
                    for (Arc a : sourceCopy.getArcsSet()) {
                        if (!((Node)a.getSource()).equals(vtx1Copy) || !((Node)a.getTarget()).equals(vtx2Copy)) continue;
                        q = a;
                    }
                }
                Arc z = null;
                if (vtx3Copy != null && vtx4Copy != null && targetCopy != null) {
                    for (Arc a : targetCopy.getArcsSet()) {
                        if (!((Node)a.getSource()).equals(vtx3Copy) || !((Node)a.getTarget()).equals(vtx4Copy)) continue;
                        z = a;
                    }
                }
                if (q != null && z != null) {
                    try {
                        if (theCopy == null) continue;
                        theCopy.addMapping(q, z);
                    }
                    catch (BadMappingException badMappingException) {}
                    continue;
                }
                failed = true;
                if (theCopy != null) {
                    theCopy.dispose();
                }
                theCopy = null;
                if (sourceCopy != null) {
                    sourceCopy.dispose();
                }
                sourceCopy = null;
                if (targetCopy != null) {
                    targetCopy.dispose();
                }
                targetCopy = null;
            }
            return theCopy;
        }
    }

    public boolean makeDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond) {
        GraphObject elem2;
        Enumeration<GraphObject> secondDom;
        GraphObject elem1;
        boolean result;
        if (!this.itsOrig.equals(theFirst.getImage())) {
            return false;
        }
        if (!this.itsImag.equals(theSecond.getImage())) {
            return false;
        }
        if (!theFirst.getOriginal().equals(theSecond.getOriginal())) {
            return false;
        }
        Enumeration<GraphObject> firstDom = theFirst.getDomain();
        while (firstDom.hasMoreElements()) {
            result = false;
            elem1 = firstDom.nextElement();
            secondDom = theSecond.getDomain();
            while (secondDom.hasMoreElements()) {
                elem2 = secondDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        secondDom = theSecond.getDomain();
        while (secondDom.hasMoreElements()) {
            result = false;
            elem1 = secondDom.nextElement();
            firstDom = theFirst.getDomain();
            while (firstDom.hasMoreElements()) {
                elem2 = firstDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        Enumeration<GraphObject> ownDom = this.getDomain();
        while (ownDom.hasMoreElements()) {
            GraphObject y = ownDom.nextElement();
            GraphObject z = this.getImage(y);
            Enumeration<GraphObject> manyX = theFirst.getInverseImage(y);
            while (manyX.hasMoreElements()) {
                GraphObject x = manyX.nextElement();
                if (theSecond.getImage(x).equals(z)) continue;
                return false;
            }
        }
        firstDom = theFirst.getDomain();
        while (firstDom.hasMoreElements()) {
            GraphObject x = firstDom.nextElement();
            GraphObject y = theFirst.getImage(x);
            GraphObject z = theSecond.getImage(x);
            if (z == null || z.equals(this.getImage(y))) continue;
            try {
                if (y.isNode()) {
                    this.addMapping(y, z);
                    continue;
                }
                if (!((Arc)z).getSource().equals(this.getImage(((Arc)y).getSource())) || !((Arc)z).getTarget().equals(this.getImage(((Arc)y).getTarget()))) continue;
                this.addMapping(y, z);
            }
            catch (BadMappingException ex) {
                System.out.println(ex.getMessage());
            }
        }
        return true;
    }

    public boolean makeWeakDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond) {
        if (!theFirst.getDomain().hasMoreElements() && !theSecond.getDomain().hasMoreElements()) {
            return this.nextCompletion();
        }
        Enumeration<GraphObject> ownDom = this.getDomain();
        while (ownDom.hasMoreElements()) {
            GraphObject y = ownDom.nextElement();
            GraphObject z = this.getImage(y);
            Enumeration<GraphObject> manyX = theFirst.getInverseImage(y);
            while (manyX.hasMoreElements()) {
                GraphObject x = manyX.nextElement();
                if (theSecond.getImage(x).equals(z)) continue;
                return false;
            }
        }
        Enumeration<GraphObject> firstDom = theFirst.getDomain();
        firstDom = theFirst.getDomain();
        while (firstDom.hasMoreElements()) {
            GraphObject x = firstDom.nextElement();
            GraphObject y = theFirst.getImage(x);
            GraphObject z = theSecond.getImage(x);
            if (z == null || z.equals(this.getImage(y))) continue;
            try {
                this.addMapping(y, z);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        if (!theFirst.getDomain().hasMoreElements() || !theSecond.getDomain().hasMoreElements()) {
            return this.nextCompletion();
        }
        return true;
    }

    public boolean makeFullDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond) {
        GraphObject elem2;
        Enumeration<GraphObject> secondDom;
        GraphObject elem1;
        boolean result;
        if (!this.itsOrig.equals(theFirst.getImage())) {
            return false;
        }
        if (!this.itsImag.equals(theSecond.getImage())) {
            return false;
        }
        if (!theFirst.getOriginal().equals(theSecond.getOriginal())) {
            return false;
        }
        Enumeration<GraphObject> firstDom = theFirst.getOriginal().getElements();
        while (firstDom.hasMoreElements()) {
            result = false;
            elem1 = firstDom.nextElement();
            secondDom = theSecond.getOriginal().getElements();
            while (secondDom.hasMoreElements()) {
                elem2 = secondDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        secondDom = theSecond.getOriginal().getElements();
        while (secondDom.hasMoreElements()) {
            result = false;
            elem1 = secondDom.nextElement();
            firstDom = theFirst.getOriginal().getElements();
            while (firstDom.hasMoreElements()) {
                elem2 = firstDom.nextElement();
                if (!elem1.equals(elem2)) continue;
                result = true;
                break;
            }
            if (result) continue;
            return result;
        }
        Enumeration<GraphObject> ownDom = this.itsOrig.getElements();
        while (ownDom.hasMoreElements()) {
            GraphObject y = ownDom.nextElement();
            GraphObject z = this.getImage(y);
            if (z == null) continue;
            Enumeration<GraphObject> manyX = theFirst.getInverseImage(y);
            while (manyX.hasMoreElements()) {
                GraphObject x = manyX.nextElement();
                if (theSecond.getImage(x).equals(z)) continue;
                return false;
            }
        }
        firstDom = theFirst.getOriginal().getElements();
        while (firstDom.hasMoreElements()) {
            GraphObject x = firstDom.nextElement();
            GraphObject y = theFirst.getImage(x);
            GraphObject z = theSecond.getImage(x);
            if (y == null || z == null || z.equals(this.getImage(y))) continue;
            try {
                this.addMapping(y, z);
            }
            catch (BadMappingException ex) {
                return false;
            }
        }
        return true;
    }

    public boolean makeDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond, OrdinaryMorphism theThird) {
        OrdinaryMorphism tmpMorph = theSecond.compose(theThird);
        return this.makeDiagram(theFirst, tmpMorph);
    }

    public boolean makeWeakDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond, OrdinaryMorphism theThird) {
        OrdinaryMorphism tmpMorph = theSecond.compose(theThird);
        return this.makeWeakDiagram(theFirst, tmpMorph);
    }

    public boolean makeFullDiagram(OrdinaryMorphism theFirst, OrdinaryMorphism theSecond, OrdinaryMorphism theThird) {
        OrdinaryMorphism tmpMorph = BaseFactory.theFactory().createMorphism(theSecond.getOriginal(), theThird.getImage());
        for (GraphObject graphObject : theSecond.getOriginal().getNodesSet()) {
            GraphObject theThirdGoImage;
            GraphObject graphObject2 = theSecond.getImage(graphObject);
            if (graphObject2 == null || (theThirdGoImage = theThird.getImage(graphObject2)) == null) continue;
            try {
                tmpMorph.addMapping(graphObject, theThirdGoImage);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        for (GraphObject graphObject : theSecond.getOriginal().getArcsSet()) {
            GraphObject theThirdGoImage;
            GraphObject theSecondGoImage = theSecond.getImage(graphObject);
            if (theSecondGoImage == null || (theThirdGoImage = theThird.getImage(theSecondGoImage)) == null) continue;
            try {
                tmpMorph.addMapping(graphObject, theThirdGoImage);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        return this.makeFullDiagram(theFirst, tmpMorph);
    }

    public boolean makeIsomorphic() {
        if (this.itsOrig.getNodesCount() != this.itsImag.getNodesCount()) {
            return false;
        }
        if (this.itsOrig.getArcsCount() != this.itsOrig.getArcsCount()) {
            return false;
        }
        if (this.isTotal()) {
            return true;
        }
        boolean result = false;
        this.setCompletionStrategy(new Completion_InjCSP());
        if (this.nextCompletion()) {
            result = true;
            if (this.itsOrig.getTypeSet().getTypeGraph() != null && this.itsOrig.getTypeSet().hasInheritance()) {
                Iterator origs = this.itsOrig.itsNodes.iterator();
                while (origs.hasNext() && result) {
                    Node orig = (Node)origs.next();
                    if (orig.getType().compareTo(this.getImage(orig).getType())) continue;
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    public void setName(String n) {
        this.itsName = n;
    }

    @Override
    public String getName() {
        return this.itsName;
    }

    public void setTextualComment(String text) {
        this.comment = text;
    }

    public String getTextualComment() {
        return this.comment;
    }

    public void addMapping(Vector<GraphObject> listOfGraphObjects) throws BadMappingException {
        Iterator<Node> origs = this.itsOrig.getNodesSet().iterator();
        int i = 0;
        while (i < listOfGraphObjects.size() && origs.hasNext()) {
            GraphObject go = listOfGraphObjects.get(i);
            GraphObject img = origs.next();
            if (go instanceof Node && img instanceof Node) {
                this.addMapping(go, img);
            }
            ++i;
        }
        Iterator<Arc> origs1 = this.itsOrig.getArcsSet().iterator();
        int i2 = 0;
        while (i2 < listOfGraphObjects.size() && origs1.hasNext()) {
            GraphObject go = listOfGraphObjects.get(i2);
            GraphObject img = origs1.next();
            if (go instanceof Arc && img instanceof Arc) {
                this.addMapping(go, img);
            }
            ++i2;
        }
    }

    public void addMapping(Hashtable<GraphObject, GraphObject> obj2img) throws BadMappingException {
        GraphObject img;
        GraphObject obj;
        Enumeration<GraphObject> objs = obj2img.keys();
        while (objs.hasMoreElements()) {
            obj = objs.nextElement();
            if (!obj.isNode()) continue;
            img = obj2img.get(obj);
            this.addMapping(obj, img);
        }
        objs = obj2img.keys();
        while (objs.hasMoreElements()) {
            obj = objs.nextElement();
            if (!obj.isArc()) continue;
            img = obj2img.get(obj);
            this.addMapping(obj, img);
        }
    }

    public TypeError checkCreateMapping(Node src, Node tar) {
        if (!this.checkType(src.getType(), tar.getType())) {
            this.errorMsg = "Objects to map must be of the compatible type.";
            return new TypeError(27, this.errorMsg);
        }
        if (this instanceof Match) {
            Enumeration<GraphObject> origEnum = this.getDomain();
            Match m = (Match)this;
            while (origEnum.hasMoreElements()) {
                GraphObject currentObject = origEnum.nextElement();
                if (!(currentObject instanceof Node) || currentObject == src) continue;
                Node currentNode = (Node)currentObject;
                Node currentRuleImage = (Node)m.getRule().getImage(currentNode);
                Node origRuleImage = (Node)m.getRule().getImage(src);
                Node currentMatchImage = (Node)m.getImage(currentNode);
                if (currentRuleImage == null || currentRuleImage != origRuleImage || currentMatchImage == null || tar.getType().compareTo(currentMatchImage.getType())) continue;
                this.errorMsg = "Non-injective rules must preserve types.";
                return new TypeError(27, this.errorMsg);
            }
        }
        return null;
    }

    public TypeError checkCreateMapping(Arc src, Arc tar) {
        GraphObject aSrc = src.getSource();
        GraphObject aTar = src.getTarget();
        if (!src.getType().compareTo(tar.getType())) {
            this.errorMsg = "Objects to map must be of the same type.";
            return new TypeError(27, this.errorMsg);
        }
        if (this.getImage(aSrc) != null) {
            if (!this.checkType(tar.getSource().getType(), this.getImage(aSrc).getType())) {
                this.errorMsg = "Edge mapping must be source compatible.";
                return new TypeError(27, this.errorMsg);
            }
        } else {
            this.errorMsg = "The sources of the edges should be already mapped.";
            return new TypeError(27, this.errorMsg);
        }
        if (this.getImage(aTar) != null) {
            if (!this.checkType(tar.getTarget().getType(), this.getImage(aTar).getType())) {
                this.errorMsg = "Edge mapping must be target compatible.";
                return new TypeError(27, this.errorMsg);
            }
        } else {
            this.errorMsg = "The targets of the edges should be already mapped.";
            return new TypeError(27, this.errorMsg);
        }
        return null;
    }

    public void addChild2ParentMapping(GraphObject o, GraphObject i) throws BadMappingException {
        if (this.getImage(o) != i) {
            if (this.getSource().isElement(o) && this.getTarget().isElement(i)) {
                try {
                    if (o.isNode() != i.isNode()) {
                        this.errorMsg = "Cannot map a node to an edge.";
                        throw new BadMappingException(this.errorMsg);
                    }
                    if (!o.getType().isParentOf(i.getType()) && !o.getType().isChildOf(i.getType())) {
                        this.errorMsg = "Objects to map must to have compatible types.";
                        throw new BadMappingException(this.errorMsg);
                    }
                    try {
                        this.checkNodeTypePreserving(o, i);
                    }
                    catch (BadMappingException ex) {
                        throw new BadMappingException(this.errorMsg);
                    }
                    try {
                        this.checkEdgeSourceTargetCompatibility(o, i);
                    }
                    catch (BadMappingException ex) {
                        throw new BadMappingException(this.errorMsg);
                    }
                    GraphObject aPreviousImage = this.getImage(o);
                    if (aPreviousImage != null) {
                        this.removeMapping(o);
                    }
                    try {
                        this.doAddChild2ParentAttrMapping(o, i);
                    }
                    catch (BadMappingException exc) {
                        this.errorMsg = exc.getMessage();
                        if (aPreviousImage != null) {
                            this.doAddChild2ParentAttrMapping(o, aPreviousImage);
                        }
                        throw exc;
                    }
                }
                catch (BadMappingException exc) {
                    this.errorMsg = exc.getMessage();
                    throw exc;
                }
            }
        } else {
            this.removeAttrMapping(o.getAttribute());
            this.addAttrMapping(o.getAttribute(), i.getAttribute());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doAddChild2ParentAttrMapping(GraphObject orig, GraphObject image) throws BadMappingException {
        if (((ContextView)this.getAttrContext()).getAllowedMapping() == 1 || ((ContextView)this.getAttrContext()).getAllowedMapping() == 3) {
            if (orig.getAttribute() == null && image.getAttribute() == null || orig.getType().isChildOf(image.getType()) || orig.getAttribute() != null && ((ValueTuple)orig.getAttribute()).canMatchTo((ValueTuple)image.getAttribute(), (ContextView)this.getAttrContext())) {
                boolean canMapAttr = true;
                if (orig.getType().isChildOf(image.getType()) && orig.getAttribute() != null && !((ValueTuple)orig.getAttribute()).canMatchChild2Parent((ValueTuple)image.getAttribute(), (ContextView)this.getAttrContext())) {
                    canMapAttr = false;
                }
                if (canMapAttr) {
                    try {
                        this.addAttrMapping(orig.getAttribute(), image.getAttribute());
                    }
                    catch (BadMappingException ex) {
                        this.errorMsg = "Attribute mapping failed!";
                        throw new BadMappingException(this.errorMsg);
                    }
                    this.addDomainMapping(orig, image, true);
                    return;
                }
                this.errorMsg = "Attribute mapping failed!";
                throw new BadMappingException(this.errorMsg);
            }
            this.errorMsg = "Attribute mapping failed!";
            throw new BadMappingException(this.errorMsg);
        }
        if (orig.getType().isChildOf(image.getType())) return;
        this.addAttrMapping(orig.getAttribute(), image.getAttribute());
        this.addDomainMapping(orig, image, true);
    }

    private void addDomainMapping(GraphObject orig, GraphObject image, boolean notificationRequired) {
        this.itsDomObjects.add(orig);
        this.itsCodomObjects.add(image);
        this.mappingChanged = true;
        if (notificationRequired) {
            if (this.isNotificationRequired()) {
                this.propagateChange(new Change(20, orig, this));
                this.propagateChange(new Change(20, image, this));
            }
            if (this.itsOrig.isNotificationRequired()) {
                this.itsOrig.propagateChange(new Change(20, orig, this));
            }
            if (this.itsImag.isNotificationRequired()) {
                this.itsImag.propagateChange(new Change(20, image, this));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMapping(GraphObject o, GraphObject i) throws BadMappingException {
        if (o == null || i == null) {
            this.errorMsg = "Mapping failed! The source or target object is null.";
            throw new BadMappingException(this.errorMsg);
        }
        if (this.getImage(o) == i) {
            this.removeAttrMapping(o.getAttribute());
            this.addAttrMapping(o.getAttribute(), i.getAttribute());
            return;
        }
        if (this.getSource().isElement(o) && this.getTarget().isElement(i)) {
            try {
                this.doAddMapping(o, i);
                return;
            }
            catch (BadMappingException exc) {
                this.errorMsg = exc.getMessage();
                throw exc;
            }
        }
        this.errorMsg = "Mapping failed! Graph objects to map must belong to the same morphism.";
        throw new BadMappingException(this.errorMsg);
    }

    public void addMappingFast(GraphObject o, GraphObject i) throws BadMappingException {
        if (o == null || i == null) {
            this.errorMsg = "Mapping failed! The source or target object is null.";
            throw new BadMappingException(this.errorMsg);
        }
        if (this.getImage(o) != i) {
            try {
                this.doAddMappingFast(o, i);
            }
            catch (BadMappingException exc) {
                this.errorMsg = exc.getMessage();
                throw exc;
            }
        } else {
            this.removeAttrMapping(o.getAttribute());
            this.addAttrMapping(o.getAttribute(), i.getAttribute());
        }
    }

    private void doAddMappingFast(GraphObject orig, GraphObject image) throws BadMappingException {
        try {
            this.doAddAttrMappingFast(orig, image);
            this.addDomainMapping(orig, image, true);
            this.changed = true;
        }
        catch (BadMappingException exc) {
            this.errorMsg = exc.getMessage();
            throw exc;
        }
    }

    private void doAddAttrMappingFast(GraphObject orig, GraphObject image) throws BadMappingException {
        if (((ContextView)this.getAttrContext()).getAllowedMapping() == 1) {
            try {
                this.addAttrMapping(orig.getAttribute(), image.getAttribute());
            }
            catch (BadMappingException ex) {
                this.errorMsg = "Attribute mapping failed! " + ex.getLocalizedMessage();
                throw new BadMappingException(this.errorMsg);
            }
        } else {
            this.addAttrMapping(orig.getAttribute(), image.getAttribute());
        }
    }

    public void addMapping(GraphObject o, GraphObject i, boolean mappingPropagation) throws BadMappingException {
        if (!mappingPropagation) {
            this.addMapping(o, i);
            return;
        }
        if (this.getSource().isElement(o) && this.getTarget().isElement(i)) {
            try {
                this.doAddMapping(o, i);
            }
            catch (BadMappingException exc) {
                this.errorMsg = exc.getMessage();
                throw exc;
            }
        }
    }

    protected void addPlainMapping(GraphObject orig, GraphObject image) throws BadMappingException {
        if (orig == null || image == null) {
            this.errorMsg = "Mapping failed! The source or target object is null.";
            throw new BadMappingException(this.errorMsg);
        }
        try {
            this.addAttrMapping(orig.getAttribute(), image.getAttribute());
            this.addDomainMapping(orig, image, false);
            this.changed = true;
        }
        catch (BadMappingException exc) {
            this.errorMsg = exc.getMessage();
            throw exc;
        }
    }

    protected void addObjectPlainMapping(GraphObject orig, GraphObject image) throws BadMappingException {
        if (orig == null || image == null) {
            this.errorMsg = "Mapping failed! The source or target object is null.";
            throw new BadMappingException(this.errorMsg);
        }
        try {
            this.addDomainMapping(orig, image, false);
            this.changed = true;
        }
        catch (BadMappingException exc) {
            this.errorMsg = exc.getMessage();
            throw exc;
        }
    }

    protected boolean checkType(Type orig, Type image) {
        return orig.isParentOf(image);
    }

    private void checkNodeTypePreserving(GraphObject orig, GraphObject image) throws BadMappingException {
        if (this instanceof Match && orig.isNode()) {
            Enumeration<GraphObject> origEnum = this.getDomain();
            Match m = (Match)this;
            while (origEnum.hasMoreElements()) {
                GraphObject currentObject = origEnum.nextElement();
                if (!(currentObject instanceof Node) || currentObject == orig) continue;
                Node currentNode = (Node)currentObject;
                Node currentRuleImage = (Node)m.getRule().getImage(currentNode);
                Node origRuleImage = (Node)m.getRule().getImage(orig);
                Node currentMatchImage = (Node)m.getImage(currentNode);
                if (currentRuleImage == null || currentRuleImage != origRuleImage || currentMatchImage == null || image.getType().compareTo(currentMatchImage.getType())) continue;
                this.errorMsg = "Non-injective rules must preserve types.";
                throw new BadMappingException(this.errorMsg);
            }
        }
    }

    protected void checkEdgeSourceTargetCompatibility(GraphObject orig, GraphObject image) throws BadMappingException {
        MatchHelper.checkEdgeSourceTargetCompatibility(this, orig, image);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doAddAttrMapping(GraphObject orig, GraphObject image) throws BadMappingException {
        if (((ContextView)this.getAttrContext()).getAllowedMapping() != 1) {
            this.addAttrMapping(orig.getAttribute(), image.getAttribute());
            return;
        }
        if (orig.getAttribute() == null || orig.getAttribute().getNumberOfEntries() == 0 || image.getAttribute() != null && ((ValueTuple)orig.getAttribute()).canMatchTo((ValueTuple)image.getAttribute(), (ContextView)this.getAttrContext())) {
            this.addAttrMapping(orig.getAttribute(), image.getAttribute());
            return;
        }
        this.errorMsg = "Attribute mapping failed!";
        throw new BadMappingException(this.errorMsg);
    }

    private void doAddMapping(GraphObject orig, GraphObject image) throws BadMappingException {
        if (orig.isNode() != image.isNode()) {
            this.errorMsg = "Cannot map node to edge.";
            throw new BadMappingException(this.errorMsg);
        }
        if (!this.checkType(orig.getType(), image.getType())) {
            this.errorMsg = "Objects to map must be of the same type.";
            throw new BadMappingException(this.errorMsg);
        }
        try {
            this.checkNodeTypePreserving(orig, image);
        }
        catch (BadMappingException ex) {
            throw new BadMappingException(this.errorMsg);
        }
        try {
            this.checkEdgeSourceTargetCompatibility(orig, image);
        }
        catch (BadMappingException ex) {
            this.errorMsg = ex.getLocalizedMessage();
            throw new BadMappingException(this.errorMsg);
        }
        GraphObject aPreviousImage = this.getImage(orig);
        if (aPreviousImage != null) {
            this.removeMapping(orig);
        }
        try {
            this.doAddAttrMapping(orig, image);
            this.addDomainMapping(orig, image, true);
            this.changed = true;
        }
        catch (BadMappingException exc) {
            this.errorMsg = exc.getMessage();
            if (aPreviousImage != null) {
                this.addMappingFast(orig, aPreviousImage);
            }
            throw exc;
        }
    }

    protected void addAttrMapping(AttrInstance o, AttrInstance i) throws BadMappingException {
        if (this.getAttrContext() != null) {
            if (o == null && i == null) {
                return;
            }
            if (o != null && i != null) {
                try {
                    this.itsAttrMappings.put(o, this.getAttrManager().newMapping(this.getAttrContext(), o, i));
                    this.errorMsg = "";
                }
                catch (AttrException exc) {
                    this.errorMsg = exc.getMessage();
                    throw new BadMappingException(exc.getMessage());
                }
            } else if (o != null && o.getNumberOfEntries() != 0) {
                throw new BadMappingException("Attribute mapping failed! Attribute of source or target object is null.");
            }
        }
    }

    protected void removeAttrMapping(AttrInstance o) {
        AttrMapping anAttrMapping;
        if (o != null && (anAttrMapping = this.itsAttrMappings.get(o)) != null && this.removeAttrMapping) {
            anAttrMapping.remove();
            this.itsAttrMappings.remove(o);
        }
    }

    public void removeVariableValue(AttrInstance o) {
        if (o == null) {
            return;
        }
        ValueTuple vt = (ValueTuple)o;
        int i = 0;
        while (i < vt.getNumberOfEntries()) {
            VarTuple vars;
            VarMember var;
            ValueMember vm = vt.getValueMemberAt(i);
            if (vm.isSet() && vm.getExpr().isVariable() && !(var = (vars = (VarTuple)this.itsAttrContext.getVariables()).getVarMemberAt(vm.getExprAsText())).isInputParameter()) {
                var.setExpr(null);
            }
            ++i;
        }
    }

    public void updateAttrMappings() {
        if (!this.itsImag.isAttributed()) {
            return;
        }
        int i = 0;
        while (i < this.itsDomObjects.size()) {
            GraphObject obj = this.itsDomObjects.get(i);
            GraphObject img = this.itsCodomObjects.get(i);
            this.removeAttrMapping(obj.getAttribute());
            this.addAttrMapping(obj.getAttribute(), img.getAttribute());
            ++i;
        }
    }

    public void resetCSPVariableDomainOf(GraphObject go) {
        if (this.itsOrig.isElement(go)) {
            this.itsCompleter.resetVariableDomain(go);
        }
    }

    public void removeAllMappings() {
        this.removeAttrMappings();
        this.itsDomObjects.clear();
        this.itsCodomObjects.clear();
        this.mappingChanged = false;
    }

    public boolean removeMapping(Node src, Node tar) {
        if (this.getSource().isElement(src) && this.getTarget().isElement(tar)) {
            int i = this.itsDomObjects.indexOf(src);
            int j = this.itsCodomObjects.indexOf(tar);
            if (i >= 0 && j >= 0) {
                if (i != j && this.itsDomObjects.get(j) == src) {
                    i = j;
                }
                if (i == j) {
                    for (GraphObject graphObject : src.getIncomingArcsSet()) {
                        if (this.getImage(graphObject) == null) continue;
                        this.removeMapping(graphObject);
                    }
                    for (GraphObject graphObject : src.getOutgoingArcsSet()) {
                        if (this.getImage(graphObject) == null) continue;
                        this.removeMapping(graphObject);
                    }
                    i = this.itsDomObjects.indexOf(src);
                    if (i != (j = this.itsCodomObjects.indexOf(tar)) && this.itsDomObjects.get(j) == src) {
                        i = j;
                    }
                    if (i == j) {
                        this.removeAttrMapping(src.getAttribute());
                        this.removeDomainMapping(i, true);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void removeDomainMapping(int i, boolean notificationRequired) {
        GraphObject dom = this.itsDomObjects.get(i);
        this.itsDomObjects.remove(i);
        GraphObject codom = this.itsCodomObjects.get(i);
        this.itsCodomObjects.remove(i);
        this.mappingChanged = true;
        if (notificationRequired) {
            if (this.isNotificationRequired()) {
                this.propagateChange(new Change(21, dom, this));
                this.propagateChange(new Change(21, codom, this));
            }
            if (this.itsOrig.isNotificationRequired()) {
                this.itsOrig.propagateChange(new Change(21, dom, this));
            }
            if (this.itsImag.isNotificationRequired()) {
                this.itsImag.propagateChange(new Change(21, codom, this));
            }
        }
    }

    public boolean removeMapping(Arc src, Arc tar) {
        if (this.getSource().isElement(src) && this.getTarget().isElement(tar)) {
            int i = this.itsDomObjects.indexOf(src);
            int j = this.itsCodomObjects.indexOf(tar);
            if (i >= 0 && j >= 0) {
                if (i != j && this.itsDomObjects.get(j) == src) {
                    i = j;
                }
                if (i == j) {
                    this.removeAttrMapping(src.getAttribute());
                    this.removeDomainMapping(i, true);
                    return true;
                }
            }
        }
        return false;
    }

    public void removeMapping(GraphObject o) {
        if (this.getSource().isElement(o)) {
            this.doRemoveMapping(o);
        } else if (this.getTarget().isElement(o)) {
            Enumeration<GraphObject> en = this.getInverseImage(o);
            while (en.hasMoreElements()) {
                this.doRemoveMapping(en.nextElement());
            }
        }
    }

    public void removeMappingFast(GraphObject obj, boolean left) {
        if (left) {
            this.doRemoveMapping(obj);
        } else {
            Enumeration<GraphObject> en = this.getInverseImage(obj);
            while (en.hasMoreElements()) {
                this.doRemoveMapping(en.nextElement());
            }
        }
    }

    private void doRemoveMapping(GraphObject o) {
        int i = this.itsDomObjects.indexOf(o);
        if (i >= 0) {
            if (o.isNode()) {
                for (GraphObject graphObject : ((Node)o).getIncomingArcsSet()) {
                    if (this.getImage(graphObject) == null) continue;
                    this.doRemoveMapping(graphObject);
                }
                for (GraphObject graphObject : ((Node)o).getOutgoingArcsSet()) {
                    if (this.getImage(graphObject) == null) continue;
                    this.doRemoveMapping(graphObject);
                }
                i = this.itsDomObjects.indexOf(o);
            }
            this.removeAttrMapping(o.getAttribute());
            this.removeDomainMapping(i, true);
        }
    }

    public void clear() {
        if (this.itsCoMorph != null) {
            this.itsCoMorph.dispose();
        }
        this.removeAllMappings();
        if (this.itsAttrContext.getVariables().getNumberOfEntries() != 0) {
            ((ContextView)this.itsAttrContext).resetVariableTuple();
            ((ContextView)this.itsAttrContext).resetConditionTuple();
        }
        this.mappingChanged = false;
        this.partialMorphCompletion = false;
        this.clearErrorMsg();
    }

    public void removeAttrMappings() {
        Enumeration<AttrInstance> keys = this.itsAttrMappings.keys();
        while (keys.hasMoreElements()) {
            AttrInstance key = keys.nextElement();
            key.getContext().removeAllMappings();
        }
        ((Hashtable)this.itsAttrMappings).clear();
        this.itsAttrContext.removeAllMappings();
    }

    public boolean isEmpty() {
        return this.itsDomObjects.isEmpty();
    }

    @Override
    public Graph getOriginal() {
        return this.itsOrig;
    }

    public Graph getSource() {
        return this.itsOrig;
    }

    @Override
    public Graph getImage() {
        return this.itsImag;
    }

    public Graph getTarget() {
        return this.itsImag;
    }

    public Vector<GraphObject> getDomainObjects() {
        return this.itsDomObjects;
    }

    @Override
    public Enumeration<GraphObject> getDomain() {
        return this.itsDomObjects.elements();
    }

    public int getDomainSize() {
        return this.itsDomObjects.size();
    }

    @Override
    public Enumeration<GraphObject> getCodomain() {
        return this.itsCodomObjects.elements();
    }

    public Vector<GraphObject> getCodomainObjects() {
        return this.itsCodomObjects;
    }

    public int getCodomainSize() {
        return this.itsCodomObjects.size();
    }

    @Override
    public GraphObject getImage(GraphObject o) {
        int i = this.itsDomObjects.indexOf(o);
        if (i > -1 && i < this.itsCodomObjects.size()) {
            return this.itsCodomObjects.elementAt(i);
        }
        return null;
    }

    public boolean hasInverseImage(GraphObject o) {
        return this.itsCodomObjects.indexOf(o) != -1;
    }

    @Override
    public Enumeration<GraphObject> getInverseImage(GraphObject o) {
        int index;
        Vector<GraphObject> invImages = new Vector<GraphObject>();
        int i = 0;
        while (i < this.itsCodomObjects.size() && (index = this.itsCodomObjects.indexOf(o, i)) != -1) {
            invImages.addElement(this.itsDomObjects.elementAt(index));
            i = index + 1;
        }
        return invImages.elements();
    }

    public List<GraphObject> getInverseImageList(GraphObject o) {
        int index;
        Vector<GraphObject> invImages = new Vector<GraphObject>();
        int i = 0;
        while (i < this.itsCodomObjects.size() && (index = this.itsCodomObjects.indexOf(o, i)) != -1) {
            invImages.add(this.itsDomObjects.get(index));
            i = index + 1;
        }
        return invImages;
    }

    public List<GraphObject> getElementsToCreate() {
        Vector<GraphObject> created = this.findCreatedElements();
        return created;
    }

    public List<GraphObject> getElementsToDelete() {
        Vector<GraphObject> deleted = this.findDeletedElements();
        return deleted;
    }

    public Hashtable<GraphObject, GraphObject> morphToMap() {
        Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>();
        Enumeration<GraphObject> dom = this.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            map.put(obj, this.getImage(obj));
        }
        return map;
    }

    public void setCompletionStrategy(MorphCompletionStrategy s, boolean rewrite) {
        if (rewrite) {
            if (this.itsCompleter == null || this.itsCompleter != s) {
                this.itsCompleter = s;
            }
        } else {
            this.setCompletionStrategy(s);
        }
    }

    public void setCompletionStrategy(MorphCompletionStrategy s) {
        if (this.itsCompleter == null || !this.itsCompleter.equals(s)) {
            this.itsCompleter = (MorphCompletionStrategy)s.clone();
        }
    }

    public final MorphCompletionStrategy getCompletionStrategy() {
        return this.itsCompleter;
    }

    public void unsetCompletionStrategy() {
        this.itsCompleter = null;
    }

    public boolean canMatch(Graph g, MorphCompletionStrategy strategy) {
        if (strategy.getProperties().get(0) && (this.itsOrig.getNodesCount() > g.getNodesCount() || this.itsOrig.getArcsCount() > g.getArcsCount())) {
            return false;
        }
        Vector<Type> origTypes = this.itsOrig.getUsedTypes();
        Vector<Type> otherTypes = g.getUsedAndInheritedTypes();
        int i = 0;
        while (i < origTypes.size()) {
            if (!otherTypes.contains(origTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canComplete() {
        if (this.itsCompleter.getProperties().get(0) && (this.itsOrig.getNodesCount() > this.itsImag.getNodesCount() || this.itsOrig.getArcsCount() > this.itsImag.getArcsCount())) {
            return false;
        }
        Vector<Type> origTypes = this.itsOrig.getUsedTypes();
        Vector<Type> imagTypes = this.itsImag.getUsedAndInheritedTypes();
        int i = 0;
        while (i < origTypes.size()) {
            if (!imagTypes.contains(origTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isMappingChanged() {
        return this.mappingChanged;
    }

    public boolean nextCompletion() {
        String attrMsg;
        boolean ok = false;
        this.errorMsg = "";
        ok = this.doNextCompletion();
        if (!ok && (attrMsg = ((ContextView)this.getAttrContext()).getManager().getErrorMsg()).length() > 0) {
            this.errorMsg = attrMsg;
        }
        return ok;
    }

    public boolean nextCompletion(Collection<Node> varnodes, Collection<Arc> varedges) {
        String attrMsg;
        boolean ok = false;
        this.errorMsg = "";
        ok = this.doNextCompletion(varnodes, varedges);
        if (!ok && (attrMsg = ((ContextView)this.getAttrContext()).getManager().getErrorMsg()).length() > 0) {
            this.errorMsg = attrMsg;
        }
        return ok;
    }

    public boolean nextCompletion(Enumeration<Node> varnodes, Enumeration<Arc> varedges) {
        return this.nextCompletion(Collections.list(varnodes), Collections.list(varedges));
    }

    public boolean nextCompletionWithConstantsChecking(Collection<Node> varnodes, Collection<Arc> varedges) {
        boolean found = false;
        while (!found && this.nextCompletion(varnodes, varedges)) {
            found = true;
            if (this.checkConstants()) continue;
            this.errorMsg = "Mismatch of constant attribute values.";
            found = false;
        }
        return found;
    }

    public boolean nextCompletionWithConstantsChecking(Enumeration<Node> varnodes, Enumeration<Arc> varedges) {
        return this.nextCompletionWithConstantsChecking(Collections.list(varnodes), Collections.list(varedges));
    }

    public boolean nextCompletionWithConstantsAndVariablesChecking(Collection<Node> varnodes, Collection<Arc> varedges) {
        boolean found = false;
        while (!found && this.nextCompletion(varnodes, varedges)) {
            found = true;
            if (this.checkAll()) continue;
            this.errorMsg = "Mismatch of constant attribute values or variables.";
            found = false;
        }
        return found;
    }

    private boolean doNextCompletion() {
        if (this.itsTouchedFlag) {
            this.itsCompleter.reset();
            this.itsTouchedFlag = false;
        }
        this.mappingChanged = false;
        this.itsInteractiveFlag = false;
        boolean b = this.itsCompleter.next(this);
        this.itsInteractiveFlag = true;
        return b;
    }

    private boolean doNextCompletion(Collection<Node> varnodes, Collection<Arc> varedges) {
        if (this.itsTouchedFlag) {
            this.itsCompleter.reset();
            this.itsTouchedFlag = false;
        }
        this.itsInteractiveFlag = false;
        boolean b = this.itsCompleter.next(this, varnodes, varedges);
        this.itsInteractiveFlag = true;
        return b;
    }

    public boolean nextCompletionWithConstantsChecking() {
        boolean found = false;
        while (!found && this.nextCompletion()) {
            found = true;
            if (this.checkConstants()) continue;
            this.errorMsg = "Mismatch of constant attribute values.";
            found = false;
        }
        return found;
    }

    public boolean nextCompletionWithConstantsAndVariablesChecking() {
        boolean found = false;
        while (!found && this.nextCompletion()) {
            found = true;
            if (this.checkAll()) continue;
            this.errorMsg = "Mismatch of constant attribute values or variables.";
            found = false;
        }
        return found;
    }

    @Override
    public final boolean isTotal() {
        return this.itsOrig.isEmpty() || this.itsOrig.getSize() == this.itsDomObjects.size();
    }

    public boolean isRightTotal() {
        boolean res = false;
        if (this.itsCodomObjects.size() == this.itsImag.getSize() && this.itsCodomObjects.containsAll(this.itsImag.getNodesCollection()) && this.itsCodomObjects.containsAll(this.itsImag.getArcsCollection())) {
            res = true;
        }
        return res;
    }

    public boolean doesIgnoreAttrs() {
        boolean res = true;
        int i = 0;
        while (i < this.itsDomObjects.size()) {
            GraphObject obj = this.itsDomObjects.get(i);
            if (obj.getAttribute() != null) {
                GraphObject img = this.getImage(obj);
                ValueTuple imgVal = (ValueTuple)img.getAttribute();
                int j = 0;
                while (j < imgVal.getNumberOfEntries()) {
                    ValueMember vmObj;
                    ValueMember vmImg = imgVal.getValueMemberAt(j);
                    if (vmImg.isSet() && !vmImg.isTransient() && (vmObj = ((ValueTuple)obj.getAttribute()).getValueMemberAt(vmImg.getName())) != null && vmObj.isSet() && vmObj.getExprAsText().equals(vmImg.getExprAsText())) {
                        res = false;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return res;
    }

    public AttrContext getAttrContext() {
        return this.itsAttrContext;
    }

    public void setAttrContext(AttrContext ac) {
        this.itsAttrContext = ac;
    }

    public Dictionary<AttrInstance, AttrMapping> getAttrMapping() {
        return this.itsAttrMappings;
    }

    public void reflectTransientOfSimilarVar(VarTuple vars) {
        VarTuple itsVars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember var = vars.getVarMemberAt(i);
            VarMember itsvar = itsVars.getVarMemberAt(var.getName());
            if (itsvar != null && !itsvar.isTransient() && var.isTransient()) {
                itsvar.setTransient(true);
            }
            ++i;
        }
    }

    public void adaptAttrContextValues(AttrContext ac) {
        VarTuple itsVars = (VarTuple)this.getAttrContext().getVariables();
        VarTuple vars = (VarTuple)ac.getVariables();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember var = vars.getVarMemberAt(i);
            VarMember itsVar = itsVars.getVarMemberAt(var.getName());
            if (itsVar != null && var.isSet()) {
                itsVar.setExpr(var.getExpr());
                VarMember tmp = vars.getVarMemberAt(var.getExprAsText());
                if (tmp != null && tmp.isTransient()) {
                    itsVar.setTransient(true);
                    var.setTransient(true);
                }
            }
            ++i;
        }
    }

    public void adaptAttrContextValuesFromExistingObjMapping() {
        int i = 0;
        while (i < this.itsDomObjects.size()) {
            GraphObject obj = this.itsDomObjects.get(i);
            if (obj.getAttribute() != null) {
                GraphObject img = this.getImage(obj);
                ValueTuple imgVal = (ValueTuple)img.getAttribute();
                int j = 0;
                while (j < imgVal.getNumberOfEntries()) {
                    ValueMember vmObj;
                    ValueMember vmImg = imgVal.getValueMemberAt(j);
                    if (vmImg.isSet() && (vmObj = ((ValueTuple)obj.getAttribute()).getValueMemberAt(vmImg.getName())) != null && vmObj.isSet() && vmObj.getExpr().isVariable()) {
                        VarMember var = ((VarTuple)this.getAttrContext().getVariables()).getVarMemberAt(vmObj.getExprAsText());
                        var.setExprAsText(vmImg.getExprAsText());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void addToAttrContextFromList(List<VarMember> vars, boolean setInputParameter) {
        VarTuple itsVars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.size()) {
            VarMember var = vars.get(i);
            DeclMember dm = (DeclMember)var.getDeclaration();
            if (!itsVars.isDeclared(dm.getTypeName(), dm.getName())) {
                itsVars.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
                itsVars.getVarMemberAt(dm.getName()).setTransient(var.isTransient());
                itsVars.getVarMemberAt(dm.getName()).setInputParameter(var.isInputParameter() || setInputParameter);
            }
            ++i;
        }
    }

    public void addToAttrContext(VarTuple vars) {
        VarTuple itsVars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember var = vars.getVarMemberAt(i);
            DeclMember dm = (DeclMember)var.getDeclaration();
            if (!itsVars.isDeclared(dm.getTypeName(), dm.getName())) {
                itsVars.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
                itsVars.getVarMemberAt(dm.getName()).setTransient(var.isTransient());
                itsVars.getVarMemberAt(dm.getName()).setInputParameter(var.isInputParameter());
            }
            ++i;
        }
    }

    public void addToAttrContextAccordingList(VarTuple vars, List<String> varNames) {
        if (varNames != null && !varNames.isEmpty()) {
            VarTuple itsVars = (VarTuple)this.getAttrContext().getVariables();
            int i = 0;
            while (i < vars.getSize()) {
                DeclMember dm;
                VarMember var = vars.getVarMemberAt(i);
                if (varNames.contains(var.getName()) && !itsVars.isDeclared((dm = (DeclMember)var.getDeclaration()).getTypeName(), dm.getName())) {
                    itsVars.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
                    itsVars.getVarMemberAt(dm.getName()).setTransient(var.isTransient());
                    itsVars.getVarMemberAt(dm.getName()).setInputParameter(var.isInputParameter());
                }
                ++i;
            }
        }
    }

    public void addToAttrContext(CondTuple conds) {
        CondTuple itsConds = (CondTuple)this.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getSize()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (!itsConds.contains(cond.getExprAsText())) {
                itsConds.addCondition(cond.getExprAsText());
            }
            ++i;
        }
    }

    public void addToAttrContext(AttrContext ac) {
        this.addToAttrContext((VarTuple)ac.getVariables());
        this.addToAttrContext((CondTuple)ac.getConditions());
    }

    public final AttrManager getAttrManager() {
        return this.itsAttrManager;
    }

    @Override
    public synchronized void setChanged() {
        if (this.itsInteractiveFlag) {
            this.itsTouchedFlag = true;
        }
        super.setChanged();
    }

    public void writeMorphism(XMLHelper h) {
        h.openSubTag("Morphism");
        h.addAttr("name", this.itsName);
        if (!this.comment.equals("")) {
            h.addAttr("comment", this.comment);
        }
        Enumeration<GraphObject> e = this.getDomain();
        while (e.hasMoreElements()) {
            GraphObject s = e.nextElement();
            h.openSubTag("Mapping");
            h.addObject("orig", s, false);
            h.addObject("image", this.getImage(s), false);
            h.close();
        }
        h.close();
    }

    public void readMorphism(XMLHelper h) {
        if (h.readSubTag("Morphism")) {
            String str = h.readAttr("name");
            this.setName(str.replaceAll(" ", ""));
            str = h.readAttr("comment");
            if (!str.equals("")) {
                this.comment = str.toString();
            }
            Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>();
            while (h.readSubTag("Mapping")) {
                GraphObject o = (GraphObject)h.getObject("orig", null, false);
                GraphObject i = (GraphObject)h.getObject("image", null, false);
                if (o != null && i != null) {
                    if (o instanceof Node) {
                        try {
                            this.addMapping(o, i);
                        }
                        catch (BadMappingException badMappingException) {}
                    } else {
                        map.put(o, i);
                    }
                }
                h.close();
            }
            h.close();
            Enumeration en = map.keys();
            while (en.hasMoreElements()) {
                GraphObject o = (GraphObject)en.nextElement();
                GraphObject i = (GraphObject)map.get(o);
                GraphObject s = ((Arc)o).getSource();
                GraphObject t = ((Arc)o).getTarget();
                if (o instanceof UndirectedArc) {
                    if ((((UndirectedArc)i).getSource() != this.getImage(s) || ((UndirectedArc)i).getTarget() != this.getImage(t)) && (((UndirectedArc)i).getTarget() != this.getImage(s) || ((UndirectedArc)i).getSource() != this.getImage(t))) continue;
                    try {
                        this.addMapping(o, i);
                    }
                    catch (BadMappingException badMappingException) {}
                    continue;
                }
                if (((Arc)i).getSource() != this.getImage(s) || ((Arc)i).getTarget() != this.getImage(t)) continue;
                try {
                    this.addMapping(o, i);
                }
                catch (BadMappingException badMappingException) {
                    // empty catch block
                }
            }
        }
    }

    public OrdinaryMorphism invert() {
        if (!this.isInjective()) {
            this.errorMsg = "Inverting of non-injective morphism is not possible.";
            return null;
        }
        OrdinaryMorphism inv = BaseFactory.theFactory().createMorphism(this.itsImag, this.itsOrig);
        Enumeration<GraphObject> domain = this.itsDomObjects.elements();
        while (domain.hasMoreElements()) {
            GraphObject go = domain.nextElement();
            try {
                inv.addMapping(this.getImage(go), go);
            }
            catch (BadMappingException e) {
                this.errorMsg = e.getMessage();
            }
        }
        return inv;
    }

    public OrdinaryMorphism simplecopy() {
        OrdinaryMorphism output = BaseFactory.theFactory().createMorphism(this.itsOrig, this.itsImag);
        Enumeration<GraphObject> mappedObjects = this.itsDomObjects.elements();
        while (mappedObjects.hasMoreElements()) {
            GraphObject go = mappedObjects.nextElement();
            try {
                output.addMapping(go, this.getImage(go));
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        return output;
    }

    public boolean isIsomorphicTo(OrdinaryMorphism h) {
        Enumeration<GraphObject> dom = this.getDomain();
        Vector<GraphObject> hDom = new Vector<GraphObject>();
        Enumeration<GraphObject> hd = h.getDomain();
        while (hd.hasMoreElements()) {
            hDom.addElement(hd.nextElement());
        }
        while (dom.hasMoreElements()) {
            GraphObject go = dom.nextElement();
            if (hDom.contains(go)) {
                if (!this.getImage(go).equals(h.getImage(go))) {
                    hDom.clear();
                    return false;
                }
                hDom.removeElement(go);
                continue;
            }
            hDom.clear();
            return false;
        }
        return hDom.size() == 0;
    }

    public boolean isIsomorphicTo(OrdinaryMorphism h, OrdinaryMorphism targetIso) {
        if (this.getSource() != h.getSource()) {
            System.out.println("OrdinaryMorphism.isIsomorphicTo:: FAILED:: this and h have different source graphs");
            return false;
        }
        if (h.getTarget() != targetIso.getTarget()) {
            System.out.println("OrdinaryMorphism.isIsomorphicTo:: FAILED:: targetIso and h have different target graphs");
            return false;
        }
        for (GraphObject graphObject : this.getSource().getNodesSet()) {
            GraphObject i2;
            GraphObject graphObject2 = targetIso.getImage(this.getImage(graphObject));
            if (graphObject2 == (i2 = h.getImage(graphObject))) continue;
            return false;
        }
        for (GraphObject graphObject : this.getSource().getArcsSet()) {
            GraphObject i2;
            GraphObject i1 = targetIso.getImage(this.getImage(graphObject));
            if (i1 == (i2 = h.getImage(graphObject))) continue;
            return false;
        }
        return true;
    }

    public boolean isPartial() {
        return !this.isTotal();
    }

    public boolean isPartialIsomorphicTo(OrdinaryMorphism h) {
        Enumeration<GraphObject> dom = this.getDomain();
        Vector<GraphObject> hDomain = h.getDomainObjects();
        while (dom.hasMoreElements()) {
            GraphObject go = dom.nextElement();
            if (!hDomain.contains(go)) continue;
            if (!this.getImage(go).equals(h.getImage(go))) {
                return false;
            }
            if (!go.isArc() || this.getImage(((Arc)go).getSource()).equals(h.getImage(((Arc)go).getSource())) && this.getImage(((Arc)go).getTarget()).equals(h.getImage(((Arc)go).getTarget()))) continue;
            return false;
        }
        return true;
    }

    public boolean isSurjective() {
        Enumeration<GraphObject> nonMapped = this.nonMappedImages();
        return !nonMapped.hasMoreElements();
    }

    public boolean isInjective() {
        int i = 0;
        while (i < this.itsCodomObjects.size()) {
            GraphObject go = this.itsCodomObjects.get(i);
            if (this.getInverseImageList(go).size() > 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isBijective() {
        return this.isInjective() && this.isSurjective();
    }

    public Enumeration<GraphObject> nonMappedOriginals() {
        Vector<GraphObject> nonMapped = new Vector<GraphObject>();
        for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
            if (this.itsDomObjects.contains(graphObject)) continue;
            nonMapped.addElement(graphObject);
        }
        for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
            if (this.itsDomObjects.contains(graphObject)) continue;
            nonMapped.addElement(graphObject);
        }
        return nonMapped.elements();
    }

    public Enumeration<GraphObject> nonMappedImages() {
        Vector<GraphObject> nonMapped = new Vector<GraphObject>();
        for (GraphObject graphObject : this.itsImag.getNodesSet()) {
            if (this.itsCodomObjects.contains(graphObject)) continue;
            nonMapped.addElement(graphObject);
        }
        for (GraphObject graphObject : this.itsImag.getArcsSet()) {
            if (this.itsCodomObjects.contains(graphObject)) continue;
            nonMapped.addElement(graphObject);
        }
        return nonMapped.elements();
    }

    public OrdinaryMorphism compose(OrdinaryMorphism input) {
        OrdinaryMorphism output = BaseFactory.theFactory().createMorphism(this.itsOrig, input.getImage(), true);
        Enumeration<GraphObject> thisDom = this.itsDomObjects.elements();
        while (thisDom.hasMoreElements()) {
            GraphObject thisGo = thisDom.nextElement();
            GraphObject thisGoImage = this.getImage(thisGo);
            GraphObject inputGoImage = input.getImage(thisGoImage);
            if (inputGoImage == null) continue;
            try {
                output.addMapping(thisGo, inputGoImage);
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        return output;
    }

    public boolean doCompose(OrdinaryMorphism morph1, OrdinaryMorphism morph2) {
        if (this.itsOrig == morph1.getSource() && this.itsImag == morph2.getTarget()) {
            Enumeration<GraphObject> dom = morph1.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject obj = dom.nextElement();
                GraphObject im = morph1.getImage(obj);
                GraphObject img = morph2.getImage(im);
                if (img == null) continue;
                try {
                    this.addMapping(obj, img);
                }
                catch (BadMappingException ex) {
                    System.out.println(ex.getClass() + "   " + ex.getMessage());
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean doComposeInherit(OrdinaryMorphism morph1, OrdinaryMorphism morph2) {
        if (this.itsOrig == morph1.getSource() && this.itsImag == morph2.getTarget()) {
            Enumeration<GraphObject> dom = morph1.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject obj = dom.nextElement();
                GraphObject img1 = morph1.getImage(obj);
                GraphObject img2 = morph2.getImage(img1);
                if (img2 == null) continue;
                try {
                    if (obj.getType().isParentOf(img2.getType())) {
                        this.addMapping(obj, img2);
                        continue;
                    }
                    if (!obj.getType().isChildOf(img2.getType())) continue;
                    this.addChild2ParentMapping(obj, img2);
                }
                catch (BadMappingException ex) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public OrdinaryMorphism completeDiagram(OrdinaryMorphism input) {
        if (!input.isInjective()) {
            this.errorMsg = "Completting with non-injective morphism is not possible";
            return null;
        }
        OrdinaryMorphism compl = BaseFactory.theFactory().createMorphism(input.getImage(), this.itsImag);
        Enumeration<GraphObject> inpDom = input.getDomain();
        while (inpDom.hasMoreElements()) {
            GraphObject inpGo = inpDom.nextElement();
            GraphObject inpImg = input.getImage(inpGo);
            GraphObject thisImgGo = this.getImage(inpGo);
            try {
                compl.addMapping(inpImg, thisImgGo);
            }
            catch (BadMappingException ex) {
                BaseFactory.theFactory().destroyMorphism(compl);
                return null;
            }
        }
        return compl;
    }

    public boolean completeDiagram(Hashtable<GraphObject, GraphObject> f, OrdinaryMorphism d) {
        if (f != null && d != null) {
            Enumeration<GraphObject> dDom = d.getDomain();
            while (dDom.hasMoreElements()) {
                GraphObject go3 = dDom.nextElement();
                GraphObject img3 = d.getImage(go3);
                GraphObject img1 = f.get(go3);
                if (img1 == null || img3 == null) continue;
                try {
                    this.addMapping(img1, img3);
                }
                catch (BadMappingException ex) {
                    this.clear();
                    this.errorMsg = "Complete of diagram: d = g o f is not possible (object mapping failed)";
                    return false;
                }
            }
            return true;
        }
        this.errorMsg = "Complete of diagram: d = g o f is not possible (d resp. f is null)";
        return false;
    }

    public boolean completeDiagram1(OrdinaryMorphism second, OrdinaryMorphism third) {
        if (second != null && third != null) {
            Enumeration<GraphObject> dom = second.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go2 = dom.nextElement();
                GraphObject img2 = second.getImage(go2);
                Enumeration<GraphObject> en = third.getInverseImage(img2);
                if (!en.hasMoreElements()) continue;
                GraphObject go1 = en.nextElement();
                try {
                    this.addMapping(go1, go2);
                }
                catch (BadMappingException ex) {
                    this.clear();
                    this.errorMsg = "Complete of diagram1 is not possible (object mapping failed)";
                    return false;
                }
            }
            return true;
        }
        this.errorMsg = "Complete of diagram1 is not possible (second or third is null)";
        return false;
    }

    public boolean completeDiagram2(OrdinaryMorphism first, OrdinaryMorphism third) {
        if (first != null && third != null) {
            if (!first.isInjective()) {
                this.errorMsg = "Complete of diagram2 is not possible (first is non-injective)";
                return false;
            }
            Enumeration<GraphObject> dom = first.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go1 = dom.nextElement();
                GraphObject img1 = first.getImage(go1);
                GraphObject img3 = third.getImage(go1);
                if (img3 == null) continue;
                try {
                    this.addMapping(img1, img3);
                }
                catch (BadMappingException ex) {
                    this.clear();
                    this.errorMsg = "Complete of diagram2 is not possible (object mapping failed)";
                    return false;
                }
            }
            return true;
        }
        this.errorMsg = "Complete of diagram2 is not possible (first resp. third is null)";
        return false;
    }

    public boolean completeDiagram3(OrdinaryMorphism first, OrdinaryMorphism second) {
        if (first != null && second != null) {
            if (!first.isInjective()) {
                this.errorMsg = "Complete of diagram3 is not possible (first is non-injective)";
                return false;
            }
            Enumeration<GraphObject> dom = first.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go1 = dom.nextElement();
                GraphObject img2 = second.getImage(first.getImage(go1));
                if (img2 == null) continue;
                try {
                    this.addMapping(go1, img2);
                }
                catch (BadMappingException ex) {
                    this.clear();
                    this.errorMsg = "Complete of diagram3 is not possible (object mapping failed)";
                    return false;
                }
            }
            return true;
        }
        this.errorMsg = "Complete of diagram3 is not possible (first resp. second is null)";
        return false;
    }

    public boolean completeDiagram(OrdinaryMorphism f, OrdinaryMorphism g) {
        if (f != null && g != null) {
            if (!f.isInjective()) {
                this.errorMsg = "Complete of diagram: d = g o f is not possible (f is non-injective)";
                return false;
            }
            AttrContext context = AttrTupleManager.getDefaultManager().newContext(0);
            g.setAttrContext(context);
            Enumeration<GraphObject> fDom = f.getDomain();
            while (fDom.hasMoreElements()) {
                GraphObject fGO = fDom.nextElement();
                GraphObject img1 = f.getImage(fGO);
                GraphObject img2 = this.getImage(fGO);
                if (img1 == null || img2 == null) continue;
                try {
                    g.addMapping(img1, img2);
                }
                catch (BadMappingException ex) {
                    g.clear();
                    this.errorMsg = "Complete of diagram: d = g o f is not possible (object mapping failed)";
                    return false;
                }
            }
            return true;
        }
        this.errorMsg = "Complete of diagram: d = g o f is not possible (g resp. f is null)";
        return false;
    }

    public boolean completeDiagram(OrdinaryMorphism v1, OrdinaryMorphism h1, OrdinaryMorphism v2) {
        boolean ok = true;
        Enumeration<GraphObject> dom = h1.getDomain();
        while (dom.hasMoreElements() && ok) {
            GraphObject obj = dom.nextElement();
            GraphObject obj1 = v1.getImage(obj);
            GraphObject obj2 = v2.getImage(h1.getImage(obj));
            if (obj1 == null || obj2 == null) continue;
            try {
                this.addMapping(obj1, obj2);
            }
            catch (BadMappingException ex) {
                ok = false;
            }
        }
        return ok;
    }

    public Enumeration<GraphObject> intersectCoDomains(OrdinaryMorphism input) {
        Vector<GraphObject> intersection = new Vector<GraphObject>();
        Enumeration<GraphObject> inpCodom = input.getCodomain();
        while (inpCodom.hasMoreElements()) {
            GraphObject g = inpCodom.nextElement();
            if (!this.itsCodomObjects.contains(g)) continue;
            intersection.addElement(g);
        }
        return intersection.elements();
    }

    public boolean checkConstants() {
        if (this.itsDomObjects.isEmpty()) {
            return true;
        }
        int j = 0;
        while (j < this.itsDomObjects.size()) {
            GraphObject orig = this.itsDomObjects.get(j);
            if (orig.getAttribute() != null) {
                GraphObject image = this.getImage(orig);
                ValueTuple valOrig = (ValueTuple)orig.getAttribute();
                ValueTuple valImage = (ValueTuple)image.getAttribute();
                int n = valOrig.getNumberOfEntries();
                int i = 0;
                while (i < n) {
                    ValueMember valMemberImage;
                    HandlerExpr exprImage;
                    HandlerExpr exprOrig;
                    String name = valOrig.getNameAsString(i);
                    ValueMember valMemberOrig = null;
                    if (valOrig.isValueSetAt(name) && (exprOrig = (valMemberOrig = valOrig.getValueMemberAt(name)).getExpr()) != null && exprOrig.isConstant() && valImage.isValueSetAt(name) && (exprImage = (valMemberImage = valImage.getValueMemberAt(name)).getExpr()) != null && exprImage.isConstant() && !valMemberOrig.toString().equals(valMemberImage.toString())) {
                        return false;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return true;
    }

    public boolean checkVariables() {
        if (this.itsDomObjects.isEmpty()) {
            return true;
        }
        int j = 0;
        while (j < this.itsDomObjects.size()) {
            GraphObject orig = this.itsDomObjects.get(j);
            if (orig.getAttribute() != null) {
                GraphObject image = this.getImage(orig);
                ValueTuple valOrig = (ValueTuple)orig.getAttribute();
                ValueTuple valImage = (ValueTuple)image.getAttribute();
                int n = valOrig.getNumberOfEntries();
                int i = 0;
                while (i < n) {
                    ValueMember valMemberImage;
                    HandlerExpr exprImage;
                    HandlerExpr exprOrig;
                    String name = valOrig.getNameAsString(i);
                    ValueMember valMemberOrig = null;
                    if (valOrig.isValueSetAt(name) && (exprOrig = (valMemberOrig = valOrig.getValueMemberAt(name)).getExpr()) != null && exprOrig.isVariable() && valImage.isValueSetAt(name) && (exprImage = (valMemberImage = valImage.getValueMemberAt(name)).getExpr()) != null && exprImage.isVariable() && !valMemberOrig.toString().equals(valMemberImage.toString())) {
                        return false;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return true;
    }

    protected boolean checkAll() {
        if (this.itsDomObjects.isEmpty()) {
            return true;
        }
        int j = 0;
        while (j < this.itsDomObjects.size()) {
            GraphObject orig = this.itsDomObjects.get(j);
            if (orig.getAttribute() != null) {
                GraphObject image = this.getImage(orig);
                ValueTuple valOrig = (ValueTuple)orig.getAttribute();
                ValueTuple valImage = (ValueTuple)image.getAttribute();
                int n = valOrig.getNumberOfEntries();
                int i = 0;
                while (i < n) {
                    ValueMember valMemberImage;
                    String name = valOrig.getNameAsString(i);
                    ValueMember valMemberOrig = null;
                    if (valOrig.isValueSetAt(name) && (valMemberOrig = valOrig.getValueMemberAt(name)).isSet() && valImage.isValueSetAt(name) && (valMemberImage = valImage.getValueMemberAt(name)) != null && valMemberImage.isSet() && !valMemberOrig.getExprAsText().equals(valMemberImage.getExprAsText())) {
                        return false;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return true;
    }

    public void putVarToAttrContext() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        this.putVarToAttrContext(this.itsOrig.getNodesSet().iterator(), vars);
        this.putVarToAttrContext(this.itsOrig.getArcsSet().iterator(), vars);
        this.putVarToAttrContext(this.itsImag.getNodesSet().iterator(), vars);
        this.putVarToAttrContext(this.itsImag.getArcsSet().iterator(), vars);
    }

    private void putVarToAttrContext(Iterator<?> elems, VarTuple vars) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)o.getAttribute();
            int n = val.getNumberOfEntries();
            int i = 0;
            while (i < n) {
                String varName;
                String name = val.getNameAsString(i);
                ValueMember valMem = val.getValueMemberAt(name);
                if (valMem != null && valMem.isSet() && valMem.getExpr().isVariable() && vars.getVarMemberAt(varName = valMem.getExprAsText()) == null) {
                    String varType = valMem.getDeclaration().getTypeName();
                    vars.declare(valMem.getDeclaration().getHandler(), varType, varName);
                }
                ++i;
            }
        }
    }

    public void fillUpOriginalAttrs() {
        Enumeration<GraphObject> elems = this.itsDomObjects.elements();
        while (elems.hasMoreElements()) {
            GraphObject orig = elems.nextElement();
            GraphObject image = this.getImage(orig);
            if (orig.getAttribute() == null) continue;
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valOrig.getNumberOfEntries();
            int i = 0;
            while (i < n) {
                ValueMember valMemberImage;
                HandlerExpr exprImage;
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                HandlerExpr exprOrig = null;
                if (valOrig.isValueSetAt(name)) {
                    valMemberOrig = valOrig.getValueMemberAt(name);
                    exprOrig = valMemberOrig.getExpr();
                }
                if ((exprOrig == null || !exprOrig.isConstant()) && valImage.isValueSetAt(name) && (exprImage = (valMemberImage = valImage.getValueMemberAt(name)).getExpr()) != null && exprImage.isConstant()) {
                    valOrig.setExprValueAt(valMemberImage.getExprAsText(), name);
                    valOrig.getValueMemberAt(name).setTransient(true);
                    valOrig.getValueMemberAt(name).checkValidity();
                }
                ++i;
            }
        }
    }

    public void fillUpImageAttrs() {
        Enumeration<GraphObject> elems = this.itsDomObjects.elements();
        while (elems.hasMoreElements()) {
            GraphObject orig = elems.nextElement();
            GraphObject image = this.getImage(orig);
            if (orig.getAttribute() == null) continue;
            ValueTuple valOrig = (ValueTuple)orig.getAttribute();
            ValueTuple valImage = (ValueTuple)image.getAttribute();
            int n = valImage.getNumberOfEntries();
            int i = 0;
            while (i < n) {
                ValueMember valMemberOrig;
                HandlerExpr exprOrig;
                String name = valImage.getNameAsString(i);
                ValueMember valMemberImage = null;
                HandlerExpr exprImage = null;
                if (valImage.isValueSetAt(name)) {
                    valMemberImage = valImage.getValueMemberAt(name);
                    exprImage = valMemberImage.getExpr();
                }
                if ((exprImage == null || !exprImage.isConstant()) && valOrig.isValueSetAt(name) && (exprOrig = (valMemberOrig = valOrig.getValueMemberAt(name)).getExpr()) != null && exprOrig.isConstant()) {
                    valImage.setExprValueAt(valMemberOrig.getExprAsText(), name);
                    valImage.getValueMemberAt(name).setTransient(true);
                    valImage.getValueMemberAt(name).checkValidity();
                }
                ++i;
            }
        }
    }

    private Vector<GraphObject> findCreatedElements() {
        Vector<GraphObject> vec = new Vector<GraphObject>();
        for (GraphObject graphObject : this.itsImag.getNodesSet()) {
            if (this.getInverseImage(graphObject).hasMoreElements()) continue;
            vec.addElement(graphObject);
        }
        for (GraphObject graphObject : this.itsImag.getArcsSet()) {
            if (this.getInverseImage(graphObject).hasMoreElements()) continue;
            vec.addElement(graphObject);
        }
        return vec;
    }

    private Vector<GraphObject> findDeletedElements() {
        Vector<GraphObject> vec = new Vector<GraphObject>();
        for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
            if (this.getImage(graphObject) != null) continue;
            vec.addElement(graphObject);
        }
        for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
            if (this.getImage(graphObject) != null) continue;
            vec.addElement(graphObject);
        }
        return vec;
    }

    public void unsetOriginalAttrsIfExpression() {
        for (GraphObject graphObject : this.itsOrig.getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            ValueTuple valueTuple = (ValueTuple)graphObject.getAttribute();
            int n = valueTuple.getNumberOfEntries();
            int i = 0;
            while (i < n) {
                String name = valueTuple.getNameAsString(i);
                ValueMember valMemberOrig = null;
                HandlerExpr exprOrig = null;
                if (valueTuple.isValueSetAt(name) && (valMemberOrig = valueTuple.getValueMemberAt(name)) != null && (exprOrig = valMemberOrig.getExpr()) != null && exprOrig.isComplex()) {
                    valMemberOrig.setExpr(null);
                }
                ++i;
            }
        }
        for (GraphObject graphObject : this.itsOrig.getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            ValueTuple valOrig = (ValueTuple)graphObject.getAttribute();
            int n = valOrig.getNumberOfEntries();
            int i = 0;
            while (i < n) {
                String name = valOrig.getNameAsString(i);
                ValueMember valMemberOrig = null;
                HandlerExpr exprOrig = null;
                if (valOrig.isValueSetAt(name) && (valMemberOrig = valOrig.getValueMemberAt(name)) != null && (exprOrig = valMemberOrig.getExpr()) != null && exprOrig.isComplex()) {
                    valMemberOrig.setExpr(null);
                }
                ++i;
            }
        }
    }

    public void fillUpAttrContext(AttrContext other) {
        if (other == null || this.getAttrContext() == null) {
            return;
        }
        VarTuple avt = (VarTuple)this.getAttrContext().getVariables();
        VarTuple avtOther = (VarTuple)other.getVariables();
        int nn = avtOther.getNumberOfEntries();
        int i = 0;
        while (i < nn) {
            VarMember avmOther = avtOther.getVarMemberAt(i);
            String name = avtOther.getNameAsString(i);
            VarMember avm = avt.getVarMemberAt(name);
            if (avm != null && avmOther.isSet() && avmOther.getExpr().isConstant()) {
                avm.setExprAsText(avmOther.getExprAsText());
            }
            ++i;
        }
    }

    public void copyAttrContext(AttrContext other) {
        if (other == null || this.getAttrContext() == null) {
            return;
        }
        VarTuple avt = (VarTuple)this.itsAttrContext.getVariables();
        VarTuple avtOther = (VarTuple)other.getVariables();
        int nn = avtOther.getNumberOfEntries();
        int i = 0;
        while (i < nn) {
            VarMember avmOther = avtOther.getVarMemberAt(i);
            String name = avtOther.getNameAsString(i);
            VarMember avm = avt.getVarMemberAt(name);
            if (avm != null) {
                if (avmOther.isSet() && avmOther.getExpr().isConstant()) {
                    avm.setExprAsText(avmOther.getExprAsText());
                }
                if (avmOther.isInputParameter()) {
                    avm.setInputParameter(true);
                }
            } else {
                DeclMember dm = (DeclMember)avmOther.getDeclaration();
                avt.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
                VarMember newMember = avt.getVarMemberAt(dm.getName());
                if (newMember != null && avmOther.getExpr() != null && avmOther.getExpr().isConstant()) {
                    ((ValueMember)newMember).setExprAsText(avmOther.getExprAsText());
                }
                avt.getVarMemberAt(dm.getName()).setInputParameter(avmOther.isInputParameter());
                avt.getVarMemberAt(dm.getName()).setTransient(avmOther.isTransient());
            }
            ++i;
        }
    }

    /*
     * Could not resolve type clashes
     */
    public Hashtable<VarMember, Vector<Pair<ValueMember, Type>>> getUsageOfInputParameters(AttrContext attrContext) {
        Hashtable<VarMember, Vector<Pair<ValueMember, Type>>> ht = new Hashtable<VarMember, Vector<Pair<ValueMember, Type>>>();
        if (attrContext == null || attrContext.getVariables() == null) {
            return ht;
        }
        Vector<Type> tmp = new Vector<Type>();
        VarTuple avt = (VarTuple)attrContext.getVariables();
        int i = 0;
        while (i < avt.getSize()) {
            VarMember avm = avt.getVarMemberAt(i);
            if (avm.getExpr() == null) {
                return ht;
            }
            Vector<Pair<ValueMember, Type>> v = new Vector<Pair<ValueMember, Type>>();
            if (avm.isInputParameter()) {
                for (GraphObject go : this.getSource().getNodesSet()) {
                    if (go.getAttribute() == null) continue;
                    ValueTuple vt = (ValueTuple)go.getAttribute();
                    int j = 0;
                    while (j < vt.getSize()) {
                        ValueMember vm = vt.getValueMemberAt(j);
                        if (vm.getExpr() != null && vm.getExpr().isVariable() && vm.getExprAsText().equals(avm.getDeclaration().getName())) {
                            v.addElement(new Pair<ValueMember, Type>(vm, go.getType()));
                            tmp.addElement(go.getType());
                        }
                        ++j;
                    }
                }
                for (GraphObject go : this.getSource().getArcsSet()) {
                    if (go.getAttribute() == null) continue;
                    ValueTuple vt = (ValueTuple)go.getAttribute();
                    int j = 0;
                    while (j < vt.getSize()) {
                        ValueMember vm = vt.getValueMemberAt(j);
                        if (vm.getExpr() != null && vm.getExpr().isVariable() && vm.getExprAsText().equals(avm.getDeclaration().getName())) {
                            v.addElement(new Pair<ValueMember, Type>(vm, go.getType()));
                            tmp.addElement(go.getType());
                        }
                        ++j;
                    }
                }
                for (GraphObject go : this.getTarget().getNodesSet()) {
                    if (go.getAttribute() == null) continue;
                    ValueTuple vt = (ValueTuple)go.getAttribute();
                    int j = 0;
                    while (j < vt.getSize()) {
                        ValueMember vm = vt.getValueMemberAt(j);
                        if (vm.getExpr() != null && vm.getExpr().isVariable() && vm.getExprAsText().equals(avm.getDeclaration().getName()) && (tmp.isEmpty() || !tmp.contains(go.getType()))) {
                            v.addElement(new Pair<ValueMember, Type>(vm, go.getType()));
                            tmp.addElement(go.getType());
                        }
                        ++j;
                    }
                }
                for (GraphObject go : this.getTarget().getArcsSet()) {
                    if (go.getAttribute() == null) continue;
                    ValueTuple vt = (ValueTuple)go.getAttribute();
                    int j = 0;
                    while (j < vt.getSize()) {
                        ValueMember vm = vt.getValueMemberAt(j);
                        if (vm.getExpr() != null && vm.getExpr().isVariable() && vm.getExprAsText().equals(avm.getDeclaration().getName()) && (tmp.isEmpty() || !tmp.contains(go.getType()))) {
                            v.addElement(new Pair<ValueMember, Type>(vm, go.getType()));
                            tmp.addElement(go.getType());
                        }
                        ++j;
                    }
                }
                if (v.size() != 0) {
                    ht.put(avm, v);
                }
            }
            ++i;
        }
        return ht;
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Object other, boolean left, boolean union) {
        return MatchHelper.getOverlappingsVector(this, other, left, union).elements();
    }

    public Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappingsVector(Object other, boolean left, boolean union) {
        return MatchHelper.getOverlappingsVector(this, other, left, union);
    }

    public Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappings(Object other, boolean left, int sizeOfInclusions, boolean union) {
        return MatchHelper.getOverlappingsVector(this, other, left, sizeOfInclusions, union).elements();
    }

    public Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> getOverlappingsVector(Object otherObj, boolean left, int sizeOfInclusions, boolean union) {
        return MatchHelper.getOverlappingsVector(this, otherObj, left, sizeOfInclusions, union);
    }

    public void setCoMorphism(OrdinaryMorphism aCoMorph) {
        this.itsCoMorph = aCoMorph;
    }

    public OrdinaryMorphism getCoMorphism() {
        return this.itsCoMorph;
    }

    protected void deleteTransientContextVariables(Graph g) {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        this.delTransientContextVar(g.getNodesSet().iterator(), vars);
        this.delTransientContextVar(g.getArcsSet().iterator(), vars);
    }

    private void delTransientContextVar(Iterator<?> elems, VarTuple vars) {
        while (elems.hasNext()) {
            GraphObject obj = (GraphObject)elems.next();
            if (obj.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < value.getNumberOfEntries()) {
                ValueMember valuem = value.getValueMemberAt(i);
                if (valuem.isTransient()) {
                    if (!vars.isEmpty()) {
                        vars.getTupleType().deleteMemberAt(valuem.getExprAsText());
                    }
                    valuem.setExpr(null);
                }
                ++i;
            }
        }
    }

    public int getSize() {
        return this.itsDomObjects.size();
    }

    public boolean compareTo(OrdinaryMorphism morph) {
        String errMsgHolder = null;
        if (!this.getSource().compareTo(morph.getSource())) {
            errMsgHolder = String.valueOf(errMsgHolder) + "LHS is different";
            return false;
        }
        if (!this.getTarget().compareTo(morph.getTarget())) {
            errMsgHolder = String.valueOf(errMsgHolder) + "RHS is different";
            return false;
        }
        Enumeration<GraphObject> e = morph.getDomain();
        Vector<GraphObject> another = new Vector<GraphObject>();
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.itsDomObjects.size() != another.size()) {
            return false;
        }
        int i = 0;
        while (i < this.itsDomObjects.size()) {
            GraphObject obj = this.itsDomObjects.elementAt(i);
            GraphObject img = this.getImage(obj);
            int j = another.size() - 1;
            while (j >= 0) {
                GraphObject obj1 = (GraphObject)another.elementAt(j);
                if (obj.compareTo(obj1)) {
                    GraphObject img1 = morph.getImage(obj1);
                    if (img == null && img1 == null) {
                        another.remove(obj1);
                        break;
                    }
                    if (!(img != null && img1 == null || img == null && img1 != null || img == null || !img.compareTo(img1))) {
                        another.remove(obj1);
                        break;
                    }
                }
                --j;
            }
            ++i;
        }
        if (another.size() != 0) {
            errMsgHolder = String.valueOf(errMsgHolder) + "Morphism mapping is different";
            return false;
        }
        return true;
    }

    public Vector<Pair<String, String>> getVariableDeclarations() {
        Vector<Pair<String, String>> varDecls = new Vector<Pair<String, String>>(2);
        this.putVarDecl(this.itsOrig.getNodesSet().iterator(), varDecls);
        this.putVarDecl(this.itsOrig.getArcsSet().iterator(), varDecls);
        this.putVarDecl(this.itsImag.getNodesSet().iterator(), varDecls);
        this.putVarDecl(this.itsImag.getArcsSet().iterator(), varDecls);
        this.putVarOfExpr(this.itsImag.getNodesSet().iterator(), varDecls);
        this.putVarOfExpr(this.itsImag.getArcsSet().iterator(), varDecls);
        return varDecls;
    }

    private void putVarDecl(Iterator<?> elems, Vector<Pair<String, String>> varDecls) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null) continue;
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    String n = vm.getExprAsText();
                    String t = vm.getDeclaration().getTypeName();
                    Pair<String, String> p = new Pair<String, String>(t, n);
                    boolean found = false;
                    int j = 0;
                    while (j < varDecls.size()) {
                        Pair<String, String> pj = varDecls.elementAt(j);
                        if (t.equals(pj.first) && n.equals(pj.second)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        varDecls.addElement(p);
                    }
                }
                ++k;
            }
        }
    }

    private void putVarOfExpr(Iterator<?> elems, Vector<Pair<String, String>> varDecls) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null) continue;
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            int k = 0;
            while (k < vt.getSize()) {
                Vector<String> vec;
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isComplex() && (vec = vm.getAllVariableNamesOfExpression()).size() != 0) {
                    int l = 0;
                    while (l < vec.size()) {
                        Pair<String, String> p = null;
                        String n = vec.elementAt(l);
                        String t = "";
                        VarMember var = this.getAttrContext().getVariables().getVarMemberAt(n);
                        if (var != null && var.getDeclaration() != null) {
                            t = var.getDeclaration().getTypeName();
                            p = new Pair<String, String>(t, n);
                        } else {
                            String className = this.isClassName(n);
                            if (className != null) {
                                t = className;
                                p = new Pair<String, String>(t, n);
                            } else {
                                p = new Pair<String, String>(t, n);
                            }
                        }
                        boolean found = false;
                        int j = 0;
                        while (j < varDecls.size()) {
                            Pair<String, String> pj = varDecls.elementAt(j);
                            if (t.equals(pj.first) && n.equals(pj.second)) {
                                found = true;
                            }
                            ++j;
                        }
                        if (!found) {
                            varDecls.addElement(p);
                        }
                        ++l;
                    }
                }
                ++k;
            }
        }
    }

    public String isClassName(String name) {
        return AttrTupleManager.getDefaultManager().isClassName(name);
    }

    public Vector<Type> getUsedTypes() {
        Vector<Type> vec = new Vector<Type>();
        this.addUsedType(this.itsOrig.getNodesSet().iterator(), vec);
        this.addUsedType(this.itsOrig.getArcsSet().iterator(), vec);
        this.addUsedType(this.itsImag.getNodesSet().iterator(), vec);
        this.addUsedType(this.itsImag.getArcsSet().iterator(), vec);
        return vec;
    }

    private void addUsedType(Iterator<?> elems, Vector<Type> vec) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (vec.contains(o.getType())) continue;
            vec.add(o.getType());
        }
    }

    protected final void propagateChange(Change ch) {
        this.setChanged();
        this.notifyObservers(ch);
    }

    public void disableUnusedAttrCondition() {
        VarTuple avt = (VarTuple)this.getAttrContext().getVariables();
        CondTuple act = (CondTuple)this.getAttrContext().getConditions();
        int k = 0;
        while (k < act.getSize()) {
            CondMember cm = act.getCondMemberAt(k);
            Vector<String> vars = cm.getAllVariables();
            if (!vars.isEmpty()) {
                int i = 0;
                while (i < vars.size()) {
                    VarMember var = avt.getVarMemberAt(vars.get(i));
                    if (var == null) {
                        cm.setEnabled(false);
                        break;
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    public void enableUnusedAttrCondition() {
        VarTuple avt = (VarTuple)this.getAttrContext().getVariables();
        CondTuple act = (CondTuple)this.getAttrContext().getConditions();
        int k = 0;
        while (k < act.getSize()) {
            CondMember cm = act.getCondMemberAt(k);
            Vector<String> vars = cm.getAllVariables();
            if (!vars.isEmpty()) {
                int i = 0;
                while (i < vars.size()) {
                    VarMember var = avt.getVarMemberAt(vars.get(i));
                    if (var == null) {
                        cm.setEnabled(true);
                        break;
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    public void removeUnusedVariableOfAttrContext() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember vm = vars.getVarMemberAt(i);
            String var = vm.getName();
            if (!this.getSource().getVariableNamesOfAttributes().contains(var) && !this.getTarget().getVariableNamesOfAttributes().contains(var)) {
                vars.getTupleType().deleteMemberAt(var);
            }
            ++i;
        }
    }

    protected boolean tryToApplyAttrExpr(Hashtable<String, String> valMembeHashcode2Expr) {
        return this.tryComputeAttrExpr(this.getSource().getNodesSet().iterator(), valMembeHashcode2Expr) && this.tryComputeAttrExpr(this.getSource().getArcsSet().iterator(), valMembeHashcode2Expr);
    }

    private boolean tryComputeAttrExpr(Iterator<?> elems, Hashtable<String, String> valMemberHashcode2Expr) {
        while (elems.hasNext()) {
            GraphObject go = (GraphObject)elems.next();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < val.getNumberOfEntries()) {
                ValueMember mem = val.getValueMemberAt(i);
                if (mem.isSet() && mem.getExpr().isComplex()) {
                    boolean applied = false;
                    String expr = mem.getExprAsText();
                    valMemberHashcode2Expr.put(String.valueOf(mem.hashCode()), expr);
                    try {
                        mem.getExpr().evaluate(this.getAttrContext());
                        applied = true;
                    }
                    catch (AttrHandlerException attrHandlerException) {
                        // empty catch block
                    }
                    if (!applied) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    protected void resetAttrValueAsExpr(Hashtable<String, String> valMembeHashcoder2Expr) {
        this.resetAttrValueAsExpr(this.getSource().getNodesSet().iterator(), valMembeHashcoder2Expr);
        this.resetAttrValueAsExpr(this.getSource().getArcsSet().iterator(), valMembeHashcoder2Expr);
    }

    private void resetAttrValueAsExpr(Iterator<?> elems, Hashtable<String, String> valMembeHashcoder2Expr) {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        CondTuple conds = (CondTuple)this.getAttrContext().getConditions();
        while (elems.hasNext()) {
            GraphObject go = (GraphObject)elems.next();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < val.getNumberOfEntries()) {
                ValueMember mem = val.getValueMemberAt(i);
                String expr = valMembeHashcoder2Expr.get(String.valueOf(mem.hashCode()));
                if (expr != null) {
                    mem.setExprAsText(expr);
                    int j = 0;
                    while (j < conds.getSize()) {
                        CondMember cond = (CondMember)conds.getMemberAt(j);
                        if (cond.getExprAsText().endsWith("=".concat(expr)) && cond.isTransient() && (cond.getMark() == 20 || cond.getMark() == 30)) {
                            String nameStr = cond.getName();
                            conds.getTupleType().deleteMemberAt(j);
                            vars.getTupleType().deleteMemberAt(nameStr);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void trimToSize() {
        this.itsOrig.trimToSize();
        this.itsImag.trimToSize();
        this.itsDomObjects.trimToSize();
        this.itsDomObjects.trimToSize();
    }
}

