/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrVariableTuple;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.cons.Convert;
import agg.cons.EvalSet;
import agg.cons.Evaluable;
import agg.cons.Formula;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.InverseRuleConstructData;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.NestedApplCond;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.ShiftedPAC;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.agt.RuleScheme;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Rule
extends OrdinaryMorphism
implements XMLObject {
    protected Formula itsFormula = new Formula(true);
    protected String formStr = "true";
    protected String formReadStr = "true";
    protected final Vector<OrdinaryMorphism> itsACs = new Vector();
    protected final Vector<OrdinaryMorphism> itsNACs = new Vector();
    protected final Vector<OrdinaryMorphism> itsPACs = new Vector();
    protected transient boolean generatePostConstraints;
    protected Vector<AtomConstraint> itsUsedAtomics;
    protected Vector<Formula> itsUsedFormulas;
    protected transient Vector<String> constraintNameSet;
    protected transient Vector<Formula> constraints;
    protected transient Vector<EvalSet> atom_conditions;
    protected Vector<ShiftedPAC> itsShiftedPACs;
    protected transient boolean applicable;
    protected boolean parallelMatching;
    protected boolean randomCSPDomain;
    protected boolean startParallelMatchByFirstCSPVar;
    protected int layer;
    protected int priority;
    protected boolean triggerOfLayer;
    protected transient boolean isReady;
    protected transient boolean isDeleting;
    protected transient boolean isNodeDeleting;
    protected transient boolean isCreating;
    protected transient boolean isChanging;
    protected transient boolean hasEnabledGACs;
    protected transient List<GraphObject> preserved;
    protected transient List<GraphObject> created;
    protected transient List<GraphObject> deleted;
    protected transient List<GraphObject> forbiden;
    protected transient Hashtable<GraphObject, GraphObject> changedPreserved;
    protected transient List<String> typesWhichNeedMultiplicityCheck;
    protected Hashtable<Node, Type> abstractType2childType;
    protected Match itsMatch;
    protected boolean notApplicable;
    protected boolean waitBeforeApply;
    private InverseRuleConstructData invConstruct;

    protected Rule() {
        this.itsName = "Rule";
        this.itsOrig.setName("Left");
        this.itsOrig.setKind("LHS");
        this.itsImag.setName("Right");
        this.itsImag.setKind("RHS");
        this.itsAttrContext = this.itsAttrManager.newContext(0);
        this.itsOrig.setAttrContext(this.itsAttrManager.newLeftContext(this.itsAttrContext));
        this.itsImag.setAttrContext(this.itsAttrManager.newRightContext(this.itsAttrContext));
        this.generatePostConstraints = true;
        this.applicable = true;
    }

    protected Rule(TypeSet types) {
        super(BaseFactory.theFactory().createGraph(types), BaseFactory.theFactory().createGraph(types));
        this.itsName = "Rule";
        this.itsOrig.setName("Left");
        this.itsOrig.setKind("LHS");
        this.itsImag.setName("Right");
        this.itsImag.setKind("RHS");
        this.itsAttrContext = this.itsAttrManager.newContext(0);
        this.itsOrig.setAttrContext(this.itsAttrManager.newLeftContext(this.itsAttrContext));
        this.itsImag.setAttrContext(this.itsAttrManager.newRightContext(this.itsAttrContext));
        this.generatePostConstraints = true;
        this.applicable = true;
    }

    protected Rule(Graph left, Graph right) {
        super(left, right);
        this.itsName = "Rule";
        this.itsOrig.setName("Left");
        this.itsOrig.setKind("LHS");
        this.itsImag.setName("Right");
        this.itsImag.setKind("RHS");
        this.itsAttrContext = this.itsAttrManager.newContext(0);
        this.itsOrig.setAttrContext(this.itsAttrManager.newLeftContext(this.itsAttrContext));
        this.itsImag.setAttrContext(this.itsAttrManager.newRightContext(this.itsAttrContext));
        this.generatePostConstraints = true;
        this.applicable = true;
    }

    protected Rule(Graph left, Graph right, AttrContext cont) {
        super(left, right, cont);
        this.itsName = "Rule";
        this.itsOrig.setName("Left");
        this.itsOrig.setKind("LHS");
        this.itsImag.setName("Right");
        this.itsImag.setKind("RHS");
        this.itsAttrContext = cont;
        this.itsOrig.setAttrContext(this.itsAttrManager.newLeftContext(cont));
        this.itsImag.setAttrContext(this.itsAttrManager.newRightContext(cont));
        this.generatePostConstraints = true;
        this.applicable = true;
    }

    public void disposeSuper() {
        super.dispose();
        this.itsMatch = null;
        this.typesWhichNeedMultiplicityCheck = null;
        this.changed = false;
    }

    @Override
    public void dispose() {
        super.dispose();
        while (!this.itsNACs.isEmpty()) {
            this.itsNACs.get(0).dispose(false, true);
            this.itsNACs.remove(0);
        }
        this.itsNACs.trimToSize();
        while (!this.itsPACs.isEmpty()) {
            this.itsPACs.get(0).dispose(false, true);
            this.itsPACs.remove(0);
        }
        this.itsPACs.trimToSize();
        while (!this.itsACs.isEmpty()) {
            this.itsACs.get(0).dispose(false, true);
            this.itsACs.remove(0);
        }
        this.itsACs.trimToSize();
        this.disposeInverseConstruct();
        this.itsOrig.dispose();
        this.itsImag.dispose();
        this.itsMatch = null;
        this.typesWhichNeedMultiplicityCheck = null;
        this.changed = false;
    }

    @Override
    public void finalize() {
    }

    @Override
    public void setName(String n) {
        this.itsName = n;
        this.itsFormula.setName("Formula.".concat(n));
    }

    public String getQualifiedName() {
        return super.getName();
    }

    @Override
    public boolean hasChanged() {
        return this.changed || this.itsOrig.hasChanged() || this.itsImag.hasChanged();
    }

    private void disposeMatch() {
        if (this.itsMatch != null) {
            this.itsMatch.dispose();
            this.itsMatch = null;
        }
    }

    public void clearRule() {
        this.disposeMatch();
        while (!this.itsNACs.isEmpty()) {
            this.itsNACs.get(0).dispose(false, true);
            this.itsNACs.remove(0);
        }
        while (!this.itsPACs.isEmpty()) {
            this.itsPACs.get(0).dispose(false, true);
            this.itsPACs.remove(0);
        }
        while (!this.itsACs.isEmpty()) {
            this.itsACs.get(0).dispose(false, true);
            this.itsACs.remove(0);
        }
        super.clear();
        this.changed = false;
        this.itsOrig.clear();
        this.itsImag.clear();
        if (this.typesWhichNeedMultiplicityCheck != null) {
            this.typesWhichNeedMultiplicityCheck.clear();
            this.typesWhichNeedMultiplicityCheck = null;
        }
    }

    public void disposeResultsOfNestedACs() {
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            ac.disposeResults();
            ++i;
        }
    }

    public boolean isElement(Graph g) {
        OrdinaryMorphism om;
        if (this.itsOrig == g || this.itsImag == g) {
            return true;
        }
        int i = 0;
        while (i < this.itsNACs.size()) {
            om = this.itsNACs.get(i);
            if (om.getTarget() == g) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsPACs.size()) {
            om = this.itsPACs.get(i);
            if (om.getTarget() == g) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsACs.size()) {
            om = this.itsACs.get(i);
            if (om.getTarget() == g) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final Graph getLeft() {
        return this.itsOrig;
    }

    public final Graph getRight() {
        return this.itsImag;
    }

    public boolean isNotApplicable() {
        return this.notApplicable;
    }

    public boolean isApplicable() {
        return !this.notApplicable && this.applicable;
    }

    public boolean isApplicable(Graph g, MorphCompletionStrategy strategy) {
        return this.isApplicable(g, strategy, false);
    }

    public boolean isApplicable(Graph g, MorphCompletionStrategy strategy, boolean doCheckIfReadyToTransform) {
        boolean result = this.enabled;
        if (result && doCheckIfReadyToTransform) {
            result = this.isReadyToTransform();
        }
        if (result) {
            result = false;
            Match m = BaseFactory.theFactory().createMatch(this, g);
            if (m != null) {
                m.setCompletionStrategy(strategy, true);
                m.enableInputParameter(false);
                if (m.nextCompletion()) {
                    result = true;
                }
                m.dispose();
            }
        }
        return result;
    }

    public void enableInputParameter(boolean enable) {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember vm = vars.getVarMemberAt(i);
            if (vm.isInputParameter()) {
                vm.setEnabled(enable);
                this.enableAttrConditionWithInputParameter(vm.getName(), enable);
            }
            ++i;
        }
    }

    private void enableAttrConditionWithInputParameter(String ipName, boolean enable) {
        CondTuple conds = (CondTuple)this.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getNumberOfEntries()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.getAllVariables().contains(ipName)) {
                cond.setEnabled(enable);
            }
            ++i;
        }
    }

    public boolean isLeftApplicable(Graph g, MorphCompletionStrategy strategy, boolean doCheckIfReadyToTransform) {
        boolean result = true;
        if (doCheckIfReadyToTransform) {
            result = this.isReadyToTransform();
        }
        if (result) {
            result = false;
            Hashtable<OrdinaryMorphism, Boolean> applcond2enable = new Hashtable<OrdinaryMorphism, Boolean>(this.itsNACs.size() + this.itsPACs.size() + this.itsACs.size());
            int i = 0;
            while (i < this.itsNACs.size()) {
                OrdinaryMorphism nac = this.itsNACs.get(i);
                applcond2enable.put(nac, nac.isEnabled());
                nac.setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < this.itsPACs.size()) {
                OrdinaryMorphism pac = this.itsPACs.get(i);
                applcond2enable.put(pac, pac.isEnabled());
                pac.setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < this.itsACs.size()) {
                OrdinaryMorphism ac = this.itsACs.get(i);
                applcond2enable.put(ac, ac.isEnabled());
                ac.setEnabled(false);
                ++i;
            }
            Match m = BaseFactory.theFactory().createMatch(this, g);
            if (m != null) {
                m.setCompletionStrategy(strategy);
                if (m.nextCompletion()) {
                    result = true;
                }
            }
            BaseFactory.theFactory().destroyMatch(m);
            int i2 = 0;
            while (i2 < this.itsNACs.size()) {
                this.itsNACs.get(i2).setEnabled((Boolean)applcond2enable.get(this.itsNACs.get(i2)));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.itsPACs.size()) {
                this.itsPACs.get(i2).setEnabled((Boolean)applcond2enable.get(this.itsPACs.get(i2)));
                ++i2;
            }
            i2 = 0;
            while (i2 < this.itsACs.size()) {
                this.itsACs.get(i2).setEnabled((Boolean)applcond2enable.get(this.itsACs.get(i2)));
                ++i2;
            }
        }
        return result;
    }

    public void enableNACs(boolean enable) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            this.itsNACs.get(i).setEnabled(enable);
            ++i;
        }
    }

    public void enablePACs(boolean enable) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            this.itsPACs.get(i).setEnabled(enable);
            ++i;
        }
    }

    public void setApplicable(boolean appl) {
        this.applicable = appl;
    }

    public TypeSet getTypeSet() {
        return this.getLeft().getTypeSet();
    }

    public NestedApplCond createNestedAC() {
        NestedApplCond ac = new NestedApplCond(this.getLeft(), BaseFactory.theFactory().createGraph(this.getRight().getTypeSet()), this.getRight().getAttrContext());
        this.itsACs.add(ac);
        AttrContext acContext = ac.getAttrContext();
        ac.getImage().setAttrContext(acContext);
        ac.getImage().setKind("AC");
        return ac;
    }

    public NestedApplCond createNestedACDuetoRHS() {
        NestedApplCond nac = this.createNestedAC();
        this.makeACDuetoRHS(nac);
        return nac;
    }

    public boolean addNestedAC(OrdinaryMorphism ac) {
        return this.addNestedAC(-1, ac);
    }

    public boolean addNestedAC(int indx, OrdinaryMorphism ac) {
        if (!this.itsACs.contains(ac)) {
            ac.getTarget().setKind("AC");
            if (indx >= 0 && indx < this.itsACs.size()) {
                this.itsACs.add(indx, ac);
            } else {
                this.itsACs.add(ac);
            }
            this.changed = true;
            return true;
        }
        return false;
    }

    public void enableNestedAC(boolean enable) {
        int i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).setEnabled(enable);
            ++i;
        }
    }

    public void destroyNestedAC(OrdinaryMorphism ac) {
        this.itsACs.removeElement(ac);
        ac.getImage().dispose();
    }

    public boolean hasNestedACs() {
        return !this.itsACs.isEmpty();
    }

    public Enumeration<OrdinaryMorphism> getNestedACs() {
        return this.itsACs.elements();
    }

    public List<NestedApplCond> getEnabledACs() {
        Vector<NestedApplCond> list = new Vector<NestedApplCond>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (ac.isEnabled()) {
                list.add(ac);
            }
            ++i;
        }
        return list;
    }

    public List<OrdinaryMorphism> getNestedACsList() {
        return this.itsACs;
    }

    public List<Evaluable> getEnabledGeneralACsAsEvaluable() {
        Vector<Evaluable> list = new Vector<Evaluable>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (ac.isEnabled()) {
                list.add(ac);
            }
            ++i;
        }
        return list;
    }

    public OrdinaryMorphism getNestedAC(String name) {
        int i = 0;
        while (i < this.itsACs.size()) {
            OrdinaryMorphism ac = this.itsACs.get(i);
            if (ac.getName().equals(name)) {
                return ac;
            }
            ++i;
        }
        return null;
    }

    public OrdinaryMorphism getNestedAC(int indx) {
        if (indx >= 0 && indx < this.itsACs.size()) {
            return this.itsACs.get(indx);
        }
        return null;
    }

    public final boolean removeNestedAC(OrdinaryMorphism ac) {
        boolean enAC = ac.isEnabled();
        if (this.itsACs.removeElement(ac)) {
            if (enAC) {
                this.itsFormula.patchOutEvaluable((NestedApplCond)ac, true);
                this.refreshFormula(new Vector<Evaluable>(this.getEnabledACs()));
            }
            return true;
        }
        return false;
    }

    public boolean nestedACIsUsingVariable(VarMember var, AttrConditionTuple act) {
        int i = 0;
        while (i < this.itsACs.size()) {
            OrdinaryMorphism ac = this.itsACs.get(i);
            if (ac.getTarget().isUsingVariable(var)) {
                return true;
            }
            Vector<String> acVars = ac.getTarget().getVariableNamesOfAttributes();
            int j = 0;
            while (j < acVars.size()) {
                String varName = acVars.get(j);
                int k = 0;
                while (k < act.getNumberOfEntries()) {
                    CondMember cond = (CondMember)act.getMemberAt(k);
                    Vector<String> condVars = cond.getAllVariables();
                    if (condVars.contains(varName) && condVars.contains(var.getName())) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public OrdinaryMorphism createNAC() {
        OrdinaryMorphism nac = new OrdinaryMorphism(this.getLeft(), BaseFactory.theFactory().createGraph(this.getRight().getTypeSet()), this.getRight().getAttrContext());
        this.itsNACs.addElement(nac);
        AttrContext nacContext = nac.getAttrContext();
        nac.getImage().setAttrContext(nacContext);
        nac.getImage().setKind("NAC");
        return nac;
    }

    public OrdinaryMorphism createNACDuetoRHS() {
        OrdinaryMorphism nac = this.createNAC();
        this.makeACDuetoRHS(nac);
        return nac;
    }

    public void makeACDuetoRHS(OrdinaryMorphism morph) {
        HashMap<Node, Node> map = new HashMap<Node, Node>();
        for (Node nr : this.itsImag.getNodesSet()) {
            Enumeration<GraphObject> l = this.getInverseImage(nr);
            if (l.hasMoreElements()) {
                Node nl = (Node)l.nextElement();
                try {
                    Node n = morph.getTarget().copyNode(nl);
                    try {
                        morph.addMapping(nl, n);
                        while (l.hasMoreElements()) {
                            morph.addMapping((Node)l.nextElement(), n);
                        }
                        map.put(nr, n);
                    }
                    catch (BadMappingException badMappingException) {
                    }
                }
                catch (TypeException n) {}
                continue;
            }
            try {
                Node n = morph.getTarget().copyNode(nr);
                if (n.getAttribute() != null) {
                    ((ValueTuple)n.getAttribute()).unsetValueAsExpr();
                }
                map.put(nr, n);
            }
            catch (TypeException n) {
                // empty catch block
            }
        }
        for (Arc ar : this.itsImag.getArcsSet()) {
            Enumeration<GraphObject> l = this.getInverseImage(ar);
            if (l.hasMoreElements()) {
                Arc al = (Arc)l.nextElement();
                try {
                    Arc a = morph.getTarget().copyArc(al, (Node)morph.getImage(al.getSource()), (Node)morph.getImage(al.getTarget()));
                    try {
                        morph.addMapping(al, a);
                        while (l.hasMoreElements()) {
                            morph.addMapping(l.nextElement(), a);
                        }
                    }
                    catch (BadMappingException badMappingException) {
                    }
                }
                catch (TypeException a) {}
                continue;
            }
            try {
                Node s = (Node)map.get(ar.getSource());
                Node t = (Node)map.get(ar.getTarget());
                Arc a = morph.getTarget().copyArc(ar, s, t);
                if (a.getAttribute() == null) continue;
                ((ValueTuple)a.getAttribute()).unsetValueAsExpr();
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        map.clear();
        map = null;
    }

    public boolean addNAC(OrdinaryMorphism nac) {
        return this.addNAC(-1, nac);
    }

    public boolean addNAC(int indx, OrdinaryMorphism nac) {
        if (!this.itsNACs.contains(nac)) {
            nac.getTarget().setKind("NAC");
            if (indx >= 0 && indx < this.itsNACs.size()) {
                this.itsNACs.add(indx, nac);
            } else {
                this.itsNACs.add(nac);
            }
            this.changed = true;
            return true;
        }
        return false;
    }

    public void destroyNAC(OrdinaryMorphism nac) {
        this.itsNACs.removeElement(nac);
        nac.getImage().dispose();
    }

    public boolean hasNACs() {
        return !this.itsNACs.isEmpty();
    }

    public boolean hasEnabledNACs() {
        for (OrdinaryMorphism n : this.itsNACs) {
            if (!n.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<OrdinaryMorphism> getNACs() {
        return this.itsNACs.elements();
    }

    public Vector<OrdinaryMorphism> getNACsVector() {
        return this.itsNACs;
    }

    public List<OrdinaryMorphism> getNACsList() {
        return this.itsNACs;
    }

    public OrdinaryMorphism getNAC(String name) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            OrdinaryMorphism nac = this.itsNACs.get(i);
            if (nac.getName().equals(name)) {
                return nac;
            }
            ++i;
        }
        return null;
    }

    public OrdinaryMorphism getNAC(int indx) {
        if (indx >= 0 && indx < this.itsNACs.size()) {
            return this.itsNACs.get(indx);
        }
        return null;
    }

    public OrdinaryMorphism getNAC(Graph g) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            OrdinaryMorphism ac = this.itsNACs.get(i);
            if (ac.getTarget() == g) {
                return ac;
            }
            ++i;
        }
        return null;
    }

    public boolean hasNAC(Graph g) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            OrdinaryMorphism ac = this.itsNACs.get(i);
            if (ac.getTarget() == g) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean removeNAC(OrdinaryMorphism nac) {
        return this.itsNACs.removeElement(nac);
    }

    public OrdinaryMorphism createPAC() {
        OrdinaryMorphism pac = new OrdinaryMorphism(this.getLeft(), BaseFactory.theFactory().createGraph(this.getRight().getTypeSet()), this.getRight().getAttrContext());
        this.itsPACs.addElement(pac);
        AttrContext pacContext = pac.getAttrContext();
        pac.getImage().setAttrContext(pacContext);
        pac.getImage().setKind("PAC");
        return pac;
    }

    public boolean addPAC(OrdinaryMorphism pac) {
        return this.addPAC(-1, pac);
    }

    public boolean addPAC(int indx, OrdinaryMorphism pac) {
        if (!this.itsPACs.contains(pac)) {
            pac.getTarget().setKind("PAC");
            if (indx >= 0 && indx < this.itsPACs.size()) {
                this.itsPACs.add(indx, pac);
            } else {
                this.itsPACs.add(pac);
            }
            this.changed = true;
            return true;
        }
        return false;
    }

    public void addShiftedPAC(List<OrdinaryMorphism> list) {
        ShiftedPAC shiftedPAC = new ShiftedPAC(list);
        if (this.itsShiftedPACs == null) {
            this.itsShiftedPACs = new Vector();
        }
        this.itsShiftedPACs.add(shiftedPAC);
    }

    public List<ShiftedPAC> getShiftedPACs() {
        return this.itsShiftedPACs;
    }

    public boolean isShiftedPAC(OrdinaryMorphism pac) {
        if (this.itsShiftedPACs == null) {
            return false;
        }
        int i = 0;
        while (i < this.itsShiftedPACs.size()) {
            if (this.itsShiftedPACs.get(i).contains(pac)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void destroyPAC(OrdinaryMorphism pac) {
        this.itsPACs.removeElement(pac);
        pac.getImage().dispose();
    }

    public boolean hasPACs() {
        return !this.itsPACs.isEmpty();
    }

    public boolean hasEnabledPACs() {
        for (OrdinaryMorphism p : this.itsPACs) {
            if (!p.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<OrdinaryMorphism> getPACs() {
        return this.itsPACs.elements();
    }

    public Enumeration<OrdinaryMorphism> getEnabledPACs() {
        Vector<OrdinaryMorphism> v = new Vector<OrdinaryMorphism>(2);
        for (OrdinaryMorphism p : this.itsPACs) {
            if (!p.isEnabled()) continue;
            v.add(p);
        }
        return v.elements();
    }

    public Vector<OrdinaryMorphism> getPACsVector() {
        return this.itsPACs;
    }

    public List<OrdinaryMorphism> getPACsList() {
        return this.itsPACs;
    }

    public OrdinaryMorphism getPAC(String name) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            OrdinaryMorphism pac = this.itsPACs.get(i);
            if (pac.getName().equals(name)) {
                return pac;
            }
            ++i;
        }
        return null;
    }

    public OrdinaryMorphism getPAC(int indx) {
        if (indx >= 0 && indx < this.itsPACs.size()) {
            return this.itsPACs.get(indx);
        }
        return null;
    }

    public OrdinaryMorphism getPAC(Graph g) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            OrdinaryMorphism ac = this.itsPACs.get(i);
            if (ac.getTarget() == g) {
                return ac;
            }
            ++i;
        }
        return null;
    }

    public boolean hasPAC(Graph g) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            OrdinaryMorphism ac = this.itsPACs.get(i);
            if (ac.getTarget() == g) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean removePAC(OrdinaryMorphism pac) {
        return this.itsPACs.removeElement(pac);
    }

    public boolean checkCreateAbstractNode(Type nodeType) {
        for (Node n : this.getTarget().getNodesSet()) {
            if (!n.getType().equals(nodeType) || this.getInverseImage(n).hasMoreElements()) continue;
            return false;
        }
        return true;
    }

    public TypeError checkNewNodeRequiresArc() {
        for (GraphObject graphObject : this.getRight().getNodesSet()) {
            List<String> list;
            if (this.getInverseImage(graphObject).hasMoreElements() || (list = this.getRight().getTypeSet().nodeRequiresArc((Node)graphObject)) == null || list.isEmpty()) continue;
            TypeError actError = new TypeError(23, "Node type  \"" + graphObject.getType().getName() + "\" \n" + "requires edge(s) of type: \n" + list.toString(), graphObject.getType());
            actError.setContainingGraph(this.getRight());
            return actError;
        }
        return null;
    }

    public boolean destroyObjectsOfType(Type t) {
        if (this.getLeft().destroyObjectsOfType(t) && this.getRight().destroyObjectsOfType(t)) {
            int j = 0;
            while (j < this.itsNACs.size()) {
                OrdinaryMorphism nac = this.itsNACs.get(j);
                if (!nac.getTarget().destroyObjectsOfType(t)) {
                    return false;
                }
                ++j;
            }
            j = 0;
            while (j < this.itsPACs.size()) {
                OrdinaryMorphism pac = this.itsPACs.get(j);
                if (!pac.getTarget().destroyObjectsOfType(t)) {
                    return false;
                }
                ++j;
            }
            j = 0;
            while (j < this.itsACs.size()) {
                OrdinaryMorphism ac = this.itsACs.get(j);
                if (!ac.getTarget().destroyObjectsOfType(t)) {
                    return false;
                }
                ++j;
            }
            Vector<EvalSet> atom_conds = this.getAtomApplConds();
            int i = 0;
            while (i < atom_conds.size()) {
                Vector<Object> v = atom_conds.get(i).getSet();
                int j2 = 0;
                while (j2 < v.size()) {
                    Vector<Object> v1 = ((EvalSet)v.get(j2)).getSet();
                    int k = 0;
                    while (k < v1.size()) {
                        AtomApplCond aac = (AtomApplCond)v1.get(k);
                        OrdinaryMorphism cond = aac.getPreCondition();
                        OrdinaryMorphism tm = aac.getT();
                        OrdinaryMorphism qm = aac.getQ();
                        cond.getSource().destroyObjectsOfType(t);
                        cond.getTarget().destroyObjectsOfType(t);
                        tm.getTarget().destroyObjectsOfType(t);
                        qm.getSource().destroyObjectsOfType(t);
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
        }
        return true;
    }

    public Vector<String> destroyObjectsOfTypes(Vector<Type> types) {
        Vector<String> failed = new Vector<String>(5);
        int i = 0;
        while (i < types.size()) {
            Type t = types.get(i);
            if (!this.destroyObjectsOfType(t)) {
                String s = "Rule:  " + this.getName() + "   Type:  " + t.getName();
                failed.add(s);
            }
            ++i;
        }
        return failed;
    }

    public Rule getClone() {
        return BaseFactory.theFactory().cloneRule(this);
    }

    public Rule getClone(TypeSet types) {
        return BaseFactory.theFactory().cloneRule(this, types, true);
    }

    public final OrdinaryMorphism getMorphism() {
        return this;
    }

    public Vector<Formula> getConstraints() {
        return this.constraints != null ? this.constraints : new Vector(0);
    }

    @Override
    protected boolean checkType(Type orig, Type image) {
        return orig.compareTo(image);
    }

    public void createAttrInstanceWhereNeeded() {
        this.itsOrig.createAttrInstanceWhereNeeded();
        this.itsImag.createAttrInstanceWhereNeeded();
        int i = 0;
        while (i < this.itsNACs.size()) {
            this.itsNACs.get(i).getTarget().createAttrInstanceWhereNeeded();
            ++i;
        }
        i = 0;
        while (i < this.itsPACs.size()) {
            this.itsPACs.get(i).getTarget().createAttrInstanceWhereNeeded();
            ++i;
        }
        i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).getTarget().createAttrInstanceWhereNeeded();
            ++i;
        }
    }

    public void createAttrInstanceOfTypeWhereNeeded(Type t) {
        this.itsOrig.createAttrInstanceOfTypeWhereNeeded(t);
        this.itsImag.createAttrInstanceOfTypeWhereNeeded(t);
        int i = 0;
        while (i < this.itsNACs.size()) {
            this.itsNACs.get(i).getTarget().createAttrInstanceOfTypeWhereNeeded(t);
            ++i;
        }
        i = 0;
        while (i < this.itsPACs.size()) {
            this.itsPACs.get(i).getTarget().createAttrInstanceOfTypeWhereNeeded(t);
            ++i;
        }
        i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.get(i).getTarget().createAttrInstanceOfTypeWhereNeeded(t);
            ++i;
        }
    }

    public String convertUsedFormulas() {
        if (this.itsUsedAtomics != null && this.itsUsedAtomics.size() > 0 && this.itsUsedFormulas != null && this.itsUsedFormulas.size() > 0) {
            String msg = "";
            Vector<EvalSet> fin = new Vector<EvalSet>();
            Vector<String> names = new Vector<String>();
            if (this.constraints == null) {
                this.constraints = new Vector();
            } else {
                this.constraints.clear();
            }
            this.setAtomApplConds(null, null);
            Hashtable<AtomConstraint, EvalSet> atomic2set = new Hashtable<AtomConstraint, EvalSet>();
            Hashtable<String, String> failedAtomic2error = new Hashtable<String, String>();
            int tgLevel = this.getTypeSet().getLevelOfTypeGraphCheck();
            if (tgLevel > 20) {
                this.getTypeSet().setLevelOfTypeGraph(20);
            }
            int j = 0;
            while (j < this.itsUsedAtomics.size()) {
                AtomConstraint a = this.itsUsedAtomics.elementAt(j);
                if (!a.isValid()) {
                    msg = "Atomic  \"" + a.getAtomicName() + "\"  is not valid. <br>";
                    this.itsUsedAtomics.clear();
                    this.itsUsedFormulas.clear();
                    return msg;
                }
                ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(true);
                Convert conv = new Convert(this, a);
                Vector<Object> v = conv.convert();
                ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
                EvalSet set = new EvalSet(v);
                fin.add(set);
                names.add(a.getAtomicName());
                if (!v.isEmpty()) {
                    atomic2set.put(a, set);
                }
                if (!"".equals(conv.getErrorMsg())) {
                    failedAtomic2error.put(a.getAtomicName(), conv.getErrorMsg());
                }
                ++j;
            }
            this.getTypeSet().setLevelOfTypeGraph(tgLevel);
            if (!failedAtomic2error.isEmpty()) {
                msg = "Error(s) during creating Post Application Condition : <br>";
            }
            j = 0;
            while (j < this.itsUsedFormulas.size()) {
                Formula f = this.itsUsedFormulas.elementAt(j);
                if (f.isEnabled()) {
                    Vector<Evaluable> v = new Vector<Evaluable>();
                    String s = f.getAsString(v);
                    boolean formulaOK = true;
                    Vector<Evaluable> v2 = new Vector<Evaluable>();
                    int k = 0;
                    while (k < v.size()) {
                        Evaluable e = v.get(k);
                        boolean convertOK = false;
                        int k2 = 0;
                        while (k2 < this.itsUsedAtomics.size()) {
                            if (this.itsUsedAtomics.get(k2) == e) {
                                String atomicName = this.itsUsedAtomics.get(k2).getAtomicName();
                                Evaluable set = (Evaluable)atomic2set.get(e);
                                if (set != null) {
                                    v2.add(set);
                                    convertOK = true;
                                    break;
                                }
                                int indx = names.indexOf(atomicName);
                                fin.remove(indx);
                                names.remove(indx);
                            }
                            ++k2;
                        }
                        if (!convertOK) {
                            formulaOK = false;
                            break;
                        }
                        ++k;
                    }
                    if (formulaOK) {
                        Formula f2 = new Formula(v2, s);
                        this.constraints.add(f2);
                    }
                }
                ++j;
            }
            if (fin.isEmpty()) {
                this.itsUsedAtomics.clear();
                this.itsUsedFormulas.clear();
            } else {
                this.setAtomApplConds(fin, names);
            }
            this.deleteTransientContextVariables(this.getSource());
            this.deleteTransientContextVariables(this.getTarget());
            this.removeUnusedVariableOfAttrContext();
            String msg1 = "Cannot convert atomic(s) :\n";
            String msg2 = "";
            Enumeration failedAtomic = failedAtomic2error.keys();
            while (failedAtomic.hasMoreElements()) {
                String name = (String)failedAtomic.nextElement();
                String error = (String)failedAtomic2error.get(name);
                msg2 = msg2.concat(" - ").concat(name).concat(" - ").concat("\n");
                msg2 = msg2.concat(error).concat("\n");
            }
            if (!"".equals(msg2)) {
                msg1 = msg1.concat(msg2);
                msg = msg.concat(msg1);
            }
            return msg;
        }
        return "Cannot create post application conditions. There isn't any formula selected. <br>";
    }

    public void setUsedFormulas(List<Formula> formulasToUse) {
        if (!formulasToUse.isEmpty()) {
            if (this.itsUsedFormulas == null) {
                this.itsUsedFormulas = new Vector();
            } else {
                this.itsUsedFormulas.clear();
            }
            if (this.itsUsedAtomics == null) {
                this.itsUsedAtomics = new Vector();
            } else {
                this.itsUsedAtomics.clear();
            }
            this.itsUsedFormulas.addAll(formulasToUse);
            int i = 0;
            while (i < this.itsUsedFormulas.size()) {
                Formula f = this.itsUsedFormulas.get(i);
                Vector<Evaluable> vec = new Vector<Evaluable>();
                String form = f.getAsString(vec);
                int j = 0;
                while (j < vec.size()) {
                    if (vec.get(j) instanceof AtomConstraint) {
                        AtomConstraint ac = (AtomConstraint)vec.get(j);
                        this.itsUsedAtomics.addElement(ac);
                    } else {
                        System.out.println("Rule.setUsedFormulas(Vector<Formula> usedFormulas):  formula: " + form + "   FAILED!");
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public Vector<AtomConstraint> getUsedAtomics() {
        return this.itsUsedAtomics != null ? this.itsUsedAtomics : new Vector(0);
    }

    public Vector<Formula> getUsedFormulas() {
        return this.itsUsedFormulas != null ? this.itsUsedFormulas : new Vector(0);
    }

    public void clearConstraints(AtomConstraint ac) {
        if (this.itsUsedAtomics != null && this.itsUsedAtomics.contains(ac)) {
            this.clearConstraints();
        }
    }

    public void clearConstraints(Formula f) {
        if (this.itsUsedFormulas != null && this.itsUsedFormulas.contains(f)) {
            this.clearConstraints();
        }
    }

    public void clearConstraints() {
        if (this.itsUsedAtomics != null) {
            this.itsUsedAtomics.clear();
        }
        if (this.itsUsedFormulas != null) {
            this.itsUsedFormulas.clear();
        }
        if (this.constraints != null) {
            this.constraints.clear();
        }
        this.setAtomApplConds(null, null);
    }

    public void setAtomApplConds(Vector<EvalSet> v, Vector<String> names) {
        if (this.atom_conditions == null) {
            this.atom_conditions = new Vector();
        } else {
            this.atom_conditions.clear();
        }
        if (this.constraintNameSet == null) {
            this.constraintNameSet = new Vector();
        } else {
            this.constraintNameSet.clear();
        }
        if (v != null) {
            this.atom_conditions.addAll(v);
        }
        if (names != null) {
            this.constraintNameSet.addAll(names);
        }
        if (this.constraintNameSet.size() < this.atom_conditions.size()) {
            int i = this.constraintNameSet.size();
            while (i < this.atom_conditions.size()) {
                this.constraintNameSet.add("Unknown Name " + i);
                ++i;
            }
        }
    }

    public Vector<EvalSet> getAtomApplConds() {
        return this.atom_conditions != null ? this.atom_conditions : new Vector(0);
    }

    public Vector<String> getConstraintNames() {
        return this.constraintNameSet != null ? this.constraintNameSet : new Vector(0);
    }

    public void removeConstraint(EvalSet constraint) {
        if (this.atom_conditions != null && this.atom_conditions.contains(constraint)) {
            int i = this.atom_conditions.indexOf(constraint);
            this.atom_conditions.removeElement(constraint);
            this.constraintNameSet.removeElementAt(i);
        }
    }

    public void removeAtomApplCond(AtomApplCond atom) {
        if (this.atom_conditions != null) {
            int i = 0;
            while (i < this.atom_conditions.size()) {
                Vector<Object> v = this.atom_conditions.get(i).getSet();
                int j = 0;
                while (j < v.size()) {
                    Vector<Object> v1 = ((EvalSet)v.get(j)).getSet();
                    int k = 0;
                    while (k < v1.size()) {
                        AtomApplCond aac = (AtomApplCond)v1.get(k);
                        if (atom.equals(aac)) {
                            v1.removeElement(atom);
                            k = v1.size();
                            continue;
                        }
                        ++k;
                    }
                    if (v1.size() == 0) {
                        v.removeElementAt(j);
                        j = v.size();
                        continue;
                    }
                    ++j;
                }
                if (v.size() == 0) {
                    this.atom_conditions.removeElementAt(i);
                    this.constraintNameSet.removeElementAt(i);
                    i = this.atom_conditions.size();
                    continue;
                }
                ++i;
            }
        }
    }

    public void removeApplConditions() {
        this.clearConstraints();
    }

    public void setTriggerForLayer(boolean trigger) {
        this.triggerOfLayer = trigger;
    }

    public boolean isTriggerOfLayer() {
        return this.triggerOfLayer;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int l) {
        this.layer = l;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public void trimToSize() {
        super.trimToSize();
        this.itsNACs.trimToSize();
        int i = 0;
        while (i < this.itsNACs.size()) {
            this.itsNACs.elementAt(i).trimToSize();
            ++i;
        }
        this.itsPACs.trimToSize();
        i = 0;
        while (i < this.itsPACs.size()) {
            this.itsPACs.elementAt(i).trimToSize();
            ++i;
        }
        this.itsACs.trimToSize();
        i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.elementAt(i).trimToSize();
            ++i;
        }
        if (this.itsUsedAtomics != null) {
            this.itsUsedAtomics.trimToSize();
            i = 0;
            while (i < this.itsUsedAtomics.size()) {
                this.itsUsedAtomics.get(i).trimToSize();
                ++i;
            }
        }
        if (this.itsUsedFormulas != null) {
            this.itsUsedFormulas.trimToSize();
            i = 0;
            while (i < this.itsUsedFormulas.size()) {
                this.itsUsedFormulas.trimToSize();
                ++i;
            }
        }
        if (this.constraints != null) {
            this.constraints.trimToSize();
            i = 0;
            while (i < this.constraints.size()) {
                this.constraints.trimToSize();
                ++i;
            }
        }
        if (this.atom_conditions != null) {
            this.atom_conditions.trimToSize();
        }
        if (this.constraintNameSet != null) {
            this.constraintNameSet.trimToSize();
        }
        if (this.itsShiftedPACs != null) {
            this.itsShiftedPACs.trimToSize();
        }
    }

    public void refreshAttributed() {
        this.getLeft().refreshAttributed();
        this.getRight().refreshAttributed();
        int i = 0;
        while (i < this.itsNACs.size()) {
            this.itsNACs.elementAt(i).getTarget().refreshAttributed();
            ++i;
        }
        i = 0;
        while (i < this.itsPACs.size()) {
            this.itsPACs.elementAt(i).getTarget().refreshAttributed();
            ++i;
        }
        i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.elementAt(i).getTarget().refreshAttributed();
            ++i;
        }
    }

    public boolean isUsingType(GraphObject typeObj) {
        if (this.getLeft().isUsingType(typeObj)) {
            return true;
        }
        if (this.getRight().isUsingType(typeObj)) {
            return true;
        }
        int i = 0;
        while (i < this.itsNACs.size()) {
            if (this.itsNACs.elementAt(i).getTarget().isUsingType(typeObj)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsPACs.size()) {
            if (this.itsPACs.elementAt(i).getTarget().isUsingType(typeObj)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsACs.size()) {
            this.itsACs.elementAt(i).getTarget().refreshAttributed();
            ++i;
        }
        return false;
    }

    @Override
    public void removeUnusedVariableOfAttrContext() {
        DeclTuple vars = ((VarTuple)this.getAttrContext().getVariables()).getTupleType();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            DeclMember vm = (DeclMember)vars.getMemberAt(i);
            String var = vm.getName();
            if (!(this.getSource().getVariableNamesOfAttributes().contains(var) || this.getRight().getVariableNamesOfAttributes().contains(var) || this.isUsedInTargetGraph(this.getNACs(), var) || this.isUsedInTargetGraph(this.getPACs(), var) || this.isUsedInNestedGraphs(this.getNestedACs(), var))) {
                vars.getTupleType().deleteMemberAt(var);
                --i;
            }
            ++i;
        }
    }

    private boolean isUsedInTargetGraph(Enumeration<OrdinaryMorphism> list, String varName) {
        while (list.hasMoreElements()) {
            Graph g = list.nextElement().getTarget();
            if (!g.getVariableNamesOfAttributes().contains(varName)) continue;
            return true;
        }
        return false;
    }

    private boolean isUsedInNestedGraphs(Enumeration<OrdinaryMorphism> list, String varName) {
        while (list.hasMoreElements()) {
            OrdinaryMorphism m = list.nextElement();
            if (m.getTarget().getVariableNamesOfAttributes().contains(varName)) {
                return true;
            }
            if (!(m instanceof NestedApplCond)) continue;
            Vector<OrdinaryMorphism> nl = new Vector<OrdinaryMorphism>();
            int i = 0;
            while (i < ((NestedApplCond)m).getNestedACs().size()) {
                nl.add(((NestedApplCond)m).getNestedACs().get(i));
                ++i;
            }
            if (!this.isUsedInNestedGraphs(nl.elements(), varName)) continue;
            return true;
        }
        return false;
    }

    public void setWaitBeforeApplyEnabled(boolean b) {
        this.waitBeforeApply = b;
    }

    public boolean isWaitBeforeApplyEnabled() {
        return this.waitBeforeApply;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        this.changed = false;
        h.openNewElem("Rule", this);
        h.addAttr("name", this.itsName);
        if (!"".equals(this.formStr)) {
            h.addAttr("formula", this.formStr);
        }
        if (!this.enabled) {
            h.addAttr("enabled", "false");
        }
        if (this.triggerOfLayer) {
            h.addAttr("trigger", "true");
        }
        if (this.parallelMatching) {
            h.addAttr("parallel", "true");
        }
        if (this.startParallelMatchByFirstCSPVar) {
            h.addAttr("parallelByFirst", "true");
        }
        if (this.waitBeforeApply) {
            h.addAttr("waitBeforeApply", "true");
        }
        AttrContext context = this.getAttrContext();
        h.addObject("", context.getVariables(), true);
        this.getSource().setKind("LHS");
        h.addObject("", this.getSource(), true);
        this.getSource().setKind("RHS");
        h.addObject("", this.getTarget(), true);
        this.writeMorphism(h);
        Enumeration<OrdinaryMorphism> nacs = this.getNACs();
        Enumeration<OrdinaryMorphism> pacs = this.getPACs();
        Enumeration<OrdinaryMorphism> nested = this.getNestedACs();
        AttrConditionTuple condt = context.getConditions();
        int num = condt.getNumberOfEntries();
        if (nested.hasMoreElements() || nacs.hasMoreElements() || pacs.hasMoreElements() || num > 0 || this.itsUsedAtomics != null && this.itsUsedAtomics.size() > 0) {
            OrdinaryMorphism m;
            h.openSubTag("ApplCondition");
            while (nacs.hasMoreElements()) {
                m = nacs.nextElement();
                m.getTarget().setKind("NAC");
                h.openSubTag("NAC");
                if (!m.isEnabled()) {
                    h.addAttr("enabled", "false");
                }
                h.addObject("", m.getTarget(), true);
                m.writeMorphism(h);
                h.close();
            }
            while (pacs.hasMoreElements()) {
                m = pacs.nextElement();
                m.getTarget().setKind("PAC");
                h.openSubTag("PAC");
                if (!m.isEnabled()) {
                    h.addAttr("enabled", "false");
                }
                h.addObject("", m.getTarget(), true);
                m.writeMorphism(h);
                h.close();
            }
            while (nested.hasMoreElements()) {
                m = nested.nextElement();
                m.getTarget().setKind("AC");
                h.openSubTag("NestedAC");
                if (!m.isEnabled()) {
                    h.addAttr("enabled", "false");
                }
                h.addObject("", m.getTarget(), true);
                m.writeMorphism(h);
                ((NestedApplCond)m).writeNestedApplConds(h);
                h.close();
            }
            if (num > 0) {
                h.openSubTag("AttrCondition");
                h.addObject("", condt, true);
                h.close();
            }
            if (this.itsUsedAtomics != null && this.itsUsedAtomics.size() > 0 && this.itsUsedFormulas != null && this.itsUsedFormulas.size() > 0) {
                h.openSubTag("PostApplicationCondition");
                int i = 0;
                while (i < this.itsUsedFormulas.size()) {
                    Formula f = this.itsUsedFormulas.elementAt(i);
                    h.openSubTag("FormulaRef");
                    h.addObject("f", f, false);
                    h.close();
                    ++i;
                }
                h.close();
            }
            h.close();
        }
        h.openSubTag("TaggedValue");
        h.addAttr("Tag", "layer");
        h.addAttr("TagValue", this.layer);
        h.close();
        h.openSubTag("TaggedValue");
        h.addAttr("Tag", "priority");
        h.addAttr("TagValue", this.priority);
        h.close();
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Rule", this)) {
            int v2;
            String t;
            String attrStr = h.readAttr("formula");
            this.formStr = !"".equals(attrStr) ? attrStr : "true";
            this.setTextualComment("Formula: ".concat(this.formStr));
            attrStr = h.readAttr("enabled");
            this.enabled = attrStr == null || !attrStr.equals("false");
            attrStr = h.readAttr("trigger");
            this.triggerOfLayer = attrStr != null && attrStr.equals("true");
            attrStr = h.readAttr("parallel");
            this.parallelMatching = attrStr != null && attrStr.equals("true");
            attrStr = h.readAttr("parallelByFirst");
            this.startParallelMatchByFirstCSPVar = attrStr != null && attrStr.equals("true");
            attrStr = h.readAttr("waitBeforeApply");
            this.waitBeforeApply = attrStr != null && attrStr.equals("true");
            h.enrichObject(this.getAttrContext().getVariables());
            h.getObject("", this.getSource(), true);
            h.getObject("", this.getTarget(), true);
            this.readMorphism(h);
            this.itsOrig.setName("LeftOf_" + this.getName());
            this.itsOrig.setKind("LHS");
            this.itsOrig.setHelpInfo(this.getName());
            this.itsImag.setName("RightOf_" + this.getName());
            this.itsImag.setKind("RHS");
            this.itsImag.setHelpInfo(this.getName());
            Vector<Formula> tmpFormulas = new Vector<Formula>();
            if (h.readSubTag("ApplCondition")) {
                while (h.readSubTag("NAC")) {
                    boolean nacEnabled = true;
                    String nacattr_enabled = h.readAttr("enabled");
                    if (nacattr_enabled != null && nacattr_enabled.equals("false")) {
                        nacEnabled = false;
                    }
                    OrdinaryMorphism nac = this.createNAC();
                    nac.getTarget().setHelpInfo(this.getName());
                    nac.getTarget().xyAttr = this.getLeft().xyAttr;
                    h.getObject("", nac.getTarget(), true);
                    nac.readMorphism(h);
                    h.close();
                    nac.setEnabled(nacEnabled);
                    nac.getTarget().setHelpInfo("");
                    if (!nac.getName().isEmpty()) continue;
                    nac.setName("nac".concat(String.valueOf(this.itsNACs.size())));
                }
                while (h.readSubTag("PAC")) {
                    boolean pacEnabled = true;
                    String pacattr_enabled = h.readAttr("enabled");
                    if (pacattr_enabled != null && pacattr_enabled.equals("false")) {
                        pacEnabled = false;
                    }
                    OrdinaryMorphism pac = this.createPAC();
                    pac.getTarget().setHelpInfo(this.getName());
                    pac.getTarget().xyAttr = this.getLeft().xyAttr;
                    h.getObject("", pac.getTarget(), true);
                    pac.readMorphism(h);
                    h.close();
                    pac.setEnabled(pacEnabled);
                    pac.getTarget().setHelpInfo("");
                    if (!pac.getName().isEmpty()) continue;
                    pac.setName("pac".concat(String.valueOf(this.itsPACs.size())));
                }
                while (h.readSubTag("NestedAC")) {
                    boolean acEnabled = true;
                    String acattr_enabled = h.readAttr("enabled");
                    if (acattr_enabled != null && acattr_enabled.equals("false")) {
                        acEnabled = false;
                    }
                    NestedApplCond ac = this.createNestedAC();
                    ac.getTarget().setHelpInfo(this.getName());
                    ac.getTarget().xyAttr = this.getLeft().xyAttr;
                    h.getObject("", ac.getTarget(), true);
                    ac.readMorphism(h);
                    ac.readNestedApplConds(h);
                    h.close();
                    ac.setEnabled(acEnabled);
                    ac.getTarget().setHelpInfo("");
                    if (!ac.getName().isEmpty()) continue;
                    ac.setName("gac".concat(String.valueOf(this.itsACs.size())));
                }
                if (h.readSubTag("AttrCondition")) {
                    AttrConditionTuple condt = this.getAttrContext().getConditions();
                    if (condt != null) {
                        h.enrichObject(condt);
                    }
                    h.close();
                }
                if (h.readSubTag("PostApplicationCondition")) {
                    while (h.readSubTag("FormulaRef")) {
                        Formula f = new Formula(true);
                        f.setName("");
                        Formula f1 = (Formula)h.getObject("f", null, false);
                        if (f1 != null) {
                            tmpFormulas.addElement(f1);
                        }
                        h.close();
                    }
                    h.close();
                }
                h.close();
            }
            if (h.readSubTag("TaggedValue")) {
                int v = 0;
                t = h.readAttr("Tag");
                int v1 = h.readIAttr("Value");
                v2 = h.readIAttr("TagValue");
                if (v1 > 0) {
                    v = v1;
                } else if (v2 > 0) {
                    v = v2;
                }
                if (t.equals("layer")) {
                    this.layer = v;
                }
                h.close();
            }
            if (h.readSubTag("TaggedValue")) {
                int v = 0;
                t = h.readAttr("Tag");
                int v1 = h.readIAttr("Value");
                v2 = h.readIAttr("TagValue");
                if (v1 > 0) {
                    v = v1;
                } else if (v2 > 0) {
                    v = v2;
                }
                if (t.equals("priority")) {
                    this.priority = v;
                }
                h.close();
            }
            h.close();
            this.applicable = true;
            this.setUsedFormulas(tmpFormulas);
            this.itsOrig.setHelpInfo("");
            this.itsImag.setHelpInfo("");
            this.setFormula(this.formStr);
        }
    }

    private boolean convertToFormula(List<NestedApplCond> pacs, List<NestedApplCond> nacs) {
        NestedApplCond ac;
        Vector<Evaluable> vars = new Vector<Evaluable>(this.itsACs.size());
        if (this.itsACs.size() == 0) {
            this.formReadStr = this.formStr = "true";
            return true;
        }
        String tmp = "";
        int indx = -1;
        int i = 0;
        while (i < pacs.size()) {
            ac = pacs.get(i);
            if (ac.isEnabled()) {
                ++indx;
                vars.add(ac);
                tmp = vars.size() == 1 ? tmp.concat(String.valueOf(indx + 1)) : tmp.concat("&").concat(String.valueOf(indx + 1));
            }
            ++i;
        }
        i = 0;
        while (i < nacs.size()) {
            ac = nacs.get(i);
            if (ac.isEnabled()) {
                ++indx;
                vars.add(ac);
                tmp = vars.size() == 1 ? tmp.concat("!".concat(String.valueOf(indx + 1))) : tmp.concat("&!").concat(String.valueOf(indx + 1));
            }
            ++i;
        }
        if ("".equals(tmp)) {
            this.formReadStr = this.formStr = "true";
            return true;
        }
        if (this.itsFormula.setFormula(vars, tmp)) {
            this.formReadStr = this.formStr = this.itsFormula.getAsString(vars);
            return true;
        }
        return false;
    }

    public Rule invertSimplex() {
        if (!this.isInjective()) {
            return null;
        }
        Rule inverse = new Rule();
        Graph lgraph = this.getLeft();
        Graph rgraph = this.getRight();
        Graph linverse = inverse.getLeft();
        Graph rinverse = inverse.getRight();
        OrdinaryMorphism lmorph = new OrdinaryMorphism(lgraph, rinverse);
        OrdinaryMorphism rmorph = new OrdinaryMorphism(rgraph, linverse);
        for (Node rNode : rgraph.getNodesSet()) {
            Node linverseNode = null;
            try {
                linverseNode = linverse.createNode(rNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            rmorph.addMapping(rNode, linverseNode);
        }
        for (Node lNode : lgraph.getNodesSet()) {
            Node rinverseNode = null;
            try {
                rinverseNode = rinverse.createNode(lNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            lmorph.addMapping(lNode, rinverseNode);
            GraphObject rn = this.getImage(lNode);
            if (rn == null) continue;
            inverse.addMapping(rmorph.getImage(rn), rinverseNode);
        }
        for (Arc rArc : rgraph.getArcsSet()) {
            Node linverseSource = (Node)rmorph.getImage(rArc.getSource());
            Node linverseTarget = (Node)rmorph.getImage(rArc.getTarget());
            Arc linverseArc = null;
            try {
                linverseArc = linverse.createArc(rArc.getType(), linverseSource, linverseTarget);
                rmorph.addMapping(rArc, linverseArc);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        for (Arc lArc : lgraph.getArcsSet()) {
            Node rinverseSource = (Node)lmorph.getImage(lArc.getSource());
            Node rinverseTarget = (Node)lmorph.getImage(lArc.getTarget());
            Arc rinverseArc = null;
            try {
                rinverseArc = rinverse.createArc(lArc.getType(), rinverseSource, rinverseTarget);
                lmorph.addMapping(lArc, rinverseArc);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            GraphObject ra = this.getImage(lArc);
            if (ra == null) continue;
            inverse.addMapping(rmorph.getImage(ra), rinverseArc);
        }
        return inverse;
    }

    public Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>> invertComplex() {
        if (!this.isInjective()) {
            return null;
        }
        Rule inverse = new Rule();
        Graph lgraph = this.getLeft();
        Graph rgraph = this.getRight();
        Graph linverse = inverse.getLeft();
        Graph rinverse = inverse.getRight();
        OrdinaryMorphism lmorph = new OrdinaryMorphism(lgraph, rinverse);
        OrdinaryMorphism rmorph = new OrdinaryMorphism(rgraph, linverse);
        for (Node rNode : rgraph.getNodesSet()) {
            Node linverseNode = null;
            try {
                linverseNode = linverse.createNode(rNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            rmorph.addMapping(rNode, linverseNode);
        }
        for (Node lNode : lgraph.getNodesSet()) {
            Node rinverseNode = null;
            try {
                rinverseNode = rinverse.createNode(lNode.getType());
            }
            catch (TypeException e) {
                e.printStackTrace();
            }
            lmorph.addMapping(lNode, rinverseNode);
            GraphObject rn = this.getImage(lNode);
            if (rn == null) continue;
            inverse.addMapping(rmorph.getImage(rn), rinverseNode);
        }
        for (Arc rArc : rgraph.getArcsSet()) {
            Node linverseSource = (Node)rmorph.getImage(rArc.getSource());
            Node linverseTarget = (Node)rmorph.getImage(rArc.getTarget());
            Arc linverseArc = null;
            try {
                linverseArc = linverse.createArc(rArc.getType(), linverseSource, linverseTarget);
                rmorph.addMapping(rArc, linverseArc);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        for (Arc lArc : lgraph.getArcsSet()) {
            Node rinverseSource = (Node)lmorph.getImage(lArc.getSource());
            Node rinverseTarget = (Node)lmorph.getImage(lArc.getTarget());
            Arc rinverseArc = null;
            try {
                rinverseArc = rinverse.createArc(lArc.getType(), rinverseSource, rinverseTarget);
                lmorph.addMapping(lArc, rinverseArc);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            GraphObject ra = this.getImage(lArc);
            if (ra == null) continue;
            inverse.addMapping(rmorph.getImage(ra), rinverseArc);
        }
        Pair<OrdinaryMorphism, OrdinaryMorphism> information = new Pair<OrdinaryMorphism, OrdinaryMorphism>(lmorph, rmorph);
        return new Pair<Rule, Pair<OrdinaryMorphism, OrdinaryMorphism>>(inverse, information);
    }

    public RuleScheme getRuleScheme() {
        return null;
    }

    public Match getMatch() {
        return this.itsMatch;
    }

    public boolean compareConstantAttributeValue(GraphObject src, GraphObject tgt) {
        boolean result = true;
        if (src.getAttribute() != null && tgt.getAttribute() != null) {
            ValueTuple tgtValue = (ValueTuple)tgt.getAttribute();
            ValueTuple srcValue = (ValueTuple)src.getAttribute();
            int i = 0;
            while (i < srcValue.getNumberOfEntries()) {
                ValueMember lhsvm = srcValue.getValueMemberAt(i);
                ValueMember tgtvm = tgtValue.getValueMemberAt(lhsvm.getName());
                if (lhsvm.isSet() && lhsvm.getExpr().isConstant() && tgtvm != null && tgtvm.isSet() && !lhsvm.getExprAsText().equals(tgtvm.getExprAsText())) {
                    result = false;
                    tgtvm.setExpr(null);
                }
                ++i;
            }
        }
        return result;
    }

    public boolean compareConstAttrValueOfMapObjs(GraphObject src, GraphObject tgt) {
        if (src.getAttribute() != null && tgt.getAttribute() != null) {
            ValueTuple tgtValue = (ValueTuple)tgt.getAttribute();
            ValueTuple srcValue = (ValueTuple)src.getAttribute();
            int i = 0;
            while (i < srcValue.getNumberOfEntries()) {
                ValueMember srcvm = srcValue.getValueMemberAt(i);
                ValueMember tgtvm = tgtValue.getValueMemberAt(srcvm.getName());
                if (srcvm.isSet() && srcvm.getExpr().isConstant() && tgtvm.isSet() && !srcvm.getExprAsText().equals(tgtvm.getExprAsText())) {
                    tgtvm.setExpr(null);
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean compareTo(Rule r) {
        CondTuple condOther;
        VarTuple varOther;
        Pair<Boolean, String> errMsgHolder = null;
        if (!this.compareTo((OrdinaryMorphism)r)) {
            errMsgHolder = new Pair<Boolean, String>(true, "Rule content is different.");
            return false;
        }
        errMsgHolder = this.compareApplConds(this.getNACsList(), r.getNACsList(), "NAC");
        if (errMsgHolder != null) {
            return false;
        }
        errMsgHolder = this.compareApplConds(this.getPACsList(), r.getPACsList(), "PAC");
        if (errMsgHolder != null) {
            return false;
        }
        errMsgHolder = this.compareApplConds(this.getNestedACsList(), r.getNestedACsList(), "nested AC");
        if (errMsgHolder != null) {
            return false;
        }
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        if (!var.compareTo(varOther = (VarTuple)r.getAttrContext().getVariables())) {
            errMsgHolder = new Pair<Boolean, String>(true, "Variable rule context is different.");
            return false;
        }
        CondTuple cond = (CondTuple)this.getAttrContext().getConditions();
        if (!cond.compareTo(condOther = (CondTuple)r.getAttrContext().getConditions())) {
            errMsgHolder = new Pair<Boolean, String>(true, "Conditional rule context is different.");
            return false;
        }
        return true;
    }

    private Pair<Boolean, String> compareApplConds(List<OrdinaryMorphism> applConds, List<OrdinaryMorphism> otherApplConds, String what) {
        Vector<OrdinaryMorphism> another = new Vector<OrdinaryMorphism>();
        another.addAll(otherApplConds);
        if (applConds.size() != another.size()) {
            Pair<Boolean, String> errMsgHolder = new Pair<Boolean, String>(true, "Number of " + what + "s is different.");
            return errMsgHolder;
        }
        OrdinaryMorphism ac = null;
        int i = 0;
        while (i < applConds.size()) {
            ac = applConds.get(i);
            int j = another.size() - 1;
            while (j >= 0) {
                OrdinaryMorphism ac1 = (OrdinaryMorphism)another.elementAt(j);
                if (ac.compareTo(ac1)) {
                    another.remove(ac1);
                    break;
                }
                --j;
            }
            ++i;
        }
        if (another.size() != 0 && ac != null) {
            Pair<Boolean, String> errMsgHolder = new Pair<Boolean, String>(true, String.valueOf(what) + ":  " + ac.getName() + "  is different.");
            return errMsgHolder;
        }
        return null;
    }

    public List<GraphObject> getInputParameterObjectsLeft(List<String> inputParams) {
        return this.getInputParameterObjects(this.getLeft(), inputParams);
    }

    public List<GraphObject> getInputParameterObjectsRight(List<String> inputParams) {
        return this.getInputParameterObjects(this.getRight(), inputParams);
    }

    private List<GraphObject> getInputParameterObjects(Graph g, List<String> inputParams) {
        Vector<GraphObject> goIP = new Vector<GraphObject>();
        Enumeration<GraphObject> elems = g.getElements();
        while (elems.hasMoreElements()) {
            GraphObject go = elems.nextElement();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < val.getNumberOfEntries()) {
                ValueMember mem = val.getEntryAt(i);
                if (mem.isSet() && mem.getExpr().isVariable() && inputParams.contains(mem.getExprAsText())) {
                    goIP.add(go);
                }
                ++i;
            }
        }
        return goIP;
    }

    public List<GraphObject> getLeftInputParameterObjects() {
        Vector<GraphObject> list = new Vector<GraphObject>();
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        Enumeration<GraphObject> elems = this.itsOrig.getElements();
        while (elems.hasMoreElements()) {
            GraphObject go = elems.nextElement();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < val.getNumberOfEntries()) {
                ValueMember mem = val.getValueMemberAt(i);
                if (mem.isSet() && mem.getExpr().isVariable() && var.getVarMemberAt(mem.getExprAsText()) != null && var.getVarMemberAt(mem.getExprAsText()).isInputParameter()) {
                    list.add(go);
                }
                ++i;
            }
        }
        return list;
    }

    public List<GraphObject> getRightInputParameterObjects() {
        Vector<GraphObject> list = new Vector<GraphObject>();
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        Enumeration<GraphObject> elems = this.itsImag.getElements();
        while (elems.hasMoreElements()) {
            GraphObject go = elems.nextElement();
            if (go.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < val.getNumberOfEntries()) {
                ValueMember mem = val.getValueMemberAt(i);
                if (mem.isSet() && mem.getExpr().isVariable() && var.getVarMemberAt(mem.getExprAsText()) != null && var.getVarMemberAt(mem.getExprAsText()).isInputParameter()) {
                    list.add(go);
                }
                ++i;
            }
        }
        return list;
    }

    public Vector<String> getInputParameterNames() {
        Vector<String> inputParams = new Vector<String>(1);
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < var.getNumberOfEntries()) {
            VarMember varm = var.getVarMemberAt(i);
            if (varm.isInputParameter()) {
                inputParams.add(varm.getName());
            }
            ++i;
        }
        return inputParams;
    }

    public Vector<VarMember> getInputParameters() {
        Vector<VarMember> inputParams = new Vector<VarMember>(1);
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < var.getNumberOfEntries()) {
            VarMember varm = var.getVarMemberAt(i);
            if (varm.isInputParameter()) {
                inputParams.addElement(varm);
            }
            ++i;
        }
        return inputParams;
    }

    public Vector<VarMember> getInputParametersLeft() {
        Vector<VarMember> inputParams = new Vector<VarMember>(1);
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < var.getNumberOfEntries()) {
            VarMember vm = var.getVarMemberAt(i);
            if (vm.isInputParameter() && vm.getMark() == 0) {
                inputParams.addElement(vm);
            }
            ++i;
        }
        return inputParams;
    }

    public Vector<VarMember> getInputParametersRight() {
        Vector<VarMember> inputParams = new Vector<VarMember>(1);
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < var.getNumberOfEntries()) {
            VarMember vm = var.getVarMemberAt(i);
            if (vm.isInputParameter() && (vm.getMark() == 1 || vm.getMark() == 2)) {
                inputParams.addElement(vm);
            }
            ++i;
        }
        return inputParams;
    }

    public Vector<VarMember> getInputParametersOfGraphObject(GraphObject go, VarTuple var) {
        if (go.getAttribute() == null) {
            return new Vector<VarMember>();
        }
        Vector<VarMember> inputParams = new Vector<VarMember>(1);
        ValueTuple attrVal = (ValueTuple)go.getAttribute();
        int i = 0;
        while (i < attrVal.getNumberOfEntries()) {
            VarMember varm;
            ValueMember vm = attrVal.getValueMemberAt(i);
            if (vm.isSet() && vm.getExpr().isVariable() && (varm = var.getVarMemberAt(vm.getExprAsText())) != null && varm.isInputParameter()) {
                inputParams.addElement(varm);
            }
            ++i;
        }
        return inputParams;
    }

    public Vector<VarMember> getNonInputParametersOfNewGraphObjects() {
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        Vector<VarMember> params = new Vector<VarMember>(1);
        Enumeration<GraphObject> objs = this.itsImag.getElements();
        while (objs.hasMoreElements()) {
            GraphObject go = objs.nextElement();
            if (go.getAttribute() == null || this.itsCodomObjects.contains(go)) continue;
            ValueTuple attrVal = (ValueTuple)go.getAttribute();
            int i = 0;
            while (i < attrVal.getNumberOfEntries()) {
                VarMember varm;
                ValueMember vm = attrVal.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable() && (varm = var.getVarMemberAt(vm.getExprAsText())) != null && !varm.isInputParameter()) {
                    params.addElement(varm);
                }
                ++i;
            }
        }
        return params;
    }

    public Vector<VarMember> getNonInputParameters() {
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        Vector<VarMember> params = new Vector<VarMember>(1);
        int i = 0;
        while (i < var.getNumberOfEntries()) {
            VarMember v = var.getVarMemberAt(i);
            if (!v.isInputParameter()) {
                params.addElement(v);
            }
            ++i;
        }
        return params;
    }

    public boolean areNACsValid() {
        return true;
    }

    public boolean isNACValid(OrdinaryMorphism nac) {
        return true;
    }

    public boolean isACShiftPossible(OrdinaryMorphism ac) {
        for (Arc a : ac.getTarget().getArcsCollection()) {
            if (ac.getInverseImage(a).hasMoreElements()) continue;
            if (ac.getInverseImage(a.getSource()).hasMoreElements() && this.getImage(ac.getInverseImage(a.getSource()).nextElement()) == null) {
                return false;
            }
            if (!ac.getInverseImage(a.getTarget()).hasMoreElements() || this.getImage(ac.getInverseImage(a.getTarget()).nextElement()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isPACValid(OrdinaryMorphism ac) {
        if (ac.isEnabled()) {
            for (Node x : this.itsOrig.getNodesSet()) {
                Node y;
                if (this.getImage(x) != null || (y = (Node)ac.getImage(x)) == null || x.getNumberOfArcs() == y.getNumberOfArcs()) continue;
                this.setErrorMsg(String.valueOf(ac.getName()) + "  -  PAC failed (dangling edge)");
                return false;
            }
        }
        return true;
    }

    public boolean arePACsValid() {
        int i = 0;
        while (i < this.itsPACs.size()) {
            OrdinaryMorphism ac = this.itsPACs.get(i);
            if (!this.isPACValid(ac)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGACValid(NestedApplCond ac) {
        if (ac.isEnabled()) {
            return ac.isValid();
        }
        return true;
    }

    public boolean areGACsValid() {
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (!this.isGACValid(ac)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean areApplCondsValid() {
        OrdinaryMorphism ac;
        int i = 0;
        while (i < this.itsPACs.size()) {
            ac = this.itsPACs.get(i);
            if (!this.isPACValid(ac)) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < this.itsACs.size()) {
            ac = (NestedApplCond)this.itsACs.get(i);
            if (!((NestedApplCond)ac).isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean extendByPacs() {
        int i = 0;
        while (i < this.itsPACs.size()) {
            OrdinaryMorphism pac = this.itsPACs.get(i);
            if (pac.isEnabled()) {
                this.extendByPac(pac);
                pac.setEnabled(false);
            }
            ++i;
        }
        return true;
    }

    private boolean extendByPac(OrdinaryMorphism pac) {
        Hashtable<Node, Node> n2n = new Hashtable<Node, Node>();
        for (Node pn : pac.getTarget().getNodesCollection()) {
            Enumeration<GraphObject> en = pac.getInverseImage(pn);
            if (!en.hasMoreElements()) {
                try {
                    Node nln = this.itsOrig.copyNode(pn);
                    n2n.put(pn, nln);
                    Node nrn = this.itsImag.copyNode(pn);
                    n2n.put(nln, nrn);
                    try {
                        this.addMapping(nln, nrn);
                        nln.setContextUsage(pac.hashCode());
                        nrn.setContextUsage(pac.hashCode());
                        continue;
                    }
                    catch (BadMappingException ex1) {
                        return false;
                    }
                }
                catch (TypeException ex) {
                    return false;
                }
            }
            if (!en.hasMoreElements()) continue;
            Node ln = (Node)en.nextElement();
            n2n.put(pn, ln);
            Node rn = (Node)this.getImage(ln);
            if (rn == null) continue;
            n2n.put(ln, rn);
        }
        for (Arc pa : pac.getTarget().getArcsCollection()) {
            Enumeration<GraphObject> en = pac.getInverseImage(pa);
            if (en.hasMoreElements()) continue;
            try {
                Node srcl = (Node)n2n.get(pa.getSource());
                Node tarl = (Node)n2n.get(pa.getTarget());
                if (srcl == null || tarl == null) continue;
                Arc nla = this.getOriginal().copyArc(pa, srcl, tarl);
                Node srcr = (Node)n2n.get(srcl);
                Node tarr = (Node)n2n.get(tarl);
                if (srcr == null || tarr == null) continue;
                Arc nra = this.getImage().copyArc(pa, srcr, tarr);
                if (nla == null || nra == null) continue;
                try {
                    this.addMapping(nla, nra);
                    nla.setContextUsage(pac.hashCode());
                    nra.setContextUsage(pac.hashCode());
                }
                catch (BadMappingException ex1) {
                    return false;
                }
            }
            catch (TypeException ex) {
                return false;
            }
        }
        return true;
    }

    public boolean extendByPacsUndo() {
        int i = 0;
        while (i < this.itsPACs.size()) {
            OrdinaryMorphism pac = this.itsPACs.get(i);
            if (this.extendByPacUndo(pac)) {
                pac.setEnabled(true);
            }
            ++i;
        }
        return true;
    }

    private boolean extendByPacUndo(OrdinaryMorphism pac) {
        boolean res = false;
        for (Arc aL : this.itsOrig.getArcsCollection()) {
            if (aL.getContextUsage() != pac.hashCode()) continue;
            Arc aR = (Arc)this.getImage(aL);
            this.removeMapping(aL, aR);
            try {
                this.itsImag.destroyArc(aR);
                this.itsOrig.destroyArc(aL);
                res = true;
            }
            catch (TypeException ex) {
                String string = ex.getLocalizedMessage();
            }
        }
        for (Node nL : this.itsOrig.getNodesCollection()) {
            if (nL.getContextUsage() != pac.hashCode()) continue;
            Node nR = (Node)this.getImage(nL);
            this.removeMapping(nL, nR);
            try {
                this.itsImag.destroyNode(nR);
                this.itsOrig.destroyNode(nL);
                res = true;
            }
            catch (TypeException ex) {
                String string = ex.getLocalizedMessage();
            }
        }
        return res;
    }

    public void adjustAttrContextOfMatch(boolean inputParameterOnly) {
        if (this.itsMatch != null) {
            this.itsMatch.adjustAttrInputParameter(inputParameterOnly);
            this.itsMatch.adjustAttrCondition();
        }
    }

    public void unsetValueOfContextVariable(boolean inputParameterOnly) {
        VarTuple vt = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vt.getNumberOfEntries()) {
            VarMember vm = vt.getVarMemberAt(i);
            if (inputParameterOnly) {
                if (vm.isInputParameter()) {
                    vm.setExpr(null);
                }
            } else {
                vm.setExpr(null);
            }
            ++i;
        }
    }

    public void unsetInputParameter() {
        AttrVariableTuple avt = this.getAttrContext().getVariables();
        int i = 0;
        while (i < avt.getNumberOfEntries()) {
            VarMember vm = (VarMember)avt.getMemberAt(i);
            if (vm.isInputParameter()) {
                vm.setInputParameter(false);
            }
            ++i;
        }
    }

    public String getInputParameterWithoutValue() {
        AttrVariableTuple avt = this.getAttrContext().getVariables();
        int i = 0;
        while (i < avt.getNumberOfEntries()) {
            VarMember vm = (VarMember)avt.getMemberAt(i);
            if (vm.isInputParameter() && !vm.isSet()) {
                return vm.getName();
            }
            ++i;
        }
        return null;
    }

    public String getInputParameterWithoutValue(boolean left) {
        AttrVariableTuple avt = this.getAttrContext().getVariables();
        int i = 0;
        while (i < avt.getNumberOfEntries()) {
            VarMember vm = (VarMember)avt.getMemberAt(i);
            if (vm.isInputParameter() && !vm.isSet()) {
                int k;
                Vector<String> vars;
                int j;
                Vector<String> vars2;
                if (left) {
                    vars2 = this.getLeft().getVariableNamesOfAttributes();
                    j = 0;
                    while (j < vars2.size()) {
                        if (vars2.get(j).equals(vm.getName())) {
                            return vm.getName();
                        }
                        ++j;
                    }
                } else {
                    vars2 = this.getRight().getVariableNamesOfAttributes();
                    j = 0;
                    while (j < vars2.size()) {
                        if (vars2.get(j).equals(vm.getName())) {
                            return vm.getName();
                        }
                        ++j;
                    }
                }
                int j2 = 0;
                while (j2 < this.itsNACs.size()) {
                    OrdinaryMorphism nac = this.itsNACs.get(j2);
                    vars = nac.getTarget().getVariableNamesOfAttributes();
                    k = 0;
                    while (k < vars.size()) {
                        if (vars.get(k).equals(vm.getName())) {
                            return vm.getName();
                        }
                        ++k;
                    }
                    ++j2;
                }
                j2 = 0;
                while (j2 < this.itsPACs.size()) {
                    OrdinaryMorphism pac = this.itsPACs.get(j2);
                    vars = pac.getTarget().getVariableNamesOfAttributes();
                    k = 0;
                    while (k < vars.size()) {
                        if (vars.get(k).equals(vm.getName())) {
                            return vm.getName();
                        }
                        ++k;
                    }
                    ++j2;
                }
                j2 = 0;
                while (j2 < this.itsACs.size()) {
                    OrdinaryMorphism ac = this.itsACs.get(j2);
                    vars = ac.getTarget().getVariableNamesOfAttributes();
                    k = 0;
                    while (k < vars.size()) {
                        if (vars.get(k).equals(vm.getName())) {
                            return vm.getName();
                        }
                        ++k;
                    }
                    ++j2;
                }
            }
            ++i;
        }
        return null;
    }

    private void deleteUnusedVars(Vector<VarMember> used) {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember vm = vars.getVarMemberAt(i);
            if (!used.contains(vm)) {
                vars.getTupleType().deleteMemberAt(vm.getName());
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReadyToTransform() {
        void var3_5;
        this.isReady = true;
        if (!this.enabled) {
            return true;
        }
        Vector<String> abstractTypesOfRHS = new Vector<String>(1);
        for (GraphObject graphObject : this.itsImag.getNodesSet()) {
            Enumeration<GraphObject> inverse = this.getInverseImage(graphObject);
            if (inverse.hasMoreElements() || !graphObject.getType().isAbstract()) continue;
            abstractTypesOfRHS.add(graphObject.getType().getName());
        }
        this.isReady = abstractTypesOfRHS.isEmpty();
        if (!this.isReady) {
            this.errorMsg = this.errorMsg.concat("RHS: creating abstract nodes not allowed!  ").concat(abstractTypesOfRHS.toString());
            return false;
        }
        boolean bl = false;
        while (var3_5 < this.itsPACs.size()) {
            this.isReady = this.isPACValid(this.itsPACs.get((int)var3_5));
            if (!this.isReady) {
                return false;
            }
            ++var3_5;
        }
        if (!this.isAttributed()) {
            return true;
        }
        this.applyDefaultAttrValuesOfTypeGraph(this.itsImag);
        AttrVariableTuple attrVariableTuple = this.itsAttrContext.getVariables();
        AttrConditionTuple act = this.itsAttrContext.getConditions();
        this.errorMsg = "";
        Vector<Pair<String, String>> varDecls = this.getVariableDeclarations();
        int l2 = 0;
        while (l2 < this.itsNACs.size()) {
            this.addVarDecl(this.itsNACs.get(l2).getImage(), varDecls);
            ++l2;
        }
        int l = 0;
        while (l < this.itsPACs.size()) {
            this.addVarDecl(this.itsPACs.get(l).getImage(), varDecls);
            ++l;
        }
        l = 0;
        while (l < this.itsACs.size()) {
            this.addVarDecl(this.itsACs.get(l).getImage(), varDecls);
            ++l;
        }
        this.isReady = this.checkDoubleVarDecl(varDecls);
        if (!this.isReady) {
            return false;
        }
        this.isReady = this.checkUsedVariables(attrVariableTuple, varDecls);
        if (!this.isReady) {
            return false;
        }
        this.markUsedVariables(attrVariableTuple);
        this.isReady = this.markAttrConditions(attrVariableTuple, act);
        if (!this.isReady) {
            return false;
        }
        this.prepareRuleInfo();
        if (this.itsMatch != null) {
            if (this.itsMatch.getRule() == this) {
                this.itsMatch.adjustAttrCondition();
            } else {
                this.itsMatch.dispose();
                this.itsMatch = null;
            }
        }
        this.isReady = this.checkAttributesOfNewObjects(attrVariableTuple);
        if (!this.isReady) {
            return false;
        }
        return this.isReady;
    }

    public boolean nacIsUsingVariable(VarMember var, AttrConditionTuple act) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            OrdinaryMorphism nac = this.itsNACs.get(i);
            if (nac.getTarget().isUsingVariable(var)) {
                return true;
            }
            Vector<String> nacVars = nac.getTarget().getVariableNamesOfAttributes();
            int j = 0;
            while (j < nacVars.size()) {
                String varName = nacVars.get(j);
                int k = 0;
                while (k < act.getNumberOfEntries()) {
                    CondMember cond = (CondMember)act.getMemberAt(k);
                    Vector<String> condVars = cond.getAllVariables();
                    if (condVars.contains(varName) && condVars.contains(var.getName())) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean pacIsUsingVariable(VarMember var, AttrConditionTuple act) {
        int i = 0;
        while (i < this.itsPACs.size()) {
            OrdinaryMorphism pac = this.itsPACs.get(i);
            if (pac.getTarget().isUsingVariable(var)) {
                return true;
            }
            Vector<String> pacVars = pac.getTarget().getVariableNamesOfAttributes();
            int j = 0;
            while (j < pacVars.size()) {
                String varName = pacVars.get(j);
                int k = 0;
                while (k < act.getNumberOfEntries()) {
                    CondMember cond = (CondMember)act.getMemberAt(k);
                    Vector<String> condVars = cond.getAllVariables();
                    if (condVars.contains(varName) && condVars.contains(var.getName())) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    protected void applyDefaultAttrValuesOfTypeGraph(Graph g, Iterator<?> iter) {
        boolean right = g == this.getRight();
        while (iter.hasNext()) {
            GraphObject o = (GraphObject)iter.next();
            if (o.getAttribute() == null) {
                if (o.getType().getAttrType() == null || o.getType().getAttrType().getNumberOfEntries() == 0) continue;
                o.createAttributeInstance();
            }
            if (!right || this.getInverseImage(o).hasMoreElements()) continue;
            if (o.isNode()) {
                g.applyDefaultAttrValuesOfTypeGraph((Node)o, null);
                continue;
            }
            g.applyDefaultAttrValuesOfTypeGraph((Arc)o, null);
        }
    }

    public void applyDefaultAttrValuesOfTypeGraph(Graph g) {
        this.applyDefaultAttrValuesOfTypeGraph(g, g.getNodesSet().iterator());
        this.applyDefaultAttrValuesOfTypeGraph(g, g.getArcsSet().iterator());
    }

    protected boolean isAttributed() {
        boolean attributed = this.itsOrig.isAttributed() || this.itsImag.isAttributed();
        int l = 0;
        while (!attributed && l < this.itsNACs.size()) {
            attributed = this.itsNACs.get(l).getImage().isAttributed();
            ++l;
        }
        l = 0;
        while (!attributed && l < this.itsPACs.size()) {
            attributed = this.itsPACs.get(l).getImage().isAttributed();
            ++l;
        }
        l = 0;
        while (!attributed && l < this.itsACs.size()) {
            attributed = this.itsACs.get(l).getImage().isAttributed();
            ++l;
        }
        return attributed;
    }

    private void addVarDecl(Graph g, Vector<Pair<String, String>> varDecls) {
        this.addVarDecl(g.getNodesSet().iterator(), varDecls);
        this.addVarDecl(g.getArcsSet().iterator(), varDecls);
    }

    private void addVarDecl(Iterator<?> elems, Vector<Pair<String, String>> varDecls) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null) continue;
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    String n = vm.getExprAsText();
                    String t = vm.getDeclaration().getTypeName();
                    Pair<String, String> p = new Pair<String, String>(t, n);
                    boolean found = false;
                    int j = 0;
                    while (j < varDecls.size()) {
                        Pair<String, String> pj = varDecls.elementAt(j);
                        if (t.equals(pj.first) && n.equals(pj.second)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (!found) {
                        varDecls.addElement(p);
                    }
                }
                ++k;
            }
        }
    }

    private boolean checkDoubleVarDecl(Vector<Pair<String, String>> varDecls) {
        boolean result = true;
        int j = 0;
        while (result && j < varDecls.size()) {
            Pair<String, String> pj = varDecls.elementAt(j);
            int jj = j + 1;
            while (result && jj < varDecls.size()) {
                Pair<String, String> pjj = varDecls.elementAt(jj);
                if (!(!((String)pj.second).equals(pjj.second) || ((String)pj.first).equals(pjj.first) || "Object".equals(pj.first) || "java.lang.Object".equals(pj.first) || "Object".equals(pjj.first) || "java.lang.Object".equals(pjj.first))) {
                    this.errorMsg = "Variable has multiple declaration : ".concat((String)pj.second);
                    result = false;
                }
                ++jj;
            }
            ++j;
        }
        return result;
    }

    private boolean checkAttributesOfNewObjects(AttrVariableTuple avt) {
        return this.checkAttrsOfNewObjs(avt, this.itsImag.getNodesSet().iterator()) && this.checkAttrsOfNewObjs(avt, this.itsImag.getArcsSet().iterator());
    }

    private boolean checkAttrsOfNewObjs(AttrVariableTuple avt, Iterator<?> elems) {
        boolean result = true;
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (this.itsCodomObjects.contains(o)) continue;
            if (o.getAttribute() == null) {
                if (o.getType().getAttrType() == null || o.getType().getAttrType().getNumberOfEntries() == 0) continue;
                this.errorMsg = "Type: <".concat(o.getType().getName()).concat(">  -  attribute not set.");
                return false;
            }
            AttrInstance attr = o.getAttribute();
            ValueTuple typeObjectAttr = null;
            if (o instanceof Node) {
                Node typeNode = o.getType().getTypeGraphNodeObject();
                if (typeNode != null) {
                    typeObjectAttr = (ValueTuple)typeNode.getAttribute();
                }
            } else {
                Arc typeEdge = o.getType().getTypeGraphArcObject(((Arc)o).getSourceType(), ((Arc)o).getTargetType());
                if (typeEdge != null) {
                    typeObjectAttr = (ValueTuple)typeEdge.getAttribute();
                }
            }
            ValueTuple vt = (ValueTuple)attr;
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.isSet()) {
                    if (vm.getExpr().isVariable()) {
                        Vector<String> leftVars;
                        VarMember var = avt.getVarMemberAt(vm.getExprAsText());
                        if (var == null) {
                            this.errorMsg = "Variable :  ";
                            this.errorMsg = this.errorMsg.concat(vm.getExprAsText());
                            this.errorMsg = this.errorMsg.concat("   is not declared.");
                            return false;
                        }
                        if (!var.isInputParameter() && vm.getExpr() == null && !(leftVars = this.itsOrig.getVariableNamesOfAttributes()).contains(var.getName())) {
                            this.errorMsg = "Variable :  ";
                            this.errorMsg = this.errorMsg.concat(var.getName());
                            this.errorMsg = this.errorMsg.concat("   in the RHS of the rule should be an input parameter");
                            this.errorMsg = this.errorMsg.concat("\nor already declared in the LHS.");
                            return false;
                        }
                    } else if (vm.getExpr().isComplex()) {
                        if (!vm.isValid()) {
                            this.errorMsg = "Not all attributes of the RHS are correct.\nPlease check expression :  ";
                            this.errorMsg = this.errorMsg.concat(vm.getExprAsText());
                            return false;
                        }
                        Vector<String> vec = vm.getAllVariableNamesOfExpression();
                        Vector<String> vecLeft = this.itsOrig.getVariableNamesOfAttributes();
                        int l = 0;
                        while (l < vec.size()) {
                            VarMember m;
                            String n = vec.elementAt(l);
                            boolean found = false;
                            int ll = 0;
                            while (ll < vecLeft.size()) {
                                String nn = vecLeft.elementAt(ll);
                                if (n.equals(nn)) {
                                    found = true;
                                }
                                ++ll;
                            }
                            if (!(found || (m = avt.getVarMemberAt(n)) == null || m.isSet() || m.isInputParameter())) {
                                this.errorMsg = "Not all attributes in the RHS of the rule are correct.";
                                this.errorMsg = this.errorMsg.concat("\nPlease check variable :  ");
                                this.errorMsg = this.errorMsg.concat(n);
                                return false;
                            }
                            ++l;
                        }
                    }
                } else {
                    ValueMember tnvm;
                    boolean failed = true;
                    if (typeObjectAttr != null && (tnvm = typeObjectAttr.getValueMemberAt(vm.getName())) != null && tnvm.isSet()) {
                        vm.setExprAsText(tnvm.getExprAsText());
                        if (vm.isSet()) {
                            failed = false;
                        }
                    }
                    if (failed) {
                        if (vm.getDeclaration().getType() == null) {
                            vm.setExprAsText("null");
                        } else if (!this.getTypeSet().isEmptyAttrAllowed()) {
                            this.errorMsg = "Not all attributes in the RHS of the rule are set.";
                            return false;
                        }
                    }
                }
                ++k;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkUsedVariables(AttrVariableTuple avt, Vector<Pair<String, String>> varDecls) {
        Vector<VarMember> used = new Vector<VarMember>(5);
        boolean result = true;
        int i = 0;
        while (i < varDecls.size()) {
            VarMember varm;
            block14: {
                String varName;
                String typeName2;
                boolean isClass2;
                boolean isClass1;
                String typeName1;
                block15: {
                    Pair<String, String> p = varDecls.elementAt(i);
                    typeName1 = (String)p.first;
                    isClass1 = false;
                    String className1 = this.isClassName(typeName1);
                    if (className1 != null) {
                        isClass1 = true;
                    }
                    isClass2 = false;
                    String className2 = null;
                    typeName2 = "";
                    varName = (String)p.second;
                    varm = ((VarTuple)avt).getVarMemberAt(varName);
                    if (varm == null) {
                        className2 = this.isClassName(varName);
                        if (className2 != null) {
                            typeName2 = className2;
                        }
                    } else {
                        if (varm.getDeclaration() == null) {
                            this.errorMsg = "Variable: ".concat(varName).concat("  isn't declared!");
                            return false;
                        }
                        typeName2 = varm.getDeclaration().getTypeName();
                        className2 = this.isClassName(typeName2);
                    }
                    if (className2 != null) {
                        isClass2 = true;
                    }
                    if (className1 == null || className2 == null) break block15;
                    if (!className1.equals(className2)) {
                        if (!className1.equals("java.lang.Object") && !className2.equals("java.lang.Object")) {
                            this.errorMsg = "Variable: " + varName + "  has wrong type." + "\nIt should be :  " + className1 + " .";
                            return false;
                        }
                        break block14;
                    } else if (!typeName1.equals(typeName2)) {
                        String packageName = className1.substring(0, className1.lastIndexOf("."));
                        if (packageName.equals("java.lang") && varm != null) {
                            varm.getDeclaration().setType(typeName1);
                            break block14;
                        } else {
                            this.errorMsg = "Variable: " + varName + "  has wrong type." + "\nIt should be :  " + typeName1 + " .";
                            return false;
                        }
                    }
                    break block14;
                }
                if (!(isClass1 || isClass2 || typeName1.equals(typeName2))) {
                    this.errorMsg = "Variable: " + varName + "  has wrong type." + "\nIt should be :  " + typeName1 + " .";
                    return false;
                }
            }
            used.add(varm);
            ++i;
        }
        this.deleteUnusedVars(used);
        return result;
    }

    private boolean markAttrConditions(AttrVariableTuple avt, AttrConditionTuple act) {
        boolean result = true;
        int k = 0;
        while (k < ((CondTuple)act).getSize()) {
            CondMember cm = ((CondTuple)act).getCondMemberAt(k);
            if (cm.getExpr() == null) {
                this.errorMsg = "Condition:  " + cm + "  is not defined.";
                return false;
            }
            if (!cm.isValid()) {
                this.errorMsg = "Condition:  " + cm + "  is not valid.\nPlease check variables of it.";
                return false;
            }
            Vector<String> vars = cm.getAllVariables();
            if (!vars.isEmpty()) {
                boolean mixedNAC = false;
                boolean mixedPAC = false;
                boolean mixed = false;
                String name0 = vars.elementAt(0);
                if (((VarTuple)avt).isDeclared(name0)) {
                    VarMember var0 = avt.getVarMemberAt(vars.elementAt(0));
                    int mark = var0.getMark();
                    int j = 1;
                    while (j < vars.size()) {
                        String name = vars.elementAt(j);
                        if (((VarTuple)avt).isDeclared(name)) {
                            VarMember var = avt.getVarMemberAt(name);
                            if (mark == 0) {
                                if (var.getMark() == 2) {
                                    mixedNAC = true;
                                } else if (var.getMark() == 3) {
                                    mixedPAC = true;
                                }
                            } else if (mark == 2) {
                                if (var.getMark() == 0) {
                                    mixedNAC = true;
                                } else if (var.getMark() == 3) {
                                    mixed = true;
                                }
                            } else if (mark == 3) {
                                if (var.getMark() == 0) {
                                    mixedPAC = true;
                                } else if (var.getMark() == 2) {
                                    mixed = true;
                                }
                            }
                        } else if (this.isClassName(name) == null) {
                            this.errorMsg = "Variable: " + name + "\nof condition: " + cm.getExprAsText() + "\nis not declared.";
                            return false;
                        }
                        ++j;
                    }
                    if (mixedNAC && mixedPAC) {
                        cm.setMark(23);
                    } else if (mixedNAC) {
                        cm.setMark(21);
                    } else if (mixedPAC) {
                        cm.setMark(31);
                    } else if (mixed) {
                        cm.setMark(22);
                    } else if (mark == 2) {
                        cm.setMark(20);
                    } else if (mark == 3) {
                        cm.setMark(30);
                    } else if (mark == 1) {
                        cm.setMark(1);
                    } else {
                        cm.setMark(0);
                    }
                } else if (this.isClassName(name0) == null) {
                    this.errorMsg = "Variable: " + name0 + "\nof condition: " + cm.getExprAsText() + "\nis not declared.";
                    return false;
                }
            }
            ++k;
        }
        return result;
    }

    private void markUsedVariables(AttrVariableTuple avt) {
        Graph g;
        this.markUsedVars(this.itsImag.getNodesSet().iterator(), this.itsImag.getArcsSet().iterator(), avt, 1);
        int l = 0;
        while (l < this.itsNACs.size()) {
            g = this.itsNACs.get(l).getImage();
            this.markUsedVars(g.getNodesSet().iterator(), g.getArcsSet().iterator(), avt, 2);
            ++l;
        }
        l = 0;
        while (l < this.itsPACs.size()) {
            g = this.itsPACs.get(l).getImage();
            this.markUsedVars(g.getNodesSet().iterator(), g.getArcsSet().iterator(), avt, 3);
            ++l;
        }
        this.markUsedVarsOfNestedACs(this.itsACs, avt);
        this.markUsedVars(this.itsOrig.getNodesSet().iterator(), this.itsOrig.getArcsSet().iterator(), avt, 0);
    }

    private void markUsedVarsOfNestedACs(List<?> nestedACs, AttrVariableTuple avt) {
        int i = 0;
        while (i < nestedACs.size()) {
            OrdinaryMorphism nestAC = (OrdinaryMorphism)nestedACs.get(i);
            Graph g = nestAC.getImage();
            this.markUsedVars(g.getNodesSet().iterator(), g.getArcsSet().iterator(), avt, 3);
            this.markUsedVarsOfNestedACs(((NestedApplCond)nestAC).getNestedACs(), avt);
            ++i;
        }
    }

    private void markUsedVars(Iterator<Node> nodes, Iterator<Arc> arcs, AttrVariableTuple avt, int mark) {
        VarMember var;
        Vector<String> vec;
        VarMember var2;
        ValueMember vm;
        int k;
        ValueTuple vt;
        GraphObject o;
        while (nodes.hasNext()) {
            o = nodes.next();
            if (o.getAttribute() == null) continue;
            vt = (ValueTuple)o.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet()) {
                    if (vm.getExpr().isVariable()) {
                        var2 = avt.getVarMemberAt(vm.getExprAsText());
                        if (var2 != null) {
                            var2.setMark(mark);
                        }
                    } else if (vm.getExpr().isComplex()) {
                        vec = new Vector<String>(3);
                        vm.getExpr().getAllVariables(vec);
                        for (String s : vec) {
                            var = avt.getVarMemberAt(s);
                            if (var == null) continue;
                            var.setMark(mark);
                        }
                    }
                }
                ++k;
            }
        }
        while (arcs.hasNext()) {
            o = arcs.next();
            if (o.getAttribute() == null) continue;
            vt = (ValueTuple)o.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet()) {
                    if (vm.getExpr().isVariable()) {
                        var2 = avt.getVarMemberAt(vm.getExprAsText());
                        if (var2 != null) {
                            var2.setMark(mark);
                        }
                    } else if (vm.getExpr().isComplex()) {
                        vec = new Vector(3);
                        vm.getExpr().getAllVariables(vec);
                        for (String s : vec) {
                            var = avt.getVarMemberAt(s);
                            if (var == null) continue;
                            var.setMark(mark);
                        }
                    }
                }
                ++k;
            }
        }
    }

    public void prepareRuleInfo() {
        this.preserved = this.findElementsToPreserve();
        this.created = this.findElementsToCreate();
        this.deleted = this.findElementsToDelete();
        this.changedPreserved = this.findElementsToChange();
        this.typesWhichNeedMultiplicityCheck = this.findTypesWhichNeedMultiplicityCheck();
        this.hasEnabledGACs = this.hasEnabledACs(true);
        if ("true".equals(this.formStr)) {
            this.setDefaultFormulaTrue();
        } else if ("false".equals(this.formStr)) {
            this.setDefaultFormulaFalse();
        }
    }

    public boolean isEmptyRule() {
        return this.itsOrig.isEmpty() && this.itsImag.isEmpty() && this.itsNACs.isEmpty() && this.itsPACs.isEmpty() && this.itsACs.isEmpty();
    }

    public List<Type> getTypesOfLeftGraph() {
        Vector<Type> list = new Vector<Type>();
        for (Node node : this.getLeft().getNodesSet()) {
            if (list.contains(node.getType())) continue;
            list.add(node.getType());
        }
        for (Arc arc : this.getLeft().getArcsSet()) {
            if (list.contains(arc.getType())) continue;
            list.add(arc.getType());
        }
        return list;
    }

    public List<Type> getTypeOfObjectToDelete() {
        Vector<Type> list = new Vector<Type>();
        for (Node node : this.getLeft().getNodesSet()) {
            if (this.getImage(node) != null || list.contains(node.getType())) continue;
            list.add(node.getType());
        }
        for (Arc arc : this.getLeft().getArcsSet()) {
            if (this.getImage(arc) != null || list.contains(arc.getType())) continue;
            list.add(arc.getType());
        }
        return list;
    }

    public List<Type> getTypeOfObjectToCreate() {
        Vector<Type> list = new Vector<Type>();
        for (GraphObject graphObject : this.getRight().getNodesSet()) {
            if (this.getInverseImage(graphObject).hasMoreElements() || list.contains(graphObject.getType())) continue;
            list.add(graphObject.getType());
        }
        for (GraphObject graphObject : this.getRight().getArcsSet()) {
            if (this.getInverseImage(graphObject).hasMoreElements() || list.contains(graphObject.getType())) continue;
            list.add(graphObject.getType());
        }
        return list;
    }

    public List<String> getTypesWhichNeedMultiplicityCheck() {
        if (this.typesWhichNeedMultiplicityCheck == null) {
            this.typesWhichNeedMultiplicityCheck = this.findTypesWhichNeedMultiplicityCheck();
        }
        this.itsOrig.changed = false;
        this.itsImag.changed = false;
        return this.typesWhichNeedMultiplicityCheck;
    }

    private List<String> findTypesWhichNeedMultiplicityCheck() {
        Vector<String> list = new Vector<String>();
        Vector<GraphObject> list1 = new Vector<GraphObject>();
        list1.addAll(this.getElementsToCreate());
        list1.addAll(this.getElementsToDelete());
        int i = 0;
        while (i < list1.size()) {
            GraphObject go = (GraphObject)list1.get(i);
            String typekey = go.convertToKey();
            if (!list.contains(typekey)) {
                if (go.isNode()) {
                    int min = go.getType().getSourceMin();
                    int max = go.getType().getSourceMax();
                    if (min > 0 || max > 0) {
                        list.add(typekey);
                        Vector<Type> children = go.getType().getChildren();
                        int ch = 0;
                        while (ch < children.size()) {
                            list.add(((Type)children.get(ch)).convertToKey());
                            ++ch;
                        }
                    }
                } else {
                    int srcMin = go.getType().getSourceMin(((Arc)go).getSource().getType(), ((Arc)go).getTarget().getType());
                    int srcMax = go.getType().getSourceMax(((Arc)go).getSource().getType(), ((Arc)go).getTarget().getType());
                    int tarMin = go.getType().getTargetMin(((Arc)go).getSource().getType(), ((Arc)go).getTarget().getType());
                    int tarMax = go.getType().getTargetMax(((Arc)go).getSource().getType(), ((Arc)go).getTarget().getType());
                    if (srcMin > 0 || tarMin > 0 || srcMax > 0 || tarMax > 0) {
                        list.add(typekey);
                    }
                }
            }
            ++i;
        }
        return list;
    }

    public boolean isCreating() {
        boolean bl = this.isCreating = this.itsImag.getSize() > this.getCodomainSize();
        if (this.isCreating) {
            this.created = this.findElementsToCreate();
        }
        return this.isCreating;
    }

    public List<GraphObject> getObjectsToCreate() {
        return this.getElementsToCreate();
    }

    public int getNumberOfObjectsToCreate() {
        return this.getElementsToCreate().size();
    }

    public boolean isDeleting() {
        boolean bl = this.isDeleting = this.itsOrig.getSize() > this.getDomainSize();
        if (this.isDeleting) {
            this.deleted = this.findElementsToDelete();
        }
        return this.isDeleting;
    }

    public boolean isNodeDeleting() {
        this.isNodeDeleting = false;
        if (this.isDeleting) {
            Iterator<Node> en = this.itsOrig.getNodesSet().iterator();
            while (en.hasNext()) {
                if (this.getImage(en.next()) != null) continue;
                this.isNodeDeleting = true;
                break;
            }
        }
        return this.isNodeDeleting;
    }

    public boolean mayCauseDanglingEdge() {
        List<Node> delNodes = this.findNodesToDelete();
        if (delNodes.isEmpty()) {
            return false;
        }
        boolean result = false;
        int i = 0;
        while (i < delNodes.size() && !result) {
            Node n = delNodes.get(i);
            Vector<Arc> inheritedArcs = this.getTypeSet().getInheritedArcs(n.getType());
            if (inheritedArcs.size() > 0) {
                int j = 0;
                while (j < inheritedArcs.size() && !result) {
                    int number;
                    Arc a = inheritedArcs.get(j);
                    if (a.getSourceType().isParentOf(n.getType())) {
                        number = n.getNumberOfOutgoingArcsOfTypeToTargetType(a.getType(), a.getTarget().getType());
                        if (number > 0) {
                            int tarMax = a.getType().getTargetMax(a.getSource().getType(), a.getTarget().getType());
                            if (tarMax != -1 && number != tarMax) {
                                result = true;
                            }
                        } else if (!this.hasNacWhichForbidsArc(a, n)) {
                            result = true;
                        }
                    } else if (a.getTargetType().isParentOf(n.getType())) {
                        number = n.getNumberOfIncomingArcsOfTypeFromSourceType(a.getType(), a.getSource().getType());
                        if (number > 0) {
                            int srcMax = a.getType().getSourceMax(a.getSource().getType(), a.getTarget().getType());
                            if (srcMax != -1 && number != srcMax) {
                                result = true;
                            }
                        } else if (!this.hasNacWhichForbidsArc(a, n)) {
                            result = true;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    private boolean hasNacWhichForbidsArc(Arc typeArc, Node lhsNode) {
        int i = 0;
        while (i < this.itsNACs.size()) {
            OrdinaryMorphism nac = this.itsNACs.get(i);
            if (nac.isEnabled()) {
                for (Arc a : nac.getTarget().getArcsCollection()) {
                    if (nac.getInverseImage(a).hasMoreElements() || a.getType() != typeArc.getType()) continue;
                    Node n = (Node)nac.getImage(lhsNode);
                    if (n == a.getSource()) {
                        return true;
                    }
                    if (n != a.getTarget()) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean isArcDeleting() {
        if (this.isDeleting) {
            Iterator<Arc> en = this.getLeft().getArcsSet().iterator();
            while (en.hasNext()) {
                if (this.getImage(en.next()) != null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isArcDeleting(Node src, Type arct, Node tar) {
        if (this.itsOrig.getNodesSet().contains(src) && this.itsOrig.getNodesSet().contains(tar)) {
            Iterator<Arc> en = src.getOutgoingArcs(arct, tar.getType()).iterator();
            while (en.hasNext()) {
                if (this.getImage(en.next()) != null) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isArcDeleting(Arc a) {
        return this.itsOrig.getArcsSet().contains(a) && this.getImage(a) == null;
    }

    public boolean isArcCreating(Node src, Type arct, Node tar) {
        if (this.isCreating && this.itsOrig.getNodesSet().contains(src) && this.itsOrig.getNodesSet().contains(tar)) {
            for (Arc a : this.itsImag.getArcsSet()) {
                List<GraphObject> inv2;
                List<GraphObject> inv1;
                if (!a.getType().compareTo(arct) || this.getInverseImage(a).hasMoreElements() || !(inv1 = this.getInverseImageList(a.getSource())).contains(src) || !(inv2 = this.getInverseImageList(a.getTarget())).contains(tar)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isArcCreating(Arc a) {
        return !this.getInverseImage(a).hasMoreElements() && this.getInverseImage(a.getSource()).hasMoreElements() && this.getInverseImage(a.getTarget()).hasMoreElements();
    }

    public List<GraphObject> getObjectsToDelete() {
        return this.getElementsToDelete();
    }

    public int getNumberOfObjectsToDelete() {
        return this.getElementsToDelete().size();
    }

    public List<GraphObject> getElementsToPreserve() {
        if (this.preserved == null || this.itsImag.changed) {
            this.preserved = this.findElementsToPreserve();
        }
        return this.preserved;
    }

    @Override
    public List<GraphObject> getElementsToCreate() {
        if (this.created == null || this.itsImag.changed) {
            this.created = this.findElementsToCreate();
        }
        return this.created;
    }

    @Override
    public List<GraphObject> getElementsToDelete() {
        if (this.deleted == null || this.itsOrig.changed) {
            this.deleted = this.findElementsToDelete();
        }
        return this.deleted;
    }

    public Hashtable<GraphObject, GraphObject> getElementsToChange() {
        if (this.changedPreserved == null || this.itsOrig.changed) {
            this.changedPreserved = this.findElementsToChange();
        }
        return this.changedPreserved;
    }

    private List<GraphObject> findElementsToPreserve() {
        Vector<GraphObject> vec = new Vector<GraphObject>();
        vec.addAll(this.itsDomObjects);
        return vec;
    }

    private List<GraphObject> findElementsToCreate() {
        Vector<GraphObject> vec = new Vector<GraphObject>();
        vec.addAll(this.findNodesToCreate());
        vec.addAll(this.findArcsToCreate());
        this.isCreating = !vec.isEmpty();
        return vec;
    }

    private List<Node> findNodesToCreate() {
        Vector<Node> vec = new Vector<Node>();
        for (Node o : this.getRight().getNodesSet()) {
            if (this.getInverseImage(o).hasMoreElements()) continue;
            vec.add(o);
        }
        return vec;
    }

    private List<Arc> findArcsToCreate() {
        Vector<Arc> vec = new Vector<Arc>();
        for (Arc o : this.getRight().getArcsSet()) {
            if (this.getInverseImage(o).hasMoreElements()) continue;
            vec.add(o);
        }
        return vec;
    }

    private List<GraphObject> findElementsToDelete() {
        Vector<GraphObject> vec = new Vector<GraphObject>();
        vec.addAll(this.findNodesToDelete());
        vec.addAll(this.findArcsToDelete());
        return vec;
    }

    private List<Node> findNodesToDelete() {
        Vector<Node> vec = new Vector<Node>();
        for (Node o : this.getLeft().getNodesSet()) {
            if (this.getImage(o) != null) continue;
            vec.add(o);
        }
        this.isNodeDeleting = this.isDeleting = !vec.isEmpty();
        return vec;
    }

    private Vector<Arc> findArcsToDelete() {
        Vector<Arc> vec = new Vector<Arc>();
        for (Arc o : this.getLeft().getArcsSet()) {
            if (this.getImage(o) != null) continue;
            vec.addElement(o);
        }
        this.isDeleting = this.isDeleting || !vec.isEmpty();
        return vec;
    }

    public boolean isChanging() {
        int i = 0;
        while (i < this.itsDomObjects.size()) {
            GraphObject go = (GraphObject)this.itsDomObjects.get(i);
            if (this.isChangingAttribute(go, this.getImage(go))) {
                this.isChanging = true;
                break;
            }
            ++i;
        }
        return this.isChanging;
    }

    private Hashtable<GraphObject, GraphObject> findElementsToChange() {
        Hashtable<GraphObject, GraphObject> set = new Hashtable<GraphObject, GraphObject>();
        int i = 0;
        while (i < this.itsDomObjects.size()) {
            GraphObject go = (GraphObject)this.itsDomObjects.get(i);
            if (this.isChangingAttribute(go, this.getImage(go))) {
                set.put(go, this.getImage(go));
            }
            ++i;
        }
        this.isChanging = !set.isEmpty();
        return set;
    }

    private boolean isChangingAttribute(GraphObject obj, GraphObject img) {
        if (img.getAttribute() == null || img.getAttribute().getNumberOfEntries() == 0) {
            return false;
        }
        ValueTuple vtObj = (ValueTuple)obj.getAttribute();
        ValueTuple vtImg = (ValueTuple)img.getAttribute();
        int i = 0;
        while (i < vtObj.getNumberOfEntries()) {
            ValueMember vmObj = vtObj.getValueMemberAt(i);
            ValueMember vmImg = vtImg.getValueMemberAt(vmObj.getName());
            if (vmImg != null && vmImg.isSet()) {
                if (!vmObj.isSet()) {
                    return true;
                }
                if (!vmImg.getExprAsText().equals(vmObj.getExprAsText())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected void restoreVariableDeclaration() {
        VarTuple vart = (VarTuple)this.getAttrContext().getVariables();
        if (this.itsImag.isAttributed()) {
            this.restoreVarDecl(this.itsImag, vart);
        }
        int l = 0;
        while (l < this.itsNACs.size()) {
            OrdinaryMorphism nac = this.itsNACs.get(l);
            if (nac.getImage().isAttributed()) {
                this.restoreVarDecl(nac.getImage(), vart);
            }
            ++l;
        }
        l = 0;
        while (l < this.itsPACs.size()) {
            OrdinaryMorphism pac = this.itsPACs.get(l);
            if (pac.getImage().isAttributed()) {
                this.restoreVarDecl(pac.getImage(), vart);
            }
            ++l;
        }
        l = 0;
        while (l < this.itsACs.size()) {
            OrdinaryMorphism ac = this.itsACs.get(l);
            if (ac.getImage().isAttributed()) {
                this.restoreVarDecl(ac.getImage(), vart);
            }
            ++l;
        }
    }

    private void restoreVarDecl(Graph g, VarTuple vart) {
        Enumeration<GraphObject> en1 = g.getElements();
        while (en1.hasMoreElements()) {
            GraphObject o = en1.nextElement();
            if (o.getAttribute() == null) continue;
            AttrInstance attr = o.getAttribute();
            ValueTuple vt = (ValueTuple)attr;
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable()) {
                    String n = vm.getExprAsText();
                    String t = vm.getDeclaration().getTypeName();
                    VarMember varm = vart.getVarMemberAt(n);
                    String t_varm = "";
                    if (varm != null) {
                        t_varm = varm.getDeclaration().getTypeName();
                    }
                    if (varm == null || !t.equals(t_varm)) {
                        vart.declare(vm.getDeclaration().getHandler(), t, n);
                        ((VarMember)vart.getMemberAt(n)).setTransient(true);
                    }
                }
                ++k;
            }
        }
    }

    @Override
    public Vector<Type> getUsedTypes() {
        OrdinaryMorphism om;
        Vector<Type> vec = super.getUsedTypes();
        int i = 0;
        while (i < this.itsNACs.size()) {
            om = this.itsNACs.get(i);
            this.addUsedTypes(om.getTarget(), vec);
            ++i;
        }
        i = 0;
        while (i < this.itsPACs.size()) {
            om = this.itsPACs.get(i);
            this.addUsedTypes(om.getTarget(), vec);
            ++i;
        }
        i = 0;
        while (i < this.itsACs.size()) {
            om = this.itsACs.get(i);
            this.addUsedTypes(om.getTarget(), vec);
            ++i;
        }
        return vec;
    }

    private void addUsedTypes(Graph g, List<Type> vec) {
        for (GraphObject graphObject : g.getNodesSet()) {
            if (vec.contains(graphObject.getType())) continue;
            vec.add(graphObject.getType());
        }
        for (GraphObject graphObject : g.getArcsSet()) {
            if (vec.contains(graphObject.getType())) continue;
            vec.add(graphObject.getType());
        }
    }

    @Override
    public String getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public boolean canMatch(Graph g, MorphCompletionStrategy strategy) {
        if (strategy.getProperties().get(0) && (this.getLeft().getNodesCount() > g.getNodesCount() || this.getLeft().getArcsCount() > g.getArcsCount())) {
            return false;
        }
        Vector<Type> origTypes = this.getLeft().getUsedTypes();
        Vector<Type> otherTypes = g.getUsedAndInheritedTypes();
        int i = 0;
        while (i < origTypes.size()) {
            if (!otherTypes.contains(origTypes.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setMatch(Match m) {
        this.itsMatch = m;
    }

    public void resetTargetOfMatch(Graph g) {
        if (this.itsMatch != null) {
            this.itsMatch.setTarget(g);
        }
    }

    public void setParallelMatchingEnabled(boolean b) {
        this.parallelMatching = b;
    }

    public boolean isParallelApplyEnabled() {
        return this.parallelMatching;
    }

    public void setRandomizedCSPDomain(boolean b) {
        this.randomCSPDomain = b;
    }

    public boolean isRandomizedCSPDomain() {
        return this.randomCSPDomain;
    }

    public void setStartParallelMatchingByFirst(boolean b) {
        this.startParallelMatchByFirstCSPVar = b;
    }

    public void setInputParameters(HashMap<String, Vector<Object>> parameters) {
        VarTuple var = (VarTuple)this.getAttrContext().getVariables();
        int j = 0;
        int i = 0;
        while (i < var.getNumberOfEntries()) {
            VarMember varm = var.getVarMemberAt(i);
            if (varm.isInputParameter()) {
                Vector<Object> valuePair = parameters.get(varm.getName());
                Object value = valuePair.get(0);
                String type = (String)valuePair.get(1);
                if (type.equals("int") || type.equals("boolean") || type.equals("float") || type.equals("double") || type.equals("short") || type.equals("long")) {
                    varm.setExprAsEvaluatedText(value.toString());
                } else {
                    varm.setExprAsObject(value);
                }
                ++j;
            }
            if (j > parameters.size()) break;
            ++i;
        }
    }

    protected boolean evalDefaultFormula() {
        boolean res;
        if (this.itsMatch == null) {
            return false;
        }
        if (this.itsACs.size() == 0) {
            return true;
        }
        int n = this.itsACs.size();
        Vector<Evaluable> vars = new Vector<Evaluable>(n);
        String tmp = "";
        int indx = -1;
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (ac.isEnabled()) {
                ac.setRelatedMorphism(this.itsMatch);
                vars.add(ac);
                tmp = ++indx == 0 ? (this.formStr.equals("false") ? tmp.concat("!".concat(String.valueOf(vars.size()))) : tmp.concat(String.valueOf(vars.size()))) : (this.formStr.equals("false") ? tmp.concat("&!").concat(String.valueOf(vars.size())) : tmp.concat("&").concat(String.valueOf(vars.size())));
            }
            ++i;
        }
        boolean bl = res = this.itsFormula.setFormula(vars, tmp) && this.itsFormula.eval(this.itsMatch.getImage());
        if (!res) {
            this.itsMatch.setErrorMsg("Formula:  " + tmp + "  is violated!");
        }
        return res;
    }

    public boolean setDefaultFormulaTrue() {
        if (this.itsACs.size() == 0) {
            this.formStr = "true";
            this.formReadStr = "true";
            return true;
        }
        Vector<Evaluable> vars = new Vector<Evaluable>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
            }
            ++i;
        }
        String tmp = "";
        int i2 = 0;
        while (i2 < vars.size()) {
            String tmp1;
            tmp = tmp1 = i2 == 0 ? tmp.concat(String.valueOf(i2 + 1)) : tmp.concat("&").concat(String.valueOf(i2 + 1));
            ++i2;
        }
        if ("".equals(tmp)) {
            this.formStr = "true";
            this.formReadStr = "true";
            return true;
        }
        if (this.itsFormula.setFormula(vars, tmp)) {
            this.formStr = this.itsFormula.getAsString(vars);
            this.formReadStr = this.itsFormula.getAsString(vars, this.getNameOfEnabledACs());
            return true;
        }
        return false;
    }

    public boolean setDefaultFormulaFalse() {
        if (this.itsACs.size() == 0) {
            this.formStr = "true";
            this.formReadStr = "true";
            return true;
        }
        Vector<Evaluable> vars = new Vector<Evaluable>(this.itsACs.size());
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
            }
            ++i;
        }
        String tmp = "";
        int i2 = 0;
        while (i2 < vars.size()) {
            String tmp1;
            tmp = tmp1 = i2 == 0 ? tmp.concat(String.valueOf(i2 + 1)) : tmp.concat("&").concat(String.valueOf(i2 + 1));
            ++i2;
        }
        if ("".equals(tmp)) {
            this.formStr = "true";
            this.formReadStr = "true";
            return true;
        }
        if (this.itsFormula.setFormula(vars, tmp = "!(".concat(tmp).concat(")"))) {
            this.formStr = this.itsFormula.getAsString(vars);
            this.formReadStr = this.itsFormula.getAsString(vars, this.getNameOfEnabledACs());
            return true;
        }
        return false;
    }

    public boolean evalFormula() {
        boolean result = true;
        if (this.itsMatch != null && this.itsACs.size() != 0) {
            int i = 0;
            while (i < this.itsACs.size()) {
                NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
                if (ac.isEnabled()) {
                    ac.setRelatedMorphism(this.itsMatch);
                }
                ++i;
            }
            if (this.formStr.equals("true")) {
                this.setDefaultFormulaTrue();
            } else if (this.formStr.equals("false")) {
                this.setDefaultFormulaFalse();
            }
            result = this.itsFormula.eval(this.itsMatch.getImage());
            if (!result) {
                this.itsMatch.setErrorMsg("Formula:  " + this.formReadStr + "  is violated!");
            }
            this.disposeResultsOfNestedACs();
            return result;
        }
        return true;
    }

    public void setFormula(Formula f) {
        this.setFormula(f.getAsString(this.getEnabledGeneralACsAsEvaluable()), this.getEnabledACs());
    }

    public boolean setFormula(String bnf) {
        return this.setFormula(bnf, this.getEnabledACs());
    }

    public boolean setFormula(String bnf, List<NestedApplCond> list) {
        if (bnf.equals("true")) {
            return this.setDefaultFormulaTrue();
        }
        if (bnf.equals("false")) {
            return this.setDefaultFormulaFalse();
        }
        Vector<Evaluable> vars = new Vector<Evaluable>();
        int i = 0;
        while (i < list.size()) {
            NestedApplCond ac = list.get(i);
            if (ac.isEnabled()) {
                vars.add(ac);
            }
            ++i;
        }
        if (vars.isEmpty()) {
            this.formStr = "true";
            this.formReadStr = "true";
            return true;
        }
        if (this.itsFormula.setFormula(vars, bnf)) {
            this.formStr = this.itsFormula.getAsString(vars);
            this.formReadStr = this.itsFormula.getAsString(vars, this.getNameOfEnabledACs());
            this.setTextualComment("Formula: ".concat(this.formReadStr));
            return true;
        }
        return false;
    }

    public boolean refreshFormula(List<Evaluable> vars) {
        String bnf = this.formStr;
        if (this.itsFormula.setFormula(vars, bnf)) {
            this.formStr = this.itsFormula.getAsString(vars);
            this.formReadStr = this.itsFormula.getAsString(vars, this.getNameOfEnabledACs());
            this.setTextualComment("Formula: ".concat(this.formReadStr));
            return true;
        }
        this.formStr = "true";
        this.formReadStr = "true";
        return false;
    }

    public String getFormulaStr() {
        return this.formStr;
    }

    public String getFormulaText() {
        return this.formReadStr;
    }

    public Formula getFormula() {
        return this.itsFormula;
    }

    public boolean hasEnabledACs(boolean checkBefore) {
        if (checkBefore) {
            this.hasEnabledGACs = false;
            int i = 0;
            while (i < this.itsACs.size()) {
                NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
                if (ac.isEnabled()) {
                    this.hasEnabledGACs = true;
                    break;
                }
                ++i;
            }
        }
        return this.hasEnabledGACs;
    }

    public List<String> getNameOfEnabledACs() {
        Vector<String> vars = new Vector<String>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac.getName());
            }
            ++i;
        }
        return vars;
    }

    public List<String> getNameOfEnabledNestedACs() {
        Vector<String> vars = new Vector<String>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            if (ac.isEnabled()) {
                vars.add(ac.getName());
            }
            vars.addAll(ac.getNameOfEnabledNestedACs());
            ++i;
        }
        return vars;
    }

    public List<String> getNameOfNestedACs() {
        Vector<String> vars = new Vector<String>();
        int i = 0;
        while (i < this.itsACs.size()) {
            NestedApplCond ac = (NestedApplCond)this.itsACs.get(i);
            vars.add(ac.getName());
            vars.addAll(ac.getNameOfEnabledNestedACs());
            ++i;
        }
        return vars;
    }

    public Rule getMinimalRule() {
        return BaseFactory.theBaseFactory.makeMinimalOfRule(this);
    }

    public InverseRuleConstructData getInverseConstructData() {
        if (this.isInjective()) {
            if (this.invConstruct == null) {
                this.invConstruct = new InverseRuleConstructData(this);
            }
            return this.invConstruct;
        }
        return null;
    }

    public void disposeInverseConstruct() {
        if (this.invConstruct != null) {
            this.invConstruct.dispose();
            this.invConstruct = null;
        }
    }

    public void destroyInverseConstruct() {
        if (this.invConstruct != null) {
            this.invConstruct.destroy();
            this.invConstruct = null;
        }
    }

    public void initSignatur() {
        ((VarTuple)this.getAttrContext().getVariables()).initSignaturOrder();
    }

    public void disposeSignatur() {
        ((VarTuple)this.getAttrContext().getVariables()).disposeSignaturOrder();
    }

    public List<Integer> getSignaturOrder() {
        return ((VarTuple)this.getAttrContext().getVariables()).getSignaturOrder();
    }

    public String getSignatur() {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        String s = this.getName().concat("(");
        String s1 = "";
        List<Integer> order = vars.getSignaturOrder();
        int i = 0;
        while (i < order.size()) {
            VarMember m = (VarMember)vars.getMemberAt(order.get(i));
            String nt = m.getName().concat(":").concat(m.getDeclaration().getTypeName());
            s1 = s1.concat(nt);
            if (i < order.size() - 1) {
                s1 = s1.concat(", ");
            }
            ++i;
        }
        String s2 = "";
        int i2 = 0;
        while (i2 < vars.getSize()) {
            VarMember m = (VarMember)vars.getMemberAt(i2);
            if (m.isOutputParameter()) {
                if (!s1.isEmpty()) {
                    s2 = s2.concat(", ");
                }
                s2 = s2.concat("out ");
                String nt = m.getName().concat(":").concat(m.getDeclaration().getTypeName());
                s2 = s2.concat(nt);
                break;
            }
            ++i2;
        }
        s = s.concat(s1).concat(s2);
        s = s.concat(")");
        return s;
    }

    public void addInToSignatur(int indxOfVar) {
        ((VarTuple)this.getAttrContext().getVariables()).addToSignaturOrder(indxOfVar);
    }

    public void removeInFromSignatur(int indxOfVar) {
        ((VarTuple)this.getAttrContext().getVariables()).removeFromSignaturOrder(indxOfVar);
    }

    public void addOutToSignatur(int indxOfVar) {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        int i = 0;
        while (i < vars.getSize()) {
            VarMember m = (VarMember)vars.getMemberAt(i);
            if (i == indxOfVar) {
                m.setOutputParameter(true);
            } else {
                m.setOutputParameter(false);
            }
            ++i;
        }
    }

    public void removeOutFromSignatur(int indxOfVar) {
        VarTuple vars = (VarTuple)this.getAttrContext().getVariables();
        VarMember m = (VarMember)vars.getMemberAt(indxOfVar);
        if (m != null) {
            m.setOutputParameter(false);
        }
    }
}

