/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.impl.AttrImplException;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarTuple;
import agg.util.Change;
import agg.util.Link;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.ColimDiagram;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.ParallelRule;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class StaticStep {
    private static boolean computeColimitBasedPushout = false;

    public static final Morphism executeColimBased(Match match) throws TypeException {
        computeColimitBasedPushout = true;
        return StaticStep.execute(match, false, false);
    }

    public static final Morphism executeColimBased(Match match, boolean allowAttrVarsInGraph) throws TypeException {
        computeColimitBasedPushout = true;
        return StaticStep.execute(match, allowAttrVarsInGraph, false);
    }

    public static final Morphism executeColimBased(Match match, boolean allowAttrVarsInGraph, boolean wrtEqualAttrVarName) throws TypeException {
        computeColimitBasedPushout = true;
        return StaticStep.execute(match, allowAttrVarsInGraph, wrtEqualAttrVarName);
    }

    public static final Morphism execute(Match match) throws TypeException {
        return StaticStep.execute(match, false, false);
    }

    public static final Morphism execute(Match match, boolean allowAttrVarsInGraph) throws TypeException {
        return StaticStep.execute(match, allowAttrVarsInGraph, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Morphism execute(Match match, boolean allowAttrVarsInGraph, boolean wrtEqualAttrVarName) throws TypeException {
        Graph aHostGraph;
        Rule rule = match.getRule();
        Graph graph = aHostGraph = match.getImage();
        synchronized (graph) {
            OrdinaryMorphism aMatchStar = new OrdinaryMorphism(rule.getImage(), aHostGraph, match.getAttrManager().newContext(0));
            try {
                match.getAttrContext().freeze();
                if (computeColimitBasedPushout) {
                    ColimDiagram aPushoutDiagram = new ColimDiagram(aHostGraph);
                    aPushoutDiagram.addNode(aHostGraph);
                    aPushoutDiagram.addNode(rule.getOriginal());
                    aPushoutDiagram.addNode(rule.getImage());
                    aPushoutDiagram.addEdge(rule);
                    aPushoutDiagram.addEdge(match);
                    aPushoutDiagram.requestEdge(aMatchStar);
                    aPushoutDiagram.computeColimit();
                } else {
                    aMatchStar = !match.getCompletionStrategy().getProperties().get(0) && !match.isGluingConditionSet() ? StaticStep.pushoutOfNonInjectiveMatch(rule, match, aMatchStar) : StaticStep.pushout(rule, match, aMatchStar);
                }
                if (aMatchStar == null) {
                    throw new TypeException("Step failed!");
                }
                aMatchStar.setName("CoMorphOf_" + match.getName());
                try {
                    StaticStep.computeAttributes(match, aMatchStar, match.getAttrContext(), allowAttrVarsInGraph, wrtEqualAttrVarName);
                }
                catch (AttrImplException ex1) {
                    aMatchStar = null;
                    match.getAttrContext().defreeze();
                    if (match.getTarget().isAttributed()) {
                        match.getRule().restoreVariableDeclaration();
                        ((VarTuple)match.getAttrContext().getVariables()).unsetInputParameters();
                    }
                    throw new TypeException(ex1.getMessage());
                }
                match.getAttrContext().defreeze();
                match.setCoMorphism(aMatchStar);
            }
            catch (TypeException ex) {
                aMatchStar = null;
                match.getAttrContext().defreeze();
                if (match.getTarget().isAttributed()) {
                    match.getRule().restoreVariableDeclaration();
                    ((VarTuple)match.getAttrContext().getVariables()).unsetInputParameters();
                }
                throw ex;
            }
            try {
                match.updateAttrMappings();
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
            if (match.getTarget().isAttributed()) {
                match.getRule().restoreVariableDeclaration();
                ((VarTuple)match.getAttrContext().getVariables()).unsetInputParameters();
            }
            return aMatchStar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Pair<OrdinaryMorphism, OrdinaryMorphism> executeColim(OrdinaryMorphism rule, OrdinaryMorphism match, boolean allowAttrVarsInGraph, boolean wrtEqualAttrVarName) throws TypeException {
        Graph H = BaseFactory.theFactory().createGraph(match.getImage().getTypeSet());
        OrdinaryMorphism ruleStar = new OrdinaryMorphism(match.getImage(), H, match.getAttrManager().newContext(0));
        Graph graph = H;
        synchronized (graph) {
            OrdinaryMorphism matchStar = new OrdinaryMorphism(rule.getImage(), H, match.getAttrManager().newContext(0));
            try {
                match.getAttrContext().freeze();
                ColimDiagram aPushoutDiagram = new ColimDiagram(H);
                aPushoutDiagram.addNode(H);
                aPushoutDiagram.addNode(rule.getOriginal());
                aPushoutDiagram.addNode(rule.getImage());
                aPushoutDiagram.addEdge(rule);
                aPushoutDiagram.addNode(match.getImage());
                aPushoutDiagram.addEdge(match);
                aPushoutDiagram.requestEdge(matchStar);
                aPushoutDiagram.requestEdge(ruleStar);
                aPushoutDiagram.computeColimit();
                matchStar.setName("CoMorphOf_" + match.getName());
                try {
                    StaticStep.copyAttrEntries(ruleStar);
                    StaticStep.computeAttributes2(rule, match, matchStar, match.getAttrContext(), allowAttrVarsInGraph, wrtEqualAttrVarName);
                }
                catch (AttrImplException ex1) {
                    matchStar = null;
                    match.getAttrContext().defreeze();
                    if (match.getTarget().isAttributed()) {
                        ((VarTuple)match.getAttrContext().getVariables()).unsetInputParameters();
                    }
                    throw new TypeException(ex1.getMessage());
                }
                match.getAttrContext().defreeze();
                match.setCoMorphism(matchStar);
            }
            catch (TypeException ex) {
                matchStar = null;
                match.getAttrContext().defreeze();
                if (match.getTarget().isAttributed()) {
                    ((VarTuple)match.getAttrContext().getVariables()).unsetInputParameters();
                }
                throw ex;
            }
            match.updateAttrMappings();
            if (match.getTarget().isAttributed()) {
                ((VarTuple)match.getAttrContext().getVariables()).unsetInputParameters();
            }
            return new Pair<OrdinaryMorphism, OrdinaryMorphism>(ruleStar, matchStar);
        }
    }

    private static final void computeAttributes(Match match, OrdinaryMorphism comatch, AttrContext context, boolean allowVariables, boolean wrtEqualAttrVarName) throws AttrImplException {
        GraphObject rhsObj;
        GraphObject gObj;
        if (!comatch.getTarget().isAttributed()) {
            return;
        }
        Rule r = match.getRule();
        boolean nonInjectiveRule = !match.getRule().isInjective();
        Vector<GraphObject> done = nonInjectiveRule ? new Vector<GraphObject>(match.getSource().getSize()) : null;
        Enumeration<GraphObject> dom = match.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject lhsObj = dom.nextElement();
            gObj = match.getImage(lhsObj);
            if (!gObj.attrExists() || done != null && done.contains(gObj)) continue;
            if (done != null) {
                done.add(gObj);
            }
            if ((rhsObj = r.getImage(lhsObj)) == null || rhsObj.getAttribute() == null) continue;
            ValueTuple rai = (ValueTuple)rhsObj.getAttribute();
            ValueTuple ai = (ValueTuple)gObj.getAttribute();
            if (!allowVariables) {
                match.getTarget().propagateChange(new Change(110, gObj));
                try {
                    ai.apply(rai, context);
                    continue;
                }
                catch (AttrImplException ex) {
                    System.out.println("StaticStep.computeAttributes::  Rule:  " + r.getName() + " : " + ex.getMessage());
                    throw new AttrImplException("Rule:  " + r.getName() + " : " + ex.getMessage());
                }
            }
            ai.apply(rai, context, allowVariables, wrtEqualAttrVarName);
        }
        Enumeration<GraphObject> anObjIter = comatch.getDomain();
        while (anObjIter.hasMoreElements()) {
            rhsObj = anObjIter.nextElement();
            if (r.getInverseImage(rhsObj).hasMoreElements() || !(gObj = comatch.getImage(rhsObj)).attrExists()) continue;
            if (rhsObj.getAttribute() == null) {
                throw new AttrImplException("Rule:  " + r.getName() + ":  Attribute of RHS new object failed (null).");
            }
            ValueTuple rai = (ValueTuple)rhsObj.getAttribute();
            ValueTuple ai = (ValueTuple)gObj.getAttribute();
            if (!allowVariables) {
                comatch.getTarget().propagateChange(new Change(110, gObj));
                try {
                    ai.apply(rai, context);
                    continue;
                }
                catch (AttrImplException ex) {
                    System.out.println("StaticStep.computeAttributes:  Rule:  " + r.getName() + " : " + ex.getMessage());
                    ((VarTuple)match.getAttrContext().getVariables()).showVariables();
                    throw new AttrImplException("Rule:  " + r.getName() + " : " + ex.getMessage());
                }
            }
            ai.apply(rai, context, allowVariables);
        }
    }

    private static final void computeAttributes2(OrdinaryMorphism r, OrdinaryMorphism match, OrdinaryMorphism comatch, AttrContext context, boolean allowVariables, boolean wrtEqualAttrVarName) throws AttrImplException {
        GraphObject hObj;
        GraphObject rhsObj;
        if (!comatch.getTarget().isAttributed()) {
            return;
        }
        boolean nonInjectiveRule = !r.isInjective();
        Vector<GraphObject> done = nonInjectiveRule ? new Vector<GraphObject>(match.getSource().getSize()) : null;
        Enumeration<GraphObject> dom = match.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject lhsObj = dom.nextElement();
            GraphObject gObj = match.getImage(lhsObj);
            if (!gObj.attrExists() || done != null && done.contains(gObj)) continue;
            if (done != null) {
                done.add(gObj);
            }
            if ((rhsObj = r.getImage(lhsObj)) == null) continue;
            hObj = comatch.getImage(rhsObj);
            if (rhsObj.getAttribute() == null) continue;
            ValueTuple rai = (ValueTuple)rhsObj.getAttribute();
            ValueTuple ai = (ValueTuple)hObj.getAttribute();
            if (!allowVariables) {
                comatch.getTarget().propagateChange(new Change(110, hObj));
                try {
                    ai.apply(rai, context);
                    continue;
                }
                catch (AttrImplException ex) {
                    System.out.println("StaticStep.computeAttributes::  Rule:  " + r.getName() + " : " + ex.getMessage());
                    throw new AttrImplException("Rule:  " + r.getName() + " : " + ex.getMessage());
                }
            }
            ai.apply(rai, context, allowVariables, wrtEqualAttrVarName);
        }
        Enumeration<GraphObject> anObjIter = comatch.getDomain();
        while (anObjIter.hasMoreElements()) {
            rhsObj = anObjIter.nextElement();
            if (r.getInverseImage(rhsObj).hasMoreElements() || !(hObj = comatch.getImage(rhsObj)).attrExists()) continue;
            if (rhsObj.getAttribute() == null) {
                throw new AttrImplException("Rule:  " + r.getName() + ":  Attribute of RHS new object failed (null).");
            }
            ValueTuple rai = (ValueTuple)rhsObj.getAttribute();
            ValueTuple ai = (ValueTuple)hObj.getAttribute();
            if (!allowVariables) {
                comatch.getTarget().propagateChange(new Change(110, hObj));
                try {
                    ai.apply(rai, context);
                    continue;
                }
                catch (AttrImplException ex) {
                    System.out.println("StaticStep.computeAttributes:  Rule:  " + r.getName() + " : " + ex.getMessage());
                    throw new AttrImplException("Rule:  " + r.getName() + " : " + ex.getMessage());
                }
            }
            ai.apply(rai, context, allowVariables);
        }
    }

    private static final void copyAttrEntries(OrdinaryMorphism rstar) {
        if (!rstar.getSource().isAttributed()) {
            return;
        }
        Enumeration<GraphObject> dom = rstar.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject gObj = dom.nextElement();
            if (!gObj.attrExists()) continue;
            GraphObject hObj = rstar.getImage(gObj);
            hObj.getAttribute().copyEntries(gObj.getAttribute());
        }
    }

    private static synchronized OrdinaryMorphism pushout(OrdinaryMorphism r, OrdinaryMorphism m, OrdinaryMorphism p) throws TypeException {
        Link l;
        GraphObject img2;
        if (!m.isTotal()) {
            return null;
        }
        Hashtable<GraphObject, Link> hashMap = new Hashtable<GraphObject, Link>();
        Graph L = r.getOriginal();
        Graph G = m.getTarget();
        boolean sameType = G.getTypeSet() == r.getTarget().getTypeSet();
        StaticStep.fillHashMap(hashMap, r, m, L);
        for (GraphObject graphObject : L.getNodesSet()) {
            GraphObject graphObject2 = r.getImage(graphObject);
            img2 = m.getImage(graphObject);
            Link l2 = hashMap.get(graphObject);
            if (graphObject2 == null || img2 == null) continue;
            l2.link(hashMap.get(graphObject2)).link(hashMap.get(img2));
            try {
                hashMap.get(graphObject2).set(img2);
            }
            catch (BadMappingException ex1) {
                throw new TypeException(ex1.getLocalizedMessage());
            }
        }
        for (GraphObject graphObject : L.getArcsSet()) {
            GraphObject img1 = r.getImage(graphObject);
            GraphObject img22 = m.getImage(graphObject);
            l = hashMap.get(graphObject);
            if (img1 == null || img22 == null) continue;
            l.link(hashMap.get(img1)).link(hashMap.get(img22));
            try {
                hashMap.get(img1).set(img22);
            }
            catch (BadMappingException ex1) {
                if (r.getInverseImageList(img1).size() > 1) continue;
                throw new TypeException(ex1.getLocalizedMessage());
            }
        }
        for (GraphObject graphObject : L.getArcsSet()) {
            img2 = m.getImage(graphObject);
            if (r.getImage(graphObject) != null || img2 == null) continue;
            G.destroyArcFast((Arc)img2);
        }
        for (GraphObject graphObject : L.getNodesSet()) {
            img2 = m.getImage(graphObject);
            if (r.getImage(graphObject) != null || img2 == null) continue;
            StaticStep.destroyNode((Node)img2, G);
        }
        for (Node n : p.getOriginal().getNodesSet()) {
            Link l2 = hashMap.get(n).find();
            Node n2 = (Node)l2.get();
            if (n2 == null) {
                try {
                    StaticStep.createNode(n, G, p, sameType);
                    continue;
                }
                catch (TypeException ex) {
                    throw new TypeException(ex.getLocalizedMessage());
                }
            }
            try {
                StaticStep.glueNodesOfSameImageNode(n, r, m, p, G);
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
        for (Arc a : p.getOriginal().getArcsSet()) {
            l = hashMap.get(a).find();
            Arc a2 = (Arc)l.get();
            if (a2 == null) {
                try {
                    StaticStep.createArc(a, G, p, sameType);
                    continue;
                }
                catch (TypeException ex) {
                    throw new TypeException(ex.getLocalizedMessage());
                }
            }
            try {
                StaticStep.glueArcsOfSameImageArc(a, r, m, p, G);
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
        return p;
    }

    private static synchronized OrdinaryMorphism pushoutOfNonInjectiveMatch(OrdinaryMorphism r, OrdinaryMorphism m, OrdinaryMorphism p) throws TypeException {
        List<GraphObject> lgos;
        Link l;
        GraphObject img2;
        if (!m.isTotal()) {
            return null;
        }
        Hashtable<GraphObject, Link> hashMap = new Hashtable<GraphObject, Link>();
        Graph L = r.getOriginal();
        Graph G = m.getTarget();
        boolean sameType = G.getTypeSet() == r.getTarget().getTypeSet();
        StaticStep.fillHashMap(hashMap, r, m, L);
        for (GraphObject graphObject : L.getNodesSet()) {
            GraphObject graphObject2 = r.getImage(graphObject);
            img2 = m.getImage(graphObject);
            Link l2 = hashMap.get(graphObject);
            if (graphObject2 == null || img2 == null) continue;
            l2.link(hashMap.get(graphObject2)).link(hashMap.get(img2));
            try {
                hashMap.get(graphObject2).set(img2);
            }
            catch (BadMappingException ex1) {
                throw new TypeException(ex1.getLocalizedMessage());
            }
        }
        for (GraphObject graphObject : L.getArcsSet()) {
            GraphObject img1 = r.getImage(graphObject);
            GraphObject img22 = m.getImage(graphObject);
            l = hashMap.get(graphObject);
            if (img1 == null || img22 == null) continue;
            l.link(hashMap.get(img1)).link(hashMap.get(img22));
            try {
                hashMap.get(img1).set(img22);
            }
            catch (BadMappingException ex1) {
                if (r.getInverseImageList(img1).size() > 1) continue;
                throw new TypeException(ex1.getLocalizedMessage());
            }
        }
        for (GraphObject graphObject : L.getArcsSet()) {
            img2 = m.getImage(graphObject);
            if (r.getImage(graphObject) != null || img2 == null) continue;
            if (!m.isIdentificationSet()) {
                if (r instanceof ParallelRule) {
                    if (StaticStep.canDeleteWhenParallelRule(G, r, m, img2)) continue;
                    throw new TypeException("Step pushout: Cannot finish transformation step. Delete edge of parallel rule failed!");
                }
                G.destroyArcFast((Arc)img2);
                continue;
            }
            boolean canDelete = true;
            lgos = m.getInverseImageList(img2);
            if (lgos.size() > 1) {
                int i = 0;
                while (i < lgos.size()) {
                    if (r.getImage(lgos.get(i)) != null) {
                        canDelete = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!canDelete) continue;
            G.destroyArcFast((Arc)img2);
        }
        for (GraphObject graphObject : L.getNodesSet()) {
            img2 = m.getImage(graphObject);
            if (r.getImage(graphObject) != null || img2 == null) continue;
            if (!m.isIdentificationSet()) {
                if (r instanceof ParallelRule) {
                    if (StaticStep.canDeleteWhenParallelRule(G, r, m, img2)) continue;
                    throw new TypeException("Step pushout: Cannot finish transformation step. Delete node of parallel rule failed!");
                }
                StaticStep.destroyNode((Node)img2, G);
                continue;
            }
            boolean canDelete = true;
            lgos = m.getInverseImageList(img2);
            if (lgos.size() > 1) {
                int i = 0;
                while (i < lgos.size()) {
                    if (r.getImage(lgos.get(i)) != null) {
                        canDelete = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!canDelete) continue;
            StaticStep.destroyNode((Node)img2, G);
        }
        for (Node n : p.getOriginal().getNodesSet()) {
            Link l3 = hashMap.get(n).find();
            Node n2 = (Node)l3.get();
            if (n2 == null) {
                try {
                    StaticStep.createNodeOfNonInjectiveMatch(hashMap, n, G, r, m, p, sameType);
                    continue;
                }
                catch (TypeException ex) {
                    throw new TypeException(ex.getLocalizedMessage());
                }
            }
            try {
                StaticStep.glueNodesOfSameImageNode(n, r, m, p, G);
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
        for (Arc a : p.getOriginal().getArcsSet()) {
            l = hashMap.get(a).find();
            Arc a2 = (Arc)l.get();
            if (a2 == null) {
                try {
                    StaticStep.createArcOfNonInjectiveMatch(hashMap, a, G, r, m, p, sameType);
                    continue;
                }
                catch (TypeException ex) {
                    throw new TypeException(ex.getLocalizedMessage());
                }
            }
            try {
                StaticStep.glueArcsOfSameImageArc(a, r, m, p, G);
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
        return p;
    }

    private static boolean canDeleteWhenParallelRule(Graph g, OrdinaryMorphism r, OrdinaryMorphism m, GraphObject go) {
        boolean canDelete = true;
        List<GraphObject> lgos = m.getInverseImageList(go);
        if (lgos.size() > 1) {
            GraphObject go1 = lgos.get(0);
            GraphObject img_go1 = r.getImage(go1);
            OrdinaryMorphism embedding = ((ParallelRule)r).getLeftEmbeddingOfObject(go1);
            int i = 0;
            while (i < lgos.size()) {
                GraphObject go2 = lgos.get(i);
                if ((img_go1 != null || r.getImage(go2) != null) && ((ParallelRule)r).getLeftEmbeddingOfObject(go2) != embedding) {
                    canDelete = false;
                    break;
                }
                ++i;
            }
        }
        return canDelete;
    }

    private static void fillHashMap(Hashtable<GraphObject, Link> hashMap, OrdinaryMorphism r, OrdinaryMorphism m, Graph left) {
        for (GraphObject graphObject : left.getNodesSet()) {
            hashMap.put(graphObject, new Link());
            hashMap.put(m.getImage(graphObject), new Link());
        }
        for (GraphObject graphObject : left.getArcsSet()) {
            hashMap.put(graphObject, new Link());
            hashMap.put(m.getImage(graphObject), new Link());
        }
        Iterator<GraphObject> iter = r.getImage().getNodesSet().iterator();
        while (iter.hasNext()) {
            hashMap.put(iter.next(), new Link());
        }
        iter = r.getImage().getArcsSet().iterator();
        while (iter.hasNext()) {
            hashMap.put(iter.next(), new Link());
        }
    }

    private static void createNode(Node n, Graph g, OrdinaryMorphism p, boolean sameType) throws TypeException {
        try {
            if (sameType) {
                StaticStep.createNodeOfSameType(n, g, p);
            } else {
                StaticStep.createNodeOfSimilarType(n, g, p);
            }
        }
        catch (TypeException ex) {
            throw new TypeException(ex.getLocalizedMessage());
        }
    }

    private static void createNodeOfNonInjectiveMatch(Hashtable<GraphObject, Link> hashMap, Node n, Graph g, OrdinaryMorphism r, OrdinaryMorphism m, OrdinaryMorphism p, boolean sameType) throws TypeException {
        if (!m.isIdentificationSet()) {
            Node go = (Node)hashMap.get(n).get();
            if (go != null) {
                List<GraphObject> lgos = m.getInverseImageList(go);
                if (lgos.size() > 1) {
                    int i = 0;
                    while (i < lgos.size()) {
                        if (r.getImage(lgos.get(i)) == null) {
                            return;
                        }
                        ++i;
                    }
                }
            } else if (r.getInverseImage(n).hasMoreElements()) {
                return;
            }
        }
        StaticStep.createNode(n, g, p, sameType);
    }

    private static void destroyNode(Node n, Graph g) {
        GraphObject a;
        Iterator<Arc> iter = n.getOutgoingArcsSet().iterator();
        while (iter.hasNext()) {
            a = iter.next();
            g.destroyArcFast((Arc)a);
            iter = n.getOutgoingArcsSet().iterator();
        }
        iter = n.getIncomingArcsSet().iterator();
        while (iter.hasNext()) {
            a = iter.next();
            g.destroyArcFast((Arc)a);
            iter = n.getIncomingArcsSet().iterator();
        }
        g.destroyNodeFast(n);
    }

    private static void createArc(Arc a, Graph g, OrdinaryMorphism p, boolean sameType) throws TypeException {
        GraphObject src = p.getImage(a.getSource());
        GraphObject tgt = p.getImage(a.getTarget());
        if (src != null && tgt != null) {
            try {
                if (sameType) {
                    StaticStep.createArcOfSameType(a, src, tgt, g, p);
                } else {
                    StaticStep.createArcOfSimilarType(a, src, tgt, g, p);
                }
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
    }

    private static void createArcOfNonInjectiveMatch(Hashtable<GraphObject, Link> hashMap, Arc a, Graph g, OrdinaryMorphism r, OrdinaryMorphism m, OrdinaryMorphism p, boolean sameType) throws TypeException {
        if (!m.isIdentificationSet()) {
            Arc go = (Arc)hashMap.get(a).get();
            if (go != null) {
                List<GraphObject> lgos = m.getInverseImageList(go);
                if (lgos.size() > 1) {
                    int i = 0;
                    while (i < lgos.size()) {
                        if (r.getImage(lgos.get(i)) == null) {
                            return;
                        }
                        ++i;
                    }
                }
            } else if (r.getInverseImage(a).hasMoreElements()) {
                return;
            }
        }
        StaticStep.createArc(a, g, p, sameType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void glueNodesOfSameImageNode(Node n, OrdinaryMorphism r, OrdinaryMorphism m, OrdinaryMorphism p, Graph g) throws TypeException {
        boolean glued = false;
        List<GraphObject> origs = r.getInverseImageList(n);
        if (origs.isEmpty()) return;
        Hashtable<Arc, Arc> arc2arcimg = new Hashtable<Arc, Arc>();
        GraphObject ol1 = origs.get(0);
        GraphObject og1 = m.getImage(ol1);
        if (og1 != null) {
            int j = 1;
            while (j < origs.size()) {
                Node node = (Node)origs.get(j);
                Node og2 = (Node)m.getImage(node);
                if (og2 != null) {
                    for (Arc arc : node.getIncomingArcsSet()) {
                        if (m.getImage(arc) == null) continue;
                        arc2arcimg.put(arc, (Arc)m.getImage(arc));
                    }
                    for (Arc arc : node.getOutgoingArcsSet()) {
                        if (m.getImage(arc) == null) continue;
                        arc2arcimg.put(arc, (Arc)m.getImage(arc));
                    }
                    if (!g.glue(og1, og2, n)) throw new TypeException("Step pushout: Cannot glue nodes of type  " + og1.getType().getName() + " !");
                    glued = true;
                } else if (m.isIdentificationSet()) {
                    throw new TypeException("Step pushout: Cannot finish transformation step. Identification condition failed!");
                }
                ++j;
            }
            try {
                if (p.getImage(n) == null || p.getImage(n) != og1) {
                    p.addPlainMapping(n, og1);
                }
            }
            catch (BadMappingException ex1) {
                throw new TypeException(ex1.getLocalizedMessage());
            }
            if (!glued) return;
            j = 1;
            while (j < origs.size()) {
                GraphObject graphObject = origs.get(j);
                try {
                    m.addObjectPlainMapping(graphObject, og1);
                }
                catch (BadMappingException ex1) {
                    throw new TypeException(ex1.getLocalizedMessage());
                }
                ++j;
            }
            Enumeration inoutarcs = arc2arcimg.keys();
            while (inoutarcs.hasMoreElements()) {
                Arc arc = (Arc)inoutarcs.nextElement();
                try {
                    m.addObjectPlainMapping(arc, (GraphObject)arc2arcimg.get(arc));
                }
                catch (BadMappingException ex1) {
                    throw new TypeException(ex1.getLocalizedMessage());
                }
            }
            return;
        }
        if (!m.isIdentificationSet()) return;
        throw new TypeException("Step pushout: Cannot finish transformation step. Identification condition failed!");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void glueArcsOfSameImageArc(Arc a, OrdinaryMorphism r, OrdinaryMorphism m, OrdinaryMorphism p, Graph g) throws TypeException {
        boolean glued = false;
        List<GraphObject> origs = r.getInverseImageList(a);
        if (origs.isEmpty()) return;
        GraphObject ol1 = origs.get(0);
        GraphObject og1 = m.getImage(ol1);
        if (og1 != null) {
            int j = 1;
            while (j < origs.size()) {
                Arc arc = (Arc)origs.get(j);
                Arc og2 = (Arc)m.getImage(arc);
                if (og2 != null) {
                    if (!g.glue(og1, og2, a)) throw new TypeException("Step pushout: Cannot glue edges of type  " + og1.getType().getName() + " !");
                    glued = true;
                } else if (m.isIdentificationSet()) {
                    throw new TypeException("Step pushout: Cannot finish transformation step. Identification condition failed!");
                }
                ++j;
            }
            try {
                if (p.getImage(a) == null || p.getImage(a) != og1) {
                    p.addPlainMapping(a, og1);
                }
            }
            catch (BadMappingException ex1) {
                throw new TypeException(ex1.getLocalizedMessage());
            }
            if (!glued) return;
            j = 1;
            while (j < origs.size()) {
                GraphObject graphObject = origs.get(j);
                try {
                    m.addObjectPlainMapping(graphObject, og1);
                }
                catch (BadMappingException ex1) {
                    throw new TypeException(ex1.getLocalizedMessage());
                }
                ++j;
            }
            return;
        }
        if (!m.isIdentificationSet()) return;
        throw new TypeException("Step pushout: Cannot finish transformation step. Identification condition failed!");
    }

    private static void createNodeOfSameType(Node n, Graph G, OrdinaryMorphism p) throws TypeException {
        block7: {
            try {
                Type nodetype = n.getType();
                if (nodetype != null) {
                    try {
                        Node n2 = G.newNodeFast(nodetype);
                        n2.setContextUsage(n.getContextUsage());
                        try {
                            p.addMappingFast(n, n2);
                            break block7;
                        }
                        catch (BadMappingException ex1) {
                            throw new TypeException(ex1.getLocalizedMessage());
                        }
                    }
                    catch (TypeException ex2) {
                        throw new TypeException(ex2.getLocalizedMessage());
                    }
                }
                throw new TypeException("Step pushout: Cannot create node! Node type not found!");
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
    }

    private static void createNodeOfSimilarType(Node n, Graph G, OrdinaryMorphism p) throws TypeException {
        block7: {
            try {
                Type nodetype = G.getTypeSet().getSimilarType(n.getType());
                if (nodetype != null) {
                    try {
                        Node n2 = G.createNode(nodetype);
                        n2.setContextUsage(n.getContextUsage());
                        try {
                            p.addMapping(n, n2);
                            break block7;
                        }
                        catch (BadMappingException ex1) {
                            throw new TypeException(ex1.getLocalizedMessage());
                        }
                    }
                    catch (TypeException ex2) {
                        throw new TypeException(ex2.getLocalizedMessage());
                    }
                }
                throw new TypeException("Step pushout: Cannot create node! Node type not found!");
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
    }

    private static void createArcOfSameType(Arc a, GraphObject src, GraphObject tar, Graph G, OrdinaryMorphism p) throws TypeException {
        block5: {
            try {
                Type arctype = a.getType();
                if (arctype != null) {
                    Arc a2 = G.newArcFast(arctype, (Node)src, (Node)tar);
                    a2.setContextUsage(a.getContextUsage());
                    try {
                        p.addMappingFast(a, a2);
                        break block5;
                    }
                    catch (BadMappingException ex1) {
                        throw new BadMappingException(ex1.getLocalizedMessage());
                    }
                }
                throw new TypeException("Step pushout: Cannot create edge! Edge type not found.");
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
    }

    private static void createArcOfSimilarType(Arc a, GraphObject src, GraphObject tgt, Graph G, OrdinaryMorphism p) throws TypeException {
        block7: {
            try {
                Type arctype = G.getTypeSet().getSimilarType(a.getType());
                if (arctype != null) {
                    try {
                        Arc a2 = G.createArc(arctype, (Node)src, (Node)tgt);
                        a2.setContextUsage(a.getContextUsage());
                        try {
                            p.addMapping(a, a2);
                            break block7;
                        }
                        catch (BadMappingException ex1) {
                            throw new BadMappingException(ex1.getLocalizedMessage());
                        }
                    }
                    catch (TypeException ex2) {
                        throw new TypeException(ex2.getLocalizedMessage());
                    }
                }
                throw new TypeException("Step pushout: Cannot create edge! Edge type not found.");
            }
            catch (TypeException ex) {
                throw new TypeException(ex.getLocalizedMessage());
            }
        }
    }

    public static List<GraphObject> getCreatedNodes(Rule r, Morphism comatch) {
        Vector<GraphObject> list = new Vector<GraphObject>();
        if (r.getRight() == ((OrdinaryMorphism)comatch).getSource()) {
            Enumeration<GraphObject> dom = comatch.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                if (!go.isNode() || r.getInverseImage(go).hasMoreElements()) continue;
                list.add(go);
            }
        }
        return list;
    }

    public static List<GraphObject> getCreatedArcs(Rule r, Morphism comatch) {
        Vector<GraphObject> list = new Vector<GraphObject>();
        if (r.getRight() == ((OrdinaryMorphism)comatch).getSource()) {
            Enumeration<GraphObject> dom = comatch.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                if (!go.isArc() || r.getInverseImage(go).hasMoreElements()) continue;
                list.add(go);
            }
        }
        return list;
    }

    public static List<GraphObject> getCreatedObjects(Rule r, Morphism comatch) {
        Vector<GraphObject> list = new Vector<GraphObject>();
        if (r.getRight() == ((OrdinaryMorphism)comatch).getSource()) {
            Enumeration<GraphObject> dom = comatch.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                if (r.getInverseImage(go).hasMoreElements()) continue;
                list.add(go);
            }
        }
        return list;
    }
}

