/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.constraints;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.interpreter.matching.constraints.AttributeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ContainmentConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.DanglingConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.PathConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.ReferenceConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.TypeConstraint;
import org.eclipse.emf.henshin.interpreter.matching.constraints.UnaryConstraint;

public class Variable {
    public String name;
    public final TypeConstraint typeConstraint;
    public final List<AttributeConstraint> attributeConstraints;
    public final List<DanglingConstraint> danglingConstraints;
    public final List<ReferenceConstraint> referenceConstraints;
    public final List<ContainmentConstraint> containmentConstraints;
    public final List<PathConstraint> pathConstraints;
    public final List<UnaryConstraint> userConstraints;
    public final Map<ReferenceConstraint, BinaryConstraint> binaryUserConstraints;
    public final Map<AttributeConstraint, UnaryConstraint> attributeUserConstraints;
    public boolean requiresFinalCheck;

    public Variable(EClass type) {
        this(type, false);
    }

    public Variable(EClass type, boolean strictTyping) {
        this.typeConstraint = new TypeConstraint(type, strictTyping);
        this.attributeConstraints = new ArrayList<AttributeConstraint>();
        this.danglingConstraints = new ArrayList<DanglingConstraint>();
        this.referenceConstraints = new ArrayList<ReferenceConstraint>();
        this.containmentConstraints = new ArrayList<ContainmentConstraint>();
        this.pathConstraints = new ArrayList<PathConstraint>();
        this.userConstraints = new ArrayList<UnaryConstraint>();
        this.binaryUserConstraints = new LinkedHashMap<ReferenceConstraint, BinaryConstraint>();
        this.attributeUserConstraints = new LinkedHashMap<AttributeConstraint, UnaryConstraint>();
        this.requiresFinalCheck = false;
    }
}

