/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.text.scoping;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.text.henshin_text.ConditionEdge;
import org.eclipse.emf.henshin.text.henshin_text.ConditionGraph;
import org.eclipse.emf.henshin.text.henshin_text.ConditionNode;
import org.eclipse.emf.henshin.text.henshin_text.ConditionReuseNode;
import org.eclipse.emf.henshin.text.henshin_text.EPackageImport;
import org.eclipse.emf.henshin.text.henshin_text.Edge;
import org.eclipse.emf.henshin.text.henshin_text.Graph;
import org.eclipse.emf.henshin.text.henshin_text.GraphElements;
import org.eclipse.emf.henshin.text.henshin_text.Henshin_textPackage;
import org.eclipse.emf.henshin.text.henshin_text.Model;
import org.eclipse.emf.henshin.text.henshin_text.MultiRuleReuseNode;
import org.eclipse.emf.henshin.text.henshin_text.Node;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportedNamespaceAwareLocalScopeProvider;
import org.eclipse.xtext.util.Strings;

public class Henshin_textImportedNamespaceAwareLocalScopeProvider
extends ImportedNamespaceAwareLocalScopeProvider {
    public IScope getScope(EObject context, EReference reference) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        IScope result = null;
        result = context.eContainer() != null ? this.getScope(context.eContainer(), reference) : this.getResourceScope(context.eResource(), reference);
        if (result != null && !result.getAllElements().iterator().hasNext() && context instanceof EPackageImport) {
            try {
                Field field = context.getClass().getDeclaredFields()[0];
                field.setAccessible(true);
                EPackage importedPackage = (EPackage)field.get(context);
                ArrayList<EPackage> candidates = new ArrayList<EPackage>();
                candidates.add(importedPackage);
                return Scopes.scopeFor(candidates);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                System.err.println("Error accessing EPackage by reflection");
                e.printStackTrace();
            }
        }
        return this.getLocalElementsScope(result, context, reference);
    }

    protected List<ImportNormalizer> internalGetImportedNamespaceResolvers(EObject context, boolean ignoreCase) {
        Node sourceNode;
        Object edge;
        List sourceNodes;
        String[] splitPackageName;
        Object packageName;
        INode reInode;
        List reNodes;
        Graph graph;
        String[] splitPackageName2;
        String packageName2;
        Object graph2;
        EObject container;
        Node reusedNode;
        String nodeName;
        String[] splitPackageName3;
        String packageName3;
        INode inode;
        Object node;
        List nodes;
        ArrayList importedNamespaceResolvers = Lists.newArrayList();
        if (context instanceof Model) {
            Model model = (Model)context;
            for (EPackageImport ePackageImport : model.getEPackageimports()) {
                List nodes2 = NodeModelUtils.findNodesForFeature((EObject)ePackageImport, (EStructuralFeature)Henshin_textPackage.Literals.EPACKAGE_IMPORT__REF);
                if (nodes2.size() <= 0) continue;
                INode inode2 = (INode)nodes2.get(0);
                String packageName4 = NodeModelUtils.getTokenText((INode)inode2);
                importedNamespaceResolvers.add(this.createImportedNamespaceResolver(packageName4, ignoreCase));
            }
        }
        if (context instanceof Node && (nodes = NodeModelUtils.findNodesForFeature((EObject)(node = (Node)context), (EStructuralFeature)Henshin_textPackage.Literals.NODE__NODETYPE)).size() > 0) {
            inode = (INode)nodes.get(0);
            packageName3 = NodeModelUtils.getTokenText((INode)inode);
            importedNamespaceResolvers.add(this.createImportedNamespaceResolver(packageName3, ignoreCase));
            splitPackageName3 = packageName3.split("\\.");
            if (splitPackageName3.length == 1) {
                splitPackageName3 = (String.valueOf(this.getPackageName(packageName3, context)) + "." + packageName3).split("\\.");
            }
            this.addSuperclasses(splitPackageName3, context, ignoreCase, importedNamespaceResolvers);
        }
        if (context instanceof ConditionNode && (nodes = NodeModelUtils.findNodesForFeature((EObject)(node = (ConditionNode)context), (EStructuralFeature)Henshin_textPackage.Literals.CONDITION_NODE__TYPE)).size() > 0) {
            inode = (INode)nodes.get(0);
            packageName3 = NodeModelUtils.getTokenText((INode)inode);
            importedNamespaceResolvers.add(this.createImportedNamespaceResolver(packageName3, ignoreCase));
            splitPackageName3 = packageName3.split("\\.");
            if (splitPackageName3.length == 1) {
                splitPackageName3 = (String.valueOf(this.getPackageName(packageName3, context)) + "." + packageName3).split("\\.");
            }
            this.addSuperclasses(splitPackageName3, context, ignoreCase, importedNamespaceResolvers);
        }
        if (context instanceof ConditionReuseNode && (nodes = NodeModelUtils.findNodesForFeature((EObject)(node = (ConditionReuseNode)context), (EStructuralFeature)Henshin_textPackage.Literals.CONDITION_REUSE_NODE__NAME)).size() > 0) {
            List reConNodes;
            inode = (INode)nodes.get(0);
            nodeName = NodeModelUtils.getTokenText((INode)inode);
            reusedNode = null;
            ConditionNode reusedConNode = null;
            boolean nodeFound = false;
            container = node.eContainer().eContainer();
            while (!nodeFound) {
                if (container instanceof Graph) {
                    graph2 = (Graph)container;
                    for (Object element : graph2.getGraphElements()) {
                        if (!(element instanceof Node) || !((Node)element).getName().equals(nodeName)) continue;
                        reusedNode = (Node)element;
                        nodeFound = true;
                    }
                } else if (container instanceof ConditionGraph) {
                    graph2 = (ConditionGraph)container;
                    for (Object element : graph2.getConditionGraphElements()) {
                        if (!(element instanceof ConditionNode) || !((ConditionNode)element).getName().equals(nodeName)) continue;
                        reusedConNode = (ConditionNode)element;
                        nodeFound = true;
                    }
                }
                container = container.eContainer();
                if (container instanceof Model) break;
            }
            if (reusedNode != null && reusedConNode == null) {
                List reNodes2 = NodeModelUtils.findNodesForFeature(reusedNode, (EStructuralFeature)Henshin_textPackage.Literals.NODE__NODETYPE);
                if (reNodes2.size() > 0) {
                    INode reInode2 = (INode)reNodes2.get(0);
                    packageName2 = NodeModelUtils.getTokenText((INode)reInode2);
                    importedNamespaceResolvers.add(this.createImportedNamespaceResolver(packageName2, ignoreCase));
                    splitPackageName2 = packageName2.split("\\.");
                    if (splitPackageName2.length == 1) {
                        splitPackageName2 = (String.valueOf(this.getPackageName(packageName2, context)) + "." + packageName2).split("\\.");
                    }
                    this.addSuperclasses(splitPackageName2, context, ignoreCase, importedNamespaceResolvers);
                }
            } else if (reusedNode == null && reusedConNode != null && (reConNodes = NodeModelUtils.findNodesForFeature(reusedConNode, (EStructuralFeature)Henshin_textPackage.Literals.CONDITION_NODE__TYPE)).size() > 0) {
                Iterator reConInode = (INode)reConNodes.get(0);
                packageName2 = NodeModelUtils.getTokenText((INode)reConInode);
                importedNamespaceResolvers.add(this.createImportedNamespaceResolver(packageName2, ignoreCase));
                splitPackageName2 = packageName2.split("\\.");
                if (splitPackageName2.length == 1) {
                    splitPackageName2 = (String.valueOf(this.getPackageName(packageName2, context)) + "." + packageName2).split("\\.");
                }
                this.addSuperclasses(splitPackageName2, context, ignoreCase, importedNamespaceResolvers);
            }
        }
        if (context instanceof MultiRuleReuseNode && (nodes = NodeModelUtils.findNodesForFeature((EObject)(node = (MultiRuleReuseNode)context), (EStructuralFeature)Henshin_textPackage.Literals.MULTI_RULE_REUSE_NODE__NAME)).size() > 0) {
            inode = (INode)nodes.get(0);
            nodeName = NodeModelUtils.getTokenText((INode)inode);
            reusedNode = null;
            boolean nodeFound = false;
            EObject container2 = node.eContainer().eContainer();
            while (!nodeFound) {
                if (container2 instanceof Graph) {
                    graph = (Graph)container2;
                    for (GraphElements element : graph.getGraphElements()) {
                        if (!(element instanceof Node) || !((Node)element).getName().equals(nodeName)) continue;
                        reusedNode = (Node)element;
                        nodeFound = true;
                    }
                }
                if ((container2 = container2.eContainer()) instanceof Model) break;
            }
            if (reusedNode != null && (reNodes = NodeModelUtils.findNodesForFeature(reusedNode, (EStructuralFeature)Henshin_textPackage.Literals.NODE__NODETYPE)).size() > 0) {
                reInode = (INode)reNodes.get(0);
                packageName = NodeModelUtils.getTokenText((INode)reInode);
                importedNamespaceResolvers.add(this.createImportedNamespaceResolver((String)packageName, ignoreCase));
                splitPackageName = ((String)packageName).split("\\.");
                if (splitPackageName.length == 1) {
                    splitPackageName = (String.valueOf(this.getPackageName((String)packageName, context)) + "." + (String)packageName).split("\\.");
                }
                this.addSuperclasses(splitPackageName, context, ignoreCase, importedNamespaceResolvers);
            }
        }
        if (context instanceof Edge && (sourceNodes = NodeModelUtils.findNodesForFeature((EObject)(edge = (Edge)context), (EStructuralFeature)Henshin_textPackage.Literals.EDGE__SOURCE)).size() > 0) {
            inode = (INode)sourceNodes.get(0);
            nodeName = NodeModelUtils.getTokenText((INode)inode);
            sourceNode = null;
            boolean nodeFound = false;
            EObject container3 = edge.eContainer();
            while (!nodeFound) {
                if (container3 instanceof Graph) {
                    graph = (Graph)container3;
                    for (GraphElements element : graph.getGraphElements()) {
                        if (!(element instanceof Node) || ((Node)element).getName() == null || !((Node)element).getName().equals(nodeName)) continue;
                        sourceNode = (Node)element;
                        nodeFound = true;
                    }
                }
                if ((container3 = container3.eContainer()) instanceof Model) break;
            }
            if (sourceNode != null && (reNodes = NodeModelUtils.findNodesForFeature(sourceNode, (EStructuralFeature)Henshin_textPackage.Literals.NODE__NODETYPE)).size() > 0) {
                reInode = (INode)reNodes.get(0);
                packageName = NodeModelUtils.getTokenText((INode)reInode);
                importedNamespaceResolvers.add(this.createImportedNamespaceResolver((String)packageName, ignoreCase));
                splitPackageName = ((String)packageName).split("\\.");
                if (splitPackageName.length == 1) {
                    splitPackageName = (String.valueOf(this.getPackageName((String)packageName, context)) + "." + (String)packageName).split("\\.");
                }
                this.addSuperclasses(splitPackageName, context, ignoreCase, importedNamespaceResolvers);
            }
        }
        if (context instanceof ConditionEdge && (sourceNodes = NodeModelUtils.findNodesForFeature((EObject)(edge = (ConditionEdge)context), (EStructuralFeature)Henshin_textPackage.Literals.CONDITION_EDGE__SOURCE)).size() > 0) {
            List sourConNodes;
            inode = (INode)sourceNodes.get(0);
            nodeName = NodeModelUtils.getTokenText((INode)inode);
            sourceNode = null;
            ConditionNode conSourceNode = null;
            boolean nodeFound = false;
            container = edge.eContainer();
            while (!nodeFound) {
                if (container instanceof Graph) {
                    graph2 = (Graph)container;
                    for (Object element : graph2.getGraphElements()) {
                        if (!(element instanceof Node) || !((Node)element).getName().equals(nodeName)) continue;
                        sourceNode = (Node)element;
                        nodeFound = true;
                    }
                } else if (container instanceof ConditionGraph) {
                    graph2 = (ConditionGraph)container;
                    for (Object element : graph2.getConditionGraphElements()) {
                        if (!(element instanceof ConditionNode) || !((ConditionNode)element).getName().equals(nodeName)) continue;
                        conSourceNode = (ConditionNode)element;
                        nodeFound = true;
                    }
                }
                container = container.eContainer();
                if (container instanceof Model) break;
            }
            if (sourceNode != null && conSourceNode == null) {
                List sourNodes = NodeModelUtils.findNodesForFeature(sourceNode, (EStructuralFeature)Henshin_textPackage.Literals.NODE__NODETYPE);
                if (sourNodes.size() > 0) {
                    INode sourInode = (INode)sourNodes.get(0);
                    packageName2 = NodeModelUtils.getTokenText((INode)sourInode);
                    importedNamespaceResolvers.add(this.createImportedNamespaceResolver(packageName2, ignoreCase));
                    splitPackageName2 = packageName2.split("\\.");
                    if (splitPackageName2.length == 1) {
                        splitPackageName2 = (String.valueOf(this.getPackageName(packageName2, context)) + "." + packageName2).split("\\.");
                    }
                    this.addSuperclasses(splitPackageName2, context, ignoreCase, importedNamespaceResolvers);
                }
            } else if (sourceNode == null && conSourceNode != null && (sourConNodes = NodeModelUtils.findNodesForFeature(conSourceNode, (EStructuralFeature)Henshin_textPackage.Literals.CONDITION_NODE__TYPE)).size() > 0) {
                INode sourConInode = (INode)sourConNodes.get(0);
                packageName2 = NodeModelUtils.getTokenText((INode)sourConInode);
                importedNamespaceResolvers.add(this.createImportedNamespaceResolver(packageName2, ignoreCase));
                splitPackageName2 = packageName2.split("\\.");
                if (splitPackageName2.length == 1) {
                    splitPackageName2 = (String.valueOf(this.getPackageName(packageName2, context)) + "." + packageName2).split("\\.");
                }
                this.addSuperclasses(splitPackageName2, context, ignoreCase, importedNamespaceResolvers);
            }
        }
        return importedNamespaceResolvers;
    }

    protected ImportNormalizer createImportedNamespaceResolver(String namespace, boolean ignoreCase) {
        if (Strings.isEmpty((String)namespace)) {
            return null;
        }
        QualifiedName importedNamespace = this.getQualifiedNameConverter().toQualifiedName(namespace);
        if (importedNamespace == null || importedNamespace.getSegmentCount() < 1) {
            return null;
        }
        return this.doCreateImportNormalizer(importedNamespace, true, ignoreCase);
    }

    private String getPackageName(String className, EObject context) {
        Model model = (Model)context.eResource().getContents().get(0);
        for (EPackageImport imp : model.getEPackageimports()) {
            if (imp.getRef() == null || imp.getRef().getName() == null) continue;
            for (EClassifier classifier : imp.getRef().getEClassifiers()) {
                if (!classifier.getName().equals(className)) continue;
                return imp.getRef().getName();
            }
        }
        return "";
    }

    private void addSuperclasses(String[] splitPackageName, EObject context, boolean ignoreCase, List<ImportNormalizer> importedNamespaceResolvers) {
        if (splitPackageName != null && splitPackageName.length > 1) {
            Model model = (Model)context.eResource().getContents().get(0);
            for (EPackageImport imp : model.getEPackageimports()) {
                if (imp.getRef() == null || imp.getRef().getName() == null || !imp.getRef().getName().equals(splitPackageName[0])) continue;
                for (EClassifier classifier : imp.getRef().getEClassifiers()) {
                    if (!classifier.getName().equals(splitPackageName[1])) continue;
                    for (String superTypes : this.getAllSuperTypes((EClass)classifier)) {
                        String superType = String.valueOf(splitPackageName[0]) + "." + superTypes;
                        importedNamespaceResolvers.add(this.createImportedNamespaceResolver(superType, ignoreCase));
                    }
                }
            }
        }
    }

    private List<String> getAllSuperTypes(EClass eClass) {
        ArrayList<String> names = new ArrayList<String>();
        for (EClass superType : eClass.getESuperTypes()) {
            names.add(superType.getName());
            names.addAll(this.getAllSuperTypes(superType));
        }
        return names;
    }
}

