/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.ruleappl;

import agg.ruleappl.ApplRuleSequence;
import agg.ruleappl.RuleSequence;
import agg.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class ApplicabilityWithoutGraphResultTable {
    static final Color RED = new Color(255, 10, 50);
    static final Color GREEN = new Color(155, 255, 105);
    static final Color ORANGE = new Color(255, 255, 100);
    static final Color BLUE = new Color(155, 205, 255);
    protected ApplRuleSequence ars;
    protected RuleSequence ruleSequence;
    protected final Hashtable<RuleSequence, Pair<JDialog, JDialog>> sequence2table = new Hashtable();
    protected final Hashtable<JButton, JDialog> close2table = new Hashtable();
    protected JScrollPane scrollpaneTable;
    protected JScrollPane scrollpaneTable2;
    protected JDialog tableFrame;
    protected JDialog tableFrame2;
    protected JTable resultTable;
    protected JTable resultTable2;

    public ApplicabilityWithoutGraphResultTable(ApplRuleSequence applrs) {
        this.ars = applrs;
    }

    public void clear() {
        this.sequence2table.clear();
        this.ruleSequence = null;
    }

    public int closeResultTables(RuleSequence rseq) {
        int nb = 0;
        Pair<JDialog, JDialog> p = this.sequence2table.get(rseq);
        if (p != null) {
            if (p.first != null) {
                ++nb;
                ((JDialog)p.first).setVisible(false);
            }
            if (p.second != null) {
                ++nb;
                ((JDialog)p.second).setVisible(false);
            }
        }
        this.sequence2table.remove(rseq);
        return nb;
    }

    public void closeAllResultTables() {
        for (Pair<JDialog, JDialog> p : this.sequence2table.values()) {
            if (p.first != null) {
                ((JDialog)p.first).setVisible(false);
            }
            if (p.second == null) continue;
            ((JDialog)p.second).setVisible(false);
        }
        this.sequence2table.clear();
    }

    public void showApplicabilityResult(Point location, int indx) {
        this.ruleSequence = this.ars.getRuleSequence(indx);
        if (this.sequence2table.get(this.ruleSequence) == null || this.sequence2table.get((Object)this.ruleSequence).first == null) {
            Pair<Boolean, String> result = this.ruleSequence.getApplicabilityResult();
            if (result == null) {
                JOptionPane.showMessageDialog(null, "This sequence isn't checked.");
                return;
            }
            this.resultTable = this.createResultTable(this.ruleSequence.getRuleNames());
            this.createResultTableFrame(this.resultTable);
            this.setTitleOfTableFrame(this.tableFrame);
            if (this.sequence2table.get(this.ruleSequence) == null) {
                this.sequence2table.put(this.ruleSequence, new Pair<JDialog, Object>(this.tableFrame, null));
            } else {
                this.sequence2table.get((Object)this.ruleSequence).first = this.tableFrame;
            }
            this.makeResultTableEntries(this.ruleSequence, (Boolean)result.first, (String)result.second);
            this.tableFrame.setLocation(location.x, location.y);
            this.tableFrame.setVisible(true);
        } else {
            Pair<JDialog, JDialog> p = this.sequence2table.get(this.ruleSequence);
            this.tableFrame = (JDialog)p.first;
            if (!this.tableFrame.isVisible()) {
                this.sequence2table.remove(this.ruleSequence);
                this.showApplicabilityResult(location, indx);
            } else {
                this.setTitleOfTableFrame(this.tableFrame);
                this.tableFrame.setVisible(true);
            }
        }
    }

    public void showNonApplicabilityResult(Point location, int indx) {
        this.ruleSequence = this.ars.getRuleSequence(indx);
        if (this.sequence2table.get(this.ruleSequence) == null || this.sequence2table.get((Object)this.ruleSequence).second == null) {
            this.resultTable2 = this.createResultTable2(this.ruleSequence.getRuleNames());
            this.createResultTableFrame2(this.resultTable2);
            this.setTitleOfTableFrame(this.tableFrame2);
            if (this.sequence2table.get(this.ruleSequence) == null) {
                this.sequence2table.put(this.ruleSequence, new Pair<Object, JDialog>(null, this.tableFrame2));
            } else {
                this.sequence2table.get((Object)this.ruleSequence).second = this.tableFrame2;
            }
            Pair<Boolean, String> result = this.ars.getNonApplicabilityResult(indx);
            if (result == null) {
                JOptionPane.showMessageDialog(null, "This sequence isn't checked.");
                return;
            }
            this.makeResultTable2Entries(this.ruleSequence, (Boolean)result.first, (String)result.second);
            this.tableFrame2.setLocation(location.x, location.y);
            this.tableFrame2.setVisible(true);
        } else {
            Pair<JDialog, JDialog> p = this.sequence2table.get(this.ruleSequence);
            this.tableFrame2 = (JDialog)p.second;
            if (!this.tableFrame2.isVisible()) {
                this.sequence2table.remove(this.ruleSequence);
                this.showNonApplicabilityResult(location, indx);
            } else {
                this.setTitleOfTableFrame(this.tableFrame2);
                this.tableFrame2.setVisible(true);
            }
        }
    }

    private void createResultTableFrame(JTable table) {
        this.scrollpaneTable = new JScrollPane(table);
        this.tableFrame = new JDialog();
        this.tableFrame.setTitle(" Applicability of Rule Sequence ");
        this.tableFrame.setModal(false);
        this.tableFrame.getContentPane().setLayout(new BorderLayout());
        this.tableFrame.getContentPane().add((Component)this.scrollpaneTable, "Center");
        JButton closeButton = this.makeCloseButton(this.tableFrame);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicabilityWithoutGraphResultTable.this.close2table.get(e.getSource()).setVisible(false);
            }
        });
        this.close2table.put(closeButton, this.tableFrame);
        int fheight = 100;
        if (table.getRowCount() > 0) {
            fheight = table.getCellRect((int)0, (int)0, (boolean)true).height * (table.getRowCount() + 6);
        }
        this.tableFrame.setSize(new Dimension(800, fheight));
        this.tableFrame.validate();
    }

    private void createResultTableFrame2(JTable table) {
        this.scrollpaneTable2 = new JScrollPane(table);
        this.tableFrame2 = new JDialog();
        this.tableFrame2.setTitle(" Non-Applicability of Rule Sequence ");
        this.tableFrame2.setModal(false);
        this.tableFrame2.getContentPane().setLayout(new BorderLayout());
        this.tableFrame2.getContentPane().add((Component)this.scrollpaneTable2, "Center");
        JButton closeButton = this.makeCloseButton(this.tableFrame2);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicabilityWithoutGraphResultTable.this.close2table.get(e.getSource()).setVisible(false);
            }
        });
        this.close2table.put(closeButton, this.tableFrame2);
        int fheight = 100;
        if (table.getRowCount() > 0) {
            fheight = table.getCellRect((int)0, (int)0, (boolean)true).height * (table.getRowCount() + 6);
        }
        this.tableFrame2.setSize(new Dimension(800, fheight));
        this.tableFrame2.validate();
    }

    private JButton makeCloseButton(JDialog dialog) {
        JPanel closePanel = new JPanel(new GridLayout(1, 0));
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closePanel.add(new JLabel("   "));
        closePanel.add(new JLabel("   "));
        closePanel.add(closeButton);
        closePanel.add(new JLabel("   "));
        closePanel.add(new JLabel("   "));
        dialog.getContentPane().add((Component)closePanel, "South");
        return closeButton;
    }

    private void setTitleOfTableFrame(JDialog tableframe) {
        if (tableframe == this.tableFrame) {
            tableframe.setTitle(" Applicability of Rule Sequence without Start Graph ");
        } else if (tableframe == this.tableFrame2) {
            tableframe.setTitle(" Non-Applicability of Rule Sequence without Start Graph ");
        }
    }

    private void setTableItemValue(RuleSequence rseq, int row, int col, String ruleName, String criterion) {
        JLabel l = new JLabel("");
        Pair<Boolean, List<String>> pair = rseq.getRuleResult(row, ruleName, criterion);
        if (pair == null) {
            l.setBackground(Color.LIGHT_GRAY);
        } else {
            l.setText((String)((List)pair.second).get(1));
            if (((Boolean)pair.first).booleanValue()) {
                if (criterion.equals("no-node-deleting-rules") || criterion.equals("no-impeding-predecessors")) {
                    l.setForeground(Color.BLACK);
                    l.setBackground(GREEN);
                } else {
                    l.setForeground(Color.WHITE);
                    l.setBackground(BLUE);
                }
            } else {
                l.setForeground(Color.BLACK);
                l.setBackground(ORANGE);
            }
        }
        this.resultTable.getModel().setValueAt(l, row, col);
    }

    private void makeResultTableEntries(RuleSequence rseq, boolean result, String condition) {
        List<String> ruleNames = rseq.getRuleNames();
        int row = 0;
        while (row < ruleNames.size()) {
            int col = 1;
            while (col < this.resultTable.getColumnCount()) {
                if (col == 1) {
                    this.setTableItemValue(rseq, row, col, ruleNames.get(row), "initialization");
                } else if (col == 2) {
                    this.setTableItemValue(rseq, row, col, ruleNames.get(row), "no-node-deleting-rules");
                } else if (col == 3) {
                    this.setTableItemValue(rseq, row, col, ruleNames.get(row), "no-impeding-predecessors");
                } else if (col == 4) {
                    this.setTableItemValue(rseq, row, col, ruleNames.get(row), "pure-enabling-predecessor");
                } else if (col == 5) {
                    this.setTableItemValue(rseq, row, col, ruleNames.get(row), "direct-enabling-predecessor");
                } else if (col == 6) {
                    this.setTableItemValue(rseq, row, col, ruleNames.get(row), "predecessor-not-needed");
                }
                ++col;
            }
            ++row;
        }
    }

    private void makeResultTable2Entries(RuleSequence rseq, boolean result, String condition) {
        List<String> ruleNames = rseq.getRuleNames();
        int row = 0;
        while (row < ruleNames.size()) {
            int col = 1;
            while (col < this.resultTable2.getColumnCount()) {
                JLabel l = new JLabel("");
                if (result) {
                    if (condition.equals("initialization-error")) {
                        if (row == 0 && col == 1) {
                            l.setBackground(RED);
                            this.resultTable2.getModel().setValueAt(l, row, col);
                        } else if (row != 0 && col == 2) {
                            this.setNoEnablingPredecessor(rseq, row, ruleNames.get(row));
                        } else {
                            l.setBackground(Color.LIGHT_GRAY);
                            this.resultTable2.getModel().setValueAt(l, row, col);
                        }
                    } else if (condition.equals("no-enabling-predecessor")) {
                        if (row == 0 && col == 1) {
                            this.setInitializationError(rseq, row, ruleNames.get(row));
                        } else if (row != 0 && col == 2) {
                            l.setBackground(RED);
                            this.resultTable2.getModel().setValueAt(l, row, col);
                        } else {
                            l.setBackground(Color.LIGHT_GRAY);
                            this.resultTable2.getModel().setValueAt(l, row, col);
                        }
                    }
                } else if (row == 0 && col == 1) {
                    this.setInitializationError(rseq, row, ruleNames.get(row));
                } else if (row != 0 && col == 2) {
                    this.setNoEnablingPredecessor(rseq, row, ruleNames.get(row));
                } else {
                    l.setBackground(Color.LIGHT_GRAY);
                    this.resultTable2.getModel().setValueAt(l, row, col);
                }
                ++col;
            }
            ++row;
        }
    }

    private void setInitializationError(RuleSequence rseq, int row, String ruleName) {
        JLabel l = new JLabel("");
        Pair<Boolean, List<String>> pair = rseq.getRuleResult(row, ruleName, "initialization-error");
        if (pair == null) {
            l.setBackground(Color.LIGHT_GRAY);
        } else if (row == 0) {
            if (((Boolean)pair.first).booleanValue()) {
                l.setForeground(Color.WHITE);
                l.setBackground(BLUE);
            } else {
                l.setBackground(ORANGE);
            }
        } else {
            l.setBackground(Color.LIGHT_GRAY);
        }
        this.resultTable2.getModel().setValueAt(l, row, 1);
    }

    private void setNoEnablingPredecessor(RuleSequence rseq, int row, String ruleName) {
        JLabel l = new JLabel("");
        Pair<Boolean, List<String>> pair = rseq.getRuleResult(row, ruleName, "no-enabling-predecessor");
        if (pair == null) {
            l.setBackground(Color.LIGHT_GRAY);
        } else {
            l.setText((String)((List)pair.second).get(1));
            if (((Boolean)pair.first).booleanValue()) {
                l.setForeground(Color.WHITE);
                l.setBackground(BLUE);
            } else {
                l.setBackground(ORANGE);
            }
        }
        this.resultTable2.getModel().setValueAt(l, row, 2);
    }

    private JTable createResultTable(List<String> sequence) {
        DefaultTableModel dataModel = new DefaultTableModel(new String[]{"Rule / Criteria", "(1) initialization", "(2) no node-deleting rules", "(3) no impeding predecessors", "(4a) pure enabling predecessor", "(4b) direct enabling predecessor(s)", "(4c) not needed"}, 7){

            @Override
            public int getColumnCount() {
                return 7;
            }

            @Override
            public int getRowCount() {
                return ApplicabilityWithoutGraphResultTable.this.ruleSequence.getRules().size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row < super.getRowCount() && col < super.getColumnCount()) {
                    return super.getValueAt(row, col);
                }
                return null;
            }
        };
        JTable table = new JTable(dataModel);
        table.getSelectionModel().setSelectionMode(0);
        int i = 0;
        while (i < 7) {
            table.setDefaultRenderer(table.getColumnClass(i), new MyTableCellRenderer());
            ++i;
        }
        int row = 0;
        while (row < sequence.size()) {
            String ruleName = sequence.get(row);
            JLabel rulel = new JLabel(ruleName);
            table.getModel().setValueAt(rulel, row, 0);
            int col = 1;
            while (col < 7) {
                JLabel l = new JLabel("");
                table.getModel().setValueAt(l, row, col);
                ++col;
            }
            ++row;
        }
        return table;
    }

    private JTable createResultTable2(List<String> sequence) {
        DefaultTableModel dataModel = new DefaultTableModel(new String[]{"Rule / Criteria", "(1) initialization error", "(2) no enabling predecessor"}, 3){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                return ApplicabilityWithoutGraphResultTable.this.ruleSequence.getRules().size();
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (row < super.getRowCount() && col < super.getColumnCount()) {
                    return super.getValueAt(row, col);
                }
                return null;
            }
        };
        JTable table = new JTable(dataModel);
        table.getSelectionModel().setSelectionMode(0);
        int i = 0;
        while (i < 3) {
            table.setDefaultRenderer(table.getColumnClass(i), new MyTableCellRenderer());
            ++i;
        }
        int row = 0;
        while (row < sequence.size()) {
            String ruleName = sequence.get(row);
            JLabel rulel = new JLabel(ruleName);
            table.getModel().setValueAt(rulel, row, 0);
            int col = 1;
            while (col < 3) {
                JLabel l = new JLabel("");
                table.getModel().setValueAt(l, row, col);
                ++col;
            }
            ++row;
        }
        return table;
    }

    class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (value instanceof JLabel) {
                JLabel l = (JLabel)value;
                if (column > 0) {
                    this.setBackground(l.getBackground());
                    this.setForeground(l.getForeground());
                    this.setText(l.getText());
                    return this;
                }
                return new JLabel(l.getText());
            }
            if (value instanceof String) {
                return new JLabel((String)value);
            }
            return new JLabel("");
        }
    }
}

