/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrContext;
import agg.attribute.handler.AvailableHandlers;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.ruleappl.ObjectFlow;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TestStep;
import agg.xt_basis.TypeException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ConcurrentRule {
    protected OrdinaryMorphism embLr1ToLcr;
    protected OrdinaryMorphism embRr1ToRcr;
    protected OrdinaryMorphism embLr2ToLcr;
    protected OrdinaryMorphism embRr2ToRcr;
    protected Object source1;
    protected Object source2;
    protected int indx1 = -1;
    protected int indx2 = -1;
    protected OrdinaryMorphism overlap1;
    protected OrdinaryMorphism overlap2;
    protected Object source1Concurrent;
    protected Object source2Concurrent;
    protected Rule concurrentRule;
    protected int depth;
    protected boolean enableEqualVariableNameOfAttrMapping;
    protected boolean disjoint;
    protected final Hashtable<GraphObject, GraphObject> reflectedObjectFlowOI = new Hashtable();
    protected final Hashtable<GraphObject, GraphObject> reflectedObjectFlowIO = new Hashtable();
    protected final Hashtable<Object, ObjectFlow> inputObjectFlow = new Hashtable(4);
    protected final Hashtable<Object, ObjectFlow> outputObjectFlow = new Hashtable(4);
    protected int sizeOfInputObjectFlow;
    protected boolean injective = true;
    private final List<OrdinaryMorphism> failedApplConds = new Vector<OrdinaryMorphism>();
    public long freeM;
    public long usedM;

    public ConcurrentRule(Rule rule1, Rule inverseRule1, Rule rule2, OrdinaryMorphism isoLeft1, OrdinaryMorphism isoRight1, OrdinaryMorphism overlapping1, OrdinaryMorphism overlapping2) {
        this.source1 = rule1;
        this.source2 = rule2;
        this.overlap1 = overlapping1;
        this.overlap2 = overlapping2;
        this.concurrentRule = this.makeRule(rule1, inverseRule1, rule2, isoLeft1, isoRight1, overlapping1, overlapping2);
        if (this.concurrentRule != null) {
            ++this.depth;
            this.concurrentRule.notApplicable = this.concurrentRule.notApplicable || rule1.isNotApplicable() || rule2.isNotApplicable();
        }
    }

    public ConcurrentRule(Rule rule1, Rule rule2) {
        this.source1 = rule1;
        this.source2 = rule2;
        this.concurrentRule = this.makeRuleByDisjointUnion(rule1, rule2);
        if (this.concurrentRule != null) {
            ++this.depth;
            this.concurrentRule.notApplicable = this.concurrentRule.notApplicable || rule1.isNotApplicable() || rule2.isNotApplicable();
        }
    }

    public ConcurrentRule(ConcurrentRule rule1, Rule inverseRule1, Rule rule2, OrdinaryMorphism isoLeft1, OrdinaryMorphism isoRight1, OrdinaryMorphism overlapping1, OrdinaryMorphism overlapping2) {
        this.source1 = rule1.getRule();
        this.source2 = rule2;
        this.source1Concurrent = rule1;
        this.overlap1 = overlapping1;
        this.overlap2 = overlapping2;
        this.concurrentRule = this.makeRule(rule1.getRule(), inverseRule1, rule2, isoLeft1, isoRight1, this.overlap1, this.overlap2);
        if (this.concurrentRule != null) {
            ++this.depth;
            this.depth += rule1.depth;
            this.concurrentRule.notApplicable = this.concurrentRule.notApplicable || rule1.getRule().isNotApplicable() || rule2.isNotApplicable();
        }
    }

    public ConcurrentRule(ConcurrentRule rule1, Rule rule2) {
        this.source1 = rule1.getRule();
        this.source2 = rule2;
        this.source1Concurrent = rule1;
        this.concurrentRule = this.makeRuleByDisjointUnion(rule1.getRule(), rule2);
        if (this.concurrentRule != null) {
            ++this.depth;
            this.depth += rule1.depth;
            this.concurrentRule.notApplicable = this.concurrentRule.notApplicable || rule1.getRule().isNotApplicable() || rule2.isNotApplicable();
        }
    }

    public ConcurrentRule(Rule rule1, ConcurrentRule rule2) {
        this.source1 = rule1;
        this.source2 = rule2.getRule();
        this.source2Concurrent = rule2;
        this.concurrentRule = this.makeRuleByDisjointUnion(rule1, rule2.getRule());
        if (this.concurrentRule != null) {
            ++this.depth;
            this.depth += rule2.depth;
            this.concurrentRule.notApplicable = this.concurrentRule.notApplicable || rule2.getRule().isNotApplicable() || rule1.isNotApplicable();
        }
    }

    public Hashtable<GraphObject, GraphObject> getReflectedInputObjectFlowFromRule(Rule r, List<ObjectFlow> list) {
        Hashtable<GraphObject, GraphObject> objmap = new Hashtable<GraphObject, GraphObject>();
        int i = 0;
        while (i < list.size()) {
            Hashtable<Object, Object> map = list.get(i).getMapping();
            Enumeration<Object> objs1 = map.keys();
            while (objs1.hasMoreElements()) {
                GraphObject in;
                GraphObject obj1 = (GraphObject)objs1.nextElement();
                GraphObject obj2 = (GraphObject)map.get(obj1);
                if (obj1.getContext() != r.getRight() || (in = this.getLeftEmbedding(obj2)) == null) continue;
                objmap.put(obj1, in);
            }
            ++i;
        }
        return objmap;
    }

    public Hashtable<GraphObject, GraphObject> getReflectedInputObjectFlowFromGraph(Graph g, List<ObjectFlow> list) {
        Hashtable<GraphObject, GraphObject> objmap = new Hashtable<GraphObject, GraphObject>();
        int i = 0;
        while (i < list.size()) {
            Hashtable<Object, Object> map = list.get(i).getMapping();
            Enumeration<Object> objs1 = map.keys();
            while (objs1.hasMoreElements()) {
                GraphObject in;
                GraphObject obj1 = (GraphObject)objs1.nextElement();
                GraphObject obj2 = (GraphObject)map.get(obj1);
                if (obj1.getContext() != g || (in = this.getLeftEmbedding(obj2)) == null) continue;
                objmap.put(obj1, in);
            }
            ++i;
        }
        return objmap;
    }

    public int getSizeOfReflectedInputObjectFlow() {
        return this.sizeOfInputObjectFlow;
    }

    public void setInjectiveMatchProperty(boolean b) {
        this.injective = b;
    }

    public boolean hasInjectiveMatchProperty() {
        return this.injective;
    }

    public Hashtable<GraphObject, GraphObject> applyReflectedObjectFlowToMatchMap(Graph graph) {
        Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>();
        Enumeration<GraphObject> keys = this.reflectedObjectFlowIO.keys();
        while (keys.hasMoreElements()) {
            GraphObject input = keys.nextElement();
            GraphObject output = this.reflectedObjectFlowIO.get(input);
            if (output.getContext() != graph) continue;
            GraphObject ownInput1 = this.embLr1ToLcr.getImage(input);
            if (ownInput1 != null) {
                map.put(ownInput1, output);
                continue;
            }
            GraphObject ownInput2 = this.embLr2ToLcr.getImage(input);
            if (ownInput2 != null) {
                map.put(ownInput2, output);
                continue;
            }
            if (!(this.source2Concurrent instanceof ConcurrentRule)) continue;
            ownInput2 = ((ConcurrentRule)this.source2Concurrent).getFirstLeftEmbedding().getImage(input);
            if (ownInput2 != null) {
                map.put(ownInput2, output);
                continue;
            }
            ownInput2 = ((ConcurrentRule)this.source2Concurrent).getSecondLeftEmbedding().getImage(input);
            if (ownInput2 == null) continue;
            map.put(ownInput2, output);
        }
        return map;
    }

    public boolean reflectObjectFlow(List<ObjectFlow> objFlowOfSource) {
        if (objFlowOfSource == null || objFlowOfSource.isEmpty()) {
            return true;
        }
        for (ObjectFlow objFlow : objFlowOfSource) {
            Hashtable<Object, Object> map = objFlow.getMapping();
            Enumeration<Object> outputs = map.keys();
            while (outputs.hasMoreElements()) {
                Object output = outputs.nextElement();
                Object input = map.get(output);
                GraphObject input_cr = null;
                GraphObject output_cr = null;
                if (this.source1 instanceof Rule) {
                    input_cr = this.embLr1ToLcr.getImage((GraphObject)input);
                    if (input_cr != null) {
                        this.reflectedObjectFlowIO.put((GraphObject)input, (GraphObject)output);
                        ++this.sizeOfInputObjectFlow;
                    } else {
                        output_cr = this.embRr1ToRcr.getImage((GraphObject)output);
                        if (output_cr != null) {
                            this.reflectedObjectFlowOI.put((GraphObject)output, (GraphObject)input);
                        }
                    }
                }
                if (this.source2Concurrent instanceof ConcurrentRule) {
                    input_cr = ((ConcurrentRule)this.source2Concurrent).getFirstLeftEmbedding().getImage((GraphObject)input);
                    if (this.embLr2ToLcr.getImage(input_cr) != null) {
                        this.reflectedObjectFlowIO.put(input_cr, (GraphObject)output);
                        ++this.sizeOfInputObjectFlow;
                        continue;
                    }
                    input_cr = ((ConcurrentRule)this.source2Concurrent).getSecondLeftEmbedding().getImage((GraphObject)input);
                    if (this.embLr2ToLcr.getImage(input_cr) == null) continue;
                    this.reflectedObjectFlowIO.put(input_cr, (GraphObject)output);
                    ++this.sizeOfInputObjectFlow;
                    continue;
                }
                if (!(this.source2 instanceof Rule)) continue;
                input_cr = this.embLr2ToLcr.getImage((GraphObject)input);
                if (input_cr != null) {
                    if (((Rule)this.source1).getTarget().isElement((GraphObject)output) && this.embLr1ToLcr.getInverseImage(input_cr).hasMoreElements()) continue;
                    this.reflectedObjectFlowIO.put((GraphObject)input, (GraphObject)output);
                    ++this.sizeOfInputObjectFlow;
                    continue;
                }
                output_cr = this.embRr2ToRcr.getImage((GraphObject)output);
                if (output_cr == null) continue;
                this.reflectedObjectFlowOI.put((GraphObject)output, (GraphObject)input);
            }
        }
        return true;
    }

    public void setFirstSourceConcurrentRule(ConcurrentRule cr) {
        this.source1Concurrent = cr;
        this.depth += cr.depth;
    }

    public ConcurrentRule getFirstSourceConcurrentRule() {
        if (this.source1Concurrent instanceof ConcurrentRule) {
            return (ConcurrentRule)this.source1Concurrent;
        }
        return null;
    }

    public Rule getFirstSourceRule() {
        if (this.source1 instanceof Rule) {
            return (Rule)this.source1;
        }
        return null;
    }

    public void setIndexOfFirstSourceRule(int indx) {
        this.indx1 = indx;
    }

    public int getIndexOfFirstSourceRule() {
        return this.indx1;
    }

    public void setSecondSourceConcurrentRule(ConcurrentRule cr) {
        this.source2Concurrent = cr;
        this.depth += cr.depth;
    }

    public ConcurrentRule getSecondSourceConcurrentRule() {
        if (this.source2Concurrent instanceof ConcurrentRule) {
            return (ConcurrentRule)this.source2Concurrent;
        }
        return null;
    }

    public Rule getSecondSourceRule() {
        if (this.source2 instanceof Rule) {
            return (Rule)this.source2;
        }
        return null;
    }

    public void setIndexOfSecondSourceRule(int indx) {
        this.indx2 = indx;
    }

    public int getIndexOfSecondSourceRule() {
        return this.indx2;
    }

    public Rule getLastSecondSourceRule() {
        if (this.source2Concurrent != null) {
            ConcurrentRule cr = (ConcurrentRule)this.source2Concurrent;
            while (cr.getSecondSourceConcurrentRule() != null) {
                cr = cr.getSecondSourceConcurrentRule();
            }
            return cr.getSecondSourceRule();
        }
        return (Rule)this.source2;
    }

    public OrdinaryMorphism getSecondOverlappingOfDependencyPair() {
        return this.overlap2;
    }

    public List<GraphObject> getOverlappingObjectsOfSecondRule() {
        if (this.overlap1 == null || this.overlap2 == null) {
            return null;
        }
        Vector<GraphObject> list = new Vector<GraphObject>();
        for (GraphObject graphObject : this.overlap1.getTarget().getNodesSet()) {
            if (!this.overlap1.getInverseImage(graphObject).hasMoreElements() || !this.overlap2.getInverseImage(graphObject).hasMoreElements()) continue;
            list.add(this.overlap2.getInverseImage(graphObject).nextElement());
        }
        for (GraphObject graphObject : this.overlap1.getTarget().getArcsSet()) {
            if (!this.overlap1.getInverseImage(graphObject).hasMoreElements() || !this.overlap2.getInverseImage(graphObject).hasMoreElements()) continue;
            list.add(this.overlap2.getInverseImage(graphObject).nextElement());
        }
        return list;
    }

    public List<GraphObject> getOverlappingObjectsOfFirstRule() {
        if (this.overlap1 == null || this.overlap2 == null) {
            return null;
        }
        Vector<GraphObject> list = new Vector<GraphObject>();
        for (GraphObject graphObject : this.overlap1.getTarget().getNodesSet()) {
            if (!this.overlap1.getInverseImage(graphObject).hasMoreElements() || !this.overlap2.getInverseImage(graphObject).hasMoreElements()) continue;
            list.add(this.overlap1.getInverseImage(graphObject).nextElement());
        }
        for (GraphObject graphObject : this.overlap1.getTarget().getArcsSet()) {
            if (!this.overlap1.getInverseImage(graphObject).hasMoreElements() || !this.overlap2.getInverseImage(graphObject).hasMoreElements()) continue;
            list.add(this.overlap1.getInverseImage(graphObject).nextElement());
        }
        return list;
    }

    public Hashtable<GraphObject, GraphObject> getOverlappingObjects() {
        if (this.overlap1 == null || this.overlap2 == null) {
            return null;
        }
        Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>();
        for (GraphObject graphObject : this.overlap1.getTarget().getNodesSet()) {
            if (!this.overlap1.getInverseImage(graphObject).hasMoreElements() || !this.overlap2.getInverseImage(graphObject).hasMoreElements()) continue;
            map.put(this.overlap1.getInverseImage(graphObject).nextElement(), this.overlap2.getInverseImage(graphObject).nextElement());
        }
        for (GraphObject graphObject : this.overlap1.getTarget().getArcsSet()) {
            if (!this.overlap1.getInverseImage(graphObject).hasMoreElements() || !this.overlap2.getInverseImage(graphObject).hasMoreElements()) continue;
            map.put(this.overlap1.getInverseImage(graphObject).nextElement(), this.overlap2.getInverseImage(graphObject).nextElement());
        }
        return map;
    }

    public GraphObject getLeftEmbedding(GraphObject obj) {
        GraphObject go1;
        GraphObject go = this.embLr1ToLcr.getImage(obj);
        if (go == null && (go = this.embLr2ToLcr.getImage(obj)) == null && this.source2Concurrent != null && (go1 = ((ConcurrentRule)this.source2Concurrent).getLeftEmbedding(obj)) != null) {
            go = this.getLeftEmbedding(go1);
        }
        return go;
    }

    public GraphObject getRightEmbedding(GraphObject obj) {
        GraphObject go1;
        GraphObject go = this.embRr1ToRcr.getImage(obj);
        if (go == null && (go = this.embRr2ToRcr.getImage(obj)) == null && this.source2Concurrent != null && (go1 = ((ConcurrentRule)this.source2Concurrent).getRightEmbedding(obj)) != null) {
            go = this.getRightEmbedding(go1);
        }
        return go;
    }

    public OrdinaryMorphism getFirstLeftEmbedding() {
        return this.embLr1ToLcr;
    }

    public OrdinaryMorphism getSecondLeftEmbedding() {
        return this.embLr2ToLcr;
    }

    public OrdinaryMorphism getFirstRightEmbedding() {
        return this.embRr1ToRcr;
    }

    public OrdinaryMorphism getSecondRightEmbedding() {
        return this.embRr2ToRcr;
    }

    public Rule getRule() {
        return this.concurrentRule;
    }

    public boolean isReadyToTransform() {
        if (this.concurrentRule != null) {
            boolean result = true;
            BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(this.concurrentRule);
            result = result && this.concurrentRule.isReadyToTransform();
            return result;
        }
        return false;
    }

    public int getDepth() {
        return this.depth;
    }

    public void enableEqualVariableNameOfAttrMapping(boolean enable) {
        this.enableEqualVariableNameOfAttrMapping = enable;
    }

    public boolean forwardMatchMappingOfFirstSourceRule(Hashtable<GraphObject, GraphObject> map, Graph g) {
        boolean result = false;
        Match m = BaseFactory.theFactory().createMatch(this.concurrentRule, g);
        if (m != null) {
            GraphObject obj_cr;
            GraphObject img;
            GraphObject obj;
            this.concurrentRule.setMatch(m);
            Enumeration<GraphObject> objs = map.keys();
            while (objs.hasMoreElements()) {
                obj = objs.nextElement();
                if (!obj.isNode()) continue;
                img = map.get(obj);
                if (this.embLr1ToLcr == null || obj.getContext() != this.embLr1ToLcr.getSource() || (obj_cr = this.embLr1ToLcr.getImage(obj)) == null) continue;
                try {
                    m.addMapping(obj_cr, img);
                    result = true;
                }
                catch (BadMappingException ex) {
                    return false;
                }
            }
            objs = map.keys();
            while (objs.hasMoreElements()) {
                obj = objs.nextElement();
                if (!obj.isArc()) continue;
                img = map.get(obj);
                if (this.embLr1ToLcr == null || obj.getContext() != this.embLr1ToLcr.getSource() || (obj_cr = this.embLr1ToLcr.getImage(obj)) == null) continue;
                try {
                    m.addMapping(obj_cr, img);
                    result = true;
                }
                catch (BadMappingException ex) {
                    return false;
                }
            }
        }
        return result;
    }

    private Rule makeRuleByDisjointUnion(Rule rule1, Rule rule2) {
        this.failedApplConds.clear();
        Rule cr = null;
        this.disjoint = true;
        OrdinaryMorphism lhs1ToLHS = rule1.getLeft().isomorphicCopy();
        if (lhs1ToLHS == null) {
            return null;
        }
        OrdinaryMorphism rhs1ToRHS = rule1.getRight().isomorphicCopy();
        if (rhs1ToRHS == null) {
            lhs1ToLHS.dispose();
            lhs1ToLHS = null;
            return null;
        }
        OrdinaryMorphism lhs2ToLHS = null;
        try {
            lhs2ToLHS = BaseFactory.theFactory().extendGraphByGraph(lhs1ToLHS.getTarget(), rule2.getLeft());
        }
        catch (Exception e) {
            lhs1ToLHS.dispose();
            lhs1ToLHS = null;
            rhs1ToRHS.dispose();
            rhs1ToRHS = null;
            return null;
        }
        if (lhs2ToLHS != null) {
            OrdinaryMorphism rhs2ToRHS = null;
            try {
                rhs2ToRHS = BaseFactory.theFactory().extendGraphByGraph(rhs1ToRHS.getTarget(), rule2.getRight());
            }
            catch (Exception e) {
                lhs1ToLHS.dispose();
                lhs1ToLHS = null;
                rhs1ToRHS.dispose();
                rhs1ToRHS = null;
                return null;
            }
            if (rhs2ToRHS != null) {
                boolean ok = true;
                Graph lhs = lhs2ToLHS.getTarget();
                Graph rhs = rhs2ToRHS.getTarget();
                OrdinaryMorphism morphCR = BaseFactory.theFactory().createMorphism(lhs, rhs);
                if (morphCR.completeDiagram(lhs1ToLHS, rule1, rhs1ToRHS) && morphCR.completeDiagram(lhs2ToLHS, rule2, rhs2ToRHS)) {
                    cr = BaseFactory.theFactory().constructRuleFromMorph(morphCR);
                    cr.setName(String.valueOf(rule1.getName()) + "+" + rule2.getName());
                    this.embLr1ToLcr = lhs1ToLHS;
                    this.embRr1ToRcr = rhs1ToRHS;
                    this.embLr2ToLcr = lhs2ToLHS;
                    this.embRr2ToRcr = rhs2ToRHS;
                    this.shiftCondsOfRuleOverEmbMorph(cr, rule1, this.embLr1ToLcr, true);
                    this.shiftCondsOfRuleOverEmbMorph(cr, rule2, this.embLr2ToLcr, true);
                    OrdinaryMorphism rhs1ToE = rule1.getRight().isomorphicCopy();
                    try {
                        OrdinaryMorphism lhs2ToE = BaseFactory.theFactory().extendGraphByGraph(rhs1ToE.getTarget(), rule2.getLeft());
                        OrdinaryMorphism left = BaseFactory.theFactory().createMorphism(lhs, lhs2ToE.getTarget());
                        if (left.completeDiagram(lhs1ToLHS, rule1, rhs1ToE) && left.completeDiagram2(this.embLr2ToLcr, lhs2ToE)) {
                            this.shiftCondsOfRuleOverMorphAndLeft(cr, rule2, lhs2ToE, left, this.embLr2ToLcr, true);
                        } else {
                            ok = false;
                        }
                    }
                    catch (Exception e) {
                        ok = false;
                    }
                    if (ok) {
                        OrdinaryMorphism rhs2ToE = rule2.getRight().isomorphicCopy();
                        try {
                            OrdinaryMorphism lhs1ToE = BaseFactory.theFactory().extendGraphByGraph(rhs2ToE.getTarget(), rule1.getLeft());
                            OrdinaryMorphism left = BaseFactory.theFactory().createMorphism(lhs, lhs1ToE.getTarget());
                            if (left.completeDiagram(lhs2ToLHS, rule2, rhs2ToE) && left.completeDiagram2(this.embLr1ToLcr, lhs1ToE)) {
                                this.shiftCondsOfRuleOverMorphAndLeft(cr, rule1, lhs1ToE, left, this.embLr1ToLcr, true);
                            } else {
                                ok = false;
                            }
                        }
                        catch (Exception e) {
                            ok = false;
                        }
                    }
                    this.removeIsomorphicMorph(cr.getNACsList());
                    this.removeIsomorphicMorph(cr.getPACsList());
                    this.addAttrConditionFromTo(rule1, cr);
                    this.addAttrConditionFromTo(rule2, cr);
                    this.addUndeclaredVariableOfExpression(cr);
                    BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(cr);
                    this.adjustUnsetAttrsAboveMorph(this.embLr1ToLcr);
                    this.adjustUnsetAttrsAboveMorph(this.embLr2ToLcr);
                    cr.removeUnusedVariableOfAttrContext();
                    this.setInputParameterIfNeeded(cr);
                    cr.isReadyToTransform();
                }
                morphCR.dispose();
            } else {
                lhs1ToLHS.dispose();
                lhs1ToLHS = null;
                rhs1ToRHS.dispose();
                rhs1ToRHS = null;
                lhs2ToLHS.dispose();
                lhs2ToLHS = null;
            }
        }
        BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(rule1);
        BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(rule2);
        return cr;
    }

    private Rule makeRule(Rule rule1, Rule inverseRule1, Rule rule2, OrdinaryMorphism isoLeft1, OrdinaryMorphism isoRight1, OrdinaryMorphism overlapping1, OrdinaryMorphism overlapping2) {
        boolean failed;
        this.failedApplConds.clear();
        Rule cr = null;
        this.disjoint = false;
        Graph graphE = overlapping1.getTarget();
        OrdinaryMorphism iso1 = graphE.isomorphicCopy();
        if (iso1 == null) {
            return null;
        }
        OrdinaryMorphism crMorph = iso1.getTarget().isomorphicCopy();
        if (crMorph == null) {
            iso1.dispose();
            return null;
        }
        Graph leftCR = crMorph.getSource();
        Graph rightCR = crMorph.getTarget();
        Match match1 = this.constructMatch1(leftCR, inverseRule1, overlapping1, iso1);
        Match match2 = this.constructMatch2(rightCR, rule2, overlapping2, iso1, crMorph);
        OrdinaryMorphism lhs1ToLHS = this.constructLHSbyPO(match1);
        boolean bl = failed = lhs1ToLHS == null;
        if (!failed) {
            OrdinaryMorphism rhs2ToRHS = this.constructRHSbyPO(match2);
            boolean bl2 = failed = rhs2ToRHS == null;
            if (!failed) {
                cr = BaseFactory.theFactory().constructRuleFromMorph(crMorph);
                cr.setName(String.valueOf(rule1.getName()) + "+" + rule2.getName());
                this.embLr1ToLcr = isoLeft1.compose(lhs1ToLHS);
                this.embRr1ToRcr = isoRight1.compose(overlapping1).compose(iso1).compose(crMorph);
                this.embLr2ToLcr = overlapping2.compose(iso1);
                this.embRr2ToRcr = rhs2ToRHS;
                boolean includedPACs = true;
                cr.notApplicable = !this.shiftCondsOfRuleOverEmbMorph(cr, rule1, this.embLr1ToLcr, includedPACs);
                includedPACs = true;
                cr.notApplicable = !this.shiftCondsOfRuleOverMorphAndRight(cr, rule2, overlapping2, iso1, this.embLr2ToLcr, includedPACs);
                this.removeIsomorphicMorph(cr.getNACsList());
                this.removeIsomorphicMorph(cr.getPACsList());
                this.addAttrConditionFromTo(rule1, cr);
                this.addAttrConditionFromTo(rule2, cr);
                OrdinaryMorphism rule1LHS2leftCR = isoLeft1.compose(lhs1ToLHS);
                this.adjustLeftMappedAttrs(cr, rule1, rule1LHS2leftCR);
                this.setAttrExpressionOfConcurrentRule(match2.getRule(), match2, rhs2ToRHS, cr);
                this.addUndeclaredVariableOfExpression(cr);
                BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(cr);
                cr.removeUnusedVariableOfAttrContext();
                this.adjustUnsetAttrsAboveMorph(this.embLr1ToLcr);
                this.setInputParameterIfNeeded(cr);
                cr.isReadyToTransform();
                rule1LHS2leftCR.dispose();
            }
        }
        BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(rule1);
        BaseFactory.theFactory().unsetAllTransientAttrValuesOfRule(rule2);
        return cr;
    }

    private Match constructMatch1(Graph leftCR, Rule inverseRule1, OrdinaryMorphism m1, OrdinaryMorphism iso1) {
        boolean failed = false;
        Match match1 = BaseFactory.theFactory().createMatch(inverseRule1, leftCR, true);
        match1.setCompletionStrategy(new Completion_InjCSP());
        match1.getTarget().setCompleteGraph(false);
        Enumeration<GraphObject> dom1 = m1.getDomain();
        while (dom1.hasMoreElements() && !failed) {
            GraphObject obj = dom1.nextElement();
            try {
                match1.addMapping(obj, iso1.getImage(m1.getImage(obj)));
            }
            catch (Exception ex) {
                failed = true;
            }
        }
        return match1;
    }

    private OrdinaryMorphism constructLHSbyPO(Match match) {
        OrdinaryMorphism comatch = null;
        try {
            comatch = (OrdinaryMorphism)TestStep.execute(match, true, this.enableEqualVariableNameOfAttrMapping);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return comatch;
    }

    private Match constructMatch2(Graph rightCR, Rule rule2, OrdinaryMorphism m2, OrdinaryMorphism iso1, OrdinaryMorphism iso2) {
        boolean failed = false;
        Match match2 = BaseFactory.theFactory().createMatch(rule2, rightCR, true);
        match2.setCompletionStrategy(new Completion_InjCSP());
        match2.getTarget().setCompleteGraph(false);
        Enumeration<GraphObject> dom2 = m2.getDomain();
        while (!failed && dom2.hasMoreElements()) {
            GraphObject obj = dom2.nextElement();
            try {
                match2.addMapping(obj, iso2.getImage(iso1.getImage(m2.getImage(obj))));
            }
            catch (BadMappingException ex) {
                failed = true;
            }
        }
        return match2;
    }

    private OrdinaryMorphism constructRHSbyPO(Match match) {
        OrdinaryMorphism comatch = null;
        try {
            comatch = (OrdinaryMorphism)TestStep.execute(match, true, this.enableEqualVariableNameOfAttrMapping);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return comatch;
    }

    private boolean shiftCondsOfRuleOverEmbMorph(Rule cr, Rule rule, OrdinaryMorphism lhsToLHS, boolean alsoPACs) {
        OrdinaryMorphism condCR;
        int l;
        List<OrdinaryMorphism> condList;
        boolean ok = true;
        if (alsoPACs && rule.getPACs().hasMoreElements()) {
            condList = this.shiftPACsOverEmbMorph(cr, rule, rule.getPACs(), lhsToLHS);
            if (cr.notApplicable) {
                return false;
            }
            if (condList != null && !condList.isEmpty()) {
                this.removeIsomorphicMorph(condList);
                l = 0;
                while (l < condList.size()) {
                    condCR = condList.get(l);
                    condCR.getImage().setAttrContext(cr.getLeft().getAttrContext());
                    condCR.setAttrContext(cr.getLeft().getAttrContext());
                    BaseFactory.theBaseFactory.declareVariable(condCR.getTarget(), (VarTuple)cr.getAttrContext().getVariables());
                    if (!condCR.isRightTotal() || !condCR.doesIgnoreAttrs()) {
                        cr.addPAC(condCR);
                    }
                    ++l;
                }
            }
        }
        if (ok && rule.getNACs().hasMoreElements() && (condList = this.shiftNACsOverEmbMorph(rule, rule.getNACs(), lhsToLHS)) != null && !condList.isEmpty()) {
            this.removeIsomorphicMorph(condList);
            l = 0;
            while (l < condList.size()) {
                condCR = condList.get(l);
                condCR.getImage().setAttrContext(cr.getLeft().getAttrContext());
                condCR.setAttrContext(cr.getLeft().getAttrContext());
                BaseFactory.theBaseFactory.declareVariable(condCR.getTarget(), (VarTuple)cr.getAttrContext().getVariables());
                if (!condCR.isRightTotal() || !condCR.doesIgnoreAttrs()) {
                    cr.addNAC(condCR);
                }
                ++l;
            }
        }
        return ok;
    }

    private void removeIsomorphicMorph(List<OrdinaryMorphism> list) {
        if (list.size() >= 2) {
            Vector<OrdinaryMorphism> list1 = new Vector<OrdinaryMorphism>(list);
            int i = 0;
            while (i < list1.size()) {
                OrdinaryMorphism m1 = (OrdinaryMorphism)list1.get(i);
                if (list.contains(m1)) {
                    int j = 0;
                    while (j < list.size()) {
                        OrdinaryMorphism iso;
                        OrdinaryMorphism m = list.get(j);
                        if (m != m1 && (iso = m1.getTarget().getIsomorphicWith(m.getTarget())) != null) {
                            if (m1.isCommutative(m, iso)) {
                                list.remove(j);
                                --j;
                            }
                            iso.dispose();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private boolean extendLeftRightGraphsByPACsOfRule(Rule concurRule, Rule rule, OrdinaryMorphism leftRuleToLeftCR) {
        boolean ok = true;
        List<OrdinaryMorphism> pacs = rule.getPACsList();
        int i = 0;
        while (i < pacs.size() && ok) {
            OrdinaryMorphism pac = pacs.get(i);
            OrdinaryMorphism pacGraph2concurRuleLHS = this.extendTargetGraph(leftRuleToLeftCR, pac, concurRule);
            Hashtable<Node, Node> tmp = new Hashtable<Node, Node>(5);
            Iterator<Node> en = pac.getTarget().getNodesSet().iterator();
            while (en.hasNext() && ok) {
                GraphObject o = en.next();
                if (pac.getInverseImage(o).hasMoreElements()) continue;
                Node lhsNode = (Node)pacGraph2concurRuleLHS.getImage(o);
                try {
                    Node rhsNode = concurRule.getRight().copyNode(lhsNode);
                    rhsNode.setContextUsage(o.hashCode());
                    tmp.put(lhsNode, rhsNode);
                    try {
                        concurRule.addMapping(lhsNode, rhsNode);
                    }
                    catch (BadMappingException exc) {
                        ok = false;
                    }
                }
                catch (TypeException ex) {
                    ok = false;
                }
            }
            Iterator<Arc> ea = pac.getTarget().getArcsSet().iterator();
            while (ea.hasNext() && ok) {
                GraphObject o = ea.next();
                if (pac.getInverseImage(o).hasMoreElements()) continue;
                Arc lhsArc = (Arc)pacGraph2concurRuleLHS.getImage(o);
                if (lhsArc != null && concurRule.getImage(lhsArc.getSource()) != null && concurRule.getImage(lhsArc.getTarget()) != null) {
                    Node src = (Node)concurRule.getImage(lhsArc.getSource());
                    Node tar = (Node)concurRule.getImage(lhsArc.getTarget());
                    if (src == null || tar == null) continue;
                    try {
                        Arc rhsArc = concurRule.getRight().copyArc(lhsArc, src, tar);
                        try {
                            concurRule.addMapping(lhsArc, rhsArc);
                        }
                        catch (BadMappingException exc) {
                            ok = false;
                        }
                    }
                    catch (TypeException ex) {
                        ok = false;
                    }
                    continue;
                }
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    private boolean checkCorrespondingAttrsOfPACs(Rule rule) {
        boolean ok = true;
        List<OrdinaryMorphism> pacs = rule.getPACsList();
        int i = 0;
        while (i < pacs.size() && ok) {
            OrdinaryMorphism pac = pacs.get(i);
            ok = this.checkCorrespondingAttrsOfApplCondition(rule, pac);
            ++i;
        }
        return ok;
    }

    private boolean checkCorrespondingAttrsOfApplCondition(Rule rule, OrdinaryMorphism applCond) {
        boolean ok = true;
        Enumeration<GraphObject> dom = applCond.getDomain();
        block0: while (dom.hasMoreElements() && ok) {
            GraphObject lhsObj = dom.nextElement();
            GraphObject acObj = applCond.getImage(lhsObj);
            if (acObj == null || acObj.getAttribute() == null) continue;
            ValueTuple acVal = (ValueTuple)acObj.getAttribute();
            ValueTuple lhsVal = (ValueTuple)lhsObj.getAttribute();
            int i = 0;
            while (i < lhsVal.getNumberOfEntries()) {
                ValueMember lhsMem = lhsVal.getEntryAt(i);
                ValueMember acMem = acVal.getEntryAt(lhsMem.getName());
                if (lhsMem.isSet() && (acMem == null || acMem.isSet()) && !lhsMem.getExprAsText().equals(acMem.getExprAsText())) {
                    ok = false;
                    continue block0;
                }
                ++i;
            }
        }
        return ok;
    }

    private boolean shiftCondsOfRuleOverMorphAndRight(Rule cr, Rule rule, OrdinaryMorphism morph, OrdinaryMorphism right, OrdinaryMorphism embMorph, boolean alsoPACs) {
        OrdinaryMorphism condCR;
        int l;
        List<OrdinaryMorphism> condList;
        boolean ok = true;
        if (alsoPACs) {
            condList = this.shiftPACsOverMorphAndRight(cr, rule, rule.getPACs(), morph, right, embMorph);
            if (cr.notApplicable) {
                return false;
            }
            if (condList != null && !condList.isEmpty()) {
                this.removeIsomorphicMorph(condList);
                l = 0;
                while (l < condList.size()) {
                    condCR = condList.get(l);
                    condCR.getImage().setAttrContext(cr.getLeft().getAttrContext());
                    condCR.setAttrContext(cr.getLeft().getAttrContext());
                    BaseFactory.theBaseFactory.declareVariable(condCR.getTarget(), (VarTuple)cr.getAttrContext().getVariables());
                    if (!condCR.isRightTotal() || !condCR.doesIgnoreAttrs()) {
                        cr.addPAC(condCR);
                    }
                    ++l;
                }
            }
        }
        if (ok && (condList = this.shiftNACsOverMorphAndRight(cr, rule, rule.getNACs(), morph, right, embMorph)) != null && !condList.isEmpty()) {
            this.removeIsomorphicMorph(condList);
            l = 0;
            while (l < condList.size()) {
                condCR = condList.get(l);
                condCR.getImage().setAttrContext(cr.getLeft().getAttrContext());
                condCR.setAttrContext(cr.getLeft().getAttrContext());
                BaseFactory.theBaseFactory.declareVariable(condCR.getTarget(), (VarTuple)cr.getAttrContext().getVariables());
                if (!condCR.isRightTotal() || !condCR.doesIgnoreAttrs()) {
                    cr.addNAC(condCR);
                }
                ++l;
            }
        }
        return ok;
    }

    private boolean shiftCondsOfRuleOverMorphAndLeft(Rule cr, Rule rule, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph, boolean alsoPACs) {
        OrdinaryMorphism condCR;
        int l;
        List<OrdinaryMorphism> condList;
        boolean ok = true;
        if (alsoPACs) {
            condList = this.shiftPACsOverMorphAndLeft(cr, rule, rule.getPACs(), morph, left, embMorph);
            if (cr.notApplicable) {
                return false;
            }
            if (condList != null && !condList.isEmpty()) {
                this.removeIsomorphicMorph(condList);
                l = 0;
                while (l < condList.size()) {
                    condCR = condList.get(l);
                    condCR.getImage().setAttrContext(cr.getLeft().getAttrContext());
                    condCR.setAttrContext(cr.getLeft().getAttrContext());
                    BaseFactory.theBaseFactory.declareVariable(condCR.getTarget(), (VarTuple)cr.getAttrContext().getVariables());
                    if (!condCR.isRightTotal() || !condCR.doesIgnoreAttrs()) {
                        cr.addPAC(condCR);
                    }
                    ++l;
                }
            }
        }
        if (ok && (condList = this.shiftNACsOverMorphAndLeft(cr, rule, rule.getNACs(), morph, left, embMorph)) != null && !condList.isEmpty()) {
            this.removeIsomorphicMorph(condList);
            l = 0;
            while (l < condList.size()) {
                condCR = condList.get(l);
                condCR.getImage().setAttrContext(cr.getLeft().getAttrContext());
                condCR.setAttrContext(cr.getLeft().getAttrContext());
                BaseFactory.theBaseFactory.declareVariable(condCR.getTarget(), (VarTuple)cr.getAttrContext().getVariables());
                if (!condCR.isRightTotal() || !condCR.doesIgnoreAttrs()) {
                    cr.addNAC(condCR);
                }
                ++l;
            }
        }
        return ok;
    }

    private List<OrdinaryMorphism> shiftPACsOverEmbMorph(Rule cr, Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        while (conds.hasMoreElements()) {
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() > 0) {
                List<OrdinaryMorphism> list = this.shiftCondOverEmbMorph(cond, morph);
                if (list != null && list.size() > 0) {
                    OrdinaryMorphism lc;
                    int i = 0;
                    while (i < list.size()) {
                        lc = list.get(i);
                        this.filterCondL(cond, lc, morph);
                        this.filterNotNeededObjs(lc, morph);
                        if (lc.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc, morph)) {
                            this.adjustUnsetAttrsAboveMorphs(cond, morph, lc);
                            result.add(lc);
                        } else {
                            list.remove(lc);
                            --i;
                        }
                        ++i;
                    }
                    if (list.size() <= 1) continue;
                    i = 1;
                    while (i < list.size()) {
                        lc = list.get(i);
                        lc.setName(lc.getName().concat("(OR)"));
                        ++i;
                    }
                    cr.addShiftedPAC(list);
                    continue;
                }
                cr.notApplicable = true;
                result.clear();
                result = null;
                break;
            }
            OrdinaryMorphism lc = this.shiftGlobalRuleCond1(rule, cond, morph);
            if (lc == null) continue;
            this.adjustUnsetAttrsAboveMorphs(cond, morph, lc);
            result.add(lc);
        }
        return result;
    }

    private List<OrdinaryMorphism> shiftNACsOverEmbMorph(Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        while (conds.hasMoreElements()) {
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() > 0) {
                List<OrdinaryMorphism> list = this.shiftCondOverEmbMorph(cond, morph);
                if (list == null || list.size() <= 0) continue;
                int i = 0;
                while (i < list.size()) {
                    OrdinaryMorphism lc = list.get(i);
                    this.filterCondL(cond, lc, morph);
                    this.filterNotNeededObjs(lc, morph);
                    if (lc.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc, morph)) {
                        this.adjustUnsetAttrsAboveMorphs(cond, morph, lc);
                        result.add(lc);
                    }
                    ++i;
                }
                list.clear();
                continue;
            }
            OrdinaryMorphism lc = this.shiftGlobalRuleCond1(rule, cond, morph);
            if (lc == null) continue;
            this.adjustUnsetAttrsAboveMorphs(cond, morph, lc);
            result.add(lc);
        }
        return result;
    }

    private List<OrdinaryMorphism> shiftPACsOverMorphAndRight(Rule cr, Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph, OrdinaryMorphism right, OrdinaryMorphism embMorph) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        while (conds.hasMoreElements()) {
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() > 0) {
                List<OrdinaryMorphism> list = this.shiftCondOverMorph(rule, cond, morph);
                Vector<OrdinaryMorphism> list2 = null;
                if (list != null && list.size() > 0) {
                    list2 = new Vector<OrdinaryMorphism>();
                    int i = 0;
                    while (i < list.size()) {
                        OrdinaryMorphism c = list.get(i);
                        OrdinaryMorphism lc = BaseFactory.theBaseFactory.createMorphism(right.getTarget(), c.getTarget());
                        Enumeration<GraphObject> dom = c.getDomain();
                        while (dom.hasMoreElements()) {
                            GraphObject go = dom.nextElement();
                            GraphObject go1 = c.getImage(go);
                            GraphObject go2 = right.getImage(go);
                            if (go2 == null) continue;
                            try {
                                lc.addMapping(go2, go1);
                            }
                            catch (BadMappingException ex) {
                                System.out.println("########### Shift Left FAILED!  Rule: " + rule.getName() + "   AC: " + cond.getName() + "  cr: " + cr.getName());
                            }
                        }
                        if (lc.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc, embMorph)) {
                            lc.setName(c.getName());
                            lc.setEnabled(cond.isEnabled());
                            this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
                            list2.add(lc);
                        }
                        ++i;
                    }
                }
                if (list2 != null && list2.size() > 0) {
                    result.addAll(list2);
                    if (list2.size() <= 1) continue;
                    cr.addShiftedPAC(list2);
                    continue;
                }
                cr.notApplicable = true;
                result.clear();
                result = null;
                break;
            }
            OrdinaryMorphism lc = this.shiftGlobalRuleCond1(rule, cond, morph.compose(right));
            if (lc == null) continue;
            this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
            result.add(lc);
        }
        return result;
    }

    private List<OrdinaryMorphism> shiftNACsOverMorphAndRight(Rule cr, Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph, OrdinaryMorphism right, OrdinaryMorphism embMorph) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        while (conds.hasMoreElements()) {
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() > 0) {
                List<OrdinaryMorphism> list = this.shiftCondOverMorph(rule, cond, morph);
                Vector<OrdinaryMorphism> list2 = new Vector<OrdinaryMorphism>();
                int i = 0;
                while (i < list.size()) {
                    OrdinaryMorphism c = list.get(i);
                    OrdinaryMorphism lc = BaseFactory.theBaseFactory.createMorphism(right.getTarget(), c.getTarget());
                    Enumeration<GraphObject> dom = c.getDomain();
                    while (dom.hasMoreElements()) {
                        GraphObject go = dom.nextElement();
                        GraphObject go1 = c.getImage(go);
                        GraphObject go2 = right.getImage(go);
                        if (go2 == null) continue;
                        try {
                            lc.addMapping(go2, go1);
                        }
                        catch (BadMappingException ex) {
                            System.out.println("########### Shift Left FAILED!  Rule: " + rule.getName() + "   AC: " + cond.getName() + "  cr: " + cr.getName());
                        }
                    }
                    if (lc.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc, embMorph)) {
                        lc.setName(c.getName());
                        lc.setEnabled(cond.isEnabled());
                        this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
                        list2.add(lc);
                    }
                    ++i;
                }
                if (list2 == null || list2.size() <= 0) continue;
                result.addAll(list2);
                continue;
            }
            OrdinaryMorphism lc = this.shiftGlobalRuleCond1(rule, cond, morph.compose(right));
            if (lc == null) continue;
            this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
            result.add(lc);
        }
        return result;
    }

    private List<OrdinaryMorphism> shiftPACsOverMorphAndLeft(Rule cr, Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        while (conds.hasMoreElements()) {
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() > 0) {
                int i;
                List<OrdinaryMorphism> list = this.shiftCondOverMorph(rule, cond, morph);
                Vector<OrdinaryMorphism> list2 = null;
                if (list != null && list.size() > 0) {
                    list2 = new Vector<OrdinaryMorphism>();
                    i = 0;
                    while (i < list.size()) {
                        OrdinaryMorphism c = list.get(i);
                        OrdinaryMorphism lc = BaseFactory.theBaseFactory.shiftApplCondLeft(c, left);
                        this.filterCondL(cond, lc, embMorph);
                        this.filterNotNeededObjs(lc, embMorph);
                        if (lc.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc, embMorph)) {
                            lc.setName(c.getName());
                            lc.setEnabled(cond.isEnabled());
                            this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
                            list2.add(lc);
                        }
                        ++i;
                    }
                }
                if (list2 != null && list2.size() > 0) {
                    result.addAll(list2);
                    if (list2.size() <= 1) continue;
                    i = 1;
                    while (i < list2.size()) {
                        OrdinaryMorphism lc = (OrdinaryMorphism)list2.get(i);
                        lc.setName(lc.getName().concat("(OR)"));
                        ++i;
                    }
                    cr.addShiftedPAC(list2);
                    continue;
                }
                cr.notApplicable = true;
                result.clear();
                result = null;
                break;
            }
            OrdinaryMorphism lc = this.shiftGlobalRuleCond2(rule, cond, left);
            if (lc == null) continue;
            this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
            result.add(lc);
        }
        return result;
    }

    private List<OrdinaryMorphism> shiftNACsOverMorphAndLeft(Rule cr, Rule rule, Enumeration<OrdinaryMorphism> conds, OrdinaryMorphism morph, OrdinaryMorphism left, OrdinaryMorphism embMorph) {
        Vector<OrdinaryMorphism> result = new Vector<OrdinaryMorphism>();
        while (conds.hasMoreElements()) {
            OrdinaryMorphism cond = conds.nextElement();
            if (cond.getSize() > 0) {
                List<OrdinaryMorphism> list = this.shiftCondOverMorph(rule, cond, morph);
                Vector<OrdinaryMorphism> list2 = new Vector<OrdinaryMorphism>();
                int i = 0;
                while (i < list.size()) {
                    OrdinaryMorphism c = list.get(i);
                    OrdinaryMorphism lc = BaseFactory.theBaseFactory.shiftApplCondLeft(c, left);
                    this.filterCondL(cond, lc, embMorph);
                    this.filterNotNeededObjs(lc, embMorph);
                    if (lc.getTarget().getSize() >= cond.getTarget().getSize() && !this.isFalseCond(cond, lc, embMorph)) {
                        lc.setName(c.getName());
                        lc.setEnabled(cond.isEnabled());
                        this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
                        list2.add(lc);
                    }
                    ++i;
                }
                if (list2 == null || list2.size() <= 0) continue;
                result.addAll(list2);
                continue;
            }
            OrdinaryMorphism lc = this.shiftGlobalRuleCond2(rule, cond, left);
            if (lc == null) continue;
            this.adjustUnsetAttrsAboveMorphs(cond, embMorph, lc);
            result.add(lc);
        }
        return result;
    }

    private void filterNotNeededObjs(OrdinaryMorphism cond, OrdinaryMorphism iL) {
        Vector<GraphObject> delete = new Vector<GraphObject>();
        for (Arc arc : cond.getTarget().getArcsSet()) {
            GraphObject lgo;
            Enumeration<GraphObject> inv = cond.getInverseImage(arc);
            if (!inv.hasMoreElements() || iL.getInverseImage(lgo = inv.nextElement()).hasMoreElements() || !this.similarAttribute(lgo, arc)) continue;
            delete.add(arc);
        }
        int i = 0;
        while (i < delete.size()) {
            Arc arc = (Arc)delete.get(i);
            try {
                cond.removeMapping(arc);
                try {
                    cond.getTarget().destroyArc(arc, false, false);
                }
                catch (TypeException lgo) {}
            }
            catch (BadMappingException lgo) {
                // empty catch block
            }
            ++i;
        }
        delete.clear();
        for (Node node : cond.getTarget().getNodesSet()) {
            GraphObject lgo;
            Enumeration<GraphObject> inv;
            if (node.getOutgoingArcs().hasNext() || node.getIncomingArcs().hasNext() || !(inv = cond.getInverseImage(node)).hasMoreElements() || iL.getInverseImage(lgo = inv.nextElement()).hasMoreElements() || !this.similarAttribute(lgo, node)) continue;
            delete.add(node);
        }
        int i2 = 0;
        while (i2 < delete.size()) {
            Node node = (Node)delete.get(i2);
            try {
                cond.removeMapping(node);
                try {
                    cond.getTarget().destroyNode(node, false, false);
                }
                catch (TypeException typeException) {}
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
            ++i2;
        }
        delete.clear();
        delete = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean similarAttribute(GraphObject go1, GraphObject go2) {
        if (go1.getAttribute() == null || go2.getAttribute() == null) return true;
        ValueTuple val1 = (ValueTuple)go1.getAttribute();
        ValueTuple val2 = (ValueTuple)go2.getAttribute();
        int i = 0;
        while (i < val2.getNumberOfEntries()) {
            ValueMember vm2 = val2.getValueMemberAt(i);
            ValueMember vm1 = val1.getValueMemberAt(vm2.getName());
            if (vm2.isSet()) {
                if (vm1 == null || !vm1.isSet()) return false;
                if (!vm2.getExprAsText().equals(vm1.getExprAsText())) {
                    return false;
                }
            } else if (vm1.isSet()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private OrdinaryMorphism shiftGlobalRuleCond1(Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph) {
        OrdinaryMorphism condIsom = cond.getTarget().isomorphicCopy();
        if (condIsom == null) {
            return null;
        }
        OrdinaryMorphism condCR = BaseFactory.theBaseFactory.createMorphism(morph.getTarget(), condIsom.getTarget());
        condCR.setName(cond.getName());
        condCR.setEnabled(cond.isEnabled());
        return condCR;
    }

    private OrdinaryMorphism shiftGlobalRuleCond2(Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph) {
        OrdinaryMorphism condIsom = cond.getTarget().isomorphicCopy();
        if (condIsom == null) {
            return null;
        }
        OrdinaryMorphism condCR = BaseFactory.theBaseFactory.createMorphism(morph.getSource(), condIsom.getTarget());
        condCR.setName(cond.getName());
        condCR.setEnabled(cond.isEnabled());
        return condCR;
    }

    private List<OrdinaryMorphism> shiftCondOverEmbMorph(OrdinaryMorphism cond, OrdinaryMorphism morph) {
        Vector<OrdinaryMorphism> list = new Vector<OrdinaryMorphism>();
        OrdinaryMorphism condSrcIsom = cond.getSource().isomorphicCopy();
        if (condSrcIsom == null) {
            return null;
        }
        BaseFactory.theBaseFactory.extendTargetGraph1ByTargetGraph2(condSrcIsom, cond);
        Graph dCondGraph = condSrcIsom.getTarget();
        Vector<GraphObject> condDom = condSrcIsom.getDomainObjects();
        Vector<Object> requiredObjs = new Vector<Object>(condDom.size());
        Hashtable<Object, Object> objmap = new Hashtable<Object, Object>(condDom.size());
        int j = 0;
        while (j < condDom.size()) {
            GraphObject go = condDom.get(j);
            GraphObject go1 = condSrcIsom.getImage(go);
            GraphObject go2 = morph.getImage(go);
            if (go1 != null && go2 != null) {
                requiredObjs.add(go1);
                objmap.put(go1, go2);
            }
            ++j;
        }
        Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlaps = BaseFactory.theBaseFactory.getOverlappingByPartialPredefinedIntersection(dCondGraph, morph.getTarget(), requiredObjs, objmap, true);
        while (overlaps.hasMoreElements()) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> p = overlaps.nextElement();
            if (((OrdinaryMorphism)p.second).getTarget().isEmpty()) continue;
            OrdinaryMorphism c = (OrdinaryMorphism)p.second;
            c.setEnabled(cond.isEnabled());
            c.setName(cond.getName());
            c.shifted = true;
            list.add(c);
        }
        return list.isEmpty() ? null : list;
    }

    private List<OrdinaryMorphism> shiftCondOverMorph(Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph) {
        Enumeration<GraphObject> dom = cond.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject go = dom.nextElement();
            if (morph.getImage(go) != null) continue;
            this.failedApplConds.add(cond);
            return null;
        }
        OrdinaryMorphism condIsom = cond.getTarget().isomorphicCopy();
        if (condIsom == null) {
            this.failedApplConds.add(cond);
            return null;
        }
        OrdinaryMorphism leftToCond = cond.compose(condIsom);
        Vector<GraphObject> condDom = cond.getDomainObjects();
        Vector<Object> requiredObjs = new Vector<Object>(condDom.size());
        Hashtable<Object, Object> objmap = new Hashtable<Object, Object>(condDom.size());
        int j = 0;
        while (j < condDom.size()) {
            GraphObject go = condDom.get(j);
            GraphObject go1 = leftToCond.getImage(go);
            GraphObject go2 = morph.getImage(go);
            if (go1 != null && go2 != null) {
                requiredObjs.add(go1);
                objmap.put(go1, go2);
            }
            ++j;
        }
        Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlaps = BaseFactory.theBaseFactory.getOverlappingByPartialPredefinedIntersection(condIsom.getTarget(), morph.getTarget(), requiredObjs, objmap, true);
        Vector<OrdinaryMorphism> list = new Vector<OrdinaryMorphism>();
        while (overlaps.hasMoreElements()) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> p = overlaps.nextElement();
            OrdinaryMorphism condCR = (OrdinaryMorphism)p.second;
            if (((OrdinaryMorphism)p.second).getTarget().isEmpty()) continue;
            this.filterObjsOfRightRuleCond(rule, cond, condIsom, (OrdinaryMorphism)p.first, condCR, morph);
            condCR.setName(cond.getName().concat(String.valueOf(list.size())));
            condCR.setEnabled(cond.isEnabled());
            condCR.shifted = true;
            list.add(condCR);
        }
        if (list.isEmpty()) {
            this.failedApplConds.add(cond);
        }
        return list;
    }

    private boolean filterObjsOfRightRuleCond(Rule r, OrdinaryMorphism condL, OrdinaryMorphism condIsom, OrdinaryMorphism condTargetToCondCR, OrdinaryMorphism condCR, OrdinaryMorphism leftEmbeddingMorph) {
        boolean ok = true;
        Vector<GraphObject> todelete = new Vector<GraphObject>();
        for (Arc go_condCR : condCR.getTarget().getArcsSet()) {
            Arc goInv_condCR = null;
            if (!condCR.getInverseImage(go_condCR).hasMoreElements()) continue;
            if (condTargetToCondCR.getInverseImage(go_condCR).hasMoreElements()) {
                goInv_condCR = (Arc)condTargetToCondCR.getInverseImage(go_condCR).nextElement();
            }
            if (goInv_condCR == null) {
                todelete.add(go_condCR);
                continue;
            }
            if (!condIsom.getInverseImage(goInv_condCR).hasMoreElements()) {
                todelete.add(go_condCR);
                continue;
            }
            Arc go_leftCR = (Arc)condCR.getInverseImage(go_condCR).nextElement();
            if (r == this.source2) {
                if (this.embLr2ToLcr.getInverseImage(go_leftCR).hasMoreElements()) {
                    Arc go_left2 = (Arc)this.embLr2ToLcr.getInverseImage(go_leftCR).nextElement();
                    if (condL.getImage(go_left2) != null) continue;
                    condCR.removeMapping(go_condCR);
                    continue;
                }
                if (!this.embLr1ToLcr.getInverseImage(go_leftCR).hasMoreElements()) continue;
                todelete.add(go_condCR);
                continue;
            }
            if (r != this.source1) continue;
            if (this.embLr1ToLcr.getInverseImage(go_leftCR).hasMoreElements()) {
                Arc go_left1 = (Arc)this.embLr1ToLcr.getInverseImage(go_leftCR).nextElement();
                if (condL.getImage(go_left1) != null) continue;
                condCR.removeMapping(go_condCR);
                continue;
            }
            if (!this.embLr2ToLcr.getInverseImage(go_leftCR).hasMoreElements()) continue;
            todelete.add(go_condCR);
        }
        int i = 0;
        while (i < todelete.size()) {
            try {
                condCR.getTarget().destroyArc((Arc)todelete.get(i), false, false);
            }
            catch (TypeException goInv_condCR) {
                // empty catch block
            }
            ++i;
        }
        todelete.clear();
        for (Node go_condCR : condCR.getTarget().getNodesSet()) {
            Node goInv_condCR = null;
            if (!condCR.getInverseImage(go_condCR).hasMoreElements()) continue;
            if (condTargetToCondCR.getInverseImage(go_condCR).hasMoreElements()) {
                goInv_condCR = (Node)condTargetToCondCR.getInverseImage(go_condCR).nextElement();
            }
            if (goInv_condCR == null) {
                todelete.add(go_condCR);
                continue;
            }
            if (!condIsom.getInverseImage(goInv_condCR).hasMoreElements()) {
                todelete.add(go_condCR);
                continue;
            }
            Node go_leftCR = (Node)condCR.getInverseImage(go_condCR).nextElement();
            if (r == this.source2) {
                if (this.embLr2ToLcr.getInverseImage(go_leftCR).hasMoreElements()) {
                    Node go_left2 = (Node)this.embLr2ToLcr.getInverseImage(go_leftCR).nextElement();
                    if (condL.getImage(go_left2) != null) continue;
                    condCR.removeMapping(go_condCR);
                    continue;
                }
                if (!this.embLr1ToLcr.getInverseImage(go_leftCR).hasMoreElements()) continue;
                todelete.add(go_condCR);
                continue;
            }
            if (r != this.source1) continue;
            if (this.embLr1ToLcr.getInverseImage(go_leftCR).hasMoreElements()) {
                Node go_left1 = (Node)this.embLr1ToLcr.getInverseImage(go_leftCR).nextElement();
                if (condL.getImage(go_left1) != null) continue;
                condCR.removeMapping(go_condCR);
                continue;
            }
            if (!this.embLr2ToLcr.getInverseImage(go_leftCR).hasMoreElements()) continue;
            todelete.add(go_condCR);
        }
        int i2 = 0;
        while (i2 < todelete.size()) {
            try {
                condCR.getTarget().destroyNode((Node)todelete.get(i2), false, false);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
            ++i2;
        }
        return ok;
    }

    private OrdinaryMorphism extendTargetGraph(OrdinaryMorphism isom, OrdinaryMorphism cond, Rule concurRule) {
        Graph extTarget = isom.getTarget();
        OrdinaryMorphism morph = BaseFactory.theFactory().createMorphism(cond.getTarget(), extTarget);
        Hashtable<Node, Node> tmp = new Hashtable<Node, Node>(5);
        for (GraphObject graphObject : cond.getTarget().getNodesSet()) {
            if (!cond.getInverseImage(graphObject).hasMoreElements()) {
                try {
                    Node node = extTarget.copyNode((Node)graphObject);
                    node.setContextUsage(graphObject.hashCode());
                    tmp.put((Node)graphObject, node);
                    try {
                        morph.addMapping(graphObject, node);
                    }
                    catch (BadMappingException badMappingException) {
                    }
                }
                catch (TypeException typeException) {}
                continue;
            }
            if (isom.getImage(cond.getInverseImage(graphObject).nextElement()) == null) continue;
            try {
                Node node = (Node)isom.getImage(cond.getInverseImage(graphObject).nextElement());
                node.setObjectName(graphObject.getObjectName());
                this.adjustAttrsFromTo(graphObject, node, concurRule);
                morph.addMapping(graphObject, isom.getImage(cond.getInverseImage(graphObject).nextElement()));
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        for (GraphObject graphObject : cond.getTarget().getArcsSet()) {
            if (!cond.getInverseImage(graphObject).hasMoreElements()) {
                Node tar;
                Node src = (Node)tmp.get(((Arc)graphObject).getSource());
                if (src == null) {
                    src = (Node)isom.getImage(cond.getInverseImage(((Arc)graphObject).getSource()).nextElement());
                }
                if ((tar = (Node)tmp.get(((Arc)graphObject).getTarget())) == null) {
                    tar = (Node)isom.getImage(cond.getInverseImage(((Arc)graphObject).getTarget()).nextElement());
                }
                try {
                    Arc a = extTarget.copyArc((Arc)graphObject, src, tar);
                    a.setContextUsage(graphObject.hashCode());
                    try {
                        morph.addMapping(graphObject, a);
                    }
                    catch (BadMappingException badMappingException) {
                    }
                }
                catch (TypeException typeException) {}
                continue;
            }
            if (isom.getImage(cond.getInverseImage(graphObject).nextElement()) == null) continue;
            try {
                Arc a = (Arc)isom.getImage(cond.getInverseImage(graphObject).nextElement());
                a.setObjectName(graphObject.getObjectName());
                this.adjustAttrsFromTo(graphObject, a, concurRule);
                morph.addMapping(graphObject, isom.getImage(cond.getInverseImage(graphObject).nextElement()));
            }
            catch (BadMappingException badMappingException) {
                // empty catch block
            }
        }
        return morph;
    }

    private void adjustAttrsFromTo(GraphObject from, GraphObject to, OrdinaryMorphism morph) {
        if (to != null && from.getAttribute() != null) {
            ValueTuple vt_from = (ValueTuple)from.getAttribute();
            ValueTuple vt_to = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < vt_from.getNumberOfEntries()) {
                ValueMember vm = vt_from.getValueMemberAt(i);
                if (vm.isSet()) {
                    ValueMember vm_to;
                    if (vm.getExpr().isVariable() && ((VarTuple)morph.getAttrContext().getVariables()).getVarMemberAt(vm.getExprAsText()) == null) {
                        ((VarTuple)morph.getAttrContext().getVariables()).getTupleType().addMember(vm.getHandler(), vm.getDeclaration().getTypeName(), vm.getExprAsText());
                        ((VarTuple)morph.getAttrContext().getVariables()).getVarMemberAt(vm.getExprAsText()).setTransient(false);
                    }
                    if ((vm_to = vt_to.getValueMemberAt(vm.getName())) != null) {
                        vm_to.setExprAsText(vm.getExprAsText());
                        vm_to.setTransient(false);
                    }
                }
                ++i;
            }
        }
    }

    private void adjustUnsetAttrsAboveMorph(OrdinaryMorphism morph) {
        Enumeration<GraphObject> dom = morph.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject from = dom.nextElement();
            GraphObject to = morph.getImage(from);
            if (from.getAttribute() == null || to.getAttribute() == null) continue;
            ValueTuple vt_from = (ValueTuple)from.getAttribute();
            ValueTuple vt_to = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < vt_from.getNumberOfEntries()) {
                ValueMember vm_to;
                ValueMember vm_from = vt_from.getValueMemberAt(i);
                if (!vm_from.isSet() && (vm_to = vt_to.getValueMemberAt(vm_from.getName())) != null && vm_to.isSet()) {
                    vm_to.setExpr(null);
                    vm_to.setTransient(false);
                }
                ++i;
            }
        }
    }

    private void adjustUnsetAttrsAboveMorphs(OrdinaryMorphism cond, OrdinaryMorphism morph, OrdinaryMorphism shifted) {
        Enumeration<GraphObject> dom = morph.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            GraphObject img = morph.getImage(obj);
            GraphObject from = cond.getImage(obj);
            GraphObject to = shifted.getImage(img);
            if (from == null || to == null || from.getAttribute() == null || to.getAttribute() == null) continue;
            ValueTuple vt_from = (ValueTuple)from.getAttribute();
            ValueTuple vt_to = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < vt_from.getNumberOfEntries()) {
                ValueMember vm_to;
                ValueMember vm_from = vt_from.getValueMemberAt(i);
                if (!vm_from.isSet() && (vm_to = vt_to.getValueMemberAt(vm_from.getName())) != null && vm_to.isSet()) {
                    vm_to.setExpr(null);
                    vm_to.setTransient(false);
                }
                ++i;
            }
        }
    }

    private void addAttrConditionFromTo(Rule fromRule, Rule toRule) {
        CondTuple condsFrom = (CondTuple)fromRule.getAttrContext().getConditions();
        if (condsFrom.isEmpty()) {
            return;
        }
        CondTuple conds = (CondTuple)toRule.getAttrContext().getConditions();
        int i = 0;
        while (i < condsFrom.getNumberOfEntries()) {
            CondMember cond = condsFrom.getCondMemberAt(i);
            if (this.isAttrCondRelevant(fromRule, cond)) {
                conds.addCondition(cond.getExprAsText());
            }
            ++i;
        }
    }

    private boolean isAttrCondRelevant(Rule r, CondMember cond) {
        Vector<String> condvars = cond.getAllVariables();
        int i = 0;
        while (i < this.failedApplConds.size()) {
            OrdinaryMorphism morph = this.failedApplConds.get(i);
            if (r.getLeft() == morph.getSource()) {
                Vector<String> vars = morph.getTarget().getVariableNamesOfAttributes();
                int j = 0;
                while (j < condvars.size()) {
                    if (vars.contains(condvars.get(j))) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private List<String> adjustLeftMappedAttrs(Rule cr, Rule rule, OrdinaryMorphism ruleLeftt2leftCR) {
        Vector<String> varToDelete = new Vector<String>();
        Enumeration<GraphObject> dom1 = rule.getDomain();
        while (dom1.hasMoreElements()) {
            GraphObject obj = dom1.nextElement();
            if (obj.getAttribute() == null) continue;
            GraphObject img = rule.getImage(obj);
            ValueTuple vt = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                GraphObject crRightObj;
                GraphObject crLeftObj;
                ValueMember vmImg;
                ValueMember vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable() && (vmImg = ((ValueTuple)img.getAttribute()).getValueMemberAt(vm.getName())) != null && vmImg.isSet() && vmImg.getExpr().isVariable() && vm.getExprAsText().equals(vmImg.getExprAsText()) && (crLeftObj = ruleLeftt2leftCR.getImage(obj)) != null && (crRightObj = cr.getImage(crLeftObj)) != null) {
                    ValueMember vm_crLeftObj = ((ValueTuple)crLeftObj.getAttribute()).getValueMemberAt(vm.getName());
                    ValueMember vm_crRightObj = ((ValueTuple)crRightObj.getAttribute()).getValueMemberAt(vm.getName());
                    if (vm_crLeftObj.isSet() && vm_crLeftObj.getExpr().isVariable() && vm_crRightObj.isSet() && vm_crRightObj.getExpr().isVariable() && !vm_crLeftObj.getExprAsText().equals(vm_crRightObj.getExprAsText())) {
                        vm_crLeftObj.setExpr(null);
                        vm_crLeftObj.setExprAsText(vm_crRightObj.getExprAsText());
                        if (!vm_crLeftObj.isTransient()) {
                            vm_crLeftObj.setTransient(vm_crRightObj.isTransient());
                        }
                    }
                }
                ++i;
            }
        }
        return varToDelete;
    }

    private void setAttrExpressionOfConcurrentRule(Rule rule2, OrdinaryMorphism match2, OrdinaryMorphism comatch2, OrdinaryMorphism concurrentMorph) {
        this.doSetAttrExpressionOfConcurrentRule(rule2, match2, comatch2, concurrentMorph, match2.getSource().getNodesSet().iterator());
        this.doSetAttrExpressionOfConcurrentRule(rule2, match2, comatch2, concurrentMorph, match2.getSource().getArcsSet().iterator());
    }

    private void doSetAttrExpressionOfConcurrentRule(Rule rule2, OrdinaryMorphism match2, OrdinaryMorphism comatch2, OrdinaryMorphism concurrentMorph, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject obj = (GraphObject)elems.next();
            GraphObject img = match2.getImage(obj);
            if (img == null || obj.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueTuple vtImg;
                ValueMember vmImg;
                ValueMember vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isVariable() && (vmImg = (vtImg = (ValueTuple)img.getAttribute()).getValueMemberAt(vm.getName())) != null && vmImg.isSet() && vmImg.getExpr().isVariable() && !vmImg.getExprAsText().equals(vm.getExprAsText())) {
                    this.replaceVariable(vm.getExprAsText(), vmImg.getExprAsText(), rule2, comatch2, concurrentMorph);
                }
                ++i;
            }
        }
    }

    private void replaceVariable(String from, String to, Rule rule2, OrdinaryMorphism comatch2, OrdinaryMorphism concurrentMorph) {
        this.doReplaceVariable(from, to, concurrentMorph.getAttrContext(), concurrentMorph.getTarget().getNodesSet().iterator());
        this.doReplaceVariable(from, to, concurrentMorph.getAttrContext(), concurrentMorph.getTarget().getArcsSet().iterator());
        BaseFactory.theFactory().renameVariableOfCondition(concurrentMorph.getAttrContext(), (CondTuple)concurrentMorph.getAttrContext().getConditions(), from, to);
        this.removeVariableOfAttrContext(concurrentMorph.getAttrContext(), from);
    }

    private void doReplaceVariable(String from, String to, AttrContext ac, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject obj = (GraphObject)elems.next();
            if (obj.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(i);
                if (vm.isSet()) {
                    if (vm.getExpr().isVariable()) {
                        if (vm.getExprAsText().equals(from)) {
                            vm.setExpr(null);
                            vm.setExprAsText(to);
                            VarMember var = this.addVariableToAttrContext(ac, from, to);
                            if (!vm.isTransient() && var != null) {
                                vm.setTransient(true);
                            }
                        }
                    } else if (vm.getExpr().isComplex()) {
                        Vector<String> v = new Vector<String>();
                        vm.getExpr().getAllVariables(v);
                        if (v.contains(from)) {
                            BaseFactory.theFactory().renameVariableOfExpression(ac, vt, from, to);
                            this.addVariableToAttrContext(ac, from, to);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void addUndeclaredVariableOfExpression(OrdinaryMorphism concurrentMorph) {
        this.doAddUndeclaredVariableOfExpression(concurrentMorph, concurrentMorph.getTarget().getNodesSet().iterator());
        this.doAddUndeclaredVariableOfExpression(concurrentMorph, concurrentMorph.getTarget().getArcsSet().iterator());
    }

    private void doAddUndeclaredVariableOfExpression(OrdinaryMorphism concurrentMorph, Iterator<?> elems) {
        VarTuple vars = (VarTuple)concurrentMorph.getAttrContext().getVariables();
        while (elems.hasNext()) {
            GraphObject obj = (GraphObject)elems.next();
            if (obj.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isComplex()) {
                    Vector<String> v = new Vector<String>();
                    vm.getExpr().getAllVariables(v);
                    int j = 0;
                    while (j < v.size()) {
                        if (vars.getVarMemberAt(v.get(j)) == null) {
                            this.addVariableToAttrContext(concurrentMorph.getAttrContext(), null, v.get(j));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private VarMember addVariableToAttrContext(AttrContext attrContext, String from, String to) {
        VarTuple vars = (VarTuple)attrContext.getVariables();
        VarMember v = null;
        if (vars.getVarMemberAt(to) == null) {
            if (from != null) {
                vars.getTupleType().addMember(vars.getVarMemberAt(from).getDeclaration().getHandler(), vars.getVarMemberAt(from).getDeclaration().getTypeName(), to);
            } else {
                vars.getTupleType().addMember(AvailableHandlers.newInstances()[0], "String", to);
            }
            v = vars.getVarMemberAt(to);
            v.setTransient(true);
        }
        return v;
    }

    private void removeVariableOfAttrContext(AttrContext attrContext, String var) {
        VarTuple vars;
        if (!(this.concurrentRule == null || (vars = (VarTuple)attrContext.getVariables()).getVarMemberAt(var) == null || this.concurrentRule.getLeft().getVariableNamesOfAttributes().contains(var) || this.concurrentRule.getRight().getVariableNamesOfAttributes().contains(var) || this.isUsedInGraph(this.concurrentRule.getNACs(), var) || this.isUsedInGraph(this.concurrentRule.getPACs(), var))) {
            vars.getTupleType().deleteMemberAt(var);
        }
    }

    public boolean isDisjoint() {
        return this.disjoint;
    }

    private void setInputParameterIfNeeded(Rule concurRule) {
        VarTuple vars = (VarTuple)concurRule.getAttrContext().getVariables();
        Vector<String> varNamesRHS = concurRule.getTarget().getVariableNamesOfAttributes();
        Vector<String> varNamesLHS = concurRule.getSource().getVariableNamesOfAttributes();
        int i = 0;
        while (i < vars.getNumberOfEntries()) {
            VarMember var = vars.getVarMemberAt(i);
            if (varNamesRHS.contains(var.getName())) {
                boolean found = false;
                if (varNamesLHS.contains(var.getName())) {
                    found = true;
                } else if (!var.isTransient() && !found) {
                    var.setInputParameter(true);
                }
            }
            ++i;
        }
    }

    private boolean isUsedInGraph(Enumeration<OrdinaryMorphism> list, String varName) {
        while (list.hasMoreElements()) {
            Graph g = list.nextElement().getTarget();
            if (!g.getVariableNamesOfAttributes().contains(varName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFalseCond(OrdinaryMorphism cond, OrdinaryMorphism condL, OrdinaryMorphism leftEmbMorph) {
        for (GraphObject graphObject : cond.getSource().getNodesSet()) {
            GraphObject graphObject2 = leftEmbMorph.getImage(graphObject);
            if (cond.getImage(graphObject) != null || condL.getImage(graphObject2) == null) continue;
            return true;
        }
        for (GraphObject graphObject : cond.getSource().getArcsSet()) {
            GraphObject go1 = leftEmbMorph.getImage(graphObject);
            if (cond.getImage(graphObject) != null || condL.getImage(go1) == null) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void filterCondL(OrdinaryMorphism cond, OrdinaryMorphism condL, OrdinaryMorphism leftEmbMorph) {
        void var7_12;
        Vector<GraphObject> del = new Vector<GraphObject>();
        for (GraphObject graphObject : cond.getSource().getArcsSet()) {
            GraphObject graphObject2 = leftEmbMorph.getImage(graphObject);
            GraphObject go2 = condL.getImage(graphObject2);
            if (cond.getImage(graphObject) != null || go2 == null || !this.similarAttribute(go2, graphObject2)) continue;
            del.add(go2);
        }
        for (GraphObject graphObject : cond.getSource().getNodesSet()) {
            GraphObject go1 = leftEmbMorph.getImage(graphObject);
            GraphObject go2 = condL.getImage(go1);
            if (cond.getImage(graphObject) != null || go2 == null || !this.similarAttribute(go2, go1)) continue;
            del.add(go2);
        }
        boolean bl = false;
        while (var7_12 < del.size()) {
            GraphObject go = (GraphObject)del.get((int)var7_12);
            if (go.isArc()) {
                try {
                    condL.removeMapping(go);
                    try {
                        condL.getTarget().destroyArc((Arc)go, false, false);
                    }
                    catch (TypeException typeException) {
                    }
                }
                catch (BadMappingException badMappingException) {}
            } else {
                try {
                    condL.removeMapping(go);
                    try {
                        condL.getTarget().destroyNode((Node)go, false, false);
                    }
                    catch (TypeException typeException) {}
                }
                catch (BadMappingException badMappingException) {
                    // empty catch block
                }
            }
            ++var7_12;
        }
        del.clear();
    }
}

