/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.exporters;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.HenshinModelExporter;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.AttributeCondition;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HenshinAGGExporter
implements HenshinModelExporter {
    public static final String EXPORTER_ID = "org.eclipse.emf.henshin.henshin2agg";
    private static final EcorePackage ECORE = EcorePackage.eINSTANCE;
    private static int[][] COLORS;
    private Document document;
    private int elementID = 0;
    private int color = 0;
    private Map<EClass, String> nodeTypeIDs;
    private Map<EClass, String> nodeIDs;
    private Map<EReference, String> edgeTypeIDs;
    private Map<EAttribute, String> attrTypeIDs;
    private Map<Node, String> graphNodeIDs;
    private Map<Edge, String> graphEdgeIDs;
    private List<String> warnings;
    private boolean createRuleParameterForAllAttributes = true;
    private boolean exportWithoutUpperLimitsOnTG;

    static {
        int[][] nArrayArray = new int[6][];
        nArrayArray[0] = new int[3];
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 255;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 128;
        nArray3[2] = 128;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[0] = 128;
        nArray4[1] = 128;
        nArrayArray[4] = nArray4;
        nArrayArray[5] = new int[]{128, 128, 128};
        COLORS = nArrayArray;
    }

    @Override
    public IStatus doExport(Module module, URI uri) {
        return this.doExport(module, uri, false);
    }

    public IStatus doExport(Module module, URI uri, boolean ignoreMultiplicities) {
        this.reset();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
            Element root = this.newElement("Document", this.document, false);
            root.setAttribute("version", "1.0");
            Comment comment = this.document.createComment("Generated by Henshin on " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
            root.appendChild(comment);
            Element systemElem = this.newElement("GraphTransformationSystem", root, true);
            String name = module.getName();
            if (name == null || name.trim().length() == 0) {
                name = module.eResource() != null ? module.eResource().getURI().trimFileExtension().lastSegment() : "GraGra";
            }
            systemElem.setAttribute("name", name);
            Element javaTag = this.newTaggedValue("AttrHandler", "Java Expr", systemElem);
            this.newTaggedValue("Package", "java.lang", javaTag);
            this.newTaggedValue("Package", "java.util", javaTag);
            this.newTaggedValue("Package", "com.objectspace.jgl", javaTag);
            this.newTaggedValue("CSP", "true", systemElem);
            this.newTaggedValue("injective", "true", systemElem);
            this.newTaggedValue("dangling", "true", systemElem);
            this.newTaggedValue("NACs", "true", systemElem);
            this.newTaggedValue("PACs", "true", systemElem);
            this.newTaggedValue("TypeGraphLevel", "ENABLED_MAX", systemElem);
            this.exportTypeGraph(module, ignoreMultiplicities, systemElem);
            this.exportRules(module, systemElem);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer trans = transFactory.newTransformer();
            trans.setOutputProperty("indent", "yes");
            File file = new File(uri.toFileString());
            StreamResult result = new StreamResult(file);
            DOMSource source = new DOMSource(this.document);
            trans.transform(source, result);
        }
        catch (Throwable t) {
            this.reset();
            return new Status(4, "org.eclipse.emf.henshin.model", "Error exporting to AGG: [" + t.toString() + "]: " + t.getMessage(), t);
        }
        if (!this.warnings.isEmpty()) {
            String message = "Warning:\n";
            for (String warning : this.warnings) {
                message = String.valueOf(message) + "\n" + warning;
            }
            this.reset();
            return new Status(2, "org.eclipse.emf.henshin.model", message);
        }
        this.reset();
        return Status.OK_STATUS;
    }

    private void exportRules(Module module, Element systemElem) {
        for (Unit unit : module.getUnits()) {
            if (!(unit instanceof Rule)) continue;
            Rule rule = (Rule)unit;
            Element ruleElem = this.newElement("Rule", systemElem, true);
            ruleElem.setAttribute("name", rule.getName());
            ruleElem.setAttribute("formula", "true");
            for (Parameter param : rule.getParameters()) {
                if (HenshinAGGExporter.isSupportedPrimitiveType(param.getType())) {
                    Element paramElem = this.newElement("Parameter", ruleElem, false);
                    paramElem.setAttribute("name", param.getName());
                    paramElem.setAttribute("type", this.getPrimitiveType(param.getType()));
                    if (!this.createRuleParameterForAllAttributes) continue;
                    paramElem.setAttribute("PTYPE", "input");
                    continue;
                }
                String type = param.getType() != null ? param.getType().getName() : "null";
                this.warnings.add(" - Parameter " + rule.getName() + "." + param.getName() + " of type " + type + " not supported");
            }
            this.convertGraph(rule.getLhs(), ruleElem, "LHS", "Left");
            this.convertGraph(rule.getRhs(), ruleElem, "RHS", "Right");
            this.convertMorphism(rule.getName(), rule.getMappings(), rule.getLhs(), rule.getRhs(), ruleElem);
            Element applCondElem = this.newElement("ApplCondition", ruleElem, false);
            if (!rule.getAttributeConditions().isEmpty()) {
                Element attrCondElem = this.newElement("AttrCondition", applCondElem, false);
                for (AttributeCondition cond : rule.getAttributeConditions()) {
                    Element condElem = this.newElement("Condition", attrCondElem, false);
                    Element valueElem = this.newElement("Value", condElem, false);
                    Element javaElem = this.newElement("java", valueElem, false);
                    javaElem.setAttribute("class", "java.beans.XMLDecoder");
                    javaElem.setAttribute("version", "1.6.0_03");
                    Element stringElem = this.newElement("string", javaElem, false);
                    stringElem.setTextContent(cond.getConditionText());
                }
            }
            for (NestedCondition nested : rule.getLhs().getNestedConditions()) {
                if (nested.isNAC()) {
                    Element nacElem = this.newElement("NAC", applCondElem, false);
                    this.convertGraph(nested.getConclusion(), nacElem, "NAC", "Graph");
                    this.convertMorphism(nested.getConclusion().getName(), nested.getMappings(), rule.getLhs(), nested.getConclusion(), nacElem);
                    continue;
                }
                if (!nested.isPAC()) continue;
                Element pacElem = this.newElement("PAC", applCondElem, false);
                this.convertGraph(nested.getConclusion(), pacElem, "PAC", "Graph");
                this.convertMorphism(nested.getConclusion().getName(), nested.getMappings(), rule.getLhs(), nested.getConclusion(), pacElem);
            }
        }
    }

    private void exportTypeGraph(Module module, boolean ignoreMultiplicities, Element systemElem) throws Exception {
        Element nodeTypeElem;
        Element typesElem = this.newElement("Types", systemElem, false);
        Element typeGraphElem = this.newElement("Graph", typesElem, true);
        typeGraphElem.setAttribute("kind", "TG");
        typeGraphElem.setAttribute("name", "TypeGraph");
        typesElem.removeChild(typeGraphElem);
        List<EClass> eclasses = new ArrayList<EClass>();
        for (EPackage epackage : module.getImports()) {
            for (Object eclassifier : epackage.getEClassifiers()) {
                if (!(eclassifier instanceof EClass)) continue;
                eclasses.add((EClass)eclassifier);
            }
        }
        eclasses = this.sort(eclasses);
        HashMap<EClass, Element> type2element = new HashMap<EClass, Element>();
        for (EClass eclass : eclasses) {
            nodeTypeElem = this.newElement("NodeType", typesElem, true);
            type2element.put(eclass, nodeTypeElem);
            nodeTypeElem.setAttribute("abstract", String.valueOf(eclass.isAbstract()));
            nodeTypeElem.setAttribute("name", String.valueOf(eclass.getName()) + "%:RECT:" + this.newColor() + ":[NODE]:");
            this.nodeTypeIDs.put(eclass, nodeTypeElem.getAttribute("ID"));
            Element nodeElem = this.newElement("Node", typeGraphElem, true);
            nodeElem.setAttribute("type", this.nodeTypeIDs.get(eclass));
            this.nodeIDs.put(eclass, nodeElem.getAttribute("ID"));
            for (EAttribute attribute : eclass.getEAttributes()) {
                EClassifier typeOfAttribute = attribute.getEType();
                if (HenshinAGGExporter.isSupportedPrimitiveType(attribute.getEType())) {
                    Element attrElem = this.newElement("AttrType", nodeTypeElem, true);
                    attrElem.setAttribute("attrname", attribute.getName());
                    String primitiveType = this.getPrimitiveType(typeOfAttribute);
                    if (typeOfAttribute instanceof EEnum) {
                        primitiveType = "String";
                    }
                    attrElem.setAttribute("typename", primitiveType);
                    attrElem.setAttribute("visible", "true");
                    this.attrTypeIDs.put(attribute, attrElem.getAttribute("ID"));
                    continue;
                }
                String attributesTypeName = "???";
                if (attribute.getEAttributeType() != null) {
                    attributesTypeName = attribute.getEAttributeType().getName();
                }
                String message = " - Attribute " + eclass.getName() + "." + attribute.getName() + " of type " + attributesTypeName + " not supported";
                this.warnings.add(message);
            }
        }
        for (EClass eclass : eclasses) {
            nodeTypeElem = (Element)type2element.get(eclass);
            for (EClass parentEClass : eclass.getESuperTypes()) {
                if (parentEClass.eContainer() == EcorePackage.eINSTANCE || eclass.eContainer() == EcorePackage.eINSTANCE) continue;
                Element parentElem = this.newElement("Parent", nodeTypeElem, false);
                String parentNodeTypeID = this.nodeTypeIDs.get(parentEClass);
                if (parentNodeTypeID == null) {
                    throw new RuntimeException("Did not find an ID for parent of " + eclass.getName() + ":  " + parentEClass.getName());
                }
                parentElem.setAttribute("pID", parentNodeTypeID);
            }
        }
        boolean hasUniqureRefNames = HenshinAGGExporter.hasUniqueEReferenceNames(module);
        hasUniqureRefNames = true;
        for (EClass eclass : eclasses) {
            for (EReference reference : eclass.getEReferences()) {
                Element edgeTypeElem = this.newElement("EdgeType", typesElem, true);
                edgeTypeElem.setAttribute("abstract", "false");
                String refName = hasUniqureRefNames ? reference.getName() : HenshinAGGExporter.getUniqueReferenceName(reference);
                edgeTypeElem.setAttribute("name", String.valueOf(refName) + "%:SOLID_LINE:java.awt.Color[r=0,g=0,b=0]:[EDGE]:");
                this.edgeTypeIDs.put(reference, edgeTypeElem.getAttribute("ID"));
                Element edgeElem = this.newElement("Edge", typeGraphElem, true);
                edgeElem.setAttribute("type", this.edgeTypeIDs.get(reference));
                edgeElem.setAttribute("source", this.nodeIDs.get(eclass));
                edgeElem.setAttribute("target", this.nodeIDs.get(reference.getEReferenceType()));
                if (ignoreMultiplicities) continue;
                if (reference.isContainment()) {
                    edgeElem.setAttribute("sourcemax", "1");
                    edgeElem.setAttribute("sourcemin", "0");
                }
                if (reference.getEOpposite() != null) {
                    edgeElem.setAttribute("sourcemax", String.valueOf(reference.getEOpposite().getUpperBound()));
                    edgeElem.setAttribute("sourcemin", String.valueOf(reference.getEOpposite().getLowerBound()));
                }
                edgeElem.setAttribute("targetmin", String.valueOf(reference.getLowerBound()));
                if (reference.getUpperBound() < 0 || this.exportWithoutUpperLimitsOnTG) continue;
                edgeElem.setAttribute("targetmax", String.valueOf(reference.getUpperBound()));
            }
        }
        typesElem.appendChild(typeGraphElem);
    }

    private List<EClass> sort(List<EClass> eclasses) {
        ArrayList<EClass> resultList = new ArrayList<EClass>();
        HashSet<EClass> resultSet = new HashSet<EClass>();
        HashSet<EClass> todo = new HashSet<EClass>(eclasses);
        HashMap class2super = new HashMap();
        for (EClass c : eclasses) {
            class2super.put(c, new HashSet(c.getEAllSuperTypes()));
        }
        while (!todo.isEmpty()) {
            EClass candidate = null;
            for (EClass cl : todo) {
                boolean isCandidate = true;
                for (EClass superClass : (Set)class2super.get(cl)) {
                    if (resultSet.contains(superClass) || !todo.contains(superClass)) continue;
                    isCandidate = false;
                }
                if (!isCandidate) continue;
                candidate = cl;
            }
            if (candidate == null) {
                throw new RuntimeException("Couldn't find a class without un-added parents!");
            }
            resultList.add(candidate);
            resultSet.add(candidate);
            todo.remove(candidate);
        }
        return resultList;
    }

    private static List<EClass> advancedSortEClasses(List<EClass> eclasses) {
        LinkedList<EClass> result = new LinkedList<EClass>();
        HashMap<EClass, Integer> unsorted = new HashMap<EClass, Integer>();
        for (EClass eclass : eclasses) {
            unsorted.put(eclass, eclass.getESuperTypes().size());
        }
        while (unsorted.size() > 0) {
            EClass current = null;
            int lowestAmountOfSuperTypes = Integer.MAX_VALUE;
            EClass eClassWithLowestNumber = null;
            Iterator iterator = unsorted.entrySet().iterator();
            while (iterator.hasNext() && current == null) {
                Map.Entry entry = iterator.next();
                if ((Integer)entry.getValue() == 0) {
                    current = (EClass)entry.getKey();
                    result.add(current);
                    continue;
                }
                if ((Integer)entry.getValue() >= lowestAmountOfSuperTypes) continue;
                lowestAmountOfSuperTypes = (Integer)entry.getValue();
                eClassWithLowestNumber = (EClass)entry.getKey();
            }
            if (current == null) {
                current = eClassWithLowestNumber;
                result.add(current);
            }
            unsorted.remove(current);
            if (current != null) {
                for (Map.Entry entry : unsorted.entrySet()) {
                    if (!((EClass)entry.getKey()).getESuperTypes().contains((Object)current)) continue;
                    entry.setValue((Integer)entry.getValue() - 1);
                }
                continue;
            }
            throw new RuntimeException("");
        }
        return result;
    }

    private void convertGraph(Graph graph, Element parent, String kind, String name) {
        Element graphElem = this.newElement("Graph", parent, true);
        graphElem.setAttribute("kind", kind);
        graphElem.setAttribute("name", name);
        for (Node node : graph.getNodes()) {
            Element nodeElem = this.newElement("Node", graphElem, true);
            String nodeType = this.nodeTypeIDs.get(node.getType());
            if (nodeType == null) {
                throw new RuntimeException("A node type was not exported correctly: " + node.getType().getName());
            }
            nodeElem.setAttribute("type", nodeType);
            this.graphNodeIDs.put(node, nodeElem.getAttribute("ID"));
            for (Attribute attribute : node.getAttributes()) {
                if (!HenshinAGGExporter.isSupportedPrimitiveType(attribute.getType().getEType())) continue;
                EDataType t = attribute.getType().getEAttributeType();
                Element attrElem = this.newElement("Attribute", nodeElem, false);
                attrElem.setAttribute("type", this.attrTypeIDs.get(attribute.getType()));
                String constValue = this.getConstant(attribute);
                Element valueElem = null;
                if (constValue != null) {
                    attrElem.setAttribute("constant", "true");
                    if (t == ECORE.getEInt()) {
                        valueElem = this.newElement("Value", attrElem, false);
                        Element intElem = this.newElement("int", valueElem, false);
                        intElem.setTextContent(attribute.getValue());
                    }
                    if (t == ECORE.getEFloat()) {
                        valueElem = this.newElement("Value", attrElem, false);
                        Element floatElem = this.newElement("float", valueElem, false);
                        floatElem.setTextContent(attribute.getValue());
                    }
                    if (t == ECORE.getEDouble()) {
                        valueElem = this.newElement("Value", attrElem, false);
                        Element doubleElem = this.newElement("double", valueElem, false);
                        doubleElem.setTextContent(attribute.getValue());
                    } else if (t == ECORE.getEBoolean()) {
                        valueElem = this.newElement("Value", attrElem, false);
                        Element booleanElem = this.newElement("boolean", valueElem, false);
                        booleanElem.setTextContent(attribute.getValue());
                    }
                }
                if (valueElem != null) continue;
                attrElem.setAttribute("variable", "true");
                valueElem = this.newElement("Value", attrElem, false);
                Element stringElem = this.newElement("string", valueElem, false);
                stringElem.setTextContent(constValue != null ? constValue : attribute.getValue());
            }
        }
        for (Edge edge : graph.getEdges()) {
            Element edgeElem = this.newElement("Edge", graphElem, true);
            this.graphEdgeIDs.put(edge, edgeElem.getAttribute("ID"));
            edgeElem.setAttribute("type", this.edgeTypeIDs.get(edge.getType()));
            edgeElem.setAttribute("source", this.graphNodeIDs.get(edge.getSource()));
            edgeElem.setAttribute("target", this.graphNodeIDs.get(edge.getTarget()));
            if (this.edgeTypeIDs.get(edge.getType()) == null) {
                throw new RuntimeException("Error during transformation of a graph: could not find the edge type " + edge.getType());
            }
            if (this.graphNodeIDs.get(edge.getSource()) == null) {
                throw new RuntimeException("Error during transformation of a graph: could not find a source for an edge of type " + edge.getType());
            }
            if (this.graphNodeIDs.get(edge.getTarget()) != null) continue;
            throw new RuntimeException("Error during transformation of a graph: could not find a target for an edge of type " + edge.getType());
        }
    }

    private void convertMorphism(String name, MappingList mappings, Graph source, Graph target, Element parent) {
        Element morphismElem = this.newElement("Morphism", parent, false);
        morphismElem.setAttribute("name", name);
        Iterator iterator = mappings.iterator();
        while (iterator.hasNext()) {
            Mapping mapping = (Mapping)iterator.next();
            if (mapping.getImage().getGraph() != target) continue;
            Element mappingElem = this.newElement("Mapping", morphismElem, false);
            mappingElem.setAttribute("orig", this.graphNodeIDs.get(mapping.getOrigin()));
            mappingElem.setAttribute("image", this.graphNodeIDs.get(mapping.getImage()));
        }
        for (Edge edge : source.getEdges()) {
            Edge image = mappings.getImage(edge, target);
            if (image == null) continue;
            Element mappingElem = this.newElement("Mapping", morphismElem, false);
            mappingElem.setAttribute("orig", this.graphEdgeIDs.get(edge));
            mappingElem.setAttribute("image", this.graphEdgeIDs.get(image));
        }
    }

    public static String getUniqueReferenceName(EReference reference) throws Exception {
        String srcName = ((EClass)reference.eContainer()).getName();
        if (srcName == null) {
            throw new Exception("EClasses without names are not supported!");
        }
        srcName = String.valueOf(Character.toLowerCase(srcName.charAt(0))) + srcName.substring(1);
        String refName = reference.getName();
        if (refName == null) {
            throw new Exception("References without names are not supported!");
        }
        refName = String.valueOf(Character.toUpperCase(refName.charAt(0))) + refName.substring(1);
        return String.valueOf(srcName) + refName;
    }

    private Element newElement(String type, org.w3c.dom.Node parent, boolean generateID) {
        Element elem = this.document.createElement(type);
        if (generateID) {
            elem.setAttribute("ID", "I" + this.elementID++);
            elem.setIdAttribute("ID", true);
        }
        parent.appendChild(elem);
        return elem;
    }

    private String newColor() {
        int[] rgb = COLORS[this.color];
        this.color = (this.color + 1) % COLORS.length;
        return "java.awt.Color[r=" + rgb[0] + ",g=" + rgb[1] + ",b=" + rgb[2] + "]";
    }

    private Element newTaggedValue(String tag, String tagValue, org.w3c.dom.Node parent) {
        Element elem = this.document.createElement("TaggedValue");
        elem.setAttribute("Tag", tag);
        elem.setAttribute("TagValue", tagValue);
        parent.appendChild(elem);
        return elem;
    }

    private void reset() {
        this.nodeTypeIDs = new HashMap<EClass, String>();
        this.nodeIDs = new HashMap<EClass, String>();
        this.edgeTypeIDs = new HashMap<EReference, String>();
        this.attrTypeIDs = new HashMap<EAttribute, String>();
        this.graphNodeIDs = new HashMap<Node, String>();
        this.graphEdgeIDs = new HashMap<Edge, String>();
        this.warnings = new ArrayList<String>();
        this.elementID = 0;
        this.color = 0;
    }

    public static boolean isSupportedPrimitiveType(EClassifier type) {
        if (type == null) {
            return false;
        }
        return type == ECORE.getEInt() || type == ECORE.getEFloat() || type == ECORE.getEDouble() || type == ECORE.getEBoolean() || type == ECORE.getEString() || type instanceof EEnum;
    }

    private String getPrimitiveType(EClassifier type) {
        if (HenshinAGGExporter.isSupportedPrimitiveType(type)) {
            if (type == ECORE.getEString()) {
                return "String";
            }
            return type.getInstanceClassName();
        }
        return "null";
    }

    private String getConstant(Attribute attribute) {
        String val = String.valueOf(attribute.getValue()).trim();
        EDataType type = attribute.getType().getEAttributeType();
        if (type == ECORE.getEInt()) {
            try {
                int intVal = Integer.parseInt(val);
                return String.valueOf(intVal);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        if (type == ECORE.getEDouble()) {
            try {
                double doubleVal = Double.parseDouble(val);
                return String.valueOf(doubleVal);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        if (type == ECORE.getEBoolean()) {
            try {
                boolean boolVal = Boolean.parseBoolean(val);
                return String.valueOf(boolVal);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        if (type == ECORE.getEString()) {
            if (val.startsWith("\"") && val.endsWith("\"") || val.startsWith("'") && val.endsWith("'")) {
                return val.substring(1, val.length() - 1);
            }
            return null;
        }
        return null;
    }

    private static boolean hasUniqueEReferenceNames(Module module) {
        HashSet<String> refNames = new HashSet<String>();
        for (EPackage epackage : module.getImports()) {
            for (EClassifier classifier : epackage.getEClassifiers()) {
                if (!(classifier instanceof EClass)) continue;
                for (EReference ref : ((EClass)classifier).getEReferences()) {
                    if (refNames.contains(ref.getName())) {
                        return false;
                    }
                    refNames.add(ref.getName());
                }
            }
        }
        return true;
    }

    @Override
    public String getExporterName() {
        return "AGG";
    }

    @Override
    public String[] getExportFileExtensions() {
        return new String[]{"ggx"};
    }

    public boolean isCreateRuleParameterForAllAttributes() {
        return this.createRuleParameterForAllAttributes;
    }

    public void setCreateRuleParameterForAllAttributes(boolean createRuleParameterForAllAttributes) {
        this.createRuleParameterForAllAttributes = createRuleParameterForAllAttributes;
    }

    public void setExportWithoutUpperLimitsOnTypeGraph(boolean exportWithoutUpperLimitsOnTG) {
        this.exportWithoutUpperLimitsOnTG = exportWithoutUpperLimitsOnTG;
    }
}

