/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.preprocessing;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class HenshinRuleLoader {
    static List<String> filteredNames = Arrays.asList(new String[0]);

    public static List<String> inspectDirectoryForHenshinFiles(File dir) {
        LinkedList<String> pathsToHenshinFiles = new LinkedList<String>();
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            File[] fileArray = directoryListing;
            int n = directoryListing.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                String fileName = child.getName();
                if (fileName.endsWith(".henshin")) {
                    pathsToHenshinFiles.add(child.getAbsolutePath());
                } else if (!child.getName().contains(".")) {
                    File subDir = child;
                    pathsToHenshinFiles.addAll(HenshinRuleLoader.inspectDirectoryForHenshinFiles(subDir));
                }
                ++n2;
            }
        } else {
            throw new RuntimeException("Invalid directory.");
        }
        return pathsToHenshinFiles;
    }

    public static List<Rule> loadAllRulesFromFileSystemPaths(File dir) {
        List<String> pathsToHenshinFiles = HenshinRuleLoader.inspectDirectoryForHenshinFiles(dir);
        LinkedList<Rule> rules = new LinkedList<Rule>();
        for (String pathToHenshinFiles : pathsToHenshinFiles) {
            HenshinResourceSet henshinResourceSet = new HenshinResourceSet();
            Module module = henshinResourceSet.getModule(pathToHenshinFiles);
            for (Unit unit : module.getUnits()) {
                boolean deactivatedRule;
                if (!(unit instanceof Rule) || (deactivatedRule = false)) continue;
                if (!filteredNames.contains(unit.getName())) {
                    rules.add((Rule)unit);
                    continue;
                }
                System.out.println("Filtered out " + unit.getName());
            }
        }
        return rules;
    }
}

