/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.ui;

import java.util.HashMap;
import laxcondition.Condition;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.tool.commands.LaxCond2AppCondCommand;
import org.eclipse.emf.henshin.ocl2ac.tool.optimizer.IntegrationChecker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class WizardLaxCond2AppCond
extends Shell {
    private static final String HENSHIN = ".henshin";
    private Table tableCompactConditions;
    private Table tableRules;
    private Condition selectedCompactCondition = null;
    private Rule selectedRule = null;
    private IFile henshinFile = null;
    private IFile compactConditionModelFile = null;
    private final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyz0123456789";

    public WizardLaxCond2AppCond(Display display, final IFile henshinFile, final HashMap<Integer, Condition> hashmapAllLaxCondition, final HashMap<Integer, Rule> hashmapAllRules, IFile compactConditionModelFile) {
        super(display, 1264);
        this.setLayout((Layout)new RowLayout(512));
        this.henshinFile = henshinFile;
        this.compactConditionModelFile = compactConditionModelFile;
        Group grpRepairActions = new Group((Composite)this, 0);
        grpRepairActions.setLayout((Layout)new GridLayout(1, false));
        grpRepairActions.setLayoutData((Object)new RowData(487, 248));
        grpRepairActions.setText("Compact Graph Constraints");
        Group groupRATop = new Group((Composite)grpRepairActions, 0);
        GridData gd_groupRATop = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_groupRATop.heightHint = 23;
        gd_groupRATop.widthHint = 471;
        groupRATop.setLayoutData((Object)gd_groupRATop);
        Label lblNewLabel_1 = new Label((Composite)groupRATop, 0);
        lblNewLabel_1.setBounds(10, 16, 283, 20);
        lblNewLabel_1.setText("Please select a compact graph constraint");
        this.tableCompactConditions = new Table((Composite)grpRepairActions, 67584);
        this.tableCompactConditions.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        GridData gd_tableAction = new GridData(4, 4, true, true, 1, 1);
        gd_tableAction.heightHint = 180;
        this.tableCompactConditions.setLayoutData((Object)gd_tableAction);
        this.tableCompactConditions.setHeaderVisible(true);
        this.tableCompactConditions.setLinesVisible(true);
        TableColumn clnID_NC = new TableColumn(this.tableCompactConditions, 0);
        clnID_NC.setWidth(46);
        clnID_NC.setText("ID");
        TableColumn clnName_NC = new TableColumn(this.tableCompactConditions, 0);
        clnName_NC.setWidth(425);
        clnName_NC.setText("Compact Graph Constraint");
        this.fillTableCompactConditions(hashmapAllLaxCondition);
        this.tableCompactConditions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardLaxCond2AppCond.this.tableCompactConditions.getItemCount() > 0) {
                    TableItem[] selectedItem = WizardLaxCond2AppCond.this.tableCompactConditions.getSelection();
                    Integer nestedConstraintID = Integer.parseInt(selectedItem[0].getText(0));
                    WizardLaxCond2AppCond.this.selectedCompactCondition = (Condition)hashmapAllLaxCondition.get(nestedConstraintID);
                }
            }
        });
        Group grpTargets = new Group((Composite)this, 0);
        grpTargets.setLayout((Layout)new GridLayout(1, false));
        grpTargets.setLayoutData((Object)new RowData(487, 239));
        grpTargets.setText("Rules");
        Group groupTargtTop = new Group((Composite)grpTargets, 0);
        GridData gd_groupTargtTop = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_groupTargtTop.heightHint = 36;
        gd_groupTargtTop.widthHint = 477;
        groupTargtTop.setLayoutData((Object)gd_groupTargtTop);
        Label lblPleaseSelectA = new Label((Composite)groupTargtTop, 0);
        lblPleaseSelectA.setBounds(10, 24, 213, 25);
        lblPleaseSelectA.setText("Please select a rule");
        this.tableRules = new Table((Composite)grpTargets, 67584);
        this.tableRules.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        GridData gd_tableTargets = new GridData(4, 4, true, true, 1, 1);
        gd_tableTargets.heightHint = 187;
        this.tableRules.setLayoutData((Object)gd_tableTargets);
        this.tableRules.setHeaderVisible(true);
        this.tableRules.setLinesVisible(true);
        TableColumn clnID_rule = new TableColumn(this.tableRules, 0);
        clnID_rule.setWidth(48);
        clnID_rule.setText("ID");
        TableColumn clnName_Rule = new TableColumn(this.tableRules, 0);
        clnName_Rule.setWidth(429);
        clnName_Rule.setText("Rule");
        this.fillTableRules(hashmapAllRules);
        Group groupFooter = new Group((Composite)this, 0);
        groupFooter.setLayoutData((Object)new RowData(488, 59));
        this.tableRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardLaxCond2AppCond.this.tableRules.getItemCount() > 0) {
                    TableItem[] selectedItem = WizardLaxCond2AppCond.this.tableRules.getSelection();
                    Integer ruleID = Integer.parseInt(selectedItem[0].getText(0));
                    WizardLaxCond2AppCond.this.selectedRule = (Rule)hashmapAllRules.get(ruleID);
                }
            }
        });
        Button btnIntegrate = new Button((Composite)groupFooter, 0);
        btnIntegrate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardLaxCond2AppCond.this.selectedCompactCondition != null && WizardLaxCond2AppCond.this.selectedRule != null) {
                    System.out.println(WizardLaxCond2AppCond.this.selectedCompactCondition + "  " + WizardLaxCond2AppCond.this.selectedRule);
                    LaxCond2AppCondCommand ilcc2ac = new LaxCond2AppCondCommand(henshinFile);
                    WizardLaxCond2AppCond.this.setNamesToRuleNodes(WizardLaxCond2AppCond.this.selectedRule);
                    ilcc2ac.integrateAndleft(WizardLaxCond2AppCond.this.selectedCompactCondition, WizardLaxCond2AppCond.this.selectedRule);
                    long translationTime = ilcc2ac.translationTime;
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)("Integration is finished. The integration time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
                    WizardLaxCond2AppCond.this.close();
                }
            }
        });
        btnIntegrate.setBounds(10, 24, 114, 34);
        btnIntegrate.setText("Integrate");
        Button btnCheckforintegration = new Button((Composite)groupFooter, 0);
        btnCheckforintegration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardLaxCond2AppCond.this.selectedCompactCondition != null && WizardLaxCond2AppCond.this.selectedRule != null) {
                    IntegrationChecker op = new IntegrationChecker();
                    boolean mustIntegrate = op.mustIntegrateWithoutAttribute(WizardLaxCond2AppCond.this.selectedRule, WizardLaxCond2AppCond.this.selectedCompactCondition);
                    if (mustIntegrate) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Info (required)", (String)"The constraint SHOULD be integrated into the rule.");
                        boolean yes = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)"Do you want to integrate it now?");
                        if (yes) {
                            System.out.println(WizardLaxCond2AppCond.this.selectedCompactCondition + "  " + WizardLaxCond2AppCond.this.selectedRule);
                            LaxCond2AppCondCommand ilcc2ac = new LaxCond2AppCondCommand(henshinFile);
                            WizardLaxCond2AppCond.this.setNamesToRuleNodes(WizardLaxCond2AppCond.this.selectedRule);
                            ilcc2ac.integrateAndleft(WizardLaxCond2AppCond.this.selectedCompactCondition, WizardLaxCond2AppCond.this.selectedRule);
                            long translationTime = ilcc2ac.translationTime;
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)("Integration is finished. The integration time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
                            WizardLaxCond2AppCond.this.close();
                        }
                    } else {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Info (not required)", (String)"There is NO need to integrate the selected constraint into the selected rule since the rule application will not violate the constraint.");
                        boolean yes = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Question", (String)"Do you want to integrate it anyway?");
                        if (yes) {
                            System.out.println(WizardLaxCond2AppCond.this.selectedCompactCondition + "  " + WizardLaxCond2AppCond.this.selectedRule);
                            LaxCond2AppCondCommand ilcc2ac = new LaxCond2AppCondCommand(henshinFile);
                            WizardLaxCond2AppCond.this.setNamesToRuleNodes(WizardLaxCond2AppCond.this.selectedRule);
                            ilcc2ac.integrateAndleft(WizardLaxCond2AppCond.this.selectedCompactCondition, WizardLaxCond2AppCond.this.selectedRule);
                            long translationTime = ilcc2ac.translationTime;
                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Integration", (String)("Integration is finished. The integration time is: (" + (double)translationTime / 1000.0 + ") second(s)."));
                            WizardLaxCond2AppCond.this.close();
                        }
                    }
                }
            }
        });
        btnCheckforintegration.setBounds(142, 24, 155, 34);
        btnCheckforintegration.setText("Check-for-Integration");
        this.createContents();
        this.tableCompactConditions.notifyListeners(13, new Event());
        this.tableRules.notifyListeners(13, new Event());
    }

    protected void createContents() {
        this.setText("Integrator Wizard (Shift + Left)");
        this.setSize(520, 689);
    }

    private void fillTableCompactConditions(HashMap<Integer, Condition> hashmapAllCompactConditions) {
        if (hashmapAllCompactConditions != null) {
            this.tableCompactConditions.removeAll();
            for (Integer key : hashmapAllCompactConditions.keySet()) {
                TableItem item = new TableItem(this.tableCompactConditions, 0);
                item.setText(0, key.toString());
                item.setText(1, hashmapAllCompactConditions.get(key).getName());
            }
            this.tableCompactConditions.select(0);
            TableItem[] selectedItem = this.tableCompactConditions.getSelection();
            Integer ruleID = Integer.parseInt(selectedItem[0].getText(0));
            this.selectedCompactCondition = hashmapAllCompactConditions.get(ruleID);
        }
    }

    private void fillTableRules(HashMap<Integer, Rule> hashmapAllRules) {
        if (hashmapAllRules != null) {
            this.tableRules.removeAll();
            for (Integer key : hashmapAllRules.keySet()) {
                TableItem item = new TableItem(this.tableRules, 0);
                item.setText(0, key.toString());
                item.setText(1, hashmapAllRules.get(key).getName());
            }
            this.tableRules.select(0);
            TableItem[] selectedItem = this.tableRules.getSelection();
            Integer ruleID = Integer.parseInt(selectedItem[0].getText(0));
            this.selectedRule = hashmapAllRules.get(ruleID);
        }
    }

    private void setNamesToRuleNodes(Rule rule) {
        for (Mapping m : rule.getMappings()) {
            if (m.getImage() == null || m.getOrigin() == null || m.getImage().getName() != null || m.getOrigin().getName() != null) continue;
            String nodeName = "rp" + this.randomAlphaNumeric(3);
            m.getOrigin().setName(nodeName);
            m.getImage().setName(nodeName);
        }
        for (NestedCondition nc : rule.getLhs().getNestedConditions()) {
            for (Mapping ncM : nc.getMappings()) {
                if (ncM.getImage() == null || ncM.getOrigin() == null || ncM.getImage().getName() != null || ncM.getOrigin().getName() != null) continue;
                String nodeName = "rf" + this.randomAlphaNumeric(3);
                ncM.getOrigin().setName(nodeName);
                ncM.getImage().setName(nodeName);
            }
        }
        for (Node node : rule.getLhs().getNodes()) {
            if (node.getName() != null) continue;
            node.setName("rd" + this.randomAlphaNumeric(3));
        }
        for (Node node : rule.getRhs().getNodes()) {
            if (node.getName() != null) continue;
            node.setName("rc" + this.randomAlphaNumeric(3));
        }
    }

    private String randomAlphaNumeric(int count) {
        StringBuilder builder = new StringBuilder();
        while (count-- != 0) {
            int character = (int)(Math.random() * (double)"abcdefghijklmnopqrstuvwxyz0123456789".length());
            builder.append("abcdefghijklmnopqrstuvwxyz0123456789".charAt(character));
        }
        return builder.toString();
    }

    protected void checkSubclass() {
    }
}

