/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.rulegen.simple;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.rulegen.matching.Correspondence;
import org.eclipse.emf.henshin.rulegen.matching.EMFCompareMatcherAdapter;
import org.eclipse.emf.henshin.rulegen.matching.Matching;

public class ExampleBasedRuleGenerator {
    private Rule rule;
    private Graph gLHS;
    private Graph gRHS;
    private Matching matching_A_B;
    private Map<EObject, Node> modelA2lhs;
    private Map<EObject, Node> modelB2rhs;

    public Rule generateRule(String ruleName, Resource modelA, Resource modelB) {
        this.modelA2lhs = new HashMap<EObject, Node>();
        this.modelB2rhs = new HashMap<EObject, Node>();
        EMFCompareMatcherAdapter matcher = new EMFCompareMatcherAdapter();
        this.matching_A_B = matcher.createMatching(modelA, modelB);
        this.gLHS = HenshinFactory.eINSTANCE.createGraph("Lhs");
        this.gRHS = HenshinFactory.eINSTANCE.createGraph("Rhs");
        this.rule = HenshinFactory.eINSTANCE.createRule(ruleName);
        this.rule.setLhs(this.gLHS);
        this.rule.setRhs(this.gRHS);
        this.traverseMatching();
        this.mapObjects(modelA, this.gLHS, this.modelA2lhs);
        this.mapObjects(modelB, this.gRHS, this.modelB2rhs);
        this.createEdges(modelA, this.gLHS, this.modelA2lhs);
        this.createEdges(modelB, this.gRHS, this.modelB2rhs);
        return this.rule;
    }

    private void traverseMatching() {
        for (Correspondence c : this.matching_A_B.getCorrespondences()) {
            Node lhsNode = this.eObject2Node(this.gLHS, c.getObjA());
            Node rhsNode = this.eObject2Node(this.gRHS, c.getObjB());
            if (lhsNode == null || rhsNode == null) continue;
            this.modelA2lhs.put(c.getObjA(), lhsNode);
            this.modelB2rhs.put(c.getObjB(), rhsNode);
            this.rule.getMappings().add((Object)HenshinFactory.eINSTANCE.createMapping(lhsNode, rhsNode));
        }
    }

    private void mapObjects(Resource model, Graph graph, Map<EObject, Node> model2graph) {
        TreeIterator iterator = model.getAllContents();
        while (iterator.hasNext()) {
            Node node;
            EObject eObject = (EObject)iterator.next();
            if (this.matching_A_B.isMatched(eObject) || (node = this.eObject2Node(graph, eObject)) == null) continue;
            model2graph.put(eObject, node);
        }
    }

    private void createEdges(Resource model, Graph graph, Map<EObject, Node> model2Graph) {
        TreeIterator iterator = model.getAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            EClass eClass = eObject.eClass();
            for (EReference eReference : eClass.getEAllReferences()) {
                if (this.isUnconsideredStructualFeature((EStructuralFeature)eReference)) continue;
                if (eReference.isMany()) {
                    List targets = (List)eObject.eGet((EStructuralFeature)eReference);
                    int i = 0;
                    while (i < targets.size()) {
                        EObject target = (EObject)targets.get(i);
                        this.createEdge(model2Graph, eObject, target, eReference);
                        ++i;
                    }
                    continue;
                }
                EObject target = (EObject)eObject.eGet((EStructuralFeature)eReference);
                if (target == null) continue;
                this.createEdge(model2Graph, eObject, target, eReference);
            }
        }
    }

    private Node eObject2Node(Graph graph, EObject obj) {
        Node node = HenshinFactory.eINSTANCE.createNode(graph, obj.eClass(), "");
        for (EAttribute eAttribute : obj.eClass().getEAllAttributes()) {
            Object attValue;
            if (this.isUnconsideredStructualFeature((EStructuralFeature)eAttribute) || (attValue = obj.eGet((EStructuralFeature)eAttribute)) == null) continue;
            attValue = attValue.toString();
            if (eAttribute.getEAttributeType() == EcorePackage.eINSTANCE.getEString()) {
                attValue = "\"" + attValue + "\"";
            }
            HenshinFactory.eINSTANCE.createAttribute(node, eAttribute, attValue.toString());
        }
        return node;
    }

    private void createEdge(Map<EObject, Node> model2Graph, EObject srcObj, EObject tgtObj, EReference referenceType) {
        Node srcNode = model2Graph.get(srcObj);
        Node tgtNode = model2Graph.get(tgtObj);
        if (srcNode != null && tgtNode != null) {
            HenshinFactory.eINSTANCE.createEdge(srcNode, tgtNode, referenceType);
        }
    }

    private boolean isUnconsideredStructualFeature(EStructuralFeature structualFeatureType) {
        return !structualFeatureType.isChangeable() || structualFeatureType.isDerived() || structualFeatureType.isTransient();
    }
}

