/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.external.AbstractStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMUtil;

public class CTMCStateSpaceExporter
extends AbstractStateSpaceExporter {
    public void doExport(StateSpace stateSpace, URI uri, String parameters, IProgressMonitor monitor) throws IOException {
        int stateCount = stateSpace.getStates().size();
        monitor.beginTask("Exporting state space...", 2 * stateCount);
        boolean explicit = "tra".equalsIgnoreCase(uri.fileExtension());
        File file = new File(uri.toFileString());
        OutputStreamWriter writer = CTMCStateSpaceExporter.createWriter(file);
        Map<String, String> rates = PRISMUtil.getAllRates(stateSpace, explicit);
        if (!explicit) {
            writer.write(PRISMUtil.getModelHeader("ctmc"));
            for (Rule rule : stateSpace.getRules()) {
                String key = PRISMUtil.getRateKey(rule);
                String value = rates.get(key);
                writer.write("const double " + key);
                if (value != null) {
                    writer.write(" = " + value);
                }
                writer.write(";\n");
            }
            writer.write("\nmodule " + uri.trimFileExtension().lastSegment() + "\n\n");
        }
        if (explicit) {
            writer.write(String.valueOf(stateCount) + " " + stateSpace.getTransitionCount() + "\n");
        } else {
            writer.write("\ts : [0.." + stateCount + "];\n\n");
        }
        for (State s : stateSpace.getStates()) {
            for (Transition t : s.getOutgoing()) {
                if (explicit) {
                    writer.write(String.valueOf(s.getIndex()) + " " + t.getTarget().getIndex() + " " + rates.get(PRISMUtil.getRateKey(t.getRule())) + "\n");
                    continue;
                }
                writer.write("\t[" + CTMCStateSpaceExporter.getAction(t.getRule()) + "] s=" + s.getIndex() + " -> " + PRISMUtil.getRateKey(t.getRule()) + " : (s'=" + t.getTarget().getIndex() + ");\n");
            }
            monitor.worked(1);
            if (monitor.isCanceled()) break;
        }
        if (!explicit) {
            writer.write("\nendmodule\n\n");
            writer.write("init\n\t");
            int i = 0;
            while (i < stateSpace.getInitialStates().size()) {
                writer.write("s=" + ((State)stateSpace.getInitialStates().get(i)).getIndex());
                if (i < stateSpace.getInitialStates().size() - 1) {
                    writer.write(" | ");
                }
                ++i;
            }
            writer.write("\nendinit\n");
        }
        if (parameters != null) {
            try {
                String expanded = PRISMUtil.expandLabels(parameters, this.stateSpaceIndex, (IProgressMonitor)new SubProgressMonitor(monitor, stateCount));
                if (explicit) {
                    OutputStreamWriter labelsWriter = CTMCStateSpaceExporter.createWriter(new File(uri.toFileString().replaceAll(".tra", ".lab")));
                    labelsWriter.write(expanded);
                    labelsWriter.close();
                } else {
                    writer.write("\n" + expanded + "\n");
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        writer.close();
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    protected static String getAction(Rule rule) {
        return rule.getName().trim();
    }

    public String getName() {
        return "PRISM CTMC";
    }

    public String[] getFileExtensions() {
        return new String[]{"sm"};
    }
}

