/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.commands.NegligentRemoveCommand;
import org.eclipse.emf.henshin.commands.NodeComplexRemoveCommand;
import org.eclipse.emf.henshin.commands.SetNestedConditionCommand;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.provider.NamedElementItemProvider;

public class GraphItemProvider
extends NamedElementItemProvider {
    public GraphItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.GRAPH__NODES);
            this.childrenFeatures.add(HenshinPackage.Literals.GRAPH__EDGES);
            this.childrenFeatures.add(HenshinPackage.Literals.GRAPH__FORMULA);
        }
        return this.childrenFeatures;
    }

    @Override
    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        Graph graph = (Graph)object;
        if (graph.isLhs()) {
            return this.getResourceLocator().getImage("full/obj16/Graph_L.gif");
        }
        if (graph.isRhs()) {
            return this.getResourceLocator().getImage("full/obj16/Graph_R.gif");
        }
        return this.getResourceLocator().getImage("full/obj16/Graph.gif");
    }

    @Override
    public String getText(Object object) {
        String label = ((Graph)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_Graph_type") : String.valueOf(this.getString("_UI_Graph_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Graph.class)) {
            case 3: 
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void notifyCorrespondingEdges(Graph graph, Notification notification) {
        if (graph.isLhs()) {
            Graph rhs = graph.getRule().getRhs();
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)rhs, Graph.class);
            adapter.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)rhs, true, true));
        } else if (graph.isRhs()) {
            Graph lhs = graph.getRule().getLhs();
            ItemProviderAdapter adapter = (ItemProviderAdapter)this.adapterFactory.adapt((Notifier)lhs, Graph.class);
            adapter.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)lhs, true, true));
        }
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.GRAPH__NODES, HenshinFactory.eINSTANCE.createNode()));
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.GRAPH__EDGES, HenshinFactory.eINSTANCE.createEdge()));
        if (((Graph)object).isLhs() || ((Graph)object).isNestedCondition()) {
            newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.GRAPH__FORMULA, HenshinFactory.eINSTANCE.createNestedCondition()));
            newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.GRAPH__FORMULA, HenshinFactory.eINSTANCE.createAnd()));
            newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.GRAPH__FORMULA, HenshinFactory.eINSTANCE.createOr()));
            newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.GRAPH__FORMULA, HenshinFactory.eINSTANCE.createXor()));
            newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.GRAPH__FORMULA, HenshinFactory.eINSTANCE.createNot()));
        }
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        if (feature == HenshinPackage.eINSTANCE.getGraph_Nodes()) {
            return new NodeComplexRemoveCommand(domain, (Graph)owner, collection);
        }
        if (feature == HenshinPackage.eINSTANCE.getGraph_Edges()) {
            return new NegligentRemoveCommand(domain, owner, feature, collection);
        }
        return super.createRemoveCommand(domain, owner, feature, collection);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        if (feature == HenshinPackage.eINSTANCE.getGraph_Formula()) {
            return new SetNestedConditionCommand(domain, owner, feature, value);
        }
        return super.createSetCommand(domain, owner, feature, value);
    }

    @Override
    public Object getToolTip(Object object) {
        Graph g = (Graph)object;
        return String.valueOf(g.getName()) + "(Nodes: " + g.getNodes().size() + ", Edges: " + g.getEdges().size() + ")";
    }
}

