/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Formula;

public abstract class DiscardInFavorOfChildFormulaCommand
extends AbstractCommand {
    protected BinaryFormula formula;
    protected Formula child;

    public DiscardInFavorOfChildFormulaCommand(BinaryFormula formula) {
        this.formula = formula;
    }

    protected boolean prepare() {
        return this.formula != null && this.formula.eContainer() != null;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        this.child = this.getChild();
        this.formula.eContainer().eSet(this.formula.eContainingFeature(), (Object)this.child);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.child.eContainer().eSet(this.child.eContainingFeature(), (Object)this.formula);
        this.resetChild();
    }

    protected abstract Formula getChild();

    protected abstract void resetChild();

    public static class Left
    extends DiscardInFavorOfChildFormulaCommand {
        public Left(BinaryFormula formula) {
            super(formula);
        }

        @Override
        protected Formula getChild() {
            return this.formula.getLeft();
        }

        @Override
        protected void resetChild() {
            this.formula.setLeft(this.child);
        }
    }

    public static class Right
    extends DiscardInFavorOfChildFormulaCommand {
        public Right(BinaryFormula formula) {
            super(formula);
        }

        @Override
        protected Formula getChild() {
            return this.formula.getRight();
        }

        @Override
        protected void resetChild() {
            this.formula.setRight(this.child);
        }
    }
}

