/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import org.eclipse.emf.henshin.interpreter.ApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class Interpreter {
    private Engine engine;
    private ApplicationMonitor applicationMonitor;
    protected HenshinResourceSet res;
    protected UnitApplication app;

    public Interpreter(String resourcePath) {
        this.res = new HenshinResourceSet(resourcePath);
        this.applicationMonitor = null;
        this.engine = new EngineImpl(new String[0]);
    }

    public EGraph executeUnit(EGraph graph, Module mod, String unitName, Object ... parameterValues) {
        Unit u = mod.getUnit(unitName);
        if (u == null) {
            throw new RuntimeException("Unit: " + unitName + " doesn't exist in this Module");
        }
        this.app = new UnitApplicationImpl(this.engine);
        this.app.setEGraph(graph);
        this.app.setUnit(u);
        if (this.app.getAssignment() == null) {
            this.app.setAssignment(InterpreterFactory.INSTANCE.createAssignment(this.app.getUnit(), false));
        }
        this.assignParameters(this.app.getAssignment(), parameterValues);
        if (!this.app.execute(this.getApplicationMonitor())) {
            throw new RuntimeException("Failed to apply transformation");
        }
        return graph;
    }

    public EGraph executeUnit(String inputModelPath, Module mod, String unitName, Object ... parameterValues) {
        return this.executeUnit(this.loadGraphFromFile(inputModelPath), mod, unitName, parameterValues);
    }

    public EGraph executeUnit(EGraph graph, String modulePath, String unitName, Object ... parameterValues) {
        return this.executeUnit(graph, this.loadModuleFromFile(modulePath), unitName, parameterValues);
    }

    public EGraph executeUnit(String inputModelPath, String modulePath, String unitName, Object ... parameterValues) {
        return this.executeUnit(this.loadGraphFromFile(inputModelPath), this.loadModuleFromFile(modulePath), unitName, parameterValues);
    }

    protected void assignParameters(Assignment assignment, Object[] values) {
        Unit u = assignment.getUnit();
        int inCounter = 0;
        int i = 0;
        while (i < u.getParameters().size()) {
            if (((Parameter)u.getParameters().get(i)).getKind().equals((Object)ParameterKind.IN) || ((Parameter)u.getParameters().get(i)).getKind().equals((Object)ParameterKind.INOUT)) {
                Parameter param = (Parameter)u.getParameters().get(i);
                try {
                    if (!param.getType().isInstance(values[i])) {
                        throw new RuntimeException("Parameter Value for " + param.getName() + " does not have the correct Type");
                    }
                    assignment.setParameterValue(param, values[i]);
                    ++inCounter;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new RuntimeException("Too less ParameterValues were specified!");
                }
            }
            ++i;
        }
        if (inCounter < values.length) {
            throw new RuntimeException("Too much ParameterValues were specified!");
        }
    }

    public Object getResultParameterValue(String param) {
        Object res = this.app.getResultParameterValue(param);
        return res;
    }

    public void saveGraph(EGraph graph, String filename) {
        this.res.saveEObject(graph.getRoots().get(0), filename);
    }

    protected EGraph loadGraphFromFile(String inputModelPath) {
        return new EGraphImpl(this.res.getResource(inputModelPath));
    }

    protected Module loadModuleFromFile(String inputModulePath) {
        return this.res.getModule(inputModulePath);
    }

    public ApplicationMonitor getApplicationMonitor() {
        return this.applicationMonitor;
    }

    public void setApplicationMonitor(ApplicationMonitor applicationMonitor) {
        this.applicationMonitor = applicationMonitor;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }
}

