/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.metamodelevolution;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.model.impl.HenshinPackageImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class Evolution1 {
    private static final String BASE = "src/org/eclipse/emf/henshin/examples/metamodelevolution/";
    private static final String MODEL_PETRI_META = "src/org/eclipse/emf/henshin/examples/metamodelevolution/petri.ecore";
    private static final String MODEL_PETRI_INSTANCE = "src/org/eclipse/emf/henshin/examples/metamodelevolution/Net1.xmi";
    private static final String HENSHIN_PETRI_META = "src/org/eclipse/emf/henshin/examples/metamodelevolution/petriM.henshin";
    private static final String HENSHIN_PETRI_INSTANCE = "src/org/eclipse/emf/henshin/examples/metamodelevolution/petriI.henshin";
    HenshinResourceSet resourceSet = new HenshinResourceSet();

    private void start() {
        EPackage petri = this.loadPetriEcoreModel();
        UnitApplication mm_unit1App = this.evolveMetaModel_ReplaceRefWithRefclass(petri, "Place", "Transition", "ArcPT");
        EClass srcType = (EClass)mm_unit1App.getResultParameterValue("objSource");
        EClass trgType = (EClass)mm_unit1App.getResultParameterValue("objTarget");
        EClass refclassType = (EClass)mm_unit1App.getResultParameterValue("objRefclass");
        EReference refType = (EReference)mm_unit1App.getResultParameterValue("objRef");
        EReference refSrcTrg = (EReference)mm_unit1App.getResultParameterValue("objRefSrcTrg");
        EReference refTrgSrc = (EReference)mm_unit1App.getResultParameterValue("objRefTrgSrc");
        this.migrateInstanceModel_ReplaceRefWithRefclass(petri, srcType, trgType, refType, refclassType, refSrcTrg, refTrgSrc);
        this.evolveMetaModel_DeleteOldReference(petri, refType);
    }

    private UnitApplication evolveMetaModel_ReplaceRefWithRefclass(EPackage petri, String srcNodeName, String trgNodeName, String refclassName) {
        Module tsM = this.loadPetriModuleM();
        EGraphImpl graphM = new EGraphImpl();
        graphM.addTree((EObject)petri);
        EngineImpl engineM = new EngineImpl();
        Rule mm_rule1 = (Rule)tsM.getUnit("MM_CreateRefClass");
        UnitApplicationImpl mm_unit1App = new UnitApplicationImpl((Engine)engineM);
        mm_unit1App.setUnit((Unit)mm_rule1);
        mm_unit1App.setEGraph((EGraph)graphM);
        mm_unit1App.setParameterValue("srcName", (Object)srcNodeName);
        mm_unit1App.setParameterValue("trgName", (Object)trgNodeName);
        mm_unit1App.setParameterValue("refclassName", (Object)refclassName);
        boolean resultM = mm_unit1App.execute(null);
        if (!resultM) {
            System.out.println("\"MM_CreateRefClass\" not applied.");
            return null;
        }
        System.out.println("\"MM_CreateRefClass\" applied.");
        try {
            petri.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mm_unit1App;
    }

    private UnitApplication migrateInstanceModel_ReplaceRefWithRefclass(EPackage petri, EClass srcType, EClass trgType, EReference refType, EClass refclassType, EReference refSrcTrg, EReference refTrgSrc) {
        HenshinFactory hFac = HenshinFactoryImpl.eINSTANCE;
        Module tsI = hFac.createModule();
        tsI.getImports().add((Object)petri);
        Rule i_rule1 = hFac.createRule();
        tsI.getUnits().add((Object)i_rule1);
        i_rule1.setActivated(true);
        i_rule1.setName("Migrate Instance Model");
        Graph lhs = i_rule1.getLhs();
        Graph rhs = i_rule1.getRhs();
        Node lhs_n_sC = hFac.createNode(lhs, srcType, null);
        Node lhs_n_tC = hFac.createNode(lhs, trgType, null);
        hFac.createEdge(lhs_n_sC, lhs_n_tC, refType);
        Node rhs_n_sC = hFac.createNode(rhs, srcType, null);
        Node rhs_n_tC = hFac.createNode(rhs, trgType, null);
        Node rhs_n_rC = hFac.createNode(rhs, refclassType, null);
        hFac.createEdge(rhs_n_sC, rhs_n_rC, refSrcTrg);
        hFac.createEdge(rhs_n_tC, rhs_n_rC, refTrgSrc);
        Mapping m1 = hFac.createMapping(lhs_n_sC, rhs_n_sC);
        i_rule1.getMappings().add((Object)m1);
        Mapping m2 = hFac.createMapping(lhs_n_tC, rhs_n_tC);
        i_rule1.getMappings().add((Object)m2);
        LoopUnit c_unit = hFac.createLoopUnit();
        tsI.getUnits().add((Object)c_unit);
        c_unit.setName("MigrationUnit");
        c_unit.setSubUnit((Unit)i_rule1);
        this.savePetriInstanceModule(tsI);
        EObject net = this.loadPetriInstanceModel();
        EGraphImpl graphI = new EGraphImpl();
        graphI.addTree(net);
        EngineImpl engineI = new EngineImpl();
        UnitApplicationImpl i_unit1App = new UnitApplicationImpl((Engine)engineI);
        i_unit1App.setEGraph((EGraph)graphI);
        i_unit1App.setUnit((Unit)c_unit);
        boolean resultI = i_unit1App.execute(null);
        if (!resultI) {
            System.out.println("Co-Evolution of instance model not successful.");
            return null;
        }
        System.out.println("Co-Evolution of instance model successful.");
        try {
            net.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return i_unit1App;
    }

    public UnitApplication evolveMetaModel_DeleteOldReference(EPackage petri, EReference refType) {
        Module tsM = this.loadPetriModuleM();
        EGraphImpl graphM = new EGraphImpl();
        graphM.addTree((EObject)petri);
        EngineImpl engineM = new EngineImpl();
        Rule mm_rule2 = (Rule)tsM.getUnit("MM_DeleteOldRefs");
        UnitApplicationImpl mm_unit2App = new UnitApplicationImpl((Engine)engineM);
        mm_unit2App.setEGraph((EGraph)graphM);
        mm_unit2App.setUnit((Unit)mm_rule2);
        mm_unit2App.setParameterValue("objDelRef", (Object)refType);
        boolean resultM = mm_unit2App.execute(null);
        if (!resultM) {
            System.out.println("\"MM_DeleteOldRefs\" not applied.");
            return null;
        }
        System.out.println("\"MM_DeleteOldRefs\" applied.");
        try {
            petri.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mm_unit2App;
    }

    private void savePetriInstanceModule(Module tsI) {
        URI iURI = URI.createFileURI((String)new File(HENSHIN_PETRI_INSTANCE).getAbsolutePath());
        Resource res = this.resourceSet.createResource(iURI, "henshin");
        res.getContents().add((Object)tsI);
        try {
            res.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Module loadPetriModuleM() {
        HenshinPackageImpl.init();
        Module tsM = this.resourceSet.getModule(HENSHIN_PETRI_META, false);
        return tsM;
    }

    private EPackage loadPetriEcoreModel() {
        URI modelUri = URI.createFileURI((String)new File(MODEL_PETRI_META).getAbsolutePath());
        Resource resourceModel = this.resourceSet.getResource(modelUri, true);
        return (EPackage)resourceModel.getContents().get(0);
    }

    private EObject loadPetriInstanceModel() {
        URI instanceUri = URI.createFileURI((String)new File(MODEL_PETRI_INSTANCE).getAbsolutePath());
        Resource resourceInstance = this.resourceSet.getResource(instanceUri, true);
        if (resourceInstance.isLoaded()) {
            resourceInstance.unload();
            try {
                resourceInstance.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (EObject)resourceInstance.getContents().get(0);
    }

    public static void main(String[] args) {
        Evolution1 test = new Evolution1();
        test.start();
    }
}

