/*******************************************************************************
 * Copyright (c) 2005 - 2006 Joel Cheuoua & others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Joel Cheuoua - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.codegen.jet.editor.dyncheck;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
/**
 * A ResourceMarkerAnnotationModel where we can turn on/off the notifications of changes.
 * 
 * @author jcheuoua
 * @version $Revision: 1.3 $
 */
public class JETAnnotationModel extends ResourceMarkerAnnotationModel {
  private boolean fireChanges = true;
  /**
   * @param resource
   */
  public JETAnnotationModel(IResource resource) {
    super(resource);
  }
  /**
   * @return boolean
   */
  public synchronized boolean isFireChanges() {
    return fireChanges;
  }
  /**
   * @param b
   */
  public synchronized void setFireChanges(boolean b) {
    fireChanges = b;
  }
  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.jface.text.source.IAnnotationModel#addAnnotation(org.eclipse.jface.text.source.Annotation,
   *      org.eclipse.jface.text.Position)
   */
  public synchronized void addAnnotation(Annotation annotation, Position position) {
    try {
      addAnnotation(annotation, position, fireChanges);
    } catch (BadLocationException e) {
      //    ignore invalid position
    }
  }
  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.jface.text.source.AnnotationModel#removeAllAnnotations()
   */
  public synchronized void removeAllAnnotations() {
    super.removeAllAnnotations(fireChanges);
  }
  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.jface.text.source.IAnnotationModel#removeAnnotation(org.eclipse.jface.text.source.Annotation)
   */
  public synchronized void removeAnnotation(Annotation annotation) {
    super.removeAnnotation(annotation, fireChanges);
  }
  
  public void fireAnnotationModelChanged() {
    fireModelChanged();
  }
  
  /**
   * Method createMarkerAnnotation.
   * @param marker IMarker
   * @return MarkerAnnotation
   */
  protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
    return new JavaMarkerAnnotation(marker);
  }
}