/*******************************************************************************
 * Copyright (c) 2007 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import java.util.EventObject;
import java.util.Map;

import org.eclipse.jdt.core.IMember;

/**
 * Event describing a change to a Java type member's {@link CodeGenStatus code
 * generation status}.
 * 
 * @noextend This class is not intended to be subclassed by clients.
 * @noinstantiate This class is not intended to be instantiated by clients.
 */
public class MemberAnnotationChangedEvent extends EventObject {

	private static final long serialVersionUID = -2126850314649035592L;

	/**
	 * Map of changed {@link IMember members} to their new {@link CodeGenStatus
	 * statuses}.
	 */
	private final Map<IMember, CodeGenStatus> changes;

	/**
	 * Creates an instance of the event.
	 * 
	 * @param manager
	 *            event source
	 * @param changes
	 *            map of members and their changed statuses
	 * @noreference This constructor is not intended to be referenced by
	 *              clients.
	 */
	public MemberAnnotationChangedEvent(IMemberAnnotationManager manager,
			Map<IMember, CodeGenStatus> changes) {
		super(manager);
		this.changes = changes;
	}

	/**
	 * Returns a map of members and their changed statuses.
	 * 
	 * @return map of members and their changed statuses
	 */
	public Map<IMember, CodeGenStatus> getChanges() {
		return changes;
	}
}
