/*******************************************************************************
 * Copyright (c) 2007 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenForeignModelAction implements IObjectActionDelegate {

	private static final String RESOURCE_URI_PREFIX = "platform:/resource/"; //$NON-NLS-1$

	private IWorkbenchPart targetPart;

	private IFile foreignModel;

	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.targetPart = targetPart;
	}

	public void run(IAction action) {
		try {
			IDE.openEditor(targetPart.getSite().getPage(), foreignModel);
		} catch (PartInitException e) {
			ErrorDialog.openError(targetPart.getSite().getShell(),
					Messages.OpenForeignModelAction_EditorError,
					Messages.OpenForeignModelAction_ErrorOpenModel, e
							.getStatus());
		}
	}

	public void selectionChanged(IAction action, ISelection selection) {
		if (selection.isEmpty()) {
			action.setEnabled(false);
			return;
		}

		GenModel genModel = (GenModel) ((IStructuredSelection) selection)
				.getFirstElement();
		EList<String> foreignModels = genModel.getForeignModel();
		if (foreignModels.isEmpty())
			action.setEnabled(false);
		else {
			URI foreignModelURI = URI.createURI((String) foreignModels.get(0));
			String foreignModelPath = foreignModelURI.resolve(
					genModel.eResource().getURI()).toString();
			if (foreignModelPath.startsWith(RESOURCE_URI_PREFIX))
				foreignModelPath = foreignModelPath
						.substring(RESOURCE_URI_PREFIX.length());

			IResource foreignModelResource = ResourcesPlugin.getWorkspace()
					.getRoot().findMember(foreignModelPath);
			if (foreignModelResource == null
					|| foreignModelResource.getType() != IResource.FILE)
				action.setEnabled(false);
			else
				foreignModel = (IFile) foreignModelResource;
		}
	}
}
