/*******************************************************************************
 * Copyright (c) 2008, 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenGeneratedAction extends Action {

	protected final IItemJavaElementDescriptor descriptor;

	protected final Object target;

	public OpenGeneratedAction(IItemJavaElementDescriptor descriptor,
			Object target) {
		this.descriptor = descriptor;
		this.target = target;
		initialize();
	}

	protected void initialize() {
		setText(descriptor.getDisplayName(target));
		IJavaElement element = descriptor.getJavaElement(target);
		if (element != null && !element.exists())
			setEnabled(false);
	}

	@Override
	public void run() {
		Object element = null;
		IStatus status = null;

		switch (descriptor.getKind(target)) {
		case JAVA_ELEMENT:
			element = descriptor.getJavaElement(target);
			break;
		case JAVA_TYPE_REFERENCE:
			IJavaTypeReference reference = descriptor
					.getJavaTypeReference(target);
			if (reference != null) {
				IJavaProject context = reference.getContext();
				String typeName = reference.getTypeName();
				try {
					element = context.findType(typeName);
				} catch (JavaModelException e) {
					status = e.getStatus();
				}

				if (element == null) {
					String msg = NLS.bind(
							Messages.OpenGeneratedAction_LocateError, typeName,
							context.getProject().getName());
					if (status == null) {
						status = new Status(IStatus.ERROR, MintUI.PLUGIN_ID, 0,
								msg, null);
					} else {
						MultiStatus multiStatus = new MultiStatus(
								MintUI.PLUGIN_ID, 0, msg, null);
						multiStatus.add(status);
						status = multiStatus;
					}
				}
			}

			break;
		case NON_JAVA_RESOURCE:
			element = descriptor.getNonJavaElement(target);
			break;
		}

		if (element == null) {
			if (status == null)
				status = new Status(IStatus.ERROR, MintUI.PLUGIN_ID, 0,
						"Could not open '" + descriptor.getDisplayName(target)
								+ "'.", null);

			ErrorDialog.openError(PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell(),
					Messages.OpenGeneratedAction_ErrorFindType, null, status);
			return;
		}

		try {
			if (element instanceof ISourceReference) {
				JavaUI.openInEditor((IJavaElement) element);
			} else {
				IWorkbenchPage page = PlatformUI.getWorkbench()
						.getActiveWorkbenchWindow().getActivePage();
				if (page != null) {
					if (element instanceof IFile) {
						IDE.openEditor(page, (IFile) element);
					} else {
						IPackagesViewPart view = (IPackagesViewPart) page
								.showView(JavaUI.ID_PACKAGES);
						view.selectAndReveal(element);
					}
				}
			}
		} catch (CoreException e) {
			ErrorDialog.openError(PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell(),
					Messages.OpenGeneratedAction_EditorError,
					Messages.OpenGeneratedAction_ErrorOpenType, e.getStatus());
		}
	}
}