/*******************************************************************************
 * Copyright (c) 2007 - 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenForeignModelAction extends Action {

	private final IWorkbenchPage page;

	private final IFile file;

	public OpenForeignModelAction(IWorkbenchPage page, IFile file) {
		setText(file.getName());
		this.page = page;
		this.file = file;
	}

	@Override
	public void run() {
		try {
			IDE.openEditor(page, file);
		} catch (PartInitException e) {
			ErrorDialog.openError(page.getWorkbenchWindow().getShell(),
					Messages.OpenForeignModelAction_EditorError,
					Messages.OpenForeignModelAction_ErrorOpenModel, e
							.getStatus());
		}
	}
}
