/*******************************************************************************
 * Copyright (c) 2007, 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import java.util.EventListener;

/**
 * Interface for listeners that want to be notified of changes to Java type
 * members' {@link CodeGenStatus code generation status}.
 * 
 * <p>
 * Clients may implement this interface.
 * </p>
 * 
 * @see IMemberAnnotationManager#addMemberAnnotationListener(IMemberAnnotationListener)
 */
public interface IMemberAnnotationListener extends EventListener {

	/**
	 * Notifies the listener of a member annotation change event.
	 * 
	 * @param event
	 *            event describing the changes
	 */
	void memberAnnotationChanged(MemberAnnotationChangedEvent event);
}
