/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal;

import java.io.PrintStream;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.mint.MintCore;

public final class Debug {

	private static final String OPTION_PREFIX = MintCore.PLUGIN_ID + "/debug/"; //$NON-NLS-1$

	public final String tag;

	private final String tracePrefix;

	public final boolean enabled;

	public final PrintStream out = System.out;

	public Debug(String tag) {
		this.tag = OPTION_PREFIX + tag;
		tracePrefix = this.tag + ": "; //$NON-NLS-1$
		enabled = Boolean.parseBoolean(Platform.getDebugOption(this.tag));
	}

	public void trace(String format, Object... args) {
		out.format(tracePrefix + format + "%n", args); //$NON-NLS-1$
	}
}
