/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal.ui.views;

import java.util.Arrays;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mint.IItemJavaElementDescriptor2;
import org.eclipse.emf.mint.IJavaTypeReference;
import org.eclipse.emf.mint.internal.ui.views.FindTypeJob;
import org.eclipse.emf.mint.internal.ui.views.ItemJavaElementDescriptor;
import org.eclipse.emf.mint.internal.ui.views.Messages;
import org.eclipse.emf.mint.internal.ui.views.UpdateViewerJob;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ItemJavaElementLabelProvider
extends StyledCellLabelProvider {
    private static final Object DEFERRED = new Object();
    private final JavaElementLabelProvider delegate;
    private final IWorkbenchSiteProgressService progressService;
    private final UpdateViewerJob updateViewerJob;

    public ItemJavaElementLabelProvider(IWorkbenchSiteProgressService progressService, UpdateViewerJob updateViewerJob) {
        this.progressService = progressService;
        this.updateViewerJob = updateViewerJob;
        this.delegate = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x800);
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof ItemJavaElementDescriptor) {
            IItemJavaElementDescriptor2 desc2;
            ItemJavaElementDescriptor desc = (ItemJavaElementDescriptor)((Object)cell.getElement());
            if (desc.getDescriptor() instanceof IItemJavaElementDescriptor2 && !(desc2 = (IItemJavaElementDescriptor2)desc.getDescriptor()).isElementOwner(desc.getTarget())) {
                cell.setForeground(JFaceResources.getColorRegistry().get("QUALIFIER_COLOR"));
            }
            switch (cell.getColumnIndex()) {
                case 0: {
                    Object[] newStyleRanges;
                    Object element = this.getJavaElement(desc);
                    if (element == null) {
                        cell.setText(Messages.ItemJavaElementLabelProvider_UnknownElementLabel);
                        cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
                        break;
                    }
                    if (element == DEFERRED) {
                        cell.setText(desc.getDescriptor().getJavaTypeReference(desc.getTarget()).getTypeName());
                        break;
                    }
                    if (element == ItemJavaElementDescriptor.ERROR_ELEMENT) {
                        cell.setText(desc.getDescriptor().getJavaTypeReference(desc.getTarget()).getTypeName());
                        cell.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
                        break;
                    }
                    StyledString styledString = this.delegate.getStyledText(element);
                    String newText = styledString.toString();
                    Object[] oldStyleRanges = cell.getStyleRanges();
                    Object[] objectArray = newStyleRanges = this.isOwnerDrawEnabled() ? styledString.getStyleRanges() : null;
                    if (!Arrays.equals(oldStyleRanges, newStyleRanges)) {
                        cell.setStyleRanges((StyleRange[])newStyleRanges);
                        if (cell.getText().equals(newText)) {
                            cell.setText("");
                        }
                    }
                    cell.setText(newText);
                    cell.setImage(this.delegate.getImage(element));
                    break;
                }
                case 1: {
                    cell.setText(desc.getDescriptor().getDisplayName(desc.getTarget()));
                    break;
                }
                case 2: {
                    cell.setText(desc.getDescriptor().getCategory(desc.getTarget()));
                }
            }
        }
    }

    private Object getJavaElement(ItemJavaElementDescriptor desc) {
        switch (desc.getDescriptor().getKind(desc.getTarget())) {
            case JAVA_ELEMENT: {
                return desc.getDescriptor().getJavaElement(desc.getTarget());
            }
            case JAVA_TYPE_REFERENCE: {
                if (desc.getElement() != null) {
                    return desc.getElement();
                }
                IJavaTypeReference ref = desc.getDescriptor().getJavaTypeReference(desc.getTarget());
                FindTypeJob job = new FindTypeJob(desc, ref, this.updateViewerJob);
                if (this.progressService == null) {
                    job.schedule();
                } else {
                    this.progressService.schedule((Job)job, 0L, true);
                }
                return DEFERRED;
            }
            case NON_JAVA_RESOURCE: {
                return desc.getDescriptor().getNonJavaElement(desc.getTarget());
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.delegate.addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.delegate.removeListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.delegate.isLabelProperty(element, property);
    }

    public void dispose() {
        super.dispose();
        this.delegate.dispose();
    }
}

