/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.processing.handlers;

import java.io.IOException;
import java.util.Stack;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.emf.mwe.core.debug.processing.ElementAdapter;
import org.eclipse.emf.mwe.core.debug.processing.EventHandler;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.ConfirmationPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.EventPackage;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.EventPackageWithFrames;
import org.eclipse.emf.mwe.internal.core.debug.processing.DebugMonitor;
import org.eclipse.emf.mwe.internal.core.debug.processing.RuntimeHandler;

public class EventRuntimeHandler
implements RuntimeHandler,
EventHandler {
    public static final int STARTED = 1;
    public static final int SUSPENDED = 2;
    public static final int RESUMED = 3;
    public static final int TERMINATED = 4;
    private Connection connection;
    private DebugMonitor monitor;
    private final Stack<Frame> stackFrames = new Stack();
    private final Stack<Frame> filteredStackFrames = new Stack();
    private int cleanStackLevel = 0;

    @Override
    public void init(DebugMonitor monitor, Connection connection) {
        this.monitor = monitor;
        this.connection = connection;
        monitor.addEventHandler(this);
    }

    @Override
    public void startListener() {
    }

    @Override
    public void started() throws IOException {
        this.sendEvent(1);
    }

    @Override
    public void preTask(Object element, Object context, int state) {
        Frame frame = new Frame(element, context, state);
        ElementAdapter adapter = this.monitor.getAdapter(element);
        if (adapter != null && adapter.shallAddToCallStack(element)) {
            this.filteredStackFrames.push(frame);
        }
        this.stackFrames.push(frame);
    }

    @Override
    public void postTask(Object context) {
        Frame frame = this.stackFrames.peek();
        this.stackFrames.pop();
        ElementAdapter adapter = this.monitor.getAdapter(frame.element);
        if (adapter != null && adapter.shallAddToCallStack(frame.element)) {
            if (this.cleanStackLevel >= this.filteredStackFrames.size()) {
                --this.cleanStackLevel;
            }
            this.filteredStackFrames.pop();
        }
    }

    @Override
    public void suspended() throws IOException {
        EventPackageWithFrames event = new EventPackageWithFrames(2);
        if (this.cleanStackLevel > 0) {
            --this.cleanStackLevel;
        }
        event.cleanStackLevel = this.cleanStackLevel;
        int i = this.cleanStackLevel;
        while (i < this.filteredStackFrames.size()) {
            Frame frame = (Frame)this.filteredStackFrames.get(i);
            ElementAdapter adapter = this.monitor.getAdapter(frame.element);
            adapter.setContext(frame.context);
            SyntaxElement to = frame.state == 1 ? (i == this.filteredStackFrames.size() - 1 ? adapter.createElement(this.stackFrames.peek().element) : adapter.createElement(frame.element)) : adapter.createEndElementTO(frame.element);
            to.type = adapter.getAdapterType();
            to.frameId = i++;
            event.frames.add(to);
        }
        this.sendAndConfirm(event);
        this.cleanStackLevel = this.filteredStackFrames.size();
    }

    @Override
    public void resumed() throws IOException {
        this.sendEvent(3);
    }

    @Override
    public void terminated() throws IOException {
        this.sendEvent(4);
    }

    private void sendEvent(int type) throws IOException {
        EventPackage event = new EventPackage(type);
        this.sendAndConfirm(event);
    }

    private void sendAndConfirm(EventPackage event) throws IOException {
        int refId = this.connection.sendPackage(event);
        this.connection.listenForPackage(ConfirmationPackage.class, refId);
    }

    private class Frame {
        final Object element;
        final int state;
        final Object context;

        private Frame(Object element, Object context, int state) {
            this.element = element;
            this.context = context;
            this.state = state;
        }
    }
}

