/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.debug.communication;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.internal.core.debug.communication.Connection;
import org.eclipse.emf.mwe.internal.core.debug.communication.packages.AbstractPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageReceiver
implements Runnable {
    private final ArrayList<AbstractPackage> receivedPackages;
    private static final Log logger = LogFactory.getLog(PackageReceiver.class);
    private final Connection connection;
    private boolean interrupt = false;
    private Exception exception;

    public static PackageReceiver newPackageReceiver(Connection connection) {
        PackageReceiver receiver = new PackageReceiver(connection);
        Thread thread = new Thread((Runnable)receiver, "PackageReceiver");
        thread.setDaemon(true);
        thread.start();
        return receiver;
    }

    private PackageReceiver(Connection connection) {
        this.connection = connection;
        this.receivedPackages = new ArrayList();
    }

    public AbstractPackage getPackage(Class<? extends AbstractPackage> type, long timeToWait) throws InterruptedIOException {
        return this.getPackage(type, 0, timeToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPackage getPackage(Class<? extends AbstractPackage> type, int refId, long timeToWait) throws InterruptedIOException {
        AbstractPackage packet = null;
        ArrayList<AbstractPackage> arrayList = this.receivedPackages;
        synchronized (arrayList) {
            long remainingTime = timeToWait;
            while ((packet = this.popReceivedPackage(type, refId)) == null && this.connection.isConnected() && !this.interrupt && (timeToWait < 0L || remainingTime > 0L)) {
                long timeBeforeWait = System.currentTimeMillis();
                try {
                    this.waitForPackageAvailable(remainingTime);
                }
                catch (InterruptedException interruptedException) {}
                if (timeToWait < 0L) continue;
                remainingTime -= System.currentTimeMillis() - timeBeforeWait;
            }
        }
        this.checkForException(packet);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        this.interrupt = true;
        ArrayList<AbstractPackage> arrayList = this.receivedPackages;
        synchronized (arrayList) {
            this.receivedPackages.notifyAll();
        }
    }

    private void waitForPackageAvailable(long timeToWait) throws InterruptedException {
        if (timeToWait == 0L) {
            return;
        }
        if (timeToWait < 0L) {
            this.receivedPackages.wait();
        } else {
            this.receivedPackages.wait(timeToWait);
        }
    }

    private synchronized AbstractPackage popReceivedPackage(Class<? extends AbstractPackage> type, int refId) {
        for (AbstractPackage packet : this.receivedPackages) {
            if (!type.isInstance(packet) || refId != 0 && packet.refId != refId) continue;
            this.receivedPackages.remove(packet);
            return packet;
        }
        return null;
    }

    private void checkForException(AbstractPackage packet) throws InterruptedIOException {
        if (packet != null) {
            return;
        }
        if (this.exception != null && !(this.exception instanceof IOException)) {
            logger.error((Object)this.exception.getMessage(), (Throwable)this.exception);
        }
        if (this.interrupt) {
            throw new InterruptedIOException("packet receiver is going to close");
        }
        if (this.exception != null) {
            throw new InterruptedIOException(this.exception.getMessage());
        }
        throw new InterruptedIOException("timeout reading a packet");
    }

    @Override
    public void run() {
        try {
            while (!this.interrupt && this.connection.isConnected()) {
                this.readAvailablePackage();
            }
        }
        catch (Exception e) {
            this.exception = e;
            this.close();
        }
    }

    private void readAvailablePackage() throws IOException {
        this.addPackageToList(this.connection.readPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackageToList(AbstractPackage packet) {
        ArrayList<AbstractPackage> arrayList = this.receivedPackages;
        synchronized (arrayList) {
            this.receivedPackages.add(packet);
            this.receivedPackages.notifyAll();
        }
    }
}

