/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dbgen.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.cdo.dbgen.provider.ColumnItemProvider;
import org.eclipse.emf.cdo.dbgen.provider.DatabaseItemProvider;
import org.eclipse.emf.cdo.dbgen.provider.IndexItemProvider;
import org.eclipse.emf.cdo.dbgen.provider.TableItemProvider;
import org.eclipse.emf.cdo.dbgen.util.DBGenAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class DBGenItemProviderAdapterFactory
extends DBGenAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection supportedTypes = new ArrayList();
    protected DatabaseItemProvider databaseItemProvider;
    protected TableItemProvider tableItemProvider;
    protected ColumnItemProvider columnItemProvider;
    protected IndexItemProvider indexItemProvider;

    public DBGenItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createDatabaseAdapter() {
        if (this.databaseItemProvider == null) {
            this.databaseItemProvider = new DatabaseItemProvider((AdapterFactory)this);
        }
        return this.databaseItemProvider;
    }

    public Adapter createTableAdapter() {
        if (this.tableItemProvider == null) {
            this.tableItemProvider = new TableItemProvider((AdapterFactory)this);
        }
        return this.tableItemProvider;
    }

    public Adapter createColumnAdapter() {
        if (this.columnItemProvider == null) {
            this.columnItemProvider = new ColumnItemProvider((AdapterFactory)this);
        }
        return this.columnItemProvider;
    }

    public Adapter createIndexAdapter() {
        if (this.indexItemProvider == null) {
            this.indexItemProvider = new IndexItemProvider((AdapterFactory)this);
        }
        return this.indexItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.databaseItemProvider != null) {
            this.databaseItemProvider.dispose();
        }
        if (this.tableItemProvider != null) {
            this.tableItemProvider.dispose();
        }
        if (this.columnItemProvider != null) {
            this.columnItemProvider.dispose();
        }
        if (this.indexItemProvider != null) {
            this.indexItemProvider.dispose();
        }
    }
}

