/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.cdo.client.CDOPersistable;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.examples.client.ResourceCache;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.ResourceContentProvider;
import org.eclipse.emf.cdo.examples.ui.ResourceFactoryHelper;
import org.eclipse.emf.cdo.examples.ui.ResourceLabelProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class CDOExportWizardPage
extends WizardPage {
    private static final String SETTING_SOURCE_PATH = "CDOExportWizardPage.SOURCE_PATH";
    private static final String SETTING_RESOURCE_FACTORY = "CDOExportWizardPage.RESOURCE_FACTORY";
    private static final String SETTING_DESTINATION_URI = "CDOExportWizardPage.DESTINATION_URI";
    private CDOResource resource;
    private IStructuredSelection selection;
    private TableViewer sourcePathViewer;
    private Text destinationURIField;
    private Combo resourceFactoryField;
    private Button browseWorkspaceButton;
    private Button browseFileSystemButton;

    public CDOExportWizardPage(CDOResource resource, IStructuredSelection selection) {
        super("CDOExportWizardPage");
        this.selection = selection;
        this.resource = resource;
    }

    public void createControl(Composite parent) {
        try {
            ResourceCache resourceCache = this.resource == null ? ExampleClientPlugin.getResourceCache() : ExampleClientPlugin.createResourceCache((ResourceManager)this.resource.getResourceManager());
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout(1, false));
            control.setLayoutData((Object)new GridData(272));
            Group sourceGroup = this.createGroup(control, "Source", 1, 1808);
            this.sourcePathViewer = new TableViewer((Composite)sourceGroup, 2820);
            this.sourcePathViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
            this.sourcePathViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
            this.sourcePathViewer.setSorter(new ViewerSorter());
            this.sourcePathViewer.setInput((Object)resourceCache);
            this.sourcePathViewer.getControl().setLayoutData((Object)new GridData(1808));
            this.sourcePathViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CDOExportWizardPage.this.dialogChanged();
                }
            });
            Group destinationGroup = this.createGroup(control, "Destination", 2, 768);
            Label pathLabel = new Label((Composite)destinationGroup, 0);
            pathLabel.setText("URI:");
            Composite grid = this.createGrid((Composite)destinationGroup, 3);
            this.destinationURIField = new Text(grid, 2048);
            this.destinationURIField.setLayoutData((Object)new GridData(768));
            this.destinationURIField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CDOExportWizardPage.this.dialogChanged();
                }
            });
            this.browseWorkspaceButton = new Button(grid, 8);
            this.browseWorkspaceButton.setText("Workspace...");
            this.browseWorkspaceButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    CDOExportWizardPage.this.browseWorkspace();
                }
            });
            this.browseFileSystemButton = new Button(grid, 8);
            this.browseFileSystemButton.setText("File System...");
            this.browseFileSystemButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    CDOExportWizardPage.this.browseFileSystem();
                }
            });
            Label resourceFactoryLabel = new Label((Composite)destinationGroup, 0);
            resourceFactoryLabel.setText("Factory:");
            this.resourceFactoryField = new Combo((Composite)destinationGroup, 2052);
            this.resourceFactoryField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CDOExportWizardPage.this.dialogChanged();
                }
            });
            this.resourceFactoryField.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    CDOExportWizardPage.this.dialogChanged();
                }
            });
            this.initValues();
            this.setControl((Control)control);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void browseWorkspace() {
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        dialog.setBlockOnOpen(true);
        dialog.setTitle("Export CDO Resource");
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            URI uri = URI.createPlatformResourceURI((String)path.toString());
            this.destinationURIField.setText(uri.toString());
        }
    }

    protected void browseFileSystem() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText("Export CDO Resource");
        String fileName = dialog.open();
        if (fileName != null) {
            String fullPath = new File(fileName).getAbsolutePath();
            URI uri = URI.createFileURI((String)fullPath);
            this.destinationURIField.setText(uri.toString());
        }
    }

    protected Group createGroup(Composite parent, String title, int numColumns, int layoutMask) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(numColumns, false));
        group.setLayoutData((Object)new GridData(layoutMask));
        group.setText(title);
        return group;
    }

    protected Composite createGrid(Composite parent, int numColumns) {
        GridData gd = new GridData(768);
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite grid = new Composite(parent, 0);
        grid.setLayoutData((Object)gd);
        grid.setLayout((Layout)layout);
        return grid;
    }

    protected void initValues() {
        IDialogSettings settings;
        ArrayList<String> extensions = new ArrayList<String>(ResourceFactoryHelper.getExtensions());
        Collections.sort(extensions);
        for (String ext : extensions) {
            this.resourceFactoryField.add(ext);
        }
        if (this.selection != null) {
            Object elem = this.selection.getFirstElement();
            if (elem instanceof ResourceInfo) {
                this.sourcePathViewer.setSelection((ISelection)new StructuredSelection(elem));
            } else if (elem instanceof CDOResource) {
                this.sourcePathViewer.setSelection((ISelection)new StructuredSelection((Object)((CDOResource)elem).getInfo()));
            } else if (elem instanceof CDOPersistable) {
                CDOResource resource = ((CDOPersistable)elem).cdoGetResource();
                this.sourcePathViewer.setSelection((ISelection)new StructuredSelection((Object)resource.getInfo()));
            }
        }
        if (this.sourcePathViewer.getSelection() == null && this.resource != null) {
            this.sourcePathViewer.setSelection((ISelection)new StructuredSelection((Object)this.resource.getInfo()));
        }
        if ((settings = this.getDialogSettings()) != null) {
            String ext;
            if (this.getSourcePath() == null) {
                String path = settings.get(SETTING_SOURCE_PATH);
                this.destinationURIField.setText(path == null ? "" : path);
            }
            this.resourceFactoryField.setText((ext = settings.get(SETTING_RESOURCE_FACTORY)) == null ? "" : ext);
            String uri = settings.get(SETTING_DESTINATION_URI);
            this.destinationURIField.setText(uri == null ? "" : uri);
        } else {
            this.resourceFactoryField.setText("xmi");
        }
    }

    public void saveValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String path = this.getSourcePath();
            settings.put(SETTING_SOURCE_PATH, path);
            String ext = this.getResourceFactoryExtension();
            settings.put(SETTING_RESOURCE_FACTORY, ext);
            String uri = this.getDestinationURI();
            settings.put(SETTING_DESTINATION_URI, uri);
        }
    }

    protected void dialogChanged() {
        this.setMessage(null);
        this.setErrorMessage(null);
        this.setPageComplete(true);
        String path = this.getSourcePath();
        if (path == null) {
            this.setMessage("Select a CDO resource to be exported.");
            this.setPageComplete(false);
            return;
        }
        if (this.getDestinationURI().length() == 0) {
            this.setMessage("Enter the destination URI.");
            this.setPageComplete(false);
            return;
        }
        String ext = this.getResourceFactoryExtension();
        if (ext.length() == 0) {
            this.setMessage("Select a resource factory to use for export.");
            this.setPageComplete(false);
            return;
        }
        if (ResourceFactoryHelper.getResourceFactory(ext) == null) {
            this.setErrorMessage("Invalid resource factory");
            this.resourceFactoryField.setFocus();
            return;
        }
    }

    public String getResourceFactoryExtension() {
        return this.resourceFactoryField.getText().trim();
    }

    public String getSourcePath() {
        IStructuredSelection selection = (IStructuredSelection)this.sourcePathViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof ResourceInfo) {
            return ((ResourceInfo)firstElement).getPath();
        }
        return null;
    }

    public String getDestinationURI() {
        return this.destinationURIField.getText().trim();
    }
}

