/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.wizards;

import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.examples.client.internal.ExampleClientPlugin;
import org.eclipse.emf.cdo.examples.ui.PackageContentProvider;
import org.eclipse.emf.cdo.examples.ui.PackageLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class CDONewWizardPage
extends WizardPage {
    private Text resourcePathText;
    private TreeViewer rootElementViewer;

    public CDONewWizardPage() {
        super("wizardPage");
        this.setTitle("New CDO Resource");
        this.setDescription("This wizard creates a new remote CDO resource that can be opened by the CDO editor.");
    }

    public String getResourcePath() {
        return this.resourcePathText.getText();
    }

    public ClassInfo getRootElement() {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.rootElementViewer.getSelection();
            return (ClassInfo)selection.getFirstElement();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        Label resourcePathLabel = new Label(container, 0);
        resourcePathLabel.setText("Resource &Path:");
        this.resourcePathText = new Text(container, 2048);
        this.resourcePathText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.resourcePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDONewWizardPage.this.dialogChanged();
            }
        });
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.marginWidth = 0;
        gridLayout_1.marginHeight = 0;
        composite.setLayout((Layout)gridLayout_1);
        Label rootElementLabel = new Label(composite, 0);
        rootElementLabel.setText("Root &Element:");
        Tree tree = new Tree(composite, 2048);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rootElementViewer = new TreeViewer(tree);
        this.rootElementViewer.setContentProvider((IContentProvider)new PackageContentProvider());
        this.rootElementViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.rootElementViewer.setSorter(new ViewerSorter());
        this.rootElementViewer.setInput((Object)ExampleClientPlugin.getPackageManager());
        this.rootElementViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CDONewWizardPage.this.dialogChanged();
            }
        });
        this.rootElementViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CDONewWizardPage.this.getWizard().performFinish();
                ((WizardDialog)CDONewWizardPage.this.getContainer()).close();
            }
        });
        new Label(container, 0);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        this.resourcePathText.setText("/");
        this.resourcePathText.setSelection(1);
    }

    private void dialogChanged() {
        String resourcePath = this.getResourcePath();
        if (!resourcePath.startsWith("/")) {
            this.updateStatus("Resource path must start with '/'");
            return;
        }
        if (resourcePath.length() < 2) {
            this.updateStatus("Resource path must not be the root");
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.rootElementViewer.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (!(selectedElement instanceof ClassInfo)) {
            this.updateStatus("Select a class for the root element");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

