/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.common.ui.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.search.ecore.common.ui.Activator;
import org.eclipse.emf.search.ui.handlers.IModelElementEditorSelectionHandler;
import org.eclipse.emf.search.ui.pages.ModelEditorOpenEnum;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public final class ModelSearchEditorUtils {
    public static IFile getFile(Resource resource) {
        ResourceSet rset = resource.getResourceSet();
        return ModelSearchEditorUtils.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null);
    }

    private static IFile getFile(URI uri, URIConverter converter) {
        URI normalized;
        if ("platform".equals(uri.scheme()) && uri.segmentCount() > 2) {
            if ("resource".equals(uri.segment(0))) {
                IPath path = new Path(URI.decode((String)uri.path())).removeFirstSegments(1);
                return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
        } else if (uri.isFile() && !uri.isRelative()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        }
        if (converter instanceof URIConverter && !uri.equals((Object)(normalized = converter.normalize(uri)))) {
            return ModelSearchEditorUtils.getFile(normalized, converter);
        }
        return null;
    }

    public static void openEditorWithSelection(IModelElementEditorSelectionHandler handler, EObject o, ModelEditorOpenEnum mode) {
        if (o != null) {
            IFile file = ModelSearchEditorUtils.getFile(o.eResource());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                if (part instanceof IEditingDomainProvider) {
                    EditingDomain editingDomain = ((IEditingDomainProvider)part).getEditingDomain();
                    EObject object = editingDomain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)o), true);
                    if (handler != null) {
                        handler.handleModelSearchElementSelection(part, (Object)object, mode);
                    }
                }
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.common.ui", "Failed to open editor !", (Throwable)e));
            }
        }
    }
}

