/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ui.internal.replace.provisional;

import java.util.ArrayList;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.internal.replace.provisional.AbstractTextualModelSearchReplace;
import org.eclipse.emf.search.ui.Activator;
import org.eclipse.emf.search.ui.l10n.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModelSearchReplaceConfigurationPage
extends UserInputWizardPage {
    private static final String SETTINGS_GROUP = "ReplaceDialog2";
    private static final String SETTINGS_REPLACE_WITH = "replace_with";
    private final AbstractTextualModelSearchReplace fReplaceRefactoring;
    private Combo textField;
    private Label fStatusLabel;

    public ModelSearchReplaceConfigurationPage(AbstractTextualModelSearchReplace refactoring) {
        super("ModelSearchReplaceConfigurationPage");
        this.setTitle(Messages.getString("ModelSearchReplaceConfigurationPage.Title"));
        this.setDescription(Messages.getString("ModelSearchReplaceConfigurationPage.Description"));
        this.fReplaceRefactoring = refactoring;
    }

    public void createControl(Composite parent) {
        String[] previousReplaceWith;
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label description = new Label(result, 0);
        IModelSearchQuery query = this.fReplaceRefactoring.getModelSearchQuery();
        int numberOfMatches = query.getModelSearchResult().getTotalMatches();
        int numberOfFiles = query.getModelSearchResult().getRootResultHierarchies().keySet().size();
        String[] arguments = new String[]{String.valueOf(numberOfMatches), String.valueOf(numberOfFiles)};
        if (numberOfMatches > 1 && numberOfFiles > 1) {
            description.setText(String.valueOf(Messages.getString("ModelSearchReplaceConfigurationPage.0")) + arguments[0] + Messages.getString("ModelSearchReplaceConfigurationPage.1") + arguments[1] + Messages.getString("ModelSearchReplaceConfigurationPage.2"));
        } else if (numberOfMatches == 1) {
            description.setText(Messages.getString("ModelSearchReplaceConfigurationPage.3"));
        } else {
            description.setText(String.valueOf(arguments[0]) + Messages.getString("ModelSearchReplaceConfigurationPage.4"));
        }
        description.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        Label label1 = new Label(result, 0);
        label1.setText(Messages.getString("ModelSearchReplaceConfigurationPage.5"));
        Text clabel = new Text(result, 2056);
        clabel.setText(query.getQueryExpression());
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        clabel.setLayoutData((Object)gd);
        Label label2 = new Label(result, 0);
        label2.setText(Messages.getString("ModelSearchReplaceConfigurationPage.6"));
        this.textField = new Combo(result, 4);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.textField.setLayoutData((Object)gd);
        this.textField.setFocus();
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(SETTINGS_GROUP);
        if (settings != null && (previousReplaceWith = settings.getArray(SETTINGS_REPLACE_WITH)) != null) {
            this.textField.setItems(previousReplaceWith);
            this.textField.select(0);
        }
        this.fStatusLabel = new Label(result, 0);
        gd = new GridData(768);
        gd.verticalAlignment = 1024;
        gd.horizontalSpan = 2;
        this.fStatusLabel.setLayoutData((Object)gd);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.getNextPage();
    }

    private void storeSettings() {
        String[] items = this.textField.getItems();
        ArrayList<String> history = new ArrayList<String>();
        history.add(this.textField.getText());
        int historySize = Math.min(items.length, 6);
        int i = 0;
        while (i < historySize) {
            String curr = items[i];
            if (!history.contains(curr)) {
                history.add(curr);
            }
            ++i;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings().addNewSection(SETTINGS_GROUP);
        settings.put(SETTINGS_REPLACE_WITH, history.toArray(new String[history.size()]));
    }

    private void initializeRefactoring() {
        this.fReplaceRefactoring.setReplaceString(this.textField.getText());
    }
}

