/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.swt;

import java.util.Arrays;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IBinding;
import org.eclipse.net4j.examples.mvc.adapter.AbstractAdapter;
import org.eclipse.net4j.examples.mvc.aspect.IEnablementViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IFocusViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMetaDataAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseButtonViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseMovementViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.IMouseTrackingViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.ISelectionViewAspect;
import org.eclipse.net4j.examples.mvc.aspect.ITextViewAspect;
import org.eclipse.net4j.examples.mvc.swt.AbstractSelectionAdapter;
import org.eclipse.net4j.examples.mvc.util.Point;
import org.eclipse.net4j.examples.mvc.util.Rectangle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class ComboViewAdapter
extends AbstractSelectionAdapter
implements ITextViewAspect,
ModifyListener {
    public ComboViewAdapter(Factory factory) {
        super((IAdapter.Factory<Control>)factory);
    }

    public Combo getComboControl() {
        return (Combo)this.getTarget();
    }

    public void add(String string) {
        this.getComboControl().add(string);
    }

    public void add(String string, int index) {
        this.getComboControl().add(string, index);
    }

    public void deselect(int index) {
        this.getComboControl().deselect(index);
    }

    public void deselect(int start, int end) {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void deselect(int[] indices) {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void deselectAll() {
        this.getComboControl().deselectAll();
    }

    public int getFocusIndex() {
        if (!this.hasFocus()) {
            return -1;
        }
        return this.getSelectionIndex();
    }

    public String getItem(int index) {
        return this.getComboControl().getItem(index);
    }

    public int getItemCount() {
        return this.getComboControl().getItemCount();
    }

    public int getItemHeight() {
        return this.getComboControl().getItemHeight();
    }

    public String[] getItems() {
        return this.getComboControl().getItems();
    }

    public String[] getSelection() {
        return new String[]{this.getSelectionText()};
    }

    public int getSelectionCount() {
        return this.getSelectionIndices().length;
    }

    public int getSelectionIndex() {
        return this.getComboControl().getSelectionIndex();
    }

    public int[] getSelectionIndices() {
        int index = this.getSelectionIndex();
        if (index == -1) {
            return new int[0];
        }
        return new int[]{index};
    }

    public int getTopIndex() {
        return this.getSelectionIndex();
    }

    public int getVisibleItemCount() {
        return this.getComboControl().getVisibleItemCount();
    }

    public int indexOf(String string) {
        return this.getComboControl().indexOf(string);
    }

    public int indexOf(String string, int start) {
        return this.getComboControl().indexOf(string, start);
    }

    public boolean isSelected(int index) {
        return index == this.getSelectionIndex();
    }

    public void remove(String string) {
        this.getComboControl().remove(string);
    }

    public void remove(int index) {
        this.getComboControl().remove(index);
    }

    public void remove(int start, int end) {
        this.getComboControl().remove(start, end);
    }

    public void remove(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("indices == null");
        }
        if (indices.length == 0) {
            return;
        }
        Arrays.sort(indices);
        int i = 0;
        while (i < indices.length) {
            this.remove(indices[i]);
            int j = i + 1;
            while (j < indices.length) {
                int n = j++;
                indices[n] = indices[n] - 1;
            }
            ++i;
        }
    }

    public void removeAll() {
        this.getComboControl().removeAll();
    }

    public void select(int index) {
        this.getComboControl().select(index);
    }

    public void select(int start, int end) {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void select(int[] indices) {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void selectAll() {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void setItem(int index, String string) {
        this.getComboControl().setItem(index, string);
    }

    public void setItems(String[] items) {
        this.getComboControl().setItems(items);
    }

    public void setSelection(String[] items) {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void setSelection(int index) {
        this.select(index);
    }

    public void setSelection(int start, int end) {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void setSelection(int[] indices) {
        throw new UnsupportedOperationException("Combo does not support multiple selection");
    }

    public void setTopIndex(int index) {
    }

    public void setVisibleItemCount(int count) {
        this.getComboControl().setVisibleItemCount(count);
    }

    public void showSelection() {
    }

    public void append(String string) {
        String newText = String.valueOf(this.getText()) + string;
        this.setText(newText);
    }

    public void clearSelection() {
        this.getComboControl().clearSelection();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return ComboViewAdapter.fromSwt(this.getComboControl().computeSize(wHint, hHint, changed));
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        return ComboViewAdapter.fromSwt(this.getComboControl().computeTrim(x, y, width, height));
    }

    public void copy() {
        this.getComboControl().copy();
    }

    public void cut() {
        this.getComboControl().cut();
    }

    public int getCaretLineNumber() {
        return 0;
    }

    public Point getCaretLocation() {
        throw new UnsupportedOperationException("Combo does not support caret");
    }

    public int getCaretPosition() {
        throw new UnsupportedOperationException("Combo does not support caret");
    }

    public int getCharCount() {
        return this.getText().length();
    }

    public boolean getDoubleClickEnabled() {
        return false;
    }

    public char getEchoChar() {
        return '\u0000';
    }

    public boolean getEditable() {
        return true;
    }

    public int getLineCount() {
        return 1;
    }

    public String getLineDelimiter() {
        return null;
    }

    public int getLineHeight() {
        return this.getComboControl().getTextHeight();
    }

    public int getOrientation() {
        return this.getComboControl().getOrientation();
    }

    public int getTabs() {
        return 0;
    }

    public String getText() {
        return this.getComboControl().getText();
    }

    public String getText(int start, int end) {
        return this.getComboControl().getText().substring(start, end - start);
    }

    public int getTextLimit() {
        return this.getComboControl().getTextLimit();
    }

    public int getTopPixel() {
        return 0;
    }

    public void insert(String string) {
        this.append(string);
    }

    public void paste() {
        this.getComboControl().paste();
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
    }

    public void setEchoChar(char echo) {
        throw new UnsupportedOperationException("Combo does not support echoChar");
    }

    public void setEditable(boolean editable) {
        throw new UnsupportedOperationException("Combo does not support editable");
    }

    public void setOrientation(int orientation) {
        this.getComboControl().setOrientation(orientation);
    }

    public void setSelection(Point selection) {
        this.getComboControl().setSelection(ComboViewAdapter.toSwt(selection));
    }

    public void setTabs(int tabs) {
        throw new UnsupportedOperationException("Combo does not support tabs");
    }

    public void setText(String string) {
        this.getComboControl().setText(string == null ? "" : string);
    }

    public void setTextLimit(int limit) {
        this.getComboControl().setTextLimit(limit);
    }

    public void onModify() {
        for (IBinding binding : this.getBindings(ITextViewAspect.class)) {
            ((ITextViewAspect)binding).onModify();
        }
    }

    public String onVerify(int start, int end, String text, int stateMask) {
        for (IBinding binding : this.getBindings(ITextViewAspect.class)) {
            text = ((ITextViewAspect)binding).onVerify(start, end, text, stateMask);
        }
        return text;
    }

    public void modifyText(ModifyEvent e) {
        this.onModify();
    }

    protected void connectTarget(Class viewAspect) {
        super.connectTarget(viewAspect);
        if (viewAspect == ISelectionViewAspect.class) {
            this.getComboControl().addSelectionListener((SelectionListener)this);
            this.getComboControl().addModifyListener((ModifyListener)this);
        }
    }

    protected void disconnectTarget(Class viewAspect) {
        if (!((Control)this.getTarget()).isDisposed() && viewAspect == ISelectionViewAspect.class) {
            this.getComboControl().removeSelectionListener((SelectionListener)this);
            this.getComboControl().removeModifyListener((ModifyListener)this);
        }
        super.disconnectTarget(viewAspect);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractAdapter.AbstractFactory<Control> {
        private static final Class[] ASPECTS = new Class[]{IMetaDataAspect.class, IEnablementViewAspect.class, IFocusViewAspect.class, IMouseButtonViewAspect.class, IMouseTrackingViewAspect.class, IMouseMovementViewAspect.class, ISelectionViewAspect.class, ITextViewAspect.class};
        private static final Class[] ADAPTABLE_CLASSES = new Class[]{Combo.class};

        public IAdapter<Control> createAdapter() {
            return new ComboViewAdapter(this);
        }

        public Class[] getAspects() {
            return ASPECTS;
        }

        public Class[] getAdaptableClasses() {
            return ADAPTABLE_CLASSES;
        }
    }
}

