/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.socket.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.NegotiationException;
import org.eclipse.net4j.core.SelectionListener;
import org.eclipse.net4j.core.impl.AbstractConnector;
import org.eclipse.net4j.core.impl.BufferImpl;
import org.eclipse.net4j.core.impl.ChannelImpl;
import org.eclipse.net4j.socket.SelectorManager;
import org.eclipse.net4j.socket.SocketConnector;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ThreadInterruptedException;
import org.eclipse.net4j.util.UnderlyingIOException;
import org.eclipse.net4j.util.thread.DeadlockDetector;

public abstract class AbstractSocketConnector
extends AbstractConnector
implements SocketConnector,
SelectionListener {
    public static final int TRACE_MODE = 1;
    private long authenticationTimeout = 5000L;
    private BufferImpl receiveBuffer;
    private SelectorManager selectorManager;
    private SocketChannel socketChannel;
    private boolean peerOnSameHost;
    private transient boolean inHeader = true;
    private transient int maxReceiveLength;
    private transient short receiveLength;
    private transient short receiveChannelIndex;

    public long getAuthenticationTimeout() {
        return this.authenticationTimeout;
    }

    public void setAuthenticationTimeout(long authenticationTimeout) {
        this.doSet("authenticationTimeout", authenticationTimeout);
    }

    public SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    public void setSelectorManager(SelectorManager selectorManager) {
        this.doSet("selectorManager", selectorManager);
    }

    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.doSet("socketChannel", socketChannel);
    }

    public boolean isPeerOnSameHost() {
        return this.peerOnSameHost;
    }

    protected void doRead() throws IOException {
        boolean ok = this.receiveBuffer.readFrom(this.socketChannel);
        if (!ok) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
        if (this.receiveBuffer.remaining() == 0) {
            this.receiveBuffer.flip();
            if (this.inHeader) {
                this.receiveLength = this.receiveBuffer.getShort();
                this.receiveChannelIndex = this.receiveBuffer.getShort();
                if (ChannelImpl.TRACING_BUFFERS && this.isDebugEnabled()) {
                    this.debug("Receiving buffer with length=" + this.receiveLength + ", channelIndex=" + this.receiveChannelIndex);
                }
                this.receiveBuffer.clear();
                this.receiveBuffer.limit((int)this.receiveLength);
                this.inHeader = false;
            } else {
                Channel channel = this.getChannel(this.receiveChannelIndex);
                channel.notifyData(this.receiveBuffer);
                this.newReceiverBuffer();
                this.inHeader = true;
            }
        }
    }

    public void transmit(int channelIndex, BufferImpl buffer) {
        int limit = buffer.limit();
        int length = limit - 4;
        if (ChannelImpl.TRACING_BUFFERS && this.isDebugEnabled()) {
            this.debug("Transmitting buffer: " + buffer + ", length=" + length + ", channelIndex=" + channelIndex);
        }
        buffer.position(0);
        buffer.putShort((short)length);
        buffer.putShort((short)channelIndex);
        buffer.position(0);
        buffer.limit(limit);
        try {
            this.socketChannel.write(buffer.getByteBuffer());
            long start = System.currentTimeMillis();
            while (buffer.position() < limit) {
                if (System.currentTimeMillis() - start > 100000L) {
                    this.error("Timeout while writing");
                    throw new ImplementationError("Timeout while writing");
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    throw new ThreadInterruptedException((Throwable)ex);
                }
                this.socketChannel.write(buffer.getByteBuffer());
            }
        }
        catch (IOException e) {
            throw new UnderlyingIOException((Throwable)e);
        }
    }

    public void notifyRegistration(SelectableChannel selectable, SelectionKey key) {
        if (this.isDebugEnabled()) {
            this.debug("Registered " + selectable + " under key " + key);
        }
    }

    public void readyForRead(SelectableChannel selectable) {
        if (ChannelImpl.TRACING && this.isDebugEnabled()) {
            this.debug("readyForRead(): " + selectable);
        }
        try {
            this.doRead();
        }
        catch (IOException ex) {
            this.error("Error while reading from socket", ex);
            throw new UnderlyingIOException((Throwable)ex);
        }
    }

    public byte[] receiveNegotiation() throws NegotiationException {
        try {
            ByteBuffer lengthBuffer = ByteBuffer.allocateDirect(4);
            this.receiveBufferDuringNegotiation(lengthBuffer);
            lengthBuffer.flip();
            int length = lengthBuffer.getInt();
            byte[] data = new byte[length];
            ByteBuffer buffer = ByteBuffer.wrap(data);
            this.receiveBufferDuringNegotiation(buffer);
            buffer.flip();
            return buffer.array();
        }
        catch (Exception ex) {
            throw new NegotiationException("Negotiation data could not be received", (Throwable)ex);
        }
    }

    public void transmitNegotiation(byte[] data) throws NegotiationException {
        try {
            ByteBuffer lengthBuffer = ByteBuffer.allocateDirect(4);
            lengthBuffer.putInt(data.length);
            lengthBuffer.flip();
            this.transmitBufferDuringNegotiation(lengthBuffer);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            this.transmitBufferDuringNegotiation(buffer);
        }
        catch (Exception ex) {
            throw new NegotiationException("Negotiation data could not be transmitted", (Throwable)ex);
        }
    }

    private void transmitBufferDuringNegotiation(ByteBuffer buffer) throws IOException {
        int written = this.socketChannel.write(buffer);
        while (written < buffer.capacity()) {
            DeadlockDetector.sleep((long)5L);
            written += this.socketChannel.write(buffer);
        }
    }

    private void receiveBufferDuringNegotiation(ByteBuffer buffer) throws IOException {
        int read = this.socketChannel.read(buffer);
        while (read < buffer.capacity()) {
            DeadlockDetector.sleep((long)5L);
            read += this.socketChannel.read(buffer);
        }
    }

    public static void waitForConnection(SocketChannel socketChannel) throws IOException {
        while (socketChannel.isConnectionPending()) {
            DeadlockDetector.sleep((long)5L);
            socketChannel.finishConnect();
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("selectorManager");
        this.maxReceiveLength = this.getBufferPool().getBufferSize() - 4;
        if (this.maxReceiveLength < 1) {
            throw new ValidationException("No space left for data: " + this.maxReceiveLength);
        }
        this.newReceiverBuffer();
    }

    protected void newReceiverBuffer() {
        this.receiveBuffer = this.getBufferPool().getBuffer();
        this.receiveBuffer.limit(4);
        this.receiveLength = 0;
        this.receiveChannelIndex = (short)-1;
    }

    public void adjustTransmitterBuffer(BufferImpl transmitterBuffer) {
        transmitterBuffer.position(4);
    }

    protected void activate() throws Exception {
        this.socketChannel.configureBlocking(false);
        if (this.isDebugEnabled()) {
            this.debug("Waiting for connection...");
        }
        AbstractSocketConnector.waitForConnection(this.socketChannel);
        Socket socket = this.socketChannel.socket();
        InetAddress localAddr = socket.getLocalAddress();
        InetAddress remoteAddr = socket.getInetAddress();
        this.peerOnSameHost = localAddr.equals(remoteAddr);
        this.info("Connected socketChannel: " + this.socketChannel);
        super.activate();
        this.selectorManager.register(this.socketChannel, this);
    }

    protected void deactivate() throws Exception {
        this.selectorManager.deregister(this.socketChannel);
        this.receiveBuffer = null;
        this.selectorManager = null;
        this.socketChannel = null;
        super.deactivate();
    }
}

