/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content.part.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.util.DiffAdapterFactory;
import org.eclipse.emf.compare.ui.util.EMFCompareEObjectUtils;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.part.IModelContentMergeViewerTab;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabFolder;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabItem;
import org.eclipse.emf.compare.util.AdapterUtils;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.DelegatingWrapperItemProvider;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelContentMergeDiffTab
extends TreeViewer
implements IModelContentMergeViewerTab {
    protected boolean needsRedraw = true;
    protected final int partSide;
    protected final List<Item> visibleItems = new ArrayList<Item>();
    private final Map<Item, TreePath> cachedTreePath = new EMFCompareMap();
    private final Map<EObject, DiffElement> dataToDiff = new EMFCompareMap();
    private final Map<Object, TreeItem> dataToTreeItem = new EMFCompareMap();
    private final Map<DiffElement, ModelContentMergeTabItem> diffToUIItem = new EMFCompareMap();
    private final ModelContentMergeTabFolder parent;

    public ModelContentMergeDiffTab(Composite parentComposite, int side, ModelContentMergeTabFolder parentFolder) {
        super(new Tree(parentComposite, 0x20000302));
        this.partSide = side;
        this.parent = parentFolder;
        this.setUseHashlookup(true);
        this.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(AdapterUtils.getAdapterFactory()));
        this.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(AdapterUtils.getAdapterFactory()));
        this.getTree().addPaintListener((PaintListener)new TreePaintListener());
        this.getTree().addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                ModelContentMergeDiffTab.this.needsRedraw = true;
            }

            public void treeExpanded(TreeEvent e) {
                ModelContentMergeDiffTab.this.needsRedraw = true;
            }
        });
        this.getTree().getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelContentMergeDiffTab.this.needsRedraw = true;
                ModelContentMergeDiffTab.this.redraw();
            }
        });
    }

    @Override
    public void dispose() {
        this.dataToDiff.clear();
        this.diffToUIItem.clear();
        this.getTree().dispose();
    }

    public List<TreeItem> getSelectedElements() {
        return Arrays.asList(this.getTree().getSelection());
    }

    @Override
    public ModelContentMergeTabItem getUIItem(EObject data) {
        ModelContentMergeTabItem result = null;
        DiffElement diff = this.dataToDiff.get(data);
        if (diff != null && DiffAdapterFactory.shouldBeHidden((EObject)diff)) {
            return result;
        }
        ModelContentMergeTabItem item = this.diffToUIItem.get(diff);
        if (item != null) {
            Item treeItem = this.getVisibleAncestorOf(item.getVisibleItem());
            result = treeItem == item.getVisibleItem() ? item : new ModelContentMergeTabItem(diff, item.getActualItem(), treeItem, item.getCurveColor());
            this.computeUIInfoFor(result);
        }
        return result;
    }

    @Override
    public List<ModelContentMergeTabItem> getVisibleElements() {
        ArrayList<ModelContentMergeTabItem> result = new ArrayList<ModelContentMergeTabItem>();
        if (this.parent.getDiffAsList().size() == 0) {
            return result;
        }
        List<Item> items = this.getVisibleTreeItems();
        for (DiffElement diff : this.diffToUIItem.keySet()) {
            ModelContentMergeTabItem nextItem = this.diffToUIItem.get(diff);
            Item visibleMatch = null;
            for (Item visible : items) {
                if (nextItem.getActualItem() != visible) continue;
                visibleMatch = visible;
                break;
            }
            if (visibleMatch == null) {
                for (Item visible : items) {
                    if (((TreeItem)visible).getExpanded() || !this.getTreePathFromItem(nextItem.getActualItem()).startsWith(this.getTreePathFromItem(visible), null)) continue;
                    visibleMatch = visible;
                    break;
                }
            }
            if (visibleMatch == null) continue;
            nextItem.setVisibleItem(visibleMatch);
            this.computeUIInfoFor(nextItem);
            result.add(nextItem);
        }
        return result;
    }

    @Override
    public void redraw() {
        this.getTree().redraw();
    }

    public void refresh(Object element, boolean updateLabels) {
        super.refresh(element, updateLabels);
        this.mapTreeItems();
        this.mapDifferences();
        this.mapTreeItemsToUI();
    }

    @Override
    public void setReflectiveInput(Object object) {
        this.dataToDiff.clear();
        this.diffToUIItem.clear();
        this.dataToTreeItem.clear();
        AdapterFactory adapterFactory = AdapterUtils.getAdapterFactory();
        this.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory));
        if (object instanceof EObject) {
            this.setInput(((EObject)object).eResource());
        } else {
            assert (object instanceof Resource);
            this.setInput(object);
        }
        this.mapTreeItems();
        this.mapDifferences();
        this.mapTreeItemsToUI();
        this.needsRedraw = true;
    }

    @Override
    public void showItems(List<DiffElement> items) {
        ArrayList<EObject> datas = new ArrayList<EObject>();
        int i = 0;
        while (i < items.size()) {
            if (this.partSide == 3 && items.get(i) instanceof ConflictingDiffElement) {
                datas.add(((ConflictingDiffElement)items.get(i)).getOriginElement());
            } else if (this.partSide == 1) {
                datas.add(EMFCompareEObjectUtils.getLeftElement((EObject)items.get(i)));
            } else {
                datas.add(EMFCompareEObjectUtils.getRightElement((EObject)items.get(i)));
            }
            ++i;
        }
        this.setSelection((ISelection)new StructuredSelection(datas), true);
        this.needsRedraw = true;
        this.redraw();
    }

    protected Widget doFindInputItem(Object element) {
        Widget res = (Widget)this.dataToTreeItem.get(element);
        if (res != null && !res.isDisposed()) {
            return res;
        }
        if (res != null) {
            this.mapTreeItems();
            this.mapDifferences();
            this.mapTreeItemsToUI();
            this.dataToTreeItem.get(element);
        }
        return super.doFindInputItem(element);
    }

    protected TreePath getTreePathFromItem(Item item) {
        TreePath result = this.cachedTreePath.get(item);
        if (result == null) {
            result = super.getTreePathFromItem(item);
            this.cachedTreePath.put(item, result);
        }
        return result;
    }

    protected void inputChanged(Object input, Object oldInput) {
        TreePath[] expandedTreePaths = this.getExpandedTreePaths();
        super.inputChanged(input, oldInput);
        this.expandAll();
        this.setExpandedTreePaths(expandedTreePaths);
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        ArrayList<TreeItem> newSelection = new ArrayList<TreeItem>();
        for (Object data : l) {
            Widget widget = null;
            if (data instanceof EObject) {
                widget = this.findItemForEObject((EObject)data);
            } else if (data instanceof TreePath) {
                widget = this.findItemForEObject((EObject)((TreePath)data).getLastSegment());
            } else if (data != null) {
                widget = this.findItem(data);
            }
            if (widget == null || !(widget instanceof TreeItem)) continue;
            newSelection.add((TreeItem)widget);
            if (!((TreeItem)widget).getExpanded() || this.getChildren(widget).length <= 0) continue;
            this.expandToLevel(data, 1);
        }
        if (newSelection.size() > 0) {
            this.setSelection(newSelection);
        } else {
            super.setSelectionToWidget(l, reveal);
        }
    }

    private void computeUIInfoFor(ModelContentMergeTabItem item) {
        DiffElement diff = item.getDiff();
        if (item.getActualItem() == item.getVisibleItem()) {
            int curveY = this.partSide == 1 && diff instanceof ModelElementChangeRightTarget ? ((TreeItem)item.getVisibleItem()).getBounds().y + ((TreeItem)item.getVisibleItem()).getBounds().height : (this.partSide == 2 && diff instanceof ModelElementChangeLeftTarget ? ((TreeItem)item.getVisibleItem()).getBounds().y + ((TreeItem)item.getVisibleItem()).getBounds().height : ((TreeItem)item.getVisibleItem()).getBounds().y + ((TreeItem)item.getVisibleItem()).getBounds().height / 2);
            item.setCurveY(curveY);
        } else {
            int curveY = this.partSide == 1 && diff instanceof ModelElementChangeRightTarget ? ((TreeItem)item.getVisibleItem()).getBounds().y + ((TreeItem)item.getVisibleItem()).getBounds().height : (this.partSide == 2 && diff instanceof ModelElementChangeLeftTarget ? ((TreeItem)item.getVisibleItem()).getBounds().y + ((TreeItem)item.getVisibleItem()).getBounds().height : ((TreeItem)item.getVisibleItem()).getBounds().y + ((TreeItem)item.getVisibleItem()).getBounds().height);
            item.setCurveY(curveY);
        }
        if (this.getSelectedElements().contains(item.getActualItem())) {
            item.setCurveSize(2);
        } else {
            item.setCurveSize(1);
        }
    }

    private Widget findItemForEObject(EObject element) {
        Widget result = super.findItem((Object)element);
        if (result == null) {
            if (element.eContainer() != null) {
                result = this.findItemForEObject(element.eContainer());
            } else if (this.getTree().getItemCount() > 0) {
                result = this.getTree().getItem(0);
            }
        }
        if (result instanceof Tree && this.getTree().getItemCount() > 0) {
            result = this.getTree().getItem(0);
        }
        return result;
    }

    private Item getVisibleAncestorOf(Item item) {
        Item result = item;
        TreePath path = this.getTreePathFromItem(item);
        if (path.getSegmentCount() > 1) {
            int i = 0;
            while (i < path.getSegmentCount()) {
                TreeItem ancestor = (TreeItem)this.findItem(path.getSegment(i));
                if (!ancestor.getExpanded()) {
                    result = ancestor;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private List<Item> getVisibleTreeItems() {
        if (this.needsRedraw) {
            this.needsRedraw = false;
            this.visibleItems.clear();
            TreeItem topItem = this.getTree().getTopItem();
            if (topItem != null) {
                int treeHeight = this.getTree().getClientArea().height;
                int treeWidth = this.getTree().getBounds().width;
                int itemHeight = topItem.getBounds().height;
                int itemWidth = topItem.getBounds().width;
                this.visibleItems.add((Item)topItem);
                int loopStart = topItem.getBounds().y + itemHeight + itemHeight / 2;
                int loopEnd = treeHeight;
                int i = loopStart;
                while (i <= loopEnd) {
                    TreeItem next = null;
                    int xCoord = topItem.getBounds().x;
                    while (xCoord < treeWidth) {
                        next = this.getTree().getItem(new Point(xCoord, i));
                        if (next != null) break;
                        xCoord += itemWidth >> 3;
                    }
                    if (next == null) break;
                    this.visibleItems.add((Item)next);
                    i += itemHeight;
                }
            }
        }
        return this.visibleItems;
    }

    private Object internalFindActualData(Object data) {
        Object actualData = data;
        if (data instanceof FeatureMapEntryWrapperItemProvider) {
            actualData = this.internalFindActualData(((FeatureMapEntryWrapperItemProvider)data).getValue());
        } else if (data instanceof DelegatingWrapperItemProvider) {
            actualData = this.internalFindActualData(((DelegatingWrapperItemProvider)data).getValue());
        } else if (data instanceof EStructuralFeatureImpl.ContainmentUpdatingFeatureMapEntry) {
            actualData = ((EStructuralFeatureImpl.ContainmentUpdatingFeatureMapEntry)data).getValue();
        }
        return actualData;
    }

    private void internalMapTreeItems(TreeItem item) {
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.dataToTreeItem.put(this.internalFindActualData(child.getData()), child);
            this.internalMapTreeItems(child);
            ++n2;
        }
    }

    private void mapDifferences() {
        this.dataToDiff.clear();
        for (DiffElement diff : this.parent.getDiffAsList()) {
            EObject data = this.partSide == 3 && diff instanceof ConflictingDiffElement ? ((ConflictingDiffElement)diff).getOriginElement() : (this.partSide == 1 ? EMFCompareEObjectUtils.getLeftElement((EObject)diff) : EMFCompareEObjectUtils.getRightElement((EObject)diff));
            if (data != null) {
                this.dataToDiff.put(data, diff);
                continue;
            }
            this.dataToDiff.put((EObject)this.getTree().getItems()[0].getData(), diff);
        }
    }

    private void mapTreeItems() {
        this.dataToTreeItem.clear();
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.dataToTreeItem.put(this.internalFindActualData(item.getData()), item);
            this.internalMapTreeItems(item);
            ++n2;
        }
    }

    private void mapTreeItemsToUI() {
        this.diffToUIItem.clear();
        for (EObject key : this.dataToDiff.keySet()) {
            EObject left;
            EObject right;
            Item actualItem;
            DiffElement diff = this.dataToDiff.get(key);
            EObject data = this.partSide == 3 && diff instanceof ConflictingDiffElement ? ((ConflictingDiffElement)diff).getOriginElement() : (this.partSide == 1 ? EMFCompareEObjectUtils.getLeftElement((EObject)diff) : EMFCompareEObjectUtils.getRightElement((EObject)diff));
            if (data == null) {
                data = (EObject)this.getTree().getItems()[0].getData();
            }
            if ((actualItem = (Item)this.findItem(data)) == null) {
                return;
            }
            Item visibleItem = null;
            if (this.partSide == 1 && diff instanceof ModelElementChangeRightTarget && ((ModelElementChangeRightTarget)diff).getRightElement().eContainer() != null) {
                right = ((ModelElementChangeRightTarget)diff).getRightElement();
                left = ((ModelElementChangeRightTarget)diff).getLeftParent();
                int rightIndex = right.eContainer().eContents().indexOf((Object)right);
                int leftIndex = Math.min(rightIndex - 1, left.eContents().size() - 1);
                if (left.eContents().size() > 0) {
                    visibleItem = (Item)this.findItem(left.eContents().get(leftIndex));
                }
            } else if (this.partSide == 2 && diff instanceof ModelElementChangeLeftTarget && ((ModelElementChangeLeftTarget)diff).getLeftElement().eContainer() != null) {
                right = ((ModelElementChangeLeftTarget)diff).getRightParent();
                left = ((ModelElementChangeLeftTarget)diff).getLeftElement();
                int leftIndex = left.eContainer().eContents().indexOf((Object)left);
                int rightIndex = Math.max(0, Math.min(leftIndex - 1, right.eContents().size() - 1));
                if (right.eContents().size() > 0) {
                    visibleItem = (Item)this.findItem(right.eContents().get(rightIndex));
                }
            }
            String color = diff.getKind() == DifferenceKind.CONFLICT || diff.isConflicting() ? "conflicting.color" : (diff.getKind() == DifferenceKind.ADDITION ? "added.color" : (diff.getKind() == DifferenceKind.DELETION ? "removed.color" : "changed.color"));
            ModelContentMergeTabItem wrappedItem = visibleItem != null ? new ModelContentMergeTabItem(diff, actualItem, visibleItem, color) : new ModelContentMergeTabItem(diff, actualItem, color);
            this.diffToUIItem.put(diff, wrappedItem);
        }
    }

    class TreePaintListener
    implements PaintListener {
        TreePaintListener() {
        }

        public void paintControl(PaintEvent event) {
            if (ModelContentMergeViewer.shouldDrawDiffMarkers()) {
                for (ModelContentMergeTabItem item : ModelContentMergeDiffTab.this.getVisibleElements()) {
                    this.drawRectangle(event.gc, item);
                }
            }
        }

        private void drawRectangle(GC gc, ModelContentMergeTabItem item) {
            Rectangle treeBounds = ModelContentMergeDiffTab.this.getTree().getClientArea();
            Rectangle treeItemBounds = ((TreeItem)item.getVisibleItem()).getBounds();
            RGB color = ModelContentMergeViewer.getColor(item.getCurveColor());
            int rectangleX = treeItemBounds.x - 60;
            int rectangleY = treeItemBounds.y;
            int rectangleWidth = treeItemBounds.width + 60;
            int rectangleHeight = treeItemBounds.height - 1;
            gc.setLineWidth(item.getCurveSize());
            gc.setForeground(new Color((Device)ModelContentMergeDiffTab.this.getTree().getDisplay(), color));
            if (ModelContentMergeDiffTab.this.partSide == 1) {
                if (item.getCurveY() != treeItemBounds.y + treeItemBounds.height / 2) {
                    gc.setLineStyle(1);
                    gc.drawLine(rectangleX, item.getCurveY(), treeBounds.width + treeBounds.x, item.getCurveY());
                } else {
                    gc.setLineStyle(4);
                    gc.drawRoundRectangle(rectangleX, rectangleY, rectangleWidth, rectangleHeight, 5, 5);
                    gc.setLineStyle(1);
                    gc.drawLine(rectangleX + rectangleWidth, item.getCurveY(), treeBounds.width + treeBounds.x, item.getCurveY());
                }
            } else if (ModelContentMergeDiffTab.this.partSide == 2) {
                if (item.getCurveY() != treeItemBounds.y + treeItemBounds.height / 2) {
                    gc.setLineStyle(1);
                    gc.drawLine(rectangleX + rectangleWidth, item.getCurveY(), treeBounds.x, item.getCurveY());
                } else {
                    gc.setLineStyle(4);
                    gc.drawRoundRectangle(rectangleX, rectangleY, rectangleWidth, rectangleHeight, 5, 5);
                    gc.setLineStyle(1);
                    gc.drawLine(rectangleX, item.getCurveY(), treeBounds.x, item.getCurveY());
                }
            } else if (item.getCurveY() != treeItemBounds.y + treeItemBounds.height / 2) {
                gc.setLineStyle(1);
                gc.drawLine(rectangleX + rectangleWidth, item.getCurveY(), rectangleX, item.getCurveY());
            } else {
                gc.setLineStyle(4);
                gc.drawRoundRectangle(rectangleX, rectangleY, rectangleWidth, rectangleHeight, 5, 5);
            }
        }
    }
}

