/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.metadata;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.EMFRecordingChangeCommand;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.TextChangeListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MinInclusiveSection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private Text constraintTxt;
    private CLabel labelTxt;

    protected void createWidgets(Composite composite) {
        this.labelTxt = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.constraintTxt = this.getWidgetFactory().createText(composite, "");
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.constraintTxt, -5);
        data.top = new FormAttachment(0, 4);
        this.labelTxt.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelTxt, 0, 0x1000000);
        this.constraintTxt.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        TextChangeListener listener = new TextChangeListener(){

            public void textChanged(Control control) {
                MinInclusiveSection.this.handleTextModified();
            }
        };
        listener.startListeningTo((Control)this.constraintTxt);
        listener.startListeningForEnter((Control)this.constraintTxt);
    }

    protected void handleTextModified() {
        if (!this.isRefreshing) {
            final String newConstraint = this.getText();
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                String oldConstraint = ExtendedMetaData.INSTANCE.getMinInclusiveFacet((EDataType)this.getEObject());
                if (oldConstraint != null && !oldConstraint.equals(newConstraint) || oldConstraint == null && newConstraint != null) {
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(this.getEObject().eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setMinInclusiveFacet((EDataType)MinInclusiveSection.this.getEObject(), newConstraint);
                        }
                    });
                }
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (final EObject nextObject : this.getEObjectList()) {
                    String oldConstraint = ExtendedMetaData.INSTANCE.getMinInclusiveFacet((EDataType)nextObject);
                    if ((oldConstraint == null || oldConstraint.equals(newConstraint)) && (oldConstraint != null || newConstraint == null)) continue;
                    editingDomain.getCommandStack().execute((Command)new EMFRecordingChangeCommand(nextObject.eResource()){

                        protected void doExecute() {
                            ExtendedMetaData.INSTANCE.setMinInclusiveFacet((EDataType)nextObject, newConstraint);
                        }
                    });
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    private String getText() {
        if (this.constraintTxt.getText() != null && !"".equals(this.constraintTxt.getText())) {
            return this.constraintTxt.getText();
        }
        return null;
    }

    public void refresh() {
        this.isRefreshing = true;
        String text = ExtendedMetaData.INSTANCE.getMinInclusiveFacet((EDataType)this.getEObject());
        if (text == null) {
            text = "";
        }
        this.constraintTxt.setText(text);
        this.isRefreshing = false;
    }

    protected EStructuralFeature getFeature() {
        return null;
    }

    protected String getLabelText() {
        return Messages.MinInclusiveSection_MinimumConstraint;
    }
}

